package SYS::gmtime;

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(gmtime ctime);

use Carp;
use Struct;

struct SYS::gmtime qw{
   sec min hour 
   mday mon year 
   wday yday isdst
};

sub gmtime {
    croak "usage: new SYS::gmtime time" if @_ > 1;
    my $timethen = $_[0];
    my @fields = CORE::gmtime $timethen;
    return @fields
    	? new SYS::gmtime @fields
	: undef;
} 

sub gmtime {
    croak "usage: new SYS::gmtime time" if @_ > 1;
    my $timethen = $_[0];
    my @fields = CORE::gmtime $timethen;
    return @fields
    	? new SYS::gmtime @fields
	: undef;
} 

sub ctime {
    croak "usage: new SYS::ctime time" if @_ > 1;
    my $timethen = $_[0];
    $timethen = CORE::time unless defined $timethen;
    return scalar CORE::gmtime $timethen;
} 

sub new { 
    croak "usage: new SYS::gmtime time" if @_ == 0;
    my $class = shift;
    # these can be imported
    ($sec,$min,$hour,$mday,$mon,
	$year,$wday,$yday,$isdst) = @_;
    return bless [ @_ ];
};

1;
