package SYS::netent;

@ISA    = qw(Exporter);
@EXPORT = qw(getnetent getnetbyaddr getnetbyname);

use Carp;
use Struct;
use Socket qw(AF_INET);


struct SYS::netent qw{
    name aliases addrtype net
};

sub getnetbyname {
    croak "usage: getnetbyname net" if @_ != 1;
    my $name = $_[0];
    my @fields = CORE::getnetbyname($name);
    return @fields
    	? new SYS::netent @fields
	: undef;
} 

sub getnetbyaddr {
    croak "usage: getpwent(addr,[addrtype])" if @_ == 0 || @_ > 2;
    my $addr = $_[0];
    my $addrtype = $_[1] || AF_INET;
    if ($addr =~ /^[\d.]+$/) {
	my @parts = split(/\./, $addr);
	unshift(@parts, (0) x (4 - @parts));
	$addr = unpack('L', pack('C4', @parts));
    } elsif (length($addr) != 4) {
	croak "getnetbyaddr: invalid address";
    } 
    my @fields = CORE::getnetbyaddr($addr,$addrtype);
    return @fields 
	? new SYS::netent @fields
	: undef
} 

sub getnetent {
    croak "usage: getpwent" if @_ != 0;
    my @fields = CORE::getnetent();
    return @fields
    	? new SYS::netent @fields
	: undef;
} 

sub new {
    croak "usage: hostent::new list" if @_ == 0;
    my $class = shift;
    # these are created so they can be imported
    ($name,$aliases,$addrtype,$net) = @_;
    return bless [ @_ ];
};

1;
