package SYS::protoent;

@ISA    = qw(Exporter);
@EXPORT = qw(getprotobyname getprotobynumber getprotoent);

use Carp;
use Struct;

struct SYS::protoent qw{
    name aliases proto
};

sub getprotobyname {
    croak "usage: getprotobyname name" if @_ != 1;
    my $name = $_[0];
    my @fields = CORE::getprotobyname($name);
    return @fields
    	? new SYS::protoent @fields
	: undef;
} 

sub getprotobynumber {
    croak "usage: getprotobynumber num" if @_ != 1;
    my $num = $_[0];
    my @fields = CORE::getprotobynumber($num);
    return @fields
    	? new SYS::protoent @fields
	: undef;
} 

sub getprotoent {
    croak "usage: getprotoent" if @_ != 0;
    my @fields = CORE::getprotoent();
    return @fields
    	? new SYS::proto @fields
	: undef;
} 

sub new {
    croak "usage: protoent::new list" if @_ == 0;
    my $class = shift;
    # these are created so they can be imported
    ($name, $aliases, $proto) = @_;
    $aliases = [ split(' ', $aliases) ];
    bless [ $name, $aliases, $proto ];
};

1;
