package SYS::stat;

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(stat);

use Carp;
use Struct;

struct SYS::stat qw{
       dev ino 
       mode nlink 
       uid gid 
       rdev size 
       atime mtime ctime 
       blksize blocks
};

sub stat {
    my $filename = $_[0];
    my @fields = CORE::stat $filename;
    return @fields
    	? new SYS::stat @fields
	: undef;
} 

sub new { 
    croak "usage: new SYS::stat list" if @_ == 0;
    my $class = shift;
    # these can be imported
    ($dev, $ino, $mode, $nlink, 
     $uid, $gid, $rdev, $size, 
     $atime, $mtime, $ctime, 
     $blksize, $blocks) = @_;
    return bless [ @_ ];
};

1;
