'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) message.n 1.31 96/08/27 13:21:46
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.8 96/02/15 20:02:24
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$1"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH message n 4.0 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
message \- Create and manipulate message widgets
.SH SYNOPSIS
\fBmessage\fI \fIpathName \fR?\fIoptions\fR?
.SO
\-anchor	\-font	\-highlightthickness	\-takefocus
\-background	\-foreground	\-padx	\-text
\-borderwidth	\-highlightbackground	\-pady	\-textvariable
\-cursor	\-highlightcolor	\-relief	\-width
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-aspect aspect Aspect
Specifies a non-negative integer value indicating desired
aspect ratio for the text.  The aspect ratio is specified as
100*width/height.  100 means the text should
be as wide as it is tall, 200 means the text should
be twice as wide as it is tall, 50 means the text should
be twice as tall as it is wide, and so on.
Used to choose line length for text if \fBwidth\fR option
isn't specified.
Defaults to 150.
.OP \-justify justify Justify
Specifies how to justify lines of text.
Must be one of \fBleft\fR, \fBcenter\fR, or \fBright\fR.  Defaults
to \fBleft\fR.
This option works together with the \fBanchor\fR, \fBaspect\fR,
\fBpadX\fR, \fBpadY\fR, and \fBwidth\fR options to provide a variety
of arrangements of the text within the window.
The \fBaspect\fR and \fBwidth\fR options determine the amount of
screen space needed to display the text.
The \fBanchor\fR, \fBpadX\fR, and \fBpadY\fR options determine where this
rectangular area is displayed within the widget's window, and the
\fBjustify\fR option determines how each line is displayed within that
rectangular region.
For example, suppose \fBanchor\fR is \fBe\fR and \fBjustify\fR is
\fBleft\fR, and that the message window is much larger than needed
for the text.
The the text will displayed so that the left edges of all the lines
line up and the right edge of the longest line is \fBpadX\fR from
the right side of the window;  the entire text block will be centered
in the vertical span of the window.
.OP \-width width Width
Specifies the length of lines in the window.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
If this option has a value greater than zero then the \fBaspect\fR
option is ignored and the \fBwidth\fR option determines the line
length.
If this option has a value less than or equal to zero, then
the \fBaspect\fR option determines the line length.
.BE

.SH DESCRIPTION
.PP
The \fBmessage\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a message widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the message such as its colors, font,
text, and initial relief.  The \fBmessage\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A message is a widget that displays a textual string.  A message
widget has three special features.  First, it breaks up
its string into lines in order to produce a given aspect ratio
for the window.  The line breaks are chosen at word boundaries
wherever possible (if not even a single word would fit on a
line, then the word will be split across lines).  Newline characters
in the string will force line breaks;  they can be used, for example,
to leave blank lines in the display.
.PP
The second feature of a message widget is justification.  The text
may be displayed left-justified (each line starts at the left side of
the window), centered on a line-by-line basis, or right-justified
(each line ends at the right side of the window).
.PP
The third feature of a message widget is that it handles control
characters and non-printing characters specially.  Tab characters
are replaced with enough blank space to line up on the next
8-character boundary.  Newlines cause line breaks.  Other control
characters (ASCII code less than 0x20) and characters not defined
in the font are displayed as a four-character sequence \fB\ex\fIhh\fR where
\fIhh\fR is the two-digit hexadecimal number corresponding to
the character.  In the unusual case where the font doesn't contain
all of the characters in ``0123456789abcdef\ex'' then control
characters and undefined characters are not displayed at all.

.SH "WIDGET COMMAND"
.PP
The \fBmessage\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.CS
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for message widgets:
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBmessage\fR
command.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBmessage\fR
command.

.SH "DEFAULT BINDINGS"
.PP
When a new message is created, it has no default event bindings:
messages are intended for output purposes only.

.SH BUGS
.PP
Tabs don't work very well with text that is centered or right-justified.
The most common result is that the line is justified wrong.

.SH KEYWORDS
message, widget
