.TH MODULE 1 "20 October 1991"
.SH NAME
module \- command interface to the Modules package
.SH SYNOPSIS
.B module
[
.I sub-command
]
.I [ sub-command-args ]
.SH DESCRIPTION
.LP
.B module
is the user interface to the Modules package.  The Modules
package provides for the dynamic modification of a user's environment
via
.I modulefiles.
.LP
Each
.I modulefile
contains the information needed to initialize the environment for a
single application or working environment.  Once the Modules package
is initialized, the environment can be modified on a per-module basis
using the 
.B module
command.
.LP
The modules are added to and removed from the current
environment by the user.  The environment changes contained in a
.I modulefile
can be summarized through the
.B module
command as well.  If no arguments are given a summary of the
usage and sub-commands is provided.
.LP
The action for the
.B module
command to take is described by the
.I sub-command
and its associated arguments.
.SS Package Initialization
.LP
The Modules package and the module command are initialized when a
shell-specific initialization script is sourced into the shell.  This
script sets up the
.B module
command as either an alias or function (depending upon the shell
type) and some environment variables.  
.LP
This alias or function executes the modulecmd program located
in ${\s-1MODULESHOME\s0}/bin and has the shell evaluate the command's
output.
.LP
The initialization scripts are kept in ${\s-1MODULESHOME\s0}/init/
.B \fIshellname\fP 
where
.B \fIshellname\fP 
is the name of the sourcing shell.
For example, a C Shell user sources the 
.B ${\s-1MODULESHOME\s0}/init/csh
script.  The sh, csh,
tcsh, bash, and ksh shells are currently supported by modulecmd.
.SS Module Sub-Commands
.LP
A summary of these commands are as follows:
.RS
.TP 15
.B add, load
Load the given
.I modulefile(s)
into the current user's shell environment.
.TP 15
.B rm, unload
Remove the given
.I modulefile(s)
from the current user's shell environment.  Environment variables are
unset when removing a module.  Thus, it is possible to add a 
.I modulefile
and remove it without having the environment variables return to the state
before the addition of the
.I modulefile.
.TP 15
.B switch, swap
Switch a new 
.I modulefile
with a
.I modulefile
that is currently loaded in the user's environment.  Trying to switch
"not very compatible" modules can lead to some odd environment changes
that may not make much sense.  The switch command works best for
switching two modules that are similar (i.e. openwin/2.0 with openwin/3.0).
.TP 15
.B display, show
Display information about each given
.I modulefile.
If no extra information is provided by the 
.I modulefile
writer, the display sub-command will list the full path of the
.I modulefile
that will be loaded and all of the environment changes the
.I modulefile
will make if loaded at this particular time.  It is possible for the
display sub-command to return different results for the same 
.I modulefile
if the module writer uses if-then-else statements based on environment
variables in the user's environment.
.TP 15
.B use
Prepend the given directory to the \s-1MODULEPATH\s0 environment variable.
.TP 15
.B unuse
Remove the given directory from the \s-1MODULEPATH\s0 environment variable.
.TP 15
.B list
List the Modules Package's understanding of all currently loaded modules.
.TP 15
.B clear
Force the Modules Package to believe that no modules are currently
loaded.
.TP 15
.B avail
List all available
.I modulefiles
.hy 0
in the current \s-1MODULEPATH\s0.  Currently, the avail command simply does an
'ls -F' for each directory in the \s-1MODULEPATH\s0.  Thus, multiple
version directories appear with a '/' after them.  If a multiple
version directory is given as an argument, the loadable versions are listed.
.TP 15
.B help
Lists the usage of each sub-command.
.TP 15
.B initadd, ia
Adds the given 
.I modulefile(s)
to the shell's initialization file in the user's home directory.  The
startup files checked are .cshrc, .login, and .csh_variables for the C
Shell, .profile for the Bourne and Korn Shells, and .bashrc,
.bash_env, and .bash_profile for the Bourne Again Shell from GNU.  If
a 'module load' line is found in any of these files, the given 
.I modulefiles
are appended to any existing list of 
.I modulefiles.  Currently, the 'module load' line must be located in
one of the files listed above for any of the 'init' sub-commands to
work properly.  If the 'module load' line is found in multiple shell
initialization files, all of the lines are changed.
.TP 15
.B initrm, ir
Remove the given
.I modulefile(s)
from the shell's initialization files.
.TP 15
.B initsw
Switch a 
.I modulefile
in the shell's initialization files with a different
.I modulefile.
.TP 15
.B initlist, il
List all of the
.I modulefile(s)
loaded from the shell's initialization file.
.TP 15
.B initclear, ic
Clear all of the 
.I modulefile(s)
from the shell's initialization files.
.RE
.SS WRITING MODULEFILES
.LP
A 
.I modulefile
contains the environment information for a single application or
working environment.  module uses
.I Tcl
(Tool Command Language).  Tcl provides control flow, expression
evaluation, and many of other features usually found in a language.
Described below are the commands the Modules Package defines that
are not part of the "standard" Tcl package (see tcl(3)).  Unless
otherwise specified, the module commands return the empty string.
.PP
.B setenv
.I variable
.I value
.RS
Sets the invoking user's environment
.I variable
equal to
.I value.
The 
.B setenv
command will also change the current processes' environment.
Thus, a reference using Tcl's 
.B env
associative array will reference changes made with the
.B setenv
command.  But, changes made using Tcl's
.B env
associative array will NOT change the user's environment variable like
the
.B setenv
command.  An environment change made this way will only affect the
module parsing process.  This is useful to change the environment for
commands that are run using the
.B exec
and
.B system
commands.
.RE
.RS
.PP
.B append-path
.I variable
.I value
.br
.B prepend-path
.I variable
.I value
.RS
Appends or prepends
.I value
to the user's path-type environment variable
.I variable.
The
.I variable
must take the form of a colon separated list (i.e.
"directory:directory:directory").  If the environment variable is not
set, it is created.
.RE
.PP
.B remove-path
.I variable
.I value
.RS
Removes
.I value
from the path-type
.I variable.
Every string between the colons in 
.I variable
is compared against
.I value.
If one matches, it is removed from
.I variable.
.RE
.PP
.B prereq
.I modulefile
[
.I modulefile
\&.\|.\|.
]
.br
.B conflict
.I modulefile
[
.I modulefile
\&.\|.\|.
]
.RS
These commands control whether or not the modulefile currently being
parsed will be loaded.  The
.B prereq
command lists some number of
.I modulefiles
that must be loaded at this point for the current modulefile to be
loaded.  If one of the requirements have not been satisfied, no
changes are made to the user's environment.  Similarly, the
.B conflict
command lists some number of
.I modulefiles
which conflict with the currently loading modulefile.  Again, if one
of the conflicts is loaded, the user's environment is not changed.
.RE
.PP
.B module
[
.I sub-command
] [
.I sub-command-args
]
.RS
.B module
has all of the same sub-commands as described above in the Module
Sub-Commands sections.  There are no checks to ensure that the module
writer does not try to load the currently loading modulefile for
example.  It is often useful to have a single modulefile that performs a
number of module loads.  For example, if every user on the system
should have a basic set of programs loaded, the a 'core' module would
contain multiple 'module load' commands.
.RE
.PP
.B module-info
[
.I option
] [
.I info-args
]
.RS
.B module-info
provides the module writer with information about the module command's
current state.
.I option
describes the type of information to be provided, and
.I info-args
are any arguments the requested type of information requires.
.TP
.B module-info mode \fImodetype\fP
.RS
Returns 1 if the module command's 
.I mode 
is 
.I modetype.
.I modetype
can be any one of the following:  load, remove, display, switch,
switch1, switch2, or switch3.
.RE
.TP
.B module-info name
.RS
Returns the name of the currently loading module.
.RE
.RE
.SH ENVIRONMENT
The behavior of 
.B module 
can be tailored by means of the following environment variables:
.TP
.SB \s-1MODULEPATH\s0
The path that the
.B module
command searches when looking for
.I modulefiles.
It is set to the master modulefiles directory
(/depot/Modules/modulefiles) by the initialization script.  This can
be set to search group module directories or individual module
directories before or after the master module directory.
.TP
.SB \s-1MODULESHOME\s0
The location of the master module file directory.  It is used
in setting \s-1MODULEPATH\s0 by the initialization script to
${\s-1MODULEPATH\s0}/modulefiles.  If \s-1MODULEPATH\s0 has not
already been set.
.TP
.SB \s-1LOADEDMODULES\s0
A colon separated list of all the currently loaded
.I modulefiles
.SS FILES
.TP
.B /depot/Modules/modulefiles
The directory for system-wide
.I modulefiles.
 The location of this directory can be changed using
the \s-1MODULESHOME\s0 environment variable as described above.
.TP
.B /depot/Modules/bin/modulecmd
The actual module program that gets executed upon each user
invocation of
.B module.
.TP
.B /depot/Modules/init/\fIshellname\fP
The initialization file that is sourced into the user's environment
to initialize the Modules package.
