/*------------------------------------------------------------------------

      File:  init.c
   Project:  Tcl Modules
   Created:  Tue Oct 22 23:45:57 1991
    Author:  John L. Furlani<john.furlani@East.Sun.COM>
  Revision:  1.2
  Last Mod:  20:19:59, 1/19/92

  Description of File:
		
	
	
	
	
	
	
	
------------------------------------------------------------------------*/
/***********************************************************************
* Copyright 1991 by John L. Furlani.  All rights reserved.
* 
* This material was written by John L. Furlani.
*
* Redistribution and use in source and binary forms are permitted
* provided that this entire copyright notice is duplicated in all such
* copies, and that any documentation, announcements, and other
* materials related to such distribution and use acknowledge that the
* software was developed by John Furlani.  No charge, other than an 
* "at-cost" distribution fee, may be charged for copies, derivations, 
* or distributions of this material without the express written 
* consent of the copyright holder.  The name of the author may not
* be used to endorse or promote products derived from this material 
* without specific prior written permission
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
* MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
************************************************************************/
static char SccsId[] = "@(#)init.c	1.2\t1/19/92";

#include "global.h"

int
Module_Tcl_ExitCmd(ClientData client_data,
		   Tcl_Interp* interp,
		   int argc,
		   char* argv[])
{
  char *buffer = malloc(25);
  int  value;
  
  if ((argc != 1) && (argc != 2)) {
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		     " ?returnCode?\"", (char *) NULL);
    return TCL_ERROR;
  }

  if(argc == 1) {
    value = 0;
  } else if (Tcl_GetInt(interp, argv[1], &value) != TCL_OK) {
    return TCL_ERROR;
  }

  sprintf(buffer, "EXIT %d", value);
  Tcl_SetResult(interp, buffer, NULL);

  return TCL_ERROR;
}


int
Initialize_Tcl(Tcl_Interp** interp,
	       int         argc,
	       char*       argv[])
{
  if(argc < 2) {
    fprintf(stderr, 
	    "ERROR:  Not enough arguments -- expected '%s shellname'\n",
	    argv[0]);
    exit(1);
  } else {
    strcpy(shell_name, argv[1]);
    
    if(set_derelict(argv[1]) == NULL) {
      fprintf(stderr, "ERROR:  %s is an unknown shell type\n",
	      argv[1]);
      exit(1);
    }
  }

  *interp = Tcl_CreateInterp();

  Tcl_CreateCommand(*interp, "exit", Module_Tcl_ExitCmd,
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);

  Tcl_CreateCommand(*interp, "setenv", cmdSetEnv, 
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);
  Tcl_CreateCommand(*interp, "unsetenv", cmdUnsetEnv, 
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);
  
  Tcl_CreateCommand(*interp, "prepend-path", cmdSetPath, 
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);
  Tcl_CreateCommand(*interp, "append-path", cmdSetPath, 
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);
  Tcl_CreateCommand(*interp, "remove-path", cmdRemovePath, 
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);

  Tcl_CreateCommand(*interp, "module-info", cmdModuleInfo, 
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);
  Tcl_CreateCommand(*interp, "module", cmdModule, 
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);
  
  Tcl_CreateCommand(*interp, "set-alias", cmdSetAlias, 
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);
  Tcl_CreateCommand(*interp, "unset-alias", cmdSetAlias, 
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);

  Tcl_CreateCommand(*interp, "conflict", cmdConflict, 
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);
  Tcl_CreateCommand(*interp, "prereq", cmdPrereq, 
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);

  Tcl_CreateCommand(*interp, "system", cmdSystem, 
		    (ClientData) shell_derelict, (void (*)(ClientData)) NULL);


  Tcl_InitHashTable((set_environ_changes = &set_changes_env_table), 
		    TCL_STRING_KEYS);
  Tcl_InitHashTable((unset_environ_changes = &unset_changes_env_table), 
		    TCL_STRING_KEYS);
  Tcl_InitHashTable((backup_environ_changes = &backup_env_table), 
		    TCL_STRING_KEYS);
  Tcl_InitHashTable((backup_alias_changes = &backup_alias_table), 
		    TCL_STRING_KEYS);

  return 0;
}

int
Setup_Environment(Tcl_Interp* interp)
{
  int   i, envsize = 0;
  char* eq;
 
  for(i = 0; environ[i]; i++) {
    envsize += strlen(environ[i]) + 1;
    eq = environ[i];
    while(*eq++ != '=' && *eq);  /* point to the equal sign */
    *(eq - 1)= '\0';
    if(Tcl_SetVar(interp, environ[i], eq, 0) == NULL) {
      Tcl_AppendResult(interp, "Tcl_SetVar couldn't set ",
                       environ[1], (char *) NULL);
      return TCL_ERROR;
    }
    *(eq - 1) = '=';
  }
 
  return 0;
}

int
TieStdout(void) {
  int save = dup(1);
  close(1);
  dup(2);
  return save;
}

int
UnTieStdout(int saved_stdout) {
  close(1);
  return dup(saved_stdout);
}
  
