/* ncftp.h
 * 
 * (View with tabstops every 4 places)
 */

#ifndef _ncftp_h_
#define _ncftp_h_ 1

#define kLibraryVersion "@(#) LibNcFTP 1.8.0 (December 22, 1996)"

#include <stdio.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "ncftp_errno.h"

#define kLibraryMagic "libncftp"

typedef struct FTPLibraryInfo {
	char magic[12];		       /* Don't modify this field. */
	int init;		       /* Don't modify this field. */
	int socksInit;		       /* Don't modify this field. */
	unsigned int defaultPort;      /* Don't modify this field. */
	char defaultAnonPassword[80];  /* You may set this after init. */
} FTPLibraryInfo, *FTPLIPtr;

typedef struct FTPConnectionInfo {
	char magic[12];		       /* Don't modify this field. */
	char host[64];		       /* REQUIRED input parameter. */
	char user[32];		       /* OPTIONAL input parameter. */
	char pass[64];		       /* OPTIONAL input parameter. */
	char acct[32];		       /* OPTIONAL input parameter. */
	unsigned int port;	       /* OPTIONAL input parameter. */
	int maxDials;		       /* OPTIONAL input parameter. */
	int redialDelay;	       /* OPTIONAL input parameter. */
	int netTimeout;		       /* OPTIONAL input parameter. */
	int dataPortMode;	       /* OPTIONAL input parameter. */
	FILE *debugLog;		       /* OPTIONAL input parameter. */
	FILE *errLog;		       /* OPTIONAL input parameter. */
	FTPLIPtr lip;		       /* Do not modify this field. */
	char actualHost[64];	       /* Do not modify this field. */
	char ip[32];		       /* Do not modify this field. */
	int connected;		       /* Do not modify this field. */
	int loggedIn;		       /* Do not modify this field. */
	int curTransferType;	       /* Do not modify this field. */
	unsigned long startPoint;      /* Do not modify this field. */
	int hasPASV;		       /* Do not modify this field. */
	int hasSIZE;		       /* Do not modify this field. */
	int hasMDTM;		       /* Do not modify this field. */
	int hasNLST_d;		       /* Do not modify this field. */
	struct sockaddr_in servCtlAddr;		/* Do not modify this field. */
	struct sockaddr_in servDataAddr;	/* Do not modify this field. */
	struct sockaddr_in ourCtlAddr; /* Do not modify this field. */
	struct sockaddr_in ourDataAddr;		/* Do not modify this field. */
	char *buf;		       /* Do not modify this field. */
	size_t bufSize;		       /* Do not modify this field. */
	FILE *cin;		       /* Do not use or modify. */
	FILE *cout;		       /* Do not use or modify. */
	int netMode;		       /* Do not use or modify. */
	int dataSocket;		       /* You may use but not modify/close. */
	int errno;		       /* You may modify this if you want. */
	char lastFTPCmdResultStr[128]; /* You may modify this if you want. */
	int lastFTPCmdResultNum;       /* You may modify this if you want. */
	struct timeval t0;	       /* Do not modify this field. */
	long bytesTransferred;	       /* Do not modify this field. */
	double sec;		       /* Do not modify this field. */
	double kBytesPerSec;	       /* Do not modify this field. */
} FTPConnectionInfo, *FTPCIPtr;

typedef struct Line *LinePtr;
typedef struct Line {
	LinePtr prev, next;
	char *line;
} Line;

typedef struct LineList {
	LinePtr first, last;
	int nLines;
} LineList, *LineListPtr;

/* Parameter for OpenDataConnection() */
#define kSendPortMode			0
#define kPassiveMode			1
#define kFallBackToSendPortMode	2

/* Parameter for AcceptDataConnection() */
#define kAcceptForWriting		00100
#define kAcceptForReading		00101
#define kNetWriting				kAcceptForWriting
#define kNetReading				kAcceptForReading

#define kDefaultFTPPort 21

#define kDefaultFTPBufSize		4096

#ifndef INADDR_NONE
#	define INADDR_NONE (0xffffffff)		       /* <netinet/in.h> should have it. */
#endif

#define kTypeAscii 'A'
#define kTypeBinary 'I'
#define kTypeEbcdic 'E'

#define kGlobChars "[*?"
#define GLOBCHARSINSTR(a) (strpbrk(a, kGlobChars) != NULL)

#define kGlobYes		1
#define kGlobNo			0
#define kRecursiveYes	1
#define kRecursiveNo	0

#define UNIMPLEMENTED_CMD(a) ((a == 500) || (a == 502) || (a == 504))

/* Possible values returned by GetDateAndTime. */
#define kSizeUnknown (-1L)
#define kModTimeUnknown ((time_t) 0)

#define kCommandAvailabilityUnknown	(-1)
#define kCommandAvailable		1
#define kCommandNotAvailable		0

#ifndef _ftp_c_
extern char gLibNcFTPVersion[64];

#endif

int FTPChdir(const FTPCIPtr, const char *);
int FTPChmod(const FTPCIPtr, const char *, const char *, int);
int FTPCloseHost(const FTPCIPtr);
int FTPCmd(const FTPCIPtr, const char *,...);
int FTPDelete(const FTPCIPtr, const char *, int, int);
int FTPEndDataCmd(const FTPCIPtr, int);
int FTPFileModificationTime(const FTPCIPtr, const char *, time_t *);
int FTPFileSize(const FTPCIPtr, const char *, long *, int);
int FTPGetCWD(const FTPCIPtr, char *, size_t);
int FTPGetFiles(const FTPCIPtr, const char *, const char *, int, int);
int FTPGetOneFile(const FTPCIPtr, const char *, const char *);
int FTPInitConnectionInfo(const FTPLIPtr, const FTPCIPtr, size_t);
int FTPInitLibrary(const FTPLIPtr);
int FTPList(const FTPCIPtr, int, int, const char *);
int FTPListToMemory(const FTPCIPtr, const char *, LineListPtr, const char *);
int FTPLocalGlob(FTPCIPtr, LineListPtr, const char *, int);
int FTPLoginHost(const FTPCIPtr);
int FTPMkdir(const FTPCIPtr, const char *, int);
int FTPOpenControlConnection(const FTPCIPtr);
int FTPOpenHost(const FTPCIPtr);
int FTPPutFiles(const FTPCIPtr, const char *, const char *, int, int);
int FTPPutOneFile(const FTPCIPtr, const char *, const char *);
int FTPRemoteGlob(FTPCIPtr, LineListPtr, const char *, int);
int FTPRename(const FTPCIPtr, const char *, const char *);
int FTPRmdir(const FTPCIPtr, const char *, int, int);
void FTPShutdownHost(const FTPCIPtr);
int FTPSetTransferType(const FTPCIPtr, int);
int FTPStartDataCmd(const FTPCIPtr, int, int, unsigned long, const char *,...);
void FTPStartIOTimer(const FTPCIPtr);
void FTPStopIOTimer(const FTPCIPtr);
int FTPUmask(const FTPCIPtr, const char *);
const char *FTPStrError(int e);
int FTPPutOneFileAscii(const FTPCIPtr, const char *, const char *);
int FTPPutFilesAscii(const FTPCIPtr, const char *, const char *, int, int);
int FTPGetOneFileAscii(const FTPCIPtr, const char *, const char *);
int FTPGetFilesAscii(const FTPCIPtr, const char *, const char *, int, int);

/* Other routines that might be useful. */
char *StrDup(const char *);
void DisposeLineListContents(LineListPtr);
void InitLineList(LineListPtr);
LinePtr RemoveLine(LineListPtr, LinePtr);
LinePtr AddLine(LineListPtr, const char *);
int FTPCmd(const FTPCIPtr, const char *,...);
int FTPRemoteGlob(FTPCIPtr, LineListPtr, const char *, int);
int FTPLocalGlob(FTPCIPtr, LineListPtr, const char *, int);
int BufferGets(char *, size_t, int, char *, char **, char **, size_t);
char *FGets(char *, size_t, FILE *);
void GetHomeDir(char *, size_t);
void GetUserName(char *, size_t);
void Scramble(unsigned char *dst, size_t dsize, unsigned char *src, char *key);

#endif /* _ncftp_h_ */
