/* getch.c:
 * Get one character of input from the user.
 * If a letter was typed, it will return an uppercase letter.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define NO_HOTKEYS		0
#define GETCHE_BUILTIN	1
#define TERMIOS			2
#define BSD_SGTTY		3
#define SYSV_TERMIO		4

#include "ncaa.h"

#ifndef HOTKEYS
#	ifdef HAVE_GETCHE
#		define HOTKEYS GETCHE_BUILTIN
#	else
#		ifdef HAVE_TERMIOS_H
#			define HOTKEYS TERMIOS
#		else
#			ifdef HAVE_SGTTY_H
#				define HOTKEYS BSD_SGTTY
#			else
#				ifdef HAVE_TERMIO_H
#					define HOTKEYS SYSV_TERMIO
#				else
#					define HOTKEYS NO_HOTKEYS
#				endif
#			endif
#		endif
#	endif
#endif

#if (HOTKEYS == NO_HOTKEYS)
int InputChar(void)
{
	int c;
	char buf[80];

	fgets(buf, (int) (sizeof(buf) - 1), stdin);
	c = buf[0];
	if (islower(c))
		c = toupper(c);
	return c;
}									   /* InputChar */
#endif	/* NO_HOTKEYS */



#if (HOTKEYS == GETCHE_BUILTIN)
int InputChar(void)
{
	int c;
	c = getche();
	if (islower(c))
		c = toupper(c);
	return c;
}									   /* InputChar */
#endif /* GETCHE_BUILTIN */




#if (HOTKEYS >= TERMIOS)

#ifdef HAVE_SYS_IOCTL_H
#	include <sys/ioctl.h>
#endif

#if (HOTKEYS == TERMIOS)
#	include <termios.h>
#	define ISTRUCT struct termios
#	define IOGET(F,A) tcgetattr(F, A)
#	define IOSET(F,A) tcsetattr(F, TCSAFLUSH, A)
#else
#	if (HOTKEYS == BSD_SGTTY)
#		include <sgtty.h>
#		define ISTRUCT struct sgttyb
#		define IOGET(F,A) ioctl(F, TIOCGETP, A)
#		define IOSET(F,A) ioctl(F, TIOCSETP, A)
#	else	/* (HOTKEYS == SYSV_TERMIO) */
#		include <termio.h>
#		define ISTRUCT struct termio
#		define IOGET(F,A) ioctl(F, TCGETA, A)
#		define IOSET(F,A) ioctl(F, TCSETAF, A)
#	endif
#endif
#ifndef VMIN
#	define VMIN 4
#endif
#ifndef VTIME
#	define VTIME 5
#endif

int InputChar(void)
{
	register int c;
	unsigned char buf;
	ISTRUCT tbuf, tbufsave;

	fflush(stdout);
	if (IOGET(0, &tbuf) < 0)
		goto fail;
	tbufsave = tbuf;
	tbuf.c_iflag &= ~(ICANON | IXON);
	tbuf.c_oflag &= ~(OPOST);
	tbuf.c_lflag &= ~(ICANON | ISIG | ECHO);
	tbuf.c_cc[VMIN] = 1;		   /* min */
	tbuf.c_cc[VTIME] = 2;		   /* time */
	if (IOSET(0, &tbuf) < 0)
		goto fail;
	while (read(0, &buf, 1) == 0) ;
	c = (int) buf & 0xff;
	if (islower(c))
		c = toupper(c);
  ret:
	(void) IOSET(0, &tbufsave);

	/* Omit this if you don't want the character to echo. */
	if (isgraph(c))
		putchar(c);

	putchar('\n');
	return (c);

  fail:
	c = EOF;
	goto ret;
}									   /* InputChar */

#endif		/* (HOTKEYS >= TERMIOS) */



/* Now for the HitAnyKey() function. */

#if (HOTKEYS == NO_HOTKEYS)

void HitAnyKey(void)
{
	printf("[Hit %s to continue] ", RETURNKEY);
	(void) InputChar();
}

#else

void HitAnyKey(void)
{
	printf("[Hit any key to continue] ");
	(void) InputChar();
}

#endif

/* eof getch.c */
