/* ncaa.h
 *
 * Copyright 1993-95 by Mike Gleason, NCEMRSoft. mgleason@cse.unl.edu
 * Original version: March 9, 1993.
 * 
 * Thanks to:
 *
 * Mike Marcelais and Jeff Blanchet for suggestions & bugfixes.
 *
 * Doug Brott, for providing the original postscript hack, which
 * inspired me to learn postscript and write my own.
 *
 * James Dodson, for lots of stuff.
 *
 * Tom Mortensen for supplying a home for the '94 pool.
 *
 * Dave Schmidt, Jeffery Parker, and Max Hartwig, John Liberty, and
 * Jeff Van Epps for 3.1.x fixes.
 */

#define kVersion "3.1.2 (March 8, 1995)"

#include "config.h"


/* System specific stuff first, then real C stuff later: */

/* UNIXs... */

#if defined(__sun) || defined(sun)
#	if !defined(__GNUC__) && !defined(__STDC__)
"^^^ The SunOS cc is not an ANSI C compiler.  Use gcc, acc, or clcc if you have'em."
#	endif
#	ifndef unix
#		define unix 1
#	endif
#	define SunOS 1
#endif

/* Personal computers... */

#ifdef THINK_C	/* Macintosh */
#	define DEBUG 1
#	define MultipleInstances 0
#	define MultiUserOS 0
#	undef HAVE_POPEN
#	define chdir(p) (0)
#	define DFDIR ""
#	ifdef _adminp_c_
#		define main AdminMain
#	endif
#endif

#ifdef msdos
#	define MultipleInstances 0		/* What about Windows NT? */
#	define MultiUserOS 0
#	define RETURNKEY "ENTER"
#endif

#ifdef amiga
#	ifndef HAVE_STRCASECMP
#		define STRCMP stricmp	/* I know SAS has stricmp, which would work. */
#	endif
#	define MultipleInstances 1
#	define MultiUserOS 0
#endif


/* Protection macros;  if we're running on a multiuser system like UNIX,
 * these are fairly important.  They're not important if you're running
 * this off a PC or if you trust all the players ;-).
 */
#ifdef unix
#	define Chmod(a,b) (chmod((a), (b)))
#else
#	define Chmod(a,b)
#endif
#ifndef MODE
#	define MODE 0600
#endif
#define PrivateFile(a) Chmod(a, MODE)

/* Defaults, if you messed up the config.h file. */
#ifndef DFDIR
#	ifdef unix
		"^^^ You MUST define DFDIR. ^^^"	/* Intentional syntax error. */
#	else
#		define DFDIR ""		/* I hope your system sets the current working
							 * directory to the same one that holds the
							 * executable then!
							 */
#	endif
#endif	/* DFDIR */


#ifndef STRCMP
#	ifdef HAVE_STRCASECMP
#		define STRCMP strcasecmp
#	else
#		define STRCMP strcmp
#	endif
#endif	/* STRCMP */

#ifndef PAGER
#	define PAGER "more"
#endif

#ifndef CANPRINT
#	ifdef PRINTER
#		define CANPRINT 1
#	else
#		define CANPRINT 0
#	endif
#endif

#ifndef CANMAIL
#	ifdef MAILER
#		define CANMAIL 1
#	else
#		define CANMAIL 0
#	endif
#endif

#ifndef WANTPSCODE
#	if CANMAIL || CANPRINT
#		define WANTPSCODE 1
#	else
#		define WANTPSCODE 0
#	endif
#endif

#ifndef DEFAULT_PS_PRINTER
#	define DEFAULT_PS_PRINTER ""
#endif

/* Can there be two or more instances of the program running at once?
 * This includes the case where different users can be running the program
 * at the same time, AND also the case where you can run multiple copies
 * of the program for one user (like AmigaDOS).
 */
#ifndef MultipleInstances
#	ifdef unix
#		define MultipleInstances 1
#	else
#		define MultipleInstances 0
#	endif
#endif	/* MultipleInstances */

/* Can this machine be used by different users simultaneously? 
 * UNIX yes, personal computers no (usually).  If no, we don't
 * need to worry about protecting files from other users, or worry
 * about running in setuid mode and have some other user do something
 * as to cause the program to write all over our stuff.
 */
#ifndef MultiUserOS
#	ifdef unix
#		define MultiUserOS 1
#	else
#		define MultiUserOS 0
#	endif
#endif	/* MultiuserOS */

/* What ask for when you want them to hit the return key. */
#ifndef RETURNKEY
#	define RETURNKEY "RETURN"
#endif

#ifndef DEBUG
#	define DEBUG 0
#endif

#if DEBUG
#	define STRICT_PROTOS 1
#endif




/*--------------------------------------*/
/* PROGRAM STUFF STARTS HERE (finally!) */
/*--------------------------------------*/

#define kNumTeams 64
#define kTotalGames (kNumTeams - 1)		/* If there 2^i teams in a binary
										 * tournament, the total number of
										 * games to play will be 2^(i-1) +
										 * 2^(i-2) + ... + 2 + 1 which is
										 * 2^i - 1 total.
										 */

/* These are the names of the data files we use; all will reside in
 * the DFDIR, defined from the Makefile.
 */
#define kTournFile "tourney.txt"
#define kPlayerFile "players.txt"
#define kPlayerFileLock "players.lock"
#define kResultsFile "results.txt"
#define kLockFile "lock.txt"
#define kOptionsFile "options.txt"
#define kTmpFile "tmpfile.txt"

/* Comment lines in the data files can start with this character and
 * be considered a comment line.
 */
#define kCommentChar '#'

/* Since a pick string contains characters between 0 and 63, we can't
 * use 0 as a nul terminator, so instead use this character to denote
 * the end of the pick string.
 */
#define kEOPicks kNumTeams

/* Possible printing modes used for Print(). */
#define kPrintBlank 0
#define kPrintPicks 1
#define kPrintResults 2

typedef int (*cmp_t) (const void *, const void *);

/* Default methods.  Normally the pool administrator sets the defaults
 * using the "admin" program, and the program reads those defaults.  If for
 * some reason that file doesn't exist we use these values.  No big deal,
 * since the admin is supposed to set the defaults from the "admin" program.
 */
#define GMETHOD Grade1
#define SMETHOD byPoints

typedef struct Picks {
	char	firstrd[32],
			secondrd[16],
			thirdrd[8],
			fourthrd[4],
			fifthrd[2],
			sixthrd;
	short	tieBreaker;
} Picks;

typedef char
	PlayerName[40],
	PlayerLine[128],				/* Usu. a PlayerName and PicksLine */
	TeamName[48],					/* Leave room for full school name, and seed info. */
	ResultLine[kNumTeams + 4],		/* Need one byte for each game (63), plus kEOPicks terminator, plus padding. */
	OptionsLine[80],
	PicksLine[kNumTeams + 4],		/* Same as in ResultLine, but for picks. */
	TournLine[128];					/* Needs to accomodate possiblly long comments */

typedef struct Player {
	PlayerName name;
	PicksLine picks;
	short nCorrectPicks, points, tieBreaker;
	char scores[6];
	char roundPts[6];
} Player;

typedef void (*gradeproc_t) (int, int, int, int, int, Player *);
#define nGradeProcs ((int)(sizeof(gradeprocs)/sizeof(gradeproc_t)))

struct Hits {
	int hits, tnum;
};

#define PERC(a,b) ((float) ((100.0 * (float)(a)) / (float)(b)))


/*--------------------------------------*/
/* Prototypes...                        */
/*--------------------------------------*/

#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif

#if defined(STRICT_PROTOS) && defined(unix)
	/* Include these, only because we want the proper function protos. */
#	include <sys/stat.h>
	extern int ioctl(int, int, ...);
#endif

/* Our prototypes: */
void SetDataFileDirectory(void);
char *FGets(char *in, size_t max, FILE * fp);
void ReadTournamentFile(void);
void ReadResultsFile(void);
int FileExists(char *fname);
int LockFile(char *lockfname);
void ClosePlayerFileOpenedForWriting(FILE *fp);
FILE *OpenPlayerFileForWriting(int append);
int LineToPlyrPtr(PlayerLine line0, Player *pptr);
int AddToPlayerFile(char *playerName, Picks *p);
void InitRandom(void);
int ReplacePlayerPicks(PlayerName pName, Picks *p);
FILE *OpenPager(void);
int FindPlayer(PlayerName pname, PlayerLine line);
int GetPlayerName(PlayerName pName);
int CheckForIllegals(char *cp);
void ClearScreen(void);
int InputChar(void);
void HitAnyKey(void);
void ProgressMsg(char *msg);

#if WANTPSCODE
FILE *OpenPrinter(void);
void GetPrinterName(char *pname, size_t pnamlen);
FILE *OpenMailer(void);
int PromptForPrinter(char *printcmd);
#endif

int ClosePipe(FILE *fp);
#define CloseMailer		ClosePipe
#define ClosePager		ClosePipe
#define ClosePrinter	ClosePipe

void StringToPicks(char *cp);
#define StringToResults StringToPicks

void Grade0(int t1, int t2, int pick, int winner, int rd, Player *p);
void Grade1(int t1, int t2, int pick, int winner, int rd, Player *p);
void Grade2(int t1, int t2, int pick, int winner, int rd, Player *p);
void Grade3(int t1, int t2, int pick, int winner, int rd, Player *p);

int byPoints(Player *a, Player *b);
int byWins(Player *a, Player *b);

void Print(int);

/* eof */
