#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "ncaa.h"

#if WANTPSCODE

extern ResultLine results;
extern int nResults;
extern short tieBreaker;
extern TeamName teamnames[kNumTeams];
extern int seeds[kNumTeams];
extern char *Regionals[4];
extern PlayerName curPlayerName;
char curPrinter[64] = DEFAULT_PS_PRINTER;
char curRecip[128] = "";

/* If you don't have the time functions, you'll have to define YEAR
 * to be what year this is.
 */
#ifndef YEAR
#include <time.h>
#endif




FILE *OpenMailer(void)
{
#if HAVE_POPEN
	FILE *fp;
	char str[256];
	char toWhom[128];
	
	fp = NULL;
	
	printf("Mail to");
	if (curRecip[0])
		printf(" [%s for \"%s\"]", RETURNKEY, curRecip);
	printf(": ");
	if ((FGets(toWhom, sizeof(toWhom) - 1, stdin) == NULL)
		|| (toWhom[0] == '\0'))
	{
		strncpy(toWhom, curRecip, sizeof(toWhom) - 1);
	}
	if (toWhom[0]) {
		if (CheckForIllegals(toWhom) == 0) {
			strncpy(curRecip, toWhom, sizeof(curRecip) - 1);
			strncpy(str, "t64ps | ", sizeof(str) - 1);
			strncat(str, MAILER, sizeof(str) - 1);
			strncat(str, " '", sizeof(str) - 1);
			strncat(str, toWhom, sizeof(str) - 1);
			strncat(str, "'", sizeof(str) - 1);
			fp = popen(str, "w");
			if (fp == NULL) {
				fprintf(stderr, "An error occurred while attempting to mail!\n");
				perror(str);
			}
		}
	} else
		printf("Nevermind.\n");
	return (fp);
#else
	return (NULL);
#endif
}	/* OpenMailer */



/* Check the print command for presence if the %p flag.  If it exists
 * return TRUE, so the caller will ask the user for a printer name.
 */
int PromptForPrinter(char *printcmd)
{
	char *cp;
	
	for (cp=printcmd; *cp; cp++)
		if ((*cp == '%') && (cp[1] == 'p'))
			return 1;
	return 0;
}	/* PromptForPrinter */



/* Ask for a printer name to send to, depending on if the PRINTER printing
 * command as the %p.  If it doesn't, don't worry about it, since that
 * means we don't need to know the printer name (maybe the PRINTER
 * command has it hard coded into it, or there is only one printer).
 */
void GetPrinterName(char *pname, size_t pnamlen)
{
	pname[0] = '\0';
	if (PromptForPrinter(PRFLAG)) {
		printf("Printer to send to");
		if (curPrinter[0])
			printf(" [%s for \"%s\"]", RETURNKEY,
curPrinter[0] ? curPrinter : "system default printer");
		printf(": ");
		if ((FGets(pname, pnamlen - 2, stdin) == NULL) || (pname[0] == '\0')) {
			strncpy(pname, curPrinter, pnamlen - 1);
		}
		strncpy(curPrinter, pname, sizeof(curPrinter) - 1);
	}
}	/* GetPrinterName */




FILE *OpenPrinter(void)
{
#if HAVE_POPEN	
	FILE *fp;
	char str[256], *cp, *dp;
	char pcmd[128];
	char printer[128];
	
	GetPrinterName(printer, sizeof(printer));

	fp = NULL;
	if (CheckForIllegals(printer) == 0) {
		strncpy(pcmd, "t64ps | ", sizeof(pcmd) - 1);
		strncat(pcmd, PRINTER, sizeof(pcmd) - 1);
		strncat(pcmd, " ", sizeof(pcmd) - 1);
		if (printer[0] != '\0') {
			strncat(pcmd, PRFLAG, sizeof(pcmd) - 1);
			strncat(pcmd, " ", sizeof(pcmd) - 1);
		}

		for (cp = pcmd, dp = str; *cp; cp++) {
			/* Check the printer string for special flags.  We do
			 * special things if %flags are present, like %p inserts
			 * the printer name given into the pathname.  At present
			 * there is only one special flag though.
			 */
			if (*cp == '%') {
				++cp;
				switch(*cp) {
					case 0: --cp; break;
					case 'p':
						strcpy(dp, printer);
						dp += strlen(printer);
						break;
					default: *dp++ = *cp;
				}
			} else
				*dp++ = *cp;
		}
		*dp = 0;
		printf("Printing, please wait...\n%s\n", str);
		fp = popen(str, "w");
		if (fp == NULL) {
			fprintf(stderr, "An error occurred while attempting to print!\n");
			perror(str);
		}
	}
	return (fp);
#else
	return (NULL);
#endif
}	/* OpenPrinter */



#if DEBUG
static FILE *GetPSFileName(void)
{
#if !HAVE_POPEN
	return (stdout);
#else
	FILE *fp;
	char fname[256];
	char str[256];

	/* Better NOT be setuid then!!! */

	printf("Save PostScript file as: ");
	if ((FGets(fname, sizeof(fname), stdin) == NULL) || (fname[0] == '\0')) {
		printf("Nevermind.\n");
		return NULL;
	}

	strncpy(str, "t64ps > ", sizeof(str) - 1);
	strncat(str, fname, sizeof(str) - 1);
	fp = popen(str, "w");
	if (fp == NULL) {
		fprintf(stderr, "Could not open for writing.\n");
		perror(str);
	}
	return (fp);
#endif
}	/* GetPSFileName */
#endif




void Print(int mode)
{
	int j, result;
	FILE *fp = NULL;
	PlayerLine line;
	char *cp;
	Player p;
	int year, choice;

#ifdef YEAR
	/* The block of code after the #else won't compile, just take the
	 * easy way out and add #define YEAR 1995 somewhere.
	 */
	year = YEAR;
#else
	time_t now;
	struct tm *tyme;

	time(&now);
	tyme = localtime(&now);
	year = tyme->tm_year + 1900;
#endif

	if (mode == kPrintBlank) {
		cp = line;
		*cp = kEOPicks;	
	} else if (mode == kPrintPicks) {
		if (GetPlayerName(curPlayerName) < 0)
			return;
		if (FindPlayer(curPlayerName, line) < 0) {
			fprintf(stderr, "%s: No such player.\n", curPlayerName);
			return;
		}
		/* Convert what FindPlayer gave us into something more meaningful. */
		if (LineToPlyrPtr(line, &p) < 0)
			return;

		cp = p.picks;
	} else /* kPrintResults */ {
		ReadResultsFile();			   /* May or may not exist at this point. */
		cp = results;
	}

#if HAVE_POPEN
#if CANPRINT && CANMAIL
	/* Put up a nice menu and ask what you'd like to do since you
	 * can do either.
	 */
	ClearScreen();
	
	printf(
"The program outputs in PostScript(tm).  You can try sending the\n"
"file directly to a printer, or you can e-mail it to someone (i.e.\n"
"one of your own accounts, so you can deal with it yourself).\n\n"
"  <1>  Print\n"
"  <2>  Mail\n");
#if DEBUG
	printf("  <3>  Dump\n");
#endif
	printf("\nChoice: ");
	do {
		choice = InputChar();
	} while ((choice < '1') &&
#if DEBUG
			(choice > '3'));
#else
			(choice > '2'));
#endif
											
	
	switch (choice) {
		case '1': fp = OpenPrinter(); break;
		case '2': fp = OpenMailer(); break;
#if DEBUG
		case '3': fp = GetPSFileName();
#endif
	}
	
#elif CANPRINT
	fp = OpenPrinter();
#elif CANMAIL
	fp = OpenMailer();
#endif	/* CANPRINT, CANMAIL */

#else	/* !HAVE_POPEN */
	fp = GetPSFileName();
#endif	/* ! HAVE_POPEN */

	if (fp == NULL)
		return;

	if (mode == kPrintPicks)
		(void) fprintf(fp, "Headers=Picks by %s,Tiebreaker: %d\n",
			p.name, p.tieBreaker);
	else
		(void) fprintf(fp, "Headers=%d NCAA Men's,Basketball Championship\n", year);
		
	(void) fprintf(fp, "Regionals=");
	for (j=0; j<4; j++)
		(void) fprintf(fp, "%s%c", Regionals[j], (j==3) ? '\n' : ',');
	for (j=0; j<kNumTeams; j++)
		(void) fprintf(fp, "(%d) %s\n", seeds[j], teamnames[j]);
	for (; *cp != kEOPicks; cp++)
		(void) fprintf(fp, "%s\n", teamnames[(int) *cp]);

	result = ClosePipe(fp);
	if (result == 0) {
		printf("\nEverything seemed to go okay.\n");
	} else {
		printf("\nMay not have succeeded;  error code %d.\n",
			result);
	}
}	/* Print */

#endif /* WANTPSCODE */

