int rdbuf(ibuf,ie1,ie2,ie3,tmo)
char ibuf[],ie1,ie2,ie3;
int tmo;
{
/*
        this subroutine reads characters from the serial line.  the
	SUN version uses a loop on the system read call.  for the
	IBMPC version if BIOS is defined, the read is done using
	interrupt calls to the port defined by cmport.  if BIOS is not
 	defined, direct calls are made to the hardware using inport and
	outport at the hardware address cmadr.  the characters are stored
	in ibuf.  the operation continues until any one of the three line
        terminators ie1, ie2 or ie3 is found.  the operation also ends
        on the 280th character if no line terminator is found before that.
        the input line is terminated by a zero byte; the last
        character before the zero byte is the terminator.

        the parameter tmo is a time-out count.  if no character is
        received before tmo goes to zero, the subroutine returns with
        a count of zero (a time-out on a partial line will result in
        the line being thrown away).

        the comparison against the terminating characters is made after
        the 8th bit is cleared in the received character.  Thus if a
        terminating character has its 8th bit on (i.e. is negative),
        then it will never be matched and is effectively removed from
        the comparison.
*/
#include "nbstime.h"
#include <stdio.h>
#ifdef IBMPC
#include <dos.h>
#endif
#ifdef SUN
#include <sys/ioctl.h>
#endif
extern int debug;
int j,tcount;
#ifdef IBMPC
unsigned char stat,mstat;
int tlimit = -16000;
#endif
char cc;
#ifdef IBMPC
#ifdef BIOS
extern int cmport;
#endif
#ifndef BIOS
extern int cmadr;
#endif
#endif
#ifdef SUN
extern int cmport;
long int k;
int tlimit = -1000;
#endif
        tcount= tlimit;
        j=0;
#ifdef SUN
/*
	loop until character is ready or tcount goes to 0
*/
	do
	{
	   do
	   { 
	      ioctl(cmport,FIONREAD,&k);
	      tcount++;
	   } while( (tcount < 0 ) && (k < 1) ) ;
	   if(tcount == 0)
	      {
	      tcount=tlimit;
	      tmo++;
	      if(tmo == 0) return (0);
	      }
	   else
	      {
	      read(cmport,&cc,1);
	      ibuf[j]= cc = cc & 0x7f;
	      j++;
	      tcount=tlimit;
	      }
	} while( (j < 280) && (cc != ie1) && (cc != ie2) && (cc != ie3) );
#endif
#ifdef IBMPC
        do
        {
           do
           {
/*
        loop until character is available or tcount goes to 0.
*/
           #ifdef BIOS
           _AH=3;
           _DX=cmport;
           geninterrupt(0x14);
           stat=_AH;
           mstat=_AL;
	   #endif
	   #ifndef BIOS
           stat=inportb(cmadr+lsreg);     /* read line status*/
           mstat=inportb(cmadr+msreg);    /* read modem status*/
           #endif
           tcount++;
           }  while ( (tcount < 0) && ( (stat & 1) ==0) );
/*
        if we exited on a time out, increment time out counter, return
        0 if number of time outs has expired, else go around again
*/
        if(tcount == 0)
           {
           tmo++;
           if(tmo == 0) return(0);
           }
        else
/*
        if tcount !=0 we exited on a char. available.  now read it,
        turn off m. s. bit, store in array and advance pointer
*/
           {
           #ifdef BIOS
           _AH=2;
           _DX=cmport;
           geninterrupt(0x14);
           cc=_AL;
	   #endif
	   #ifndef BIOS
           cc=inportb(cmadr);
           #endif
           ibuf[j]= cc= cc & '\x7f';    /* turn off ms bit */
           j++;
/*
        if clear to send and carrier detect have been lost then
        the fact that a character is ready to be read is an error
        terminate line here. how can the hardware do this over
        and over again ??
*/
           if( (mstat && 0xb0) == 0)
              {
              ibuf[j]=0;
              return(j);
              }
           }
        tcount=tlimit;
        } while ( (j < 280) && (cc != ie1) && (cc != ie2) && (cc != ie3));
#endif
        ibuf[j]=0;
        return(j);
}
