/*
 * GIZMO machine dependent declarations
 */

/*
 * No way to read variables from the gizmo's kernel, so we just hardwire
 * a default tickadj and tick
 */
#define	GIZMO_HZ	60
#define	GIZMO_TICKADJ	((500 + GIZMO_HZ - 1) / GIZMO_HZ)
#define	GIZMO_TICK	(1000000 / GIZMO_HZ)

/*
 * Authentication keys are transmitted to the gizmo in the configuration
 * info.  Unfortunately this is insecure (figure out why).  We hence
 * encrypt each key one more time using some variation of the following
 * key.  This doesn't make things any more secure, but at least
 * gets the code in there until I figure out a better way.
 */
#define	GIZMO_KEY_L	0x589dd0a8
#define	GIZMO_KEY_R	0x86b0d508

/*
 * Size of the configuration array.  Make it large enough for a
 * reasonable number of keys.
 */
#define	GIZMO_CONFIG_SIZE	4096

/*
 * Configuration codes for the gizmo
 */
#define CONFIG_UNKNOWN		0
#define	CONFIG_END		255

#define	CONFIG_PEER		1
#define	CONFIG_SERVER		2
#define	CONFIG_PRECISION	3
#define	CONFIG_DRIFT		4
#define	CONFIG_BROADCAST	5
#define	CONFIG_BROADCASTCLIENT	6
#define	CONFIG_AUTHENTICATE	7
#define	CONFIG_KEYS		8
#define	CONFIG_MONITOR		9
#define	CONFIG_AUTHDELAY	10
#define	CONFIG_RESTRICT		11
#define	CONFIG_BDELAY		12
#define	CONFIG_TRUSTEDKEY	13
#define	CONFIG_REQUESTKEY	14
#define	CONFIG_CONTROLKEY	15
#define	CONFIG_TRAP		16
#define	CONFIG_FUDGE		17
#define	CONFIG_MAXSKEW		18
#define	CONFIG_DEBUGLEVEL	100
#define	CONFIG_SYSLOGHOST	101

#define	CONF_MOD_VERSION	1
#define	CONF_MOD_KEY		2
#define	CONF_MOD_MINPOLL	3

#define	CONF_RES_IGNORE		0x001
#define	CONF_RES_NOSERVE	0x002
#define	CONF_RES_NOTRUST	0x004
#define	CONF_RES_NOQUERY	0x008
#define	CONF_RES_NOMODIFY	0x010
#define	CONF_RES_NOPEER		0x020
#define	CONF_RES_NOTRAP		0x040
#define	CONF_RES_LPTRAP		0x080
#define	CONF_RES_NTPPORT	0x100
#define	CONF_RES_MASK		0x1000

#define	CONF_TRAP_PORT		1
#define	CONF_TRAP_INTERFACE	2

#define	CONF_FDG_TIME1		1
#define	CONF_FDG_TIME2		2
#define	CONF_FDG_VALUE1		3
#define	CONF_FDG_VALUE2		4
#define	CONF_FDG_FLAG1		5
#define	CONF_FDG_FLAG2		6
#define	CONF_FDG_FLAG3		7
#define	CONF_FDG_FLAG4		8

#define	CONF_YORN_NO		1
#define	CONF_YORN_YES		2
