#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <stdlib.h>

/*
 * Parameters
 */
#define PI 3.141592653589
double envelope(double), gauss(double);
void corr(char[], char[]);
double a, b;

char mcode[] =  {+1,+1,-1,-1,+1,-1,+1,-1, +1,-1,-1,+1,+1,+1,+1,+1};
char mxcode[] = {+1,-1,-1,+1,+1,+1,+1,+1, +1,+1,-1,-1,+1,-1,+1,-1};
char macode[] = {+1,+1,-1,-1,+1,-1,+1,-1,  0, 0, 0, 0, 0, 0, 0, 0};
char mbcode[] = {+1,-1,-1,+1,+1,+1,+1,+1,  0, 0, 0, 0, 0, 0, 0, 0};

char scode[] =  {+1,+1,+1,+1,+1,-1,-1,+1, +1,-1,+1,-1,+1,+1,-1,-1};
char sxcode[] = {+1,-1,+1,-1,+1,+1,-1,-1, +1,+1,+1,+1,+1,-1,-1,+1};
char sacode[] = {+1,+1,+1,+1,+1,-1,-1,+1, 0, 0, 0, 0, 0, 0, 0, 0};
char sbcode[] = {+1,-1,+1,-1,+1,+1,-1,-1, 0, 0, 0, 0, 0, 0, 0, 0};

void main() {
	int i, j;
	double t, u, dtemp, etemp, ftemp, gtemp, htemp;

	printf("master-master  "); corr(mcode, mcode);
	printf("master-masterx "); corr(mcode, mxcode);
	printf("master-mastera "); corr(mcode, macode);
	printf("master-masterb "); corr(mcode, mbcode);

	printf("slave-slave    "); corr(scode, scode);
	printf("slave-slavex   "); corr(scode, sxcode);
	printf("slave-slavea   "); corr(scode, sacode);
	printf("slave-slaveb   "); corr(scode, sbcode);

	printf("master-slave   "); corr(mcode, scode);
	printf("master-slavex  "); corr(mcode, sxcode);
	printf("slave-masterx  "); corr(scode, mxcode);

	dtemp = etemp = 0;
	ftemp = 1;
	htemp = 0;
	for (t = 0; t < 400; t += 1) {
		htemp++;
		dtemp += pow(envelope(t), 2);
		ftemp += (pow(gauss(1), 2) - ftemp) / 256;
		etemp += gauss(1);
		}
	gtemp = (dtemp + ftemp) / htemp;
	dtemp /= htemp;
	etemp = etemp / htemp;
	ftemp = sqrt(ftemp);
	printf("%10.2lf%10.2lf\n", sqrt(etemp), ftemp);
	}

/*
 * Subroutine to produce Gaussian noise samples
 *
 * This subroutine generates a random number uniformly distributed
 * over the interval [-1, 1], then transforms the distribution to
 * a Gaussian distribution with zero mean and specified standard
 * deviation. See the header file for additional data.
 *
 * Calling sequence: x = gauss(sigma)
 * 	sigma		standard deviation of noise
 *	x			noise sample
 *
 * Variables and functions used (math library)
 *	rand()		generate uniform random sample over [0, 32767]
 *	sqrt()		square rootsie
 *	log()		log base e
 */
double gauss(sigma)
	double sigma;				/* standard deviation of noise */
	{
 	double x, y;				/* double temps */

	x = ((double)rand() / 16384 - 1);
	if (x > 0)
		y = sigma / sqrt(2) * log(1 / x);
	else if (x < 0)
		y = -sigma / sqrt(2) * log(1 / -x);
	else
		y = 0;
	return (y);
	}

/*
 * Subroutine to produce LORAN-C envelope pulse
 *
 * This subroutine generates the standard LORAN-C envelope pulse
 * normalized for unit peak amplitude. By numeric methods the integral
 * of the normalized envelope is 120.072 and the integral of the square
 * of the normalized envelope is 83.1769. See the header file for
 * additional details. Note that 65 * 65 * exp(-2) = 571.792.
 *
 * Calling sequence: x = envelope(t)
 * 	t			simulation time (us)
 *	x			pulse amplitude
 *
 * Variables and functions used (math library)
 *	sin()		sine function
 *	cos()		cosine function
 *	exp()		exponent base e
 */
double envelope(t)
	double t;					/* simulation time */
	{

	if (t > 0 && t < 400)
		return (t * t * exp(-2 * t / 65) / 571.792);
	else
		return (0);
	}

/*
 * compute correlation function between two vectors
 */
void corr(u, v) char u[],v[]; {
	double a;
	int i, j;

	for (i = 0; i < 16; i++) {
		a = 0;
		for (j = 0; j < 16; j++) {
			if (i+j < 16)
				a += v[j]*u[i+j];
			}
		printf("%3.0f", a);
		}
	printf("\n");
	}

