 /* NETWORK SIMULATOR 
	NetSim 1.0
    		Rob Redwinski
  	This Version: Completed August 1998 

    	redwinsk@ee.udel.edu

*/

#include <fstream.h>
#include <stdlib.h>
#include "node_list_definition.h"
#include "nodules.h"
#include "eventqueue.h"
#include "primitives.h"
#include "broadcastinfo.h"

int addelemcounter=0;
int howmany=0;
int innercount=0;
float delta=0.1;
// Counters used for verification of memory usage
float bellmannew=0;
float eventqueuenew=0;
float thegrandtotal=0;

// reaperflag determines whether or not there will be a manual kill(1)
// or a randomized set of kills (0)
char reaperflag=0;
char bob=0;
float lowerbound=0, upperbound=0;

int clockfix=0; 

// Can track one or more nodes through all relevant events.
char tracking=0;
short track[]={1,-1};
// -1 is end delimiter

// Time for death/Node - manual failures
// Format is  Time for node/link to drop, row#, col#, -5 (delimiter)
short reaper[]={30,2,2,-5};
//short reaper[]={0,4,4,0,2,2,0,6,6,0,702,702,0,856,856,0,553,553,0,222,222,-5};

// External file, reaperind.h created from reaperind.C can contain a large
// number of manual failures and times to drop

// unreap contains values to bring back up manually
short unreap[]={120,2,2,-5};

//int reaper[]={-5};
// Above is default setting for reaper

// Below: indices into the reaperindex and unreapindex to point to
// next node of interest.
short unreapindex=0;
short reaperindex=0;
int counter,flag=1;
int size2=size,connect2=connectivity;

// Initialize values for keeping track of overall network churn
float churning=0,churningtotal=0,churn100thou=0,churning100thoutotal=0,churn10bill=0,churning10billtotal=0,churnbig=0,churningbigtotal=0,bchurninga=0,bchurnabig=0,bchurna100thou=0,bchurna10bill=0;

// DEFAULT VALUES FOR OUTPUT OPTIONS  *****************
// verbose: outputs entire tracking data for every variable
// split: activates split horizon
// duplex: duplex links, if one end goes down, the other end does as well
// update: an abbreviated version of verbose
// amount: amount of connectivity
// timer: whether or not the simulation will end relative to a pre-selected
//        global time (see timetorun comment below).
char verbose=0,split=1,churner=0,duplex=1,update=0,timer=1,execution=1,nodedist=0,finalize=0;

// ****************************************************
// Define the value for infinity/unreachable destination:
int infinitee=size2+10;

// timetorun CONTAINS AMOUNT OF WALLCLOCK TIME TO EXECUTE SIMULATION FOR
// WILL ONLY BE USED IF time=1
float wallclock=0,timetorun=500, wallclock1=0, adjustment=0;

// *********************************************************
// NETWORK DEFINITION
nodule routing[size][size];

// EVENTQUEUE DEFINITION
list1 my_list;
list_node *n;

// BROADCASTED-DATA MEMORY DEFINITION
list2 brcastmemory[size];
list_broad *brcastchanges;
// *********************************************************


void churn(int x)
        {
// Keeps track of the amount of overall network churn, and
// handles overflow problems
        if (x>0)
        {
        churning++;
        if (churning==100000)
                {
                churning=0;
                churn100thou++;
                        if (churn100thou==100000)
                                {
                                churn100thou=0;
                                churn10bill++;
                                        if (churn10bill==1000000)
                                                {
                                                 churn10bill=0;
                                                 churnbig++;
                                                }
                                }
                }
        }
        else
        {
        churning--;
        if (churning<0)
                {
                churning=0;
                churn100thou--;
                        if (churn100thou<0)
                                {
                                churn100thou=0;
                                churn10bill--;
                                        if (churn10bill<0)
                                                {
                                                churn10bill=0;
                                                churnbig--;
                                                        if (churnbig<0)
                                                                churnbig=0;
                                                }
                                }
                }
        }
        }
 


int cmp_ptr_node(const void *a, const void *b)
        {
// Needed for qsort to sort initial queue
// AUGMENTED FROM ORIGINAL TO SORT BASED ON za (BROADCASTTIME) AS OPPOSED
// TO z (HELLOTIME)
          int x, y;
          float z;
	  float za;

        const list_node *la=*((const list_node * const *)a);
        const list_node *lb=*((const list_node * const *)b);

        if (la->get_za() < lb->get_za())
                { return -1; }
        else if (la->get_za() > lb->get_za()) {
                return 1; }
        else {return 0;}
        }

int same(char* p, char* q)
	{
// Check 2 strings to see if they're the same
	int ii=0;
	int flagii=1;
	while ((flagii)&&(p[ii]!='\0')&&(q[ii]!='\0'))
		{
		if (p[ii]!=q[ii])
			{
			flag=0;
			return (0); 
			}
		ii++;
		}
	return(1);
	}

void arrayprint()
        {
// Print-out current routing table with current values for hop counts
        for (int i=0;i<size;i++)
                {
        for (counter=0;counter<size;counter++)
                cout<<routing[i][counter].length<<" ";
        cout<<endl;
                }
        }

int whereisit(int row2find, int col2find)
	{
// GIVEN A NODE IS GOING TO DROP, NEED TO FIND ITS
// LOCATION AND PERTINENT INFO. FOR UPDATING
// ITS LENGTH AND DEATH-STATE
	n=my_list.first();
	int scnt=0;
	while ((n!=NULL)&&(scnt<howmany))
		{
		if ((n->getrow()==row2find)&&(n->getcolumn()==col2find))
			return(scnt);
		else {scnt++; n=my_list.next(n);}			
		}
	return (0);
	}

void inventory(int row)
	{
	// PRINTS OUT THE CONTENTS OF THE GIVEN NODE'S 
	// BROADCAST MEMORY
	brcastchanges=brcastmemory[row].first();
	brcastchanges->gotofirst();
	while (brcastchanges!=NULL)
		{
		if (verbose)
			{
			cout<<"From: "<<row<<endl;
			cout<<" Going to: "<<brcastchanges->getforwhichnode()<<endl;
			}
		short stoppit=brcastchanges->isnull();
		while (!stoppit)
			{
			if (verbose)
			cout<<brcastchanges->getelement()<<" "<<brcastchanges->returnvalue()<<endl;
			brcastchanges->advance();
			stoppit=brcastchanges->isnull();
			}
		brcastchanges=brcastmemory[row].next(brcastchanges);
		if (brcastchanges!=NULL)
			{
			brcastchanges->gotofirst();
			}
		}
	}

// NEW BELLMAN
void bellman1(int broadcastrow,int receiverow)
        {
	short changes=0;
	// BELLMAN FORD ROUTING ALGORITHM. PART I
	// This portion of the bellman ford algorithm
	// serves to determine the differences between
	// the broadcasting node's routing table, and the receiver's.
	// The differences are indexed and stored in the broadcaster's
	// broadcast memory for later retrieval by the receiver.
 
	// Works from broadcaster to receiver.

	// New transmission 
	if (verbose)
	cout<<"Broadcast from: "<<broadcastrow<<" going to: "<<receiverow<<endl;
	   brcastmemory[broadcastrow].append(new list_broad());
		bellmannew++;
	if (verbose)
		{
		cout<<"broadcasting from: "<<broadcastrow<<" going to row:"<<receiverow<<endl;
	//print out the two rows as they currently are:
		for (int i=0;i<size;i++)
			{
			cout<<routing[broadcastrow][i].length<<" ";
			}
		cout<<endl;
		
		for (int j=0;j<size;j++)
			{
			cout<<routing[receiverow][j].length<<" ";
			}
		cout<<endl;
		}
        // FIRST - MAKE SURE THAT THE BEST DISTANCE BETWEEN THESE NEIGHBORS
        // IS CURRENTLY ACHIEVED:
        // Corrects for 1-hop neighbor going down and coming back up.
       /* if ((routing[broadcastrow][receiverow].length==1)&&(routing[receiverow][broadcastrow].length!=1)&&(routing[receiverow][receiverow].length!=infinitee))
                routing[receiverow][broadcastrow].length=1; */
//below is genericized version of above 2 lines
	if ((routing[broadcastrow][receiverow].txmit==1)&&(routing[broadcastrow][receiverow].length!=routing[receiverow][broadcastrow].length)&&(routing[receiverow][receiverow].length!=infinitee))
		{
		if (routing[broadcastrow][receiverow].length<routing[receiverow][broadcastrow].length)
			routing[receiverow][broadcastrow].length=routing[broadcastrow][receiverow].length;
		else
			routing[broadcastrow][receiverow].length=routing[receiverow][broadcastrow].length;
		}
// end genericized lines


        for (int subcount=0;subcount<size;subcount++)
                {
                // +1 -- only 1-hop neighbors update
		// dist2 used to be 1
		double dist2=routing[receiverow][broadcastrow].length;
 		if (((routing[broadcastrow][subcount].length+dist2)<(routing[receiverow][subcount].length))&&(routing[broadcastrow][subcount].length!=0)||((routing[receiverow][subcount].length==0)&&(subcount!=receiverow)&&(routing[broadcastrow][subcount].length!=0)))
 			{
			//  ACTUAL UPDATE CHOICES MADE HERE 
			if (verbose)
				{
				cout<<" a difference: "<<endl;
				cout<<" element: "<<subcount<<" will have a new value of: "<<routing[broadcastrow][subcount].length+dist2<<endl;
				}
			changes=1;
			int okaytoproceed=1;

			if (split)
				{
				// verify that the new update isn't a cycle
				if (routing[broadcastrow][subcount].updatnde==subcount)
					{
					// Shouldn't make an update.
					okaytoproceed=0;
					changes=0;
					if (verbose||update)
						cout<<"Split horizon active."<<endl;
					} 
				}

			if (okaytoproceed)
				{
				// split horizon, if active, has okayed the 
				// update	

			brcastchanges=brcastmemory[n->getrow()].first();
			brcastchanges->gotofirst();
			while ((brcastchanges!=NULL)&&(brcastmemory[n->getrow()].next(brcastchanges)!=NULL)){
				brcastchanges=brcastmemory[broadcastrow].next(brcastchanges);
				brcastchanges->gotofirst();
				}
			brcastchanges->addelem(n->getgoingto(),subcount,routing[broadcastrow][subcount].length+dist2);
			addelemcounter++;
			inventory(n->getrow()); 
				}

			}
			

                // if next hop is thru the broadcasting node, and the
                // distance has increased, the distance relative at this node
                // must also increase.
                else if ((routing[receiverow][subcount].updatnde==broadcastrow)&&((routing[receiverow][subcount].length!=routing[broadcastrow][subcount].length+1)&&((routing[receiverow][subcount].length!=infinitee)||(routing[broadcastrow][subcount].length!=infinitee)))&&(routing[broadcastrow][subcount].length!=0))
                        {
			brcastchanges=brcastmemory[n->getrow()].first();
			changes=1;
			   while ((brcastchanges!=NULL)&&(brcastmemory[n->getrow()].next(brcastchanges)!=NULL))
				{
                         	brcastchanges=brcastmemory[broadcastrow].next(brcastchanges);
			  	}
	
			brcastchanges->addelem(n->getgoingto(),subcount,routing[broadcastrow][subcount].length+dist2);
			addelemcounter++;
			inventory(n->getrow());
			}	
			
                }

		if (changes==0)
			{
			if (verbose)
			cout<<" No changes made. "<<endl;
		 	    brcastchanges=brcastmemory[n->getrow()].first();
                            while ((brcastchanges!=NULL)&&(brcastmemory[n->getrow()].next(brcastchanges)!=NULL)){
                                brcastchanges=brcastmemory[broadcastrow].next(brcastchanges);
                                }
                            brcastchanges->addelem(n->getgoingto(),-2,-1);
				addelemcounter++;
			    if (verbose)
                            inventory(n->getrow());
			} 
        }

void bellman2(short row)
	{
	// BELLMAN FORD ROUTING ALGORITHM. PART II
	// This portion of the bellman ford routing
	// algorithm accesses the broadcaster's broadcast-memory
	// and updates the receiver's routing table accordingly.

		inventory(n->getgoingto());
		brcastchanges=brcastmemory[n->getgoingto()].first();
		brcastchanges->gotofirst();
		while (brcastchanges->getforwhichnode()!=n->getrow())
			{
			//cout<<"Incorrect row info. Looking for "<<row<<" have found "<<brcastchanges->getforwhichnode()<<endl;
			//cout<<brcastchanges->getforwhichnode()<<endl;
			//cout<<"--"<<endl;
			brcastchanges=brcastmemory[n->getgoingto()].next(brcastchanges);
			brcastchanges->gotofirst();
			}
		// Have now paged up to the appropriate information
		// in memory. Now make changes.
		short stop=brcastchanges->isnull();
		while (!stop)
			{
//	cout<<"FLAG"<<endl;
			short columnno=brcastchanges->getelement();
			short rowno=brcastchanges->getvalue();
			addelemcounter--;
			if (verbose)
			{
			cout<<"update from "<<n->getgoingto()<<" to "<<n->getrow()<<endl;
			cout<<" The change: "<<columnno<<" w/val: "<<rowno<<endl;
			}
			if (rowno>infinitee)
				rowno=infinitee;
			if (columnno<0)
			   	{
				// there was no change in the broadcast
				if (verbose)
					cout<<" No changes to make. "<<endl;
				} 
			else if ((routing[n->getrow()][columnno].length==infinitee)&&(rowno==infinitee))
				{
				// no need for update. values are already set
				// and there should not be additional churn
				}
			else
				{
				routing[n->getrow()][columnno].length=rowno;
				routing[n->getrow()][columnno].updatnde=n->getgoingto();
				churn(1);
				}
			brcastchanges->gotofirst();
			stop=brcastchanges->isnull();
			}
		if (verbose)
		cout<<"ping "<<n->getgoingto()<<" "<<n->getrow()<<endl;
		brcastmemory[n->getgoingto()].remove(brcastchanges);
			bellmannew--;
		delete brcastchanges;
	}
			
				
void noduleinsert(nodule stuff,int row,int column,float broadtime,char otb,short bnce,int gotoo,short gfr)
	{
// FORMAT:
// pointer to actual element, row, column, what time the event will be
// occuring--is sorted by this value, significance of event
// delimiter, 
// and an element to designate an echo from a broadcast to determine if node
// is down

// Insert new element/nodule into queuing structure
// to be sorted later via qsort
	howmany++;

// ***** MAJOR CHANGE RIGHT HERE!!!!!!!!!! LINE BELOW COMMENTED OUT
// IF SEG FAULT OCCURS, MAY BE DUE TO THIS.
	//n=my_list.first();
	my_list.append(new list_node(row,column,broadtime,otb,bnce,gotoo,gfr));
		eventqueuenew++;
	}
	
void nodulesorting()
   {
// Sort the linked list to develop ordered GLOBAL EVENT QUEUE
// **********************************************************
// 					   ******************
     int ii;
	typedef list_node *p_list_node;
	list_node **array=new p_list_node[howmany];
	list_node **elt;
	list_node *node;
	for (node=my_list.first(),
		elt=array;
		node!=0;
		node=my_list.next(node),
		elt++){
		*elt=node;
		}
	qsort((void*)array,howmany,sizeof(list_node*),cmp_ptr_node);
	array[howmany-1]->set_next(NULL);
	for(ii=howmany-1;ii--;){
		array[ii]->set_next(array[ii+1]);
		}
	my_list.make_head(array[0]);

	delete [] array;

	//print-out 
	/*for (ii=0; ii<howmany; ii++) {
		int x,y;
		float z;
		array[ii]->get_data(x,y,z);
		cout<<x<<", "<<y<<", "<<z<<endl;
		}
	cout<<endl;
	 for (node = my_list.first(); node != NULL; node = node->get_next()) {
       int x, y;
       float z;

       node->get_data(x, y, z);

       //cout << x << ", " << y << ", " << z << endl;
       }*/
   }
/*
int reset(int value)
	{
// Node has just come back on-line
// Need to revive all associated links 
	n=my_list.first();
	for (int cntr=0; cntr<value; cntr++)
		n=my_list.next(n);
	return(value);
	}
*/
void deathtoreceiver(int row1,int col1)
	{
	// Row1, Col1 has failed. Need to set deadtxmission property to 1
	routing[row1][col1].deadtxmission=1;
	}

void mortician(int rowb, int colb)
	{
// Iterations occur based on time frame of Node routing table
// broadcasts. This function is called if an event has occured
// BEFORE the first broadcast of a simulated iteration
// Function serves to "kill" the given element.
          if (rowb==colb)  //is a node
		{
		for (int killing=0;killing<size;killing++)
			{
			routing[rowb][killing].waitonnode=1;
		//	routing[rowb][killing]->sink(0);
			routing[rowb][killing].churn(1);
			churn(1);
		           if (rowb==killing)
				routing[rowb][killing].waitonnode=0;
			routing[rowb][killing].deadfunction(1,-1,1);
			routing[rowb][killing].sink(0);
			}
		if (verbose||update){
		cout<<"Node Failure"<<endl;
		arrayprint();}
		}
	   else			// is a link
		{
		int miniflag=1;
		// IF LINK IS ALREADY DEAD FROM A NODE FAILURE
		// SHOULDN'T KILL MIRROR
		if (routing[rowb][colb].length==infinitee)
			miniflag=0;
		// Need to kill any transmission in progress from
		// a 1-hop link any failure
		if (routing[rowb][colb].length==1)
			deathtoreceiver(rowb,colb);
		routing[rowb][colb].length=infinitee;
		// IS THIS REGISTERING CHURN?--is only registering
		// with the link 
		routing[rowb][colb].churn(1);
		routing[rowb][colb].deadfunction(1,-1,0);
		// Below registers the churn with the node	
		routing[rowb][rowb].churn(1);
		churn(1);
		if (duplex&&miniflag)
			{
			routing[colb][rowb].churn(1);
			churn(1);
			routing[colb][rowb].length=infinitee;
			routing[colb][rowb].deadfunction(1,-1,0);
			}
		if (verbose||update){
		cout<<"Link has died. "<<endl;
		arrayprint();}
		}
	}

void medic(int rowc, int colc)
	{
// Similar to mortician function. This function is called if a node
// or link has come back on-line between simulated iterations of interest
// Serves to bring an element back "alive"
	  
	if (rowc==colc)   // is a node
		{
		if (verbose||update)
			cout<<" NODE "<<rowc<<" is ALIVE. %%%"<<endl;
		for (int killing=0;killing<size;killing++)
			{
			routing[rowc][killing].waitonnode=0;
			//routing[rowc][killing].sink(1);
			routing[rowc][killing].churn(1);
			routing[rowc][killing].deadfunction(0,lowerbound,1);
			routing[rowc][killing].sink(1);
			churn(1);
			}
		if (verbose||update){
		arrayprint();
		cout<<endl; }
		}
	else 		// it is a link
		{
		if (verbose||update)
			cout<<"LINK is ALIVE **"<<endl;
	//	routing[rowc][colc].sink(1);
		routing[rowc][colc].churn(1);
		routing[rowc][colc].deadfunction(0,-1,0);
		routing[rowc][colc].sink(1);
		churn(1);
		if (duplex)
			{
		//	cout<<" DUPLEXING "<<endl;
			routing[colc][rowc].churn(1);
			churn(1);
			routing[colc][rowc].sink(1);
			routing[colc][rowc].deadfunction(0,-1,0);
			}
		}
	}

void totaler(int rowzz)
	{
// Total churn for each row
// Total amount of churn each node has undergone in updating links
// link failure, link resurrection, and nodule failure and resurrection
	for (int hangfire=0;hangfire<size;hangfire++)
		{
		churningtotal+=routing[rowzz][hangfire].churninga;
		if (churningtotal>=100000)
			{
			churningtotal-=100000;
			churning100thoutotal++;
			}
		churning100thoutotal+=routing[rowzz][hangfire].churna100thou;
		if (churning100thoutotal>=100000)
			{
			churning100thoutotal-=100000;
			churning10billtotal+=1;
			}
		churning10billtotal+=routing[rowzz][hangfire].churna10bill;
		if (churning10billtotal>=1000000)
			{
			churning10billtotal-=1000000;
			churningbigtotal++;
			}
		churningbigtotal+=routing[rowzz][hangfire].churnabig;
		}
	}
		
int whoismax(int a, int b, int c)
	{
	// return 0 if node a is smaller than node b's information
	// c=1 means comparing nodule churn itself
	// c=0 means comparing total churn of row
//cout<<" comparing node "<<a<<" with node "<<b<<endl;
	if (c)
	   {
	    if (((routing[a][a].churnabig)>=(routing[b][b].churnabig))&&(routing[a][a].churnabig!=0))
			{
			return(1);
			}
	    else if ((routing[a][a].churnabig)<(routing[b][b].churnabig))
			{
			return(0);
			}
	    else if (((routing[a][a].churna10bill)>=(routing[b][b].churna10bill))&&(routing[a][a].churnabig!=0))
			{
			return(1);
			}
	    else if ((routing[a][a].churna10bill)<(routing[b][b].churna10bill))
			{
			return(0);
			}
	    else if (((routing[a][a].churna100thou)>=(routing[b][b].churna100thou))&&(routing[a][a].churna100thou!=0))
			{
			return(1);
			}
	    else if ((routing[a][a].churna100thou)<(routing[b][b].churna100thou))
			{
			return(0);
			}
	    else if (((routing[a][a].churninga)>=(routing[b][b].churninga))&&(routing[a][a].churninga!=0))
			{
			return(1);
			}
	    else return(0);
	    }
	else
	    {
	    if (((bchurnabig)>=(churningbigtotal))&&(bchurnabig!=0))
                        {
                        return(1);
                        }
            else if ((bchurnabig)<(churningbigtotal))
                        {
                        return(0);
                        }
            else if (((bchurna10bill)>=(churning10billtotal))&&(bchurnabig!=0))
                        {
                        return(1);
                        }
            else if ((bchurna10bill)<(churning10billtotal))
                        {
                        return(0);
                        }
            else if (((bchurna100thou)>=(churning100thoutotal))&&(bchurna100thou!=0))
                        {
                        return(1);
                        }
            else if ((bchurna100thou)<(churning100thoutotal))
                        {
                        return(0);
                        }
            else if (((bchurninga)>=(churningtotal))&&(bchurninga!=0))
                        {
                        return(1);
                        }
            else return(0);
            }
	}
	
void checkqueue()
	{
	// EVENTQUEUE CHECK:
	cout<<" CHECKING EVENTQUEUE: "<<endl;
	n=my_list.first();
	while (n!=NULL)
        {
        cout<<n->getrow()<<" "<<n->getcolumn()<<" "<<n->get_za();
                if (n->get_otb()==1)
                        cout<<" BROADCAST"<<endl;
                else if(n->get_otb()==0)
                        cout<<" KILL"<<endl;
                else if(n->get_otb()==2)
			{
			cout<<" received from:"<<n->getgoingto();
                        cout<<" UPDATEE"<<endl;
			}
                else if(n->get_otb()==3)
                        cout<<" REVIVAL"<<endl;
                else if(n->get_otb()==4)
                        cout<<" RTD RECEIVED"<<endl;
        n=my_list.next(n);
        }
	}

void initiator()
	{
	// in my_list, okay-to-broadcast:
	//			0 for not able to broadcast; is a kill
	//			1 for doing a broadcast of routing table
	//			2 for receiving an update
	//			3 for a revival
	//			4 for roundtrip delay check of failed node

	// This function sets up one iteration of the global event queue.

	n=my_list.first();
	int index=0;
	int avail[size];	
	int minitally=0;
	for (int i=0;i<size;i++)
		{
		avail[i]=i;
		}
	for (int j=0;j<size;j++)
		{
	// must assign BROADCASTING events into EVENTQUEUE
		while (avail[index]==-1)
			{
			index=(rand())%(size)+0;
			}
			avail[index]=-1;
			// NEED TO INSERT A BROADCAST EVENT PER EACH 1 HOP
			// NEIGHBOR.
			// Need to scan through the row and insert an
			// a number of broadcast events equal to the number
			// of 1-hop neighbors
			for (int subcnt1=0;subcnt1<size;subcnt1++)
				{
				//if (routing[index][subcnt1].length==1)
				  if (routing[index][subcnt1].txmit==1)
					{
					// Note: All broadcast events, tho
					// separate per each 1 hop neighbor
					// occur at the same time w/in
					// the same node.
					// Same time, create an array
					// associated with each node
					// locating the 1-hop neighbors.
					
					// BELOW INSERTS A BROADCAST
					// EVENT FROM NODE index x index
					// TO NODE subcnt1
//cout<<" INSERTING BROADCAST FOR: "<<index<<" going to: "<<subcnt1<<endl;
					// BELOW TRACKS WHICH COLUMN
					//noduleinsert(routing[index][index],index,index,routing[index][index].hellotime,1,-1,subcnt1,-1);	
					noduleinsert(routing[index][index],index,index,0,1,-1,subcnt1,-1);
					minitally++;
					}
				}
		}	

// All nodes are now in the eventqueue for broadcasting

// EVENTQUEUE CHECK:
	//checkqueue();

	// ALL THE NODES ARE NOW IN THE EVENTQUEUE,
	// NOW MUST ASSIGN BROADCAST TIMES TO EACH 
	// THE TIMES WILL BE IN A RANGE OF 27 to 33 SECONDS
	n=my_list.first();


	// WANT TO DISTRIBUTE THE BROADCAST TIMES ACROSS THE FULL 6 SECOND
	// TIME FRAME
	//float increment=6.0/(size*connectivity);
	lowerbound=upperbound;
	float increment=6.0/(size);
	int rowtemp=-1;
	int coltemp=-1;	

	while(n!=NULL)
		{
		if ((n->getrow()!=rowtemp)&&(n->getcolumn()!=coltemp))
			{
			increment+=.2;
			n->set_broad(lowerbound+27+increment);
			rowtemp=n->getrow();
			coltemp=n->getcolumn();
			// ALSO NEED A LINE TO CHANGE BROADCAST TIME
			}
		else
			{
                        n->set_broad(lowerbound+27+increment);
			}
		n=my_list.next(n);
		}

	// ALL NODES ARE ASSIGNED A TIME.	
	
		n=my_list.last();	

	// SCAN FOR FAILURES AND REVIVALS, SCHEDULE FAILS & RECOVERIES
	// AS NECESSARY - BASED ON MTBF and MTBR 

        // NOW NEED TO LOOK AT ALL THE BROADCAST REQUESTS AND SEE WHAT THE
        // NEAREST NEIGHBORS ARE, AND PUT AN EVENT UP FOR THEM TO UPDATE THEIR
        // TABLES.

float maxmax=0;
        //                      - determine nearest 1-hop neighbors
        //                      - determine delay to get to that neighbor
        //                      - put new event on queue, and designate
        //                         broadcast time as broadcast time of
        //                         root + delay to that neighbor.
        //                        And ok-to-broadcast param. gets set to 2
        //                         to receive an update.
	n=my_list.first();
	int minitally2=0;
        while ((n!=NULL)&&(minitally2!=minitally))
                {
		if (verbose){
		cout<<"UPDATE FROM: "<<endl;
		cout<<n->getrow()<<" going to column "<<n->getgoingto()<<endl; }
		noduleinsert(routing[n->getgoingto()][n->getgoingto()],n->getgoingto(),n->getgoingto(),(n->get_za())+(routing[n->getrow()][n->getgoingto()].delay),2,-1,n->getrow(),-1);
		// SCHEDULE ROUNDTRIP RESPONSE
		if (verbose){
		cout<<" delay: "<<routing[n->getgoingto()][n->getgoingto()].delay<<" given time for a rtd "<<(2*routing[n->getgoingto()][n->getgoingto()].delay)+n->get_za()<<endl; }
		 noduleinsert(routing[n->getrow()][n->getcolumn()],n->getrow(),n->getcolumn(),(2*routing[n->getgoingto()][n->getgoingto()].delay)+n->get_za()+.1,4,n->getgoingto(),-1,-1);
		minitally2++;	
                n=my_list.next(n);
                }


	upperbound=maxmax;
	if (upperbound==0)
		upperbound=lowerbound+35.8;
	if (verbose)
	cout<<" THE BOUNDS ARE: "<<lowerbound<<" "<<upperbound<<endl;
        n=my_list.first();
int pass=0;

	// reaperflag--if doing a manual kill, don't want
	// other failures and revivals to interfere
int deathtally=0;
int revivaltally=0;
	if (!reaperflag){
		for (int rowz=0;rowz<size;rowz++)
			{
			for (int colz=0;colz<size;colz++)
				{
				if (verbose)
				cout<<"death/phoenix "<<routing[rowz][colz].deathtime<<" "<<routing[rowz][colz].phoenix<<"    "<<rowz<<" "<<colz<<endl;
				if (((routing[rowz][colz].deathtime)<upperbound))
					{
				//	cout<<" DEATH EVENT. DEATH: "<<routing[rowz][colz].deathtime<<" for node/link: "<<rowz<<" "<<colz<<endl;
					deathtally++;
					noduleinsert(routing[rowz][colz],rowz,colz,routing[rowz][colz].deathtime,0,-1,-1,-1);
					}
				if (((routing[rowz][colz].phoenix)<upperbound))
					{
				//	cout<<" REVIVAL EVENT. REVIVAL: "<<routing[rowz][colz].phoenix<<" for node/link: "<<rowz<<" "<<colz<<endl;
					revivaltally++;
					noduleinsert(routing[rowz][colz],rowz,colz,routing[rowz][colz].phoenix,3,-1,-1,-1);
					}
				}
			}
	}
if (verbose)
{
cout<<" TALLY: "<<endl;
cout<<" deathtally: "<<deathtally<<endl;
cout<<" revivaltally:"<<revivaltally<<endl;
}					


/*       THIS WILL ASSIGN DEATHS PER EACH EVENT...DONT WANT THIS, WANT DEATH
         ASSIGNED ON A PER NODE BASIS, NOT PER EVENT
		if ((routing[n->getrow()][n->getcolumn()].deathtime)<upperbound)
			{
			cout<<" HEY A DEATH!!! "<<" DEATH: "<<routing[n->getrow()][n->getcolumn()].deathtime<<" and upper "<<upperbound<<" FOR NODE "<<n->getrow()<<" "<<n->getcolumn()<<endl;
			noduleinsert(routing[n->getrow()][n->getcolumn()],n->getrow(),n->getcolumn(),routing[n->getrow()][n->getcolumn()].deathtime,0,-1,-1,-1);
			}
		// CHECK FOR REVIVALS (failure and revival may occur w/in same
		//                     time frame)
		if ((routing[n->getrow()][n->getcolumn()].phoenix)<upperbound)
			{
			cout<<" HEY A REVIVAL "<<endl;
			noduleinsert(routing[n->getrow()][n->getcolumn()],n->getrow(),n->getcolumn(),routing[n->getrow()][n->getcolumn()].phoenix,3,-1,-1,-1);
			}
		pass++;	
		n=my_list.next(n);
		
		}   // for while !reaperflag at top
*/

	// If doing a manual kill, need to schedule this failure
	
	if (reaperflag)
		{
		while ((reaper[reaperindex]<=upperbound)&&(reaper[reaperindex]>=lowerbound))
			{
			noduleinsert(routing[reaper[reaperindex+1]][reaper[reaperindex+2]],reaper[reaperindex+1],reaper[reaperindex+2],reaper[reaperindex],0,-1,-1,-1);
			reaperindex+=3;
			}
		}
	// If doing a manual revival, need to schedule it here.
	if (reaperflag)
		{
		while ((unreap[unreapindex]<=upperbound)&&(unreap[unreapindex]>=lowerbound))
			{
			noduleinsert(routing[unreap[unreapindex+1]][unreap[unreapindex+2]],unreap[unreapindex+1],unreap[unreapindex+2],unreap[unreapindex],3,-1,-1,-1);
			unreapindex+=3;
			}
		}

	// AND THEN CALL nodulesorting...DON'T FORGET TO CHANGE UP wahoo ROUTINE
	// TO PRINT OUT CORRECT DATA
	nodulesorting();	
	if (verbose)
		{
		cout << " ************************************ "<<endl;
		cout<<"SEVEN"<<endl;
		//checkqueue();
		}
//cout<<"Hello...the contents of the event queue are:"<<endl;
//checkqueue();
}  // END OF INITIATOR	
			
void whatsin(int wh)
        {
       // cout<<"test pattern:"<<endl;
        brcastchanges=brcastmemory[wh].first();
	if (brcastchanges!=NULL)
	{
        brcastchanges->gotofirst();
        while (brcastchanges!=NULL)
                {
                short stoppit=brcastchanges->isnull();
                while (!stoppit)
                        {
			if (verbose)
                        cout<<"goingto node:"<<brcastchanges->getforwhichnode()<<" "<<brcastchanges->getelement()<<" "<<brcastchanges->returnvalue()<<endl;
                        brcastchanges->advance();
                        stoppit=brcastchanges->isnull();
                        }
                brcastchanges=brcastmemory[wh].next(brcastchanges);
                if (brcastchanges!=NULL)
                        {
                        brcastchanges->gotofirst();
                        }
                }
	}
        }

void spillit()
       {
        cout<<"test pattern:"<<endl;
	for (int wh=0;wh<size;wh++)
	{
        brcastchanges=brcastmemory[wh].first();
        if (brcastchanges!=NULL)
        {
	cout<<"A"<<endl;
        brcastchanges->gotofirst();
        while (brcastchanges!=NULL)
                {
                short stoppit=brcastchanges->isnull();
                while (!stoppit)
                        {
                        cout<<"ARRAY ELEMENT:"<<wh<<" goingto node:"<<brcastchanges->getforwhichnode()<<" "<<brcastchanges->getelement()<<" "<<brcastchanges->returnvalue()<<endl;
                        brcastchanges->advance();
                        stoppit=brcastchanges->isnull();
                        }
                brcastchanges=brcastmemory[wh].next(brcastchanges);
                if (brcastchanges!=NULL)
                        {
                        brcastchanges->gotofirst();
                        }
                }
           }
	 }
        }

void deleteall()
{
	// This function clears out the broadcast memory.
	// Eliminates any residual values not processed, or incorrectly
	// deleted.

	//cout<<" NODE: "<<n->getrow()<<" is active receiver. MESSAGE FROM: "<<n->getgoingto()<<" whose table is: "<<endl;
	whatsin(n->getgoingto());
	int search=n->getrow();
        // SET TO FIRST ROW IN ELEM#0 AND TO FIRST DATASET IN ROW
        brcastchanges=brcastmemory[n->getgoingto()].first();
       // brcastchanges->gotofirst();

        // IF ELEMENT EXISTS, CAN BEGIN DELETION
	 if (brcastchanges!=NULL)
        {
                brcastchanges->gotofirst();

        //****
                while (brcastchanges!=NULL)
                {
                        brcastchanges->gotofirst();
                        if (brcastchanges->getforwhichnode()==search)
                        {

                                // ************************
                                while (brcastchanges!=NULL)
                                        {
                                        short stoppit=brcastchanges->isnull();
                                        while (!stoppit)
                                                {
                                               // cout<<"Row: "<<brcastchanges->getforwhichnode()<<" Deleting value: "<<brcastchanges->getvalue()<<endl;
						brcastchanges->getvalue();
						addelemcounter--;

                                                brcastchanges->gotofirst();

                                                if (brcastchanges->isnull())
                                                        {
                                                        stoppit=1;
                                                        }
                                                }
                                        brcastmemory[n->getgoingto()].remove(brcastchanges);
					bellmannew--;
					brcastchanges=NULL;
                                        }
                        }
                        else
                               // cout<<"HAVE FOUND "<<brcastchanges->getforwhichnode()<<" LOOKING FOR "<<search<<endl;
                        // ***************************
                if (brcastchanges!=NULL)
                        brcastchanges=brcastmemory[n->getgoingto()].next(brcastchanges);
                else
                        { delete brcastchanges;
                        brcastchanges=brcastmemory[n->getgoingto()].first();
                        }
                }
        }
//inventory();
}


main(int argc,char **argv)
        {
        /*cout<<"received "<<argc<<" arguments..."<<endl;
        for (int i=0;i<argc;i++)
                cout<<"argument: "<<i<<":"<<argv[i]<<endl;*/

        // PROCESSING
        int count=1;
        int convertedvalue;
        while (count<argc)
                {
                switch(argv[count][1])
                        {
                        case 'T':
                        case 't':
                                cout<<"Time flag for completion is set at: "<<argv[count+1]<<endl;
                                if (argv[count+1]==NULL){
                                        cout<<"Value has been left blank. Using  default of 5000 sec. simulation run."<<endl;
                                        timetorun=5000;
                                        }
                                else {
                                timetorun=atoi(argv[count+1]);
                                //timetorun=convertedvalue;
                                cout<<timetorun<<" seconds."<<endl;}
                                break;
                        case 's':
                        case 'S':
                               	split=1; 
				break;
			case 'v':
			case 'V':
				if (atoi(argv[count+1])==1)
					{
					verbose=1;
					update=0;
					finalize=0;
					}
				else if (atoi(argv[count+1])==2)
					{
					verbose=0;
					update=1;
					finalize=0;
					}
				else if (atoi(argv[count+1])==3)
					{
					verbose=0;
					update=0;
					finalize=1;
					}
						
				break;
			case 'd':
			case 'D':
				duplex=1;
                       		if ((count+1)<argc)
					{
					if (atoi(argv[count+1])==0)
						{
						cout<<" Duplex turned off. "<<endl;
						duplex=0;}
					}
				break; 
			case 'e':
			case 'E':
				// Execution stopping option
				// 1: run based soley on timer
				// 2: run based on timer or stability whichever
				//    occurs first
				// 3: run on stability only
				execution=1;
				if ((count+1)<argc)
					{
					if ((atoi(argv[count+1])>3)||(atoi(argv[count+1])<0))
						{
						cout<<"Error on execution selection. Using default."<<endl;
						execution=1;
						}
					else execution=atoi(argv[count+1]);
					}
				break;
			case 'n':
			case 'N':
				// Metric toggle:
				// 0: hop count metric
				// 1: cartesian distance
				if (argv[count+1]==NULL){
					cout<<"Metric toggle has been left blank, default to node hop count."<<endl;
					nodedist=0;
					}
				else
					nodedist=atoi(argv[count+1]);
				break;
			case 'f':
			case 'F':
				// Follow a node/link's progress
				// -f node# 
				if (argv[count+1]==NULL){
					cout<<"Follow tag has been left uninitialized, default to no following."<<endl;
					tracking=0;
					}
				else 
					{
					track[0]=int(argv[count+1]);
					}
				break;	
			}
                count++;
                }
		timer=execution;	
		// ETC ETC ETC
                cout<<"Execution setup complete. "<<update<<"hh"<<endl;

// *******************************
// *******************************


// Initialize random number generator
for(int values=0;values<152;values++)
	(rand()%10);

// *************************************************************
int initi;

// END INITIALIZATION
// *************************************************************

// FILL ROUTING MATRIX FROM EXTERNAL FILE
//**********************************************
// First round update:
// USING 2-D NODULE ARRAY, ROUTING -- INITIALIZATION
// CONVERTING LINKED LIST DATA TO A HOP-COUNT ARRAY
int tiktock=0;
//cout<<" BEGINNING LOOP "<<endl;
for (int row1=0;row1<size;row1++)
        {
                for (int col1=0;col1<size;col1++)
                        {
	if (row1==col1)
        routing[row1][col1].setvalues(0,reaperflag,size2,connect2,1);
	else
	routing[row1][col1].setvalues(0,reaperflag,size2,connect2,0);
                        }
        }
//cout<<"Routing Matrix Initialized"<<endl;
char check[60];
int rower=0;

int endit=0;
int distnow=0;
ifstream squeak(impvalue);
squeak>>check;
while (!same(check,"multiply:")&&!(cin.eof()))
	{
	int flagit=1;
	if (same(check,"graph"))
		{
		while(flagit)
		{
		squeak>>check;
		if (same(check,"."))
			{
//			cout<<"next row"<<endl;
			rower++;
			squeak>>check;
			}
		if (same(check,"distance"))
			{
//			cout<<"bailing out"<<endl;
			distnow=1;
			flagit=0;
			}

		if (flagit){
//		cout<<"bang. "<<check<<endl;
		int whichcol=atoi(check);
		if (!nodedist)
			{
			routing[rower][whichcol-1].length=1;
			routing[rower][whichcol-1].orilength=1;	
			routing[rower][whichcol-1].txmit=1;
			// read in distance
			// delta is defined as an adjustment factor for
			// converting lengths to a unit of time
			squeak>>check;
			}
		else
			{
			// Cartesian distances adjusted to 1/10
			// in order to account for an upper
			// infinity value
			squeak>>check;
			routing[rower][whichcol-1].length=(atoi(check))*.1;
			routing[rower][whichcol-1].orilength=(atoi(check))*.1;
			routing[rower][whichcol-1].txmit=1;
			}
	
		routing[rower][whichcol-1].delay=(atoi(check))*delta;
			   }
	
		}
		
		}
	 else squeak>>check;
	}
squeak.close();	
//if (verbose||update)
arrayprint();
if (verbose||update)
cout<<"THE MATRIX IS LOADED."<<endl;	  
//****************************************************************

//printout(seekeril);
int counter;

cout<<"\n";

// SORTS BY HELLOTIME VALUE---BUT HELLOTIME VALUE IS GIVEN A 0 INITIALLY
// SHOULD BE A LOOP THAT RANDOMLY ASSIGNS THE ORDER OF THE NODES
// AND ASSIGNS A TIME VALUE TO EACH ONCE ALL ARE IN EVENTQUEUE
// noduleinsert INSERTS NODULES ONTO EVENTQUEUE

// HERE SHOULD EXAMINE THE LATEST TIME OF THE NODE AT THE END OF THE
// EVENTQUEUE---THEN, SHOULD LOOK AT CURRENT WALLCLOCK TIME AND
// SEE IF ANY OF THE ELEMENT'S MTBF IS DUE TO OCCUR IN THIS TIME FRAME
// (TIME FRAME FROM 0->LATEST TIME IN QUEUE)
// IF SO, ADDON AN EVENT FOR KILLING THE NODE
// OR REVIVING
// ----WHICH COULD JUST BE PUTTING THAT PARTICULAR NODE BACK ON A SECOND
// TIME....UPDATE WALLCLOCK AT THE BEGINING OF THE HANDLLING OF EACH EVENT
// THAT WAY A DEATH WILL BE TRIGGERED AT THE START/ or revival
// OF THE NODULE
// ALSO GO THROUGH AND FIND NEAREST NEIGHBORS OF EACH NODE BEING INSERTED
// AND PUT IN A ROUTING UPDATE EVENT FOR EACH OF THEM, WITH THE TIME
// FOR THOSE EVENTS BASED ON THE CARTESIAN DISTANCE
// WITH THE ABILITY THAT EACH OF THESE LINKS WILL HAVE THEIR waitonnode
// VALUE SET TO 1 IF THE BASE NODE DIES, AND THAT EVENT WILL BE PASSED OVER



// CALL initiator TO INITIALIZE THE GLOBAL EVENTQUEUE
cout<<"one side"<<endl;
initiator();
cout<<"the other side"<<endl;

// *********************************************************

// BELOW USED FOR DEBUGGING: PRINTS OUT EVERYTHING ON EVENT QUEUE
// AS WELL AS WITH WHAT TIME THE NODE/LINK IS TO BE POLLED FOR
// AN EVENT.
n=my_list.first();

/*for (int wahoo=0; wahoo<howmany;wahoo++)
	{
	cout<<" WAHOO: "<<wahoo<<" time to die: "<<routing[n->getrow()][n->getcolumn()].deathtime<<" row "<<n->getrow()<<" col "<<n->getcolumn()<<" Sorted Time value: "<<n->get_za()<<" "<<n->get_otb()<<endl;
	cout<<" \t Is requesting:";	
	if ((n->get_otb()==0)||(n->get_otb()==3))
		cout<<" death/revival "<<endl;
	else if (n->get_otb()==1)
		cout<<" broadcast "<<endl;
	else if (n->get_otb()==2)
		cout<<" routing table update."<<endl;
	else if (n->get_otb()==4)
		cout<<" a bounced update. "<<endl;
 
	n=my_list.next(n);
	}
*/
//MEXICAN
// *************************************************************************
// NETWORK SIMULATION 
// Second (and further) round update. Everyone exchanges with their neighbors
// as established in first iteration, and updates hop count.
// WILL LOOP THROUGH UNTIL ARRAY STABILIZES WITH A SET NUMBER OF ROUTES
// IN ORDER TO TAKE ADVANTAGE OF NEWLY CREATED HOPS AND POSSIBLY LOWER HOP
// ***************************************************************************
// 
// RUN THROUGH QUEUE FROM START TO FINISH, UPDATING WALLCLOCK TIME AS
// IT GOES. MUST ONLY ALLOW UPDATE REQUESTS FROM NODES. LINK NODULES
// CANNOT UPDATE.
 
float bigtemp=0,a10billtemp=0,a100thoutemp=0,churntemp=0;
char stable=0;
	       // these vars used for calculating running average of simulator's
		// activity, if does not increase after 1 run thru, matrix is
		// considered stable or if running average
		// (flotsam/number of nodes/time increment (30sec) )
		// is same as previously calculated value

n=my_list.first();
int stag=0;
int runthis=1;
while (runthis)
//** BELOW WHILE IS FOR RUNNING SOLELY ON TIMER
//while (!((timer==1)&&(wallclock>=timetorun)))

//** BELOW WHILE IS FOR RUNNING ON STABILITY & TIMER - WHICHEVER OCCURS FIRST
//cout<<" stable "<<!stable<<" timer "<<timer<<" wallclock "<<wallclock<<" timetorun "<<timetorun<<endl;

//while ((stable!=3)&&(timer==2)&&(wallclock>=timetorun))

// BELOW WHILE IS FOR JUST STABILITY
//while (stable!=3)

// CONTINUE LOOPING UNTIL STABILITY IS REACHED
{
if(verbose)
cout<<"******************************************************************\n";
n=my_list.first();
innercount++;

//checkqueue();
n=my_list.first();
// NEED TO SEE WHETHER OR NOT TO START A NEW EVENT QUEUE
// 	- must check current wallclock-time and check to see if 
//	  simulation is at upperbound
//		if so, must recall initiator
//              if not, continue simulation
stag++;

//cout<<"howmany"<<howmany<<endl;
while (n==NULL)
	{
	if (stag>1)
		{
	/*	cout<<"braking."<<endl;
		cout<<"rowcounter/list2: "<<bellmannew<<" eventqueuenew:"<<eventqueuenew<<" list3elements"<<addelemcounter<<endl;
		spillit();
			char keystroke;
			cout<<"press a key to continue"<<endl;
			cin>>keystroke; */
			/*while(1)
				{} */ 
		}
	if (verbose){
	cout<<" IN ARRAY: "<<endl;
	spillit();
	cout<<"bellmannew:"<<bellmannew<<" eventqueuenew:"<<eventqueuenew<<endl;}
	
	initiator();
	n=my_list.first();
	}
if (verbose)
cout<<"halibut"<<endl;
// get_otb()  values
// 0 is a failure 
// 1 is a broadcast
// 2 is an update
// 3 is a revival
// 4 is a rtd failed node check
n=my_list.first();
// FIRST, NEED TO DETERMINE WHAT THE EVENT IS.
update=0;
// Check for tracking values.
int ptr=0;
while ((tracking)&&(track[ptr]!=-1))
	{
	if ((n->getrow()==track[ptr])||((n->get_otb()==2)&&(n->getgoingto()==track[ptr])))
		update=1;
	ptr++;
	}


if (verbose||update)
cout<<innercount<<" Node: "<<n->getrow()<<" "<<n->getcolumn()<<" has issued a ";

if (n->get_otb()==0)
	{
	if (verbose||update)
		cout<<" DEATH at time"<<n->get_za()<<endl;
	// A LINK OR NODE IS ABOUT TO FAIL
	// FIRST SEE WHETHER OR NOT THE ASSOCIATED NODE IS ALIVE
	if (routing[n->getrow()][n->getrow()].dead==0)
		{
		mortician(n->getrow(),n->getcolumn());
		}
	else
		{
		if (verbose||update)
		cout<<"Associated root-node is already dead. Link is down already."<<endl;
		}
	}

else if (n->get_otb()==4)
	{
	if (n->getfromrow()==infinitee)
		{
			if (verbose||update)
			cout<<" ROUNDTRIP DELAY HAS OCCURED. \n Initial broadcast failed. No roundtrip delay."<<" at time: "<<n->get_za()<<" bounced off of "<<n->getbounce()<<" returning to: "<<n->getrow()<<endl;
			}
	else {
	if (verbose||update)
		cout<<" A ROUNDTRIP DELAY HAS OCCURED. CHECKING FOR FAILED NODE. at time"<<n->get_za()<<" AND BOUNCE="<<n->getbounce()<<endl;
	// NEED TO KNOW WHO CAUSED THIS NEW EVENT, i.e. WHAT LINK ARE WE 
	// CHECKING.

	if (routing[n->getbounce()][n->getbounce()].dead==1) 
		{
		// update our personal routing table link to infinity for
		// that node.
		if (verbose||update)
			cout<<" Node: "<<n->getrow()<<" has found node: "<<n->getbounce()<<" to be currently down."<<endl;
		routing[n->getrow()][n->getbounce()].length=infinitee;
		//arrayprint();	
		}
	 }	
	}	

else if (n->get_otb()==3)
	{
	if (verbose||update)
		cout<<" REVIVAL. at time:"<<n->get_za()<<endl;
	if ((routing[n->getrow()][n->getcolumn()].waitonnode==0)&&(routing[n->getrow()][n->getcolumn()].dead==1)&&(routing[n->getcolumn()][n->getrow()].waitonnode==0))
		{
		if (verbose||update)
		cout<<"Node/Link: "<<n->getrow()<<" "<<n->getcolumn()<<" is coming back up."<<endl;
		medic(n->getrow(),n->getcolumn());
		}
	else if (routing[n->getrow()][n->getcolumn()].dead==0)
		{
		if (verbose||update)
			cout<<"Node/link has not failed. Cannot come back up."<<endl;
		routing[n->getrow()][n->getcolumn()].deadfunction(3,-1,-1);
		}
	else 
		{
		if (verbose||update)
			cout<<" Link cannot come back up, associated node is down. "<<endl;
		}
	}

else if (n->get_otb()==1)
	{
// JALAPENO
	// FUNCTION TO PRINT OUT WHAT IS IN BRCAST MEMORY AT THIS POINT


	// A NODE IS BROADCASTING ITS ROUTING TABLE TO ITS NEAREST 
	// 1-HOP NEIGHBORS
	if (verbose||update){
		cout<<n->getgoingto()<<" "<<n->get_za()<<endl;
	// SET ASIDE STORAGE FOR WHAT HAS BEEN BROADCAST
	// UNTIL THE RECIPIENTS HAVE RECEIVED THIS INFO.	
	
		cout<<" BROADCAST  at time: "<<n->get_za()<<" going to node: "<<n->getgoingto()<<endl;
		}
	int suspect=n->getrow();
	int target=n->getgoingto();
	if ((routing[n->getrow()][n->getcolumn()].dead==1)||(routing[n->getrow()][n->getgoingto()].length==infinitee))
		{
		if (verbose||update)
		cout<<" BUT THIS NODE/LINK HAS FAILED AND CANNOT BROADCAST."<<endl;

		// NEED TO CANCEL PREVIOUSLY ASSIGNED UPDATE
		// EVENTS
		/*cout<<" YOYO. "<<routing[n->getrow()][n->getcolumn()].dead<<" "<<routing[n->getrow()][n->getgoingto()].length<<" node/link for node:"<<n->getrow()<<" goingto "<<n->getgoingto()<<endl;
		arrayprint(); */
		while (n!=NULL)
			{/*
			if (((n->get_otb()==2)&&(n->getgoingto()==suspect)&&(n->getrow()==target))||((n->get_otb()==4)&&(n->getbounce()==target)&&(n->getrow()==suspect)))
				{
				// KILL THIS EVENT
				n->set_getfrmrow(infinitee);
				} */
		if ((n->get_otb()==2)&&(n->getgoingto()==suspect)&&(n->getrow()==target))	
				{
				n->set_getfrmrow(infinitee);
				}
		else if ((n->get_otb()==4)&&(n->getbounce()==target)&&(n->getrow()==suspect))
				{
				if (update)
				n->set_getfrmrow(infinitee);
				}
			//if (update)
			//cout<<" active node: "<<n->getrow()<<" otb "<<n->get_otb()<<" bounce "<<n->getbounce()<<" target/suspect: "<<target<<" "<<suspect<<endl;
			n=my_list.next(n);
			}
		}
	else
	{
	// BROADCASTING TABLE CREATION:
	//    - Need to determine what values in routing matrix will
	//      change (using variant of bellman ford algorithm)
	//    - These values will be stored in an array of linked lists
	//      and can be indexed by the receiver in the following
	//	manner:
	//	   The receiver will know from which node it is 
	//	receiving an update and can index accordingly into
	//	the linked-list array. Then, the receiver can look at
	//	the variable 'forwhichnode' which will contain the node number
	//	of the intended recipient. The receiver can index through
	//	these entries (total # of entries = # of 1-hop neighbors).
	//      The receiver can then index through the entry to determine
	//	what changes should be made to its routing table.

	// Need to call a bellman-function that will take as arguments
	// the row# of the broadcaster, and the row# of the receiver.
	// It will compare the two for differences, and write the
	// appropriate differences and what values to change the receiver's
	// table to into the linked-list array.
	
	bellman1(n->getrow(),n->getgoingto());

	// PRINT OUT WHAT IS IN MEMORY NOW:
	if (verbose||update){
		cout<<" ******* NODE: "<<n->getrow();
	cout<<endl;
	}
		
	// receiver already has which node has broadcasted to it,
	// just need to be sure to appropriately set the goingto parameter
	// of the broadcast-memory array.
        	

	// SETTING DEADTXMISSION
	n=my_list.first();
	routing[n->getrow()][n->getcolumn()].deadtxmission=0;
       
	// the below two lines were used to verify a link going down
	// if the link goes down while a transmission is in progress,
	// the transmission is lost.
        // mortician(n->getrow(),n->getgoingto());
        // medic(n->getrow(),n->getgoingto());

	} 

	n=my_list.first();
    }
					
		

else if (n->get_otb()==2)
	{
//SPICE
	short gotcha=0;
	// NODE IS RECEIVING AN UPDATE
	//  -needs to access the sender's setasidestorage to see
	//   what exactly was broadcast.
	//  -knows who broadcast it, stored in routing[][]->receivedfrom
	//  -assume that broadcaster has a matrix. Each row corresponding
	//   to a broadcast. The receiver needs to know which row# to look
	//   at for its update.  
	if (verbose||update){
		cout<<" RECEPTION/UPDATE OF TABLE ---guacamole at time"<<n->get_za()<<endl;

		cout<<endl<<" IS RECEIVING AN UPDATE FROM NODE ";
	cout<<n->getgoingto()<<endl;}	
//	cout<<endl<<routing[n->getrow()][n->getcolumn()].update_from_index<<endl;
	if (verbose||update)
		{
		cout<<" PRE-UPDATE STAT: "<<endl;
		arrayprint();
		}

	int recindex=n->getfromrow();
	if (n->getfromrow()==infinitee)
		{
		gotcha=1;   // Broadcaster failed before it could allocate
			    // memory. Therefore, there is no memory to delete
		if (verbose||update){
			cout<<" NO UPDATE POSSIBLE. BROADCASTER LINK/NODE "<<n->getgoingto()<<" HAS FAILED. "<<endl;	
			cout<<n->getgoingto()<<" "<<n->getrow()<<endl;
			}
		}
	else if (routing[n->getgoingto()][n->getrow()].deadtxmission==1)
		{
//		cout<<"hork."<<endl;
		gotcha=0;
		if (n->getgoingto()<size)
			if ((routing[n->getgoingto()][n->getrow()].deadtxmission==1)&&(verbose||update))
				cout<<" Failed transmission line "<<endl;
		}

	else if (routing[n->getrow()][n->getcolumn()].dead!=1)
		{
		gotcha=1;
		bellman2(n->getrow());
		}
	else 
		{
		// STILL NEED TO RELEASE MEMORY, EVEN IF RECEIVER IS DEAD
		if (verbose||update)
		cout<<" NODE: "<<n->getrow()<<" is currently failed and cannot update it's routing table. "<<endl;
		gotcha=0;
		}
if (verbose){	
	cout<<" brcast node: "<<n->getgoingto()<<endl;
	whatsin(n->getgoingto());
}
	deleteall();
	

	if (verbose||update){
		cout<<" POST-UPDATE STAT "<<endl;
		arrayprint();	
		}
	
	}
/*
		cout<<"entering wallclock\n";
		cout<<" wallclock1: "<<wallclock1<<" the other thing: "<<n->get_za()<<endl;
*/
if ((wallclock1<=n->get_za())&&(clockfix==0))
	{
	 wallclock+=n->get_za()-wallclock1;
	 wallclock1=n->get_za();
	}
else if ((n->get_za()<wallclock1)&&(clockfix==0))
	{
	 /*wallclock+=n->get_za();
	 wallclock1=n->get_za();*/
	// DO NOTHING. IS AN OLD EVENT. NO UPDATE NECESSARY.
	}
// AND IF DEALING WITH MANUAL NODE KILL:
// NEED VARIABLE adjustment WHICH WILL CONTAIN THE GIVEN TIME
// OF THE NODE/LINK'S DEATH
else if ((wallclock1<=adjustment)&&(clockfix==1))
	{
	 wallclock+=adjustment;
	 wallclock1=adjustment;
	}

if (verbose||update)
	cout<<" THE WALLCLOCK TIME IS: "<<wallclock<<endl;
 
my_list.remove(n);
eventqueuenew--;
delete n;
howmany--;
if (verbose||update)
{
cout<<"#of events in queue currently: "<<howmany<<" **********************************"<<endl;
}

// CHECK FOR STABILITY
// FIRST COMPARE CHURN VALUES TO SEE IF ANYONE HAS INCREASED
// IF NO INCREASE SINCE LAST ITERATION, MATRIX HAS STABILIZED
// OR IF DEALING WITH RANDOM FAILURES, CHECK TIME AVERAGE
if ((reaperflag==1)&&(howmany==0))
	{
	// COMPARE TO SEE IF CHURN HAS NOT INCREASED
        	if ((churning==churntemp)&&(churn100thou==a100thoutemp)&&(churn10bill==a10billtemp)&&(bigtemp==churnbig)) 
			{
			cout<<"stabilizing **********************************"<<endl;
			stable++;
			}
		else
			{
			/*	
			cout<<"ITS NOT EQUAL ***********************"<<endl;
			cout<<churntemp<<" "<<churning<<endl;
			cout<<a100thoutemp<<" "<<churn100thou<<endl;
			cout<<a10billtemp<<" "<<churn10bill<<endl;
			cout<<bigtemp<<" "<<churnbig<<endl; */
			churntemp=churning;
			a100thoutemp=churn100thou;
			a10billtemp=churn10bill;	
			bigtemp=churnbig;
			stable=0;
			}
	}
else if ((reaperflag==0)&&(howmany==0))
	{
	// NEED TO COMPUTE TIME AVERAGE AND COMPARE FOR STABILITY
	if (((churning/wallclock)-(churntemp/wallclock)<=.01)&&((churn100thou/wallclock)-(a100thoutemp/wallclock)<=.01)&&((churn10bill/wallclock)-(a10billtemp/wallclock)<=.01)&&((churnbig/wallclock)-(bigtemp/wallclock)<=.01))
		{
		//cout<<" STABLE "<<endl;
		stable++;
		}
	else	
                        { 		
		if (verbose)
		cout<<" churning/wallclock "<<churning<<" "<<wallclock<<" "<<churning/wallclock<<endl;
                        churntemp=churning;
                        a100thoutemp=churn100thou;
                        a10billtemp=churn10bill;
                        bigtemp=churnbig;
                        }
	}

// Check for continued execution
if (timer==1)
	{
	if (wallclock>=timetorun)
		runthis=0;
	else runthis=1;
	}
else if (timer==2)
	{
	if ((wallclock>=timetorun)||(stable>3))
		runthis=0;
	else runthis=1;
	}
else if (timer==3)
	{
	if (stable>=3)
		runthis=0;
	else runthis=1;
	}

}   // FOR WHILE STATEMENT


// **********************************************
// SIMULATION IS COMPLETE
// NOW FORMATTING DATA FOR OUTPUT TO SCREEN
// **********************************************

if (verbose||update){
cout<<endl<<" NETWORK HAS STABILIZED: CURRENT HOP COUNTS: \n\n";
arrayprint();
cout<<endl;}
/*if (verbose||update)
{
cout<<endl<<" Initial Single Hop Matrix \n";
printout(il);
}*/
if (finalize)
arrayprint();
//if (duplex)
cout<<"bellmannew: "<<bellmannew<<" eventqueuenew: "<<eventqueuenew<<endl;
//countcount();
cout<<" vs. "<<endl;
cout<<thegrandtotal<<" "<<howmany<<endl;
cout<<endl<<" The total churn was: 10^16*"<<churnbig<<" + 10^10*"<<churn10bill<<" + 10^5*"<<churn100thou<<" + "<<churning<<" changes"<<endl;
//cout<<endl<<"Total execution time: "<<wallclock<<" seconds. 10^16*"<<churnbig<<" + 10^10*"<<churn10bill<<" + 10^5*"<<churn100thou<<" + "<<churning<<" changes/sec."<<endl;
cout<<" In "<<wallclock<<" seconds."<<endl;
cout<<" Churn per node: "<<endl;
cout<<" ****************"<<endl;
int mostnodefailure=0;
int mostchurn=0;
for (counter=0;counter<size;counter++)
	{
churningtotal=churning10billtotal=churning100thoutotal=churningbigtotal=0;

// NEED TO TOTAL ALL CHURN PER EACH ROW
// MAY WANT TO SINGLE OUT WHICH NODE FAILED MOST OFTEN
// THEN FIND OUT CHURN/SEC, etc etc
	//determine node with most individual churn
if (verbose||update)
cout<<"NODE #"<<mostnodefailure<<" has a nodefail of: "<<routing[mostnodefailure][mostnodefailure].churninga<<"  AND "<<routing[counter][counter].churninga<<" for node: "<<counter<<"compared."<<endl; 
	if (!whoismax(mostnodefailure,counter,1))
		{
		//cout<<" mostnodefailure switched to: "<<counter<<endl;
		mostnodefailure=counter;
		}
	totaler(counter);
if (verbose)
	{
	cout<<"Node: "<<counter<<"\n\t 10^16*"<<churningbigtotal<<"+\n\t 10^10*"<<churning10billtotal<<"+\n\t 10^5*"<<churning100thoutotal<<"+\n\t churning"<<churningtotal<<" total changes."<<endl;
	cout<<"\n\t 10^16*"<<churningbigtotal/wallclock<<"+\n\t 10^10*"<<churning10billtotal/wallclock<<"+\n\t 10^5*"<<churning100thoutotal/wallclock<<"+\n\t churning "<<churningtotal/wallclock<<" total changes per second."<<endl;	
	}
	if (!whoismax(mostchurn,counter,0))
		{
		mostchurn=counter;
		bchurninga=churningtotal;
		bchurnabig=churningbigtotal;
		bchurna100thou=churning100thoutotal;
		bchurna10bill=churning10billtotal;
		}
	}
cout<<"\n The node with most failures/resurrections was: "<<mostnodefailure<<" with a fail/recovery rate of: "<<routing[mostnodefailure][mostnodefailure].churnabig<<" * 10^16 + "<<routing[mostnodefailure][mostnodefailure].churna10bill<<" * 10^10 + "<<routing[mostnodefailure][mostnodefailure].churna100thou<<" * 10^5 + "<<routing[mostnodefailure][mostnodefailure].churninga<<"."<<endl;
cout<<"\n And the node with the most churn was node: "<<mostchurn<<" with "<<bchurnabig<<" * 10^16 + "<<bchurna10bill<<" * 10^10 + "<<bchurna100thou<<" * 10^5 + "<<bchurninga<<"."<<endl;

cout<<" AVERAGE CHURN PER NODE: "<<churnbig/size<<"*10^16 +"<<churn10bill/size<<"*10^10 +"<<churn100thou/size<<"*10^5 +"<<churning/size<<"  Churn per node on average."<<endl;
cout<<" AVERAGE CHURN PER NODE PER SECOND: "<<churnbig/wallclock<<"*10^16 +"<<churn10bill/wallclock<<"*10^10 +"<<churn100thou/wallclock<<"*10^5 +"<<churning/wallclock<<"    churn per node per second."<<endl;


/*
cout<<" changes/updates in "<<wallclock<<" seconds.\n Which equates to: "<<churning/wallclock<<" changes per second on average.\n";
*/
cout<<"\n The network has stabilized. Wallclock time: "<<wallclock<<" seconds."<<endl;

// ***************************************************************************
}
  



