#include <iostream.h>
#include <math.h>
#include <stdlib.h>

// Define number of nodes/matrix size
//#define size 10

// Define node and list classes for creation
// of network matrix
enum Boolean { FALSE, TRUE };      // general truth values

class node {
        friend class list;
        node* next;
};

class list {
        node* head;
        node* prev;
        node* cur;

     public:
        list() { head=prev=cur=0; }
        void insert (node* p)      // insert new node before current
		{
		if (prev==0)
			head=p;
		else
			prev->next=p;
		p->next=cur;
		prev=p;
		}
        node* remove()             //delete current node
		{
		if (cur==0) return 0;
		if (prev==0)
			head=cur->next;
		else
			prev->next=cur->next;
		node* p=cur;
		cur=cur->next;
		return p;
		}
        
	node* first()               //make first node current node
           { prev=0; cur=head; return cur; }
        node* next()               // advance cursor to next node
		{
		if (cur==0) return 0;
		prev=cur;
		cur=cur->next;
		return cur;
		}
        Boolean empty()             // return TRUE for empty list
           { return Boolean (head == 0); }
	};

class inode: private node 
	{
public:
	int value;		//relevant value
    //public:
	inode (int i) { value = i; }
	friend ostream& operator<< (ostream& c, inode& n)
		{ return c << n.value; }   //output value of inode
	};

class ilist:private list
	{
   public:
	ilist() {}
	void insert (inode* p) { list::insert( (node*)p ); }
	inode* remove() { return (inode*)list::remove(); }
	inode* first() { return (inode*)list::first(); }
	inode* next() { return (inode*)list::next(); }
	void list (inode* p) { list::list(); }
	Boolean empty() { return list::empty(); }
	};

