#include<iostream.h>

#ifndef NULL
#define NULL ((void *)0)
#endif


// This header defines the list structure for the global event queue

class list_node{
private:
  list_node *next;
  list_node *prev;
  short row;
  short col;
// EXTRA BITS FOR TRACKING USE
  short nodebounce;
  float broadcasttime;
  char okay_to_broadcast;
  int goingto;
  short getfrmrow;

public:

  list_node(int x, int y, float za, short otb,short bounced,int gto,short getfrmrw):
    next(NULL),
    prev(NULL),
    row(x),
    col(y),
    broadcasttime(za),
    okay_to_broadcast(otb),
    nodebounce(bounced),
    goingto(gto),
    getfrmrow(getfrmrw)
    {
    }

  inline list_node *get_next()
    {
      return next;
    }

  inline void set_next(list_node *n)
    {
      next=n;
    }

  list_node *get_prev()
    {
      return prev;
    }

  void set_getgoingto(int x)
    {
	// set return value for where this event is targetted, i.e. broadcasting
	// to which node?
      goingto=x;
    }

  void set_prev(list_node *n)
    {
      prev=n;
    }

  void get_data (int &x, int &y, float &za, short &otb)
    {
	// return basic useful information about an event
      x=row;
      y=col;
      za=broadcasttime;
      otb=okay_to_broadcast;
    }

  inline void set_getfrmrow(short yy)
    {
	// set information about the return address
	// of this event
    getfrmrow=yy;
    }

  inline void set_broad(float xx)
    {
	// sets broadcast time
    broadcasttime=xx;
    }

  inline void set_data (int x1, int x2, float z3, short z4)
    {
      row=x1;
      col=x2;
      broadcasttime=z3;
      okay_to_broadcast=z4;
    }

  inline short getfromrow() const
    {
	//return information about this event's return
	// address
    return(getfrmrow);
    }

  inline short getbounce() const
    {
	// return flag determining is this event is
	// a rtd event
      return nodebounce;
    }

  inline short getgoingto() const
    {
	// return information about where this event is
	// targetted
      return goingto;
    }

  inline float get_za() const
    {
	// return broadcast time for event
      return broadcasttime;
    }

  inline short get_otb() const
    {
	// return set flags, as defined in initiator
      return okay_to_broadcast;
    }

// RETURN VALUES FOR LOCATION IN MATRIX
  inline int getrow()
    {
	return row;
    }

  inline int getcolumn()
    {
	return col;
    }

  void insert_after(list_node *n)
    {
      list_node *after=next;
      n->next=after;
      next=n;
      n->prev=this;
      if (after!=NULL){
	after->prev=n;
      }
    }
// SPECIALIZED REMOVE FUNCTION 
  list_node* remove1(list_node *n)
    {
     list_node* previous=n->prev;
     list_node* thenext=n->next;
     previous->set_next(thenext);
     thenext->set_prev(previous);
     delete n;
    } 
  list_node* remove2(list_node *n)
    {
     list_node* previous=n->prev;
     list_node* thenext=n->next;
     previous->set_next(NULL);
     thenext->set_prev(NULL);
    } 

};

class list1 {
private:
  list_node *head, *tail;
public:
  list1() :
    head(NULL),
    tail(NULL)
    {
    }
  list_node* remove(list_node *n)
    {
      if (head==NULL) return(NULL);
      else if (n==head)
	{
	 if (n->get_next()==NULL)
		{
		head=NULL;	
		return(NULL);
		}
	 else
	 make_head(n->get_next());
	}
      else 
	{
		n->remove1(n);	
	}
    }
  list_node* next(list_node *n)
    {
      return n->get_next();
    }
  void prepend(list_node *n) 
    {
      n->insert_after(head);
      n->set_prev(NULL);
      head=n;
    }
  void append(list_node *n){
    if (head==NULL){
      head=tail=n; }
    else {
      insert_after(n,tail);
    }
  }
  void insert_after (list_node *n, list_node *p)
    {
      p->insert_after(n);
      if (n->get_next()==NULL){
	tail=n;
      }
    }
  list_node* first()
    {
      return head;
    }
  list_node* last()
    {
      return tail;
    }

  void make_head(list_node *node) {
    head = node;
    node->set_prev(NULL);
  }

};
