#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include <string.h>
#include <X11/libsx.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>

#include <assert.h>

#define STRENGTH_CUTTOFF	0


/* format of the plot taken from SAWatch */

#define uchar unsigned char

extern Dimension pixmap_xmax, pixmap_ymax;
extern double	X0, Y0, Xmax, Ymax;

static	u_char sav[341][341];
static	double Elevation[360];


/*
 * MY coordinate system is (0,0) at lower left
 *			   (5,5) at upper right.
 * LIBSX coordinate system is in pixels,
 *	measured from upper left.
 */

/*
 * NB. Navigators measure Azimuth from the North, to the East,
 *     viz ccw, so
 *		x = R*sin(Az)
 *		y = R*cos(Az)
 *     Astronomers measure Azimuth from the South to the West.
 */

struct Sat {
	int	active;
	int	az;
	int	el;
	u_char	ss;
} sat[33];

void circle(double x, double y, double R);
void draw_posn(void);
void draw_horizon(void);
void frame(void);
void Text(double, double, char *);
void quit(Widget w, void *data);
void print_ps(Widget w, void *data);
void nada(Widget w, int width, int height, void *data);
void sat_update_posn(void);
void set_color(void);

double	pi = 3.1415926535;
double	Rearth = 6.371e6;	/* m */
double	RRmax = 1.6875;

int	plot_choice = 0;
int	size;
char	*file;
uchar	*Buf;

XFont	f;
int	fd;

int	ht_type0;
double	Lat0, Lon0, Ht0, Rmax = 100.;
double	MdLat, MdLon, MdZ;
int	Mn;

int	year, mo, day, hour, minute, second;
int	timeout = 11000;       /* miliseconds */
int	Ea_seen, As_seen;


Widget wb, wd, wp;

void	plots(), axis(), plot(), line();
void	draw(), read_data();
void	oncore_msg_do_Ea(), oncore_msg_Ea(), oncore_msg_Bb(), do_time();

struct Msg {
	char	     c[5];
	unsigned int seq;
	void	     (*go_to)(uchar *);
};

struct Msg Hdr[] = { {"@@Bb", 0, &oncore_msg_Bb},
		     {"@@Ea", 0, &oncore_msg_Ea}};

/*
 * Colors
 *   1 red
 *   2 blue
 *   3 green
 *   4 black
 *   5 white
 *   6 magenta
 *   7 orange
 *   8 gray
 */

int	Red = 1, Blue = 2, Green = 3, Black = 4, White = 5, Magenta = 6, Orange = 7, Gray=8, Color; /* flags */
int	red, blue, green, black, white, magenta, orange, gray;	/* libsx colors */

/* size of drawing area in pixels */
#define XSIZE	500
#define YSIZE	500

#define w32(buf)      (((buf)[0]&0xff) << 24 | \
		       ((buf)[1]&0xff) << 16 | \
		       ((buf)[2]&0xff) <<  8 | \
		       ((buf)[3]&0xff) )

	/* from buffer, char *buf, result to an int */
#define buf_w32(buf) (((buf)[0]&0200) ? (-(~w32(buf)+1)) : w32(buf))

struct stat statbuf;


int
main(int argc, char *argv[])
{
	time_t	clock;
	struct timeval tp;
	char *cp;

	argc = OpenDisplay(argc, argv);
	if (argc == 0)
		exit(5);

	wb = MakeButton("Quit", quit, NULL);

	wd = MakeDrawArea(XSIZE, YSIZE, nada, NULL);

	wp = MakeButton("Print", print_ps, NULL);

	SetWidgetPos(wd, PLACE_UNDER, wb, NO_CARE, NULL);
	SetWidgetPos(wp, PLACE_RIGHT, wb, NO_CARE, NULL);

	red = GetNamedColor("red");
	black = GetNamedColor("black");
	white = GetNamedColor("white");
	blue = GetNamedColor("blue");
	green = GetNamedColor("green");
	magenta = GetNamedColor("magenta");
	orange = GetNamedColor("orange");
	gray = GetNamedColor("DarkSlateGray");

	ShowDisplay();
	GetStandardColors();

	if (!(f=GetFont("-adobe-helvetica-medium-r-*-*-15-*-*-*-*-*-*-*"))) {
		fprintf(stderr, "Cant get Helvetica 8pt\n");
		exit(1);
	}

	file = "/var/adm/ntpstats/ONCORE";
	if ((fd=open(file, O_RDONLY)) < 0) {
		fprintf(stderr, "Cant open %s\n", file);
		exit(1);
	}

	if (stat(file, &statbuf) < 0) {
		fprintf(stderr, "Cant stat %s\n", file);
		exit(1);
	}

	size = statbuf.st_size;
	if ((Buf=mmap(0, size, PROT_READ, MAP_SHARED, fd, (off_t) 0)) < 0) {
		fprintf(stderr, "MMAP failed\n");
		exit(1);
	}

	gettimeofday(&tp, (struct timezone *)0);
	clock = tp.tv_sec;
	cp = ctime(&clock);
	cp[24] = '\0';

	AddTimeOut(100, read_data, NULL);

	MainLoop();
	exit(0);
}


void
quit (Widget w, void *data)
{
	exit(0);
}

void
nada (Widget w, int width, int height, void *data)
{
	draw();
}

void
read_data()
{
	int	i, j, k, n, iseq, jseq;
	uchar	*cp, *cp1;


	for(cp=Buf+1; (n = 256*(*cp) + *(cp+1)) != 0;  cp+=(n+3)) {
		for (k=0; k<sizeof(Hdr)/sizeof(Hdr[0]);  k++) {
			if (!strncmp(cp+3, Hdr[k].c, 4)) {	/* am I interested? */
				iseq = *(cp+2);
				jseq = Hdr[k].seq;
				Hdr[k].seq = iseq;
				if (iseq > jseq) {		/* has it changed? */
					/* verify checksum */
					j = 0;
					cp1 = cp+3;		/* points to start of oncore response */
					for (i=2; i<n-3; i++)
						j ^= cp1[i];
					if (j == cp1[n-3]) {	/* good checksum */
						Hdr[k].go_to(cp1);
					} else {
						fprintf(stderr, "Bad Checksum for %s\n", Hdr[k].c);
						break;
					}
				}
			}
		}
		if (!strncmp(cp+3, "@@Ea", 4))
			cp += 3*(n+3);
	}
	draw();
	AddTimeOut(timeout, read_data, NULL);
}


void
oncore_msg_Bb(uchar *buf)
{
	int i, j, id, nsat;

	for (i=0; i<33; i++) {
		sat[i].active = 0;
	}
	nsat = buf[4];
	nsat = (nsat > 12) ? 12 : nsat; /* manual lies, this can be 13 */
	j = 4;
	for (i=0; i<nsat; i++) {
		id = buf[j+1];
		if (id < 1 || id > 32) {
			fprintf(stderr, "Error in sat id = %d\n", id);
		} else {
			sat[id].el = buf[j+4];
			sat[id].az = 256*buf[j+5] + buf[j+6];
			sat[id].active = 1;
		}
		j += 7;
	}
	sat_update_posn();
}


void
oncore_msg_Ea(uchar *buf)
{
	int	i;

	mo   = buf[4];
	day  = buf[5];
	year = buf[6]*256+buf[7];
	hour = buf[8];
	minute = buf[9];
	second = buf[10];

	/********************************/

	for (i=1; i<33; i++) {
		sat[i].ss = 0;
	}

	for (i=40; i<72; i+=4) {
		int	id;

		id = buf[i];
		if (id < 1 || id > 32)
			continue;

		sat[id].ss   = buf[i+2];
	}
}


void
sat_update_posn()
{
	int	i;
	double	Az, El;
	int	ss;

	for (i=1; i<33; i++) {
		if (sat[i].active) {
			Az = sat[i].az;
			El = sat[i].el;
			ss = sat[i].ss;

			if (ss > STRENGTH_CUTTOFF) {
				double r, th, x0, y0;
				int	ix, iy;

				r = ((90.-El)/90.)*RRmax;
				th = 2.0*pi*(Az/360.);

				x0 = RRmax + r*sin(th);
				y0 = RRmax + r*cos(th);

				/* now convert to pixels in sav array */

				ix = 100.*x0 + 0.5;
				iy = 100.*y0 + 0.5;
				if (ss > sav[ix][iy])
					sav[ix][iy] = ss;

				/****************/

				ix = Az;
				if (!Elevation[ix] || El < Elevation[ix])
					Elevation[ix] = El;
			}
		}
	}
}


void
draw_posn()
{
	int	i, j;
	double	x, y, XLL, YLL, ss;

	XLL = 2.5-RRmax;
	YLL = 2.5-RRmax;

	for (j=0; j<341; j++) {
		for (i=0; i<341; i++) {
			if (sav[i][j]) {
				x = i;
				x = XLL + 0.01*x;
				y = j;
				y = YLL + 0.01*y;

				ss = sav[i][j];
				if (ss < 50)
					Color = Red;
				else if (ss < 100)
					Color = Orange;
				else if (ss < 150)
					Color = Green;
				else if (ss <  200)
					Color = Blue;
				else
					Color = Black;
				set_color();

				plot (x-0.01, y-0.01, 3);
				plot (x-0.01, y+0.01, 2);
				plot (x+0.01, y+0.01, 2);
				plot (x+0.01, y-0.01, 3);
				plot (x-0.01, y-0.01, 2);
			}
		}
	}
}


void
draw_horizon()
{
	int	i, i0;
	double	x, y, x0, y0, r, theta;

	for (i=0; i<360; i++)
		if (Elevation[i])
			break;

	Color = Gray;
	set_color();

	i0 = i;
	r = ((90.0-Elevation[i0])/90.)*RRmax;
	theta = (2.0*pi*i)/360.;
	x0 = 2.5 + r*sin(theta);
	y0 = 2.5 + r*cos(theta);
	plot (x0, y0, 3);

	SetLineWidth(2);
	for (i=i0; i<360; i++) {
		if (Elevation[i]) {
			r = ((90.0-Elevation[i])/90.)*RRmax;
			theta = (2.0*pi*i)/360.;
			x = 2.5 + r*sin(theta);
			y = 2.5 + r*cos(theta);
			plot (x, y, 2);
		}
	}
	plot(x0, y0, 2);
	SetLineWidth(1);
}


void
draw()
{
	plots(0., 0., 5., 5.);
	ClearDrawArea();

	axis();
	draw_posn();
	draw_horizon();

	SyncDisplay();
}


void
print_ps(Widget w, void *data)
{
	plot_choice = 2;
	plots(0., 0., 5., 5.);

	axis();
	draw_posn();
	draw_horizon();

	frame();
	plot_choice = 0;
}

void
axis()
{
	int	j;
	double x, y;
	double RR[3] = { 1.6875, 1.125, 0.5625};

	Color = Black;
	SetFgColor(wd, black);
	SetBgColor(wd, white);

	plot(2.5, 2.5-1.8, 3);
	plot(2.5, 2.5+1.8, 2);

	plot(2.5-1.8, 2.5, 3);
	plot(2.5+1.8, 2.5, 2);

	plot(2.5+0.9, 2.5+1.56, 3);
	plot(2.5-0.9, 2.5-1.56, 2);

	plot(2.5-0.9, 2.5+1.56, 3);
	plot(2.5+0.9, 2.5-1.56, 2);

	plot(2.5+1.56, 2.5+0.9, 3);
	plot(2.5-1.56, 2.5-0.9, 2);

	plot(2.5-1.56, 2.5+0.9, 3);
	plot(2.5+1.56, 2.5-0.9, 2);

	Text( 2.49,  4.25, "N");
	Text( 2.49,  0.6 , "S");
	Text( 0.6 ,  2.45, "W");
	Text( 4.35,  2.45, "E");

	x = 4.5;
	y = 2.5-RRmax;
	Text(x, y, "Horiz");
	y = 2.5+RRmax;
	Text(x, y, "Horiz");

	y = 2.5-1.125;
	Text(x, y, "30 deg");
	y = 2.5+1.125;
	Text(x, y, "30 deg");

	y = 2.5-0.5625;
	Text(x, y, "60 deg");
	y = 2.5+0.5625;
	Text(x, y, "60 deg");

	y = 2.5;
	Text(x, y, "90 deg");

	for (j=0; j<3; j++)
		circle(2.5, 2.5, RR[j]);
}
