#include <stdio.h>
#include <math.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/List.h>
#include <X11/libsx.h>

GC      gc;
XFont   f;

Dimension pixmap_xmax, pixmap_ymax;
double   X0, Y0, Xmax, Ymax;
void    setFGcolor_X(), setBGcolor_X();

extern  Widget wd;
Display *draw_display;
Screen  *draw_screen;
Window  draw_window;

extern int     red, blue, green, black, white, magenta, orange, gray;
extern int     Red, Blue, Green, Black, White, Magenta, Orange, Gray, Color;
extern double  RRmax;

void
plots_X(double x0, double y0, double xmax, double ymax)
{
	Arg     arg[2];
	int fore_g,back_g;      /* Fore and back ground pixels */
	static int first = 1;

	if (first) {
		first = 0;
		draw_display = XtDisplay(wd);
		draw_window = XtWindow(wd);
		draw_screen = XtScreen(wd);

		gc = XCreateGC(draw_display, DefaultRootWindow(draw_display), 0, 0);
	}

	X0 = x0;
	Y0 = y0;
	Xmax = xmax;
	Ymax = ymax;

	XtSetArg(arg[0], XtNwidth,  &pixmap_xmax);
	XtSetArg(arg[1], XtNheight, &pixmap_ymax);
	XtGetValues(wd, arg, 2);

	back_g = WhitePixel(draw_display,DefaultScreen(draw_display));
	fore_g = BlackPixel(draw_display,DefaultScreen(draw_display));

	XSetForeground(draw_display, gc, fore_g);
	XSetBackground(draw_display, gc, back_g);
	XSetFunction  (draw_display, gc, GXcopy);
	ClearDrawArea();
}

void
plot_X(double x, double y,int ic)
{
	int     i, j;
	static int iold, jold;

	x += X0;
	y += Y0;

	i = (int) ( (float) pixmap_xmax /Xmax * x );
	j = (int) ( (float) pixmap_ymax /Ymax * y );
	j = pixmap_ymax - j;

	if (ic == 2) {
		setFGcolor_X();
		DrawLine(iold, jold, i, j);
	}
	iold = i;
	jold = j;
}


void
satellite_X (int id, int az, int el, int posn)    /* Az, El in DEGREES */
{
	char line[5];
	double Az, El;
	extern double pi;
	double r, th;
	double x0, y0;
	int    ix, iy, x3, y3;
	int ht = 15;            /* pixels */
	int width = 25;         /* pixels */

	/* convert Lat,Lon to (x,y) */

	Az = az;
	El = el;

	r = ((90.-El)/90.)*RRmax;
	th = 2.0*pi*(Az/360.);

	x0 = 2.5 + r*sin(th);
	y0 = 2.5 + r*cos(th);

	/* now conver to pixels */

	ix = (int) ( (float) pixmap_xmax /Xmax * x0 );
	iy = (int) ( (float) pixmap_ymax /Ymax * y0 );
	iy = pixmap_ymax - iy;

	/* now move corner of box so ctr of box at x0,y0 */

	x3 = ix - width/2;
	y3 = iy - ht/2;

	setFGcolor_X();
	DrawFilledArc(x3 , y3, width,  ht, 0., 360.);
	setBGcolor_X(Color);
	Color = Black;
	setFGcolor_X();

	if (posn) {
		SetLineWidth(2);
		DrawArc(x3-1, y3-1, width+2,  ht+2, 0., 360.);
		SetLineWidth(1);
	}

	/* now label */

	sprintf(line, "%02d", id);
	DrawText(line, ix-5, iy+5);
	SetBgColor(wd, white);
}

void
frame_X()
{}

void
Text_X(double x, double y, char *text)
{
	int     i, j;

	i = (int) ( (float) pixmap_xmax /Xmax * x );
	j = (int) ( (float) pixmap_ymax /Ymax * y );
	j = pixmap_ymax - j;
	DrawText(text, i, j);
}


void
circle_X(double x, double y, double R)
{
	int     i, j, rx, ry;

	i = (int) ( (float) pixmap_xmax /Xmax * x );
	j = (int) ( (float) pixmap_ymax /Ymax * y );
	j = pixmap_ymax - j;

	rx= (int) ( (float) pixmap_xmax /Xmax * R );
	ry= (int) ( (float) pixmap_ymax /Ymax * R );

	DrawArc(i-rx, j-ry, 2*rx, 2*ry, 0, 360);
}


void
setFGcolor_X()
{
	static int last_color;

	if (Color == last_color)
		return;

	last_color = Color;
	switch(Color) {
	case 1: /* red */
		SetFgColor(wd, red);
		break;
	case 2: /* blue */
		SetFgColor(wd, blue);
		break;
	case 3: /* green */
		SetFgColor(wd, green);
		break;
	case 4: /* black */
		SetFgColor(wd, black);
		break;
	case 5: /* white */
		SetFgColor(wd, white);
		break;
	case 6: /* magenta */
		SetFgColor(wd, magenta);
		break;
	case 7: /* orange */
		SetFgColor(wd, orange);
		break;
	case 8: /* gray */
		SetFgColor(wd, gray);
		break;
	default:
		SetFgColor(wd, black);
		break;
	}
}


void
setBGcolor_X(Color)
{
	switch(Color) {
	case 1: /* red */
		SetBgColor(wd, red);
		break;
	case 2: /* blue */
		SetBgColor(wd, blue);
		break;
	case 3: /* green */
		SetBgColor(wd, green);
		break;
	case 4: /* black */
		SetBgColor(wd, black);
		break;
	case 5: /* white */
		SetBgColor(wd, white);
		break;
	case 6: /* magenta */
		SetBgColor(wd, magenta);
		break;
	case 7: /* orange */
		SetBgColor(wd, orange);
		break;
	case 8: /* gray */
		SetBgColor(wd, gray);
		break;
	default:
		SetBgColor(wd, black);
		break;
	}
}

