%!PS-Adobe-2.0
%%Title: PADS Postscript Driver Header
%%Creator: Andy Montalvo, 18 Lupine St., Lowell, MA  01851
%%CreationDate: 06/08/90
%%For: CAD Software, Littleton, MA
%%EndComments
%%BeginProcSet: Markers 1.0 0
% marker attributes
/MAttr_Width 1 def
/MAttr_Size  0 def
/MAttr_Type /M1 def
% procedures
/M1 { %def
% draw marker 1: plus
% Stack: - M1 -
    -2 0 rmoveto
    4 0 rlineto
    -2 2 rmoveto
    0 -4 rlineto
} bind def
/M2 { %def
% draw marker 2: cross
% Stack: - M2 -
    -2 -2 rmoveto
    4 4 rlineto
    -4 0 rmoveto
    4 -4 rlineto
} bind def
/M3 { %def
% draw marker 3: square
% Stack: - M3 -
    0 2 rlineto
    2 0 rlineto
    0 -4 rlineto
    -4 0 rlineto
    0 4 rlineto
    2 0 rlineto
} bind def
/M4 { %def
% draw marker 4: diamond
% Stack: - M4 -
    0 2 rlineto
    2 -2 rlineto
    -2 -2 rlineto
    -2 2 rlineto
    2 2 rlineto
} bind def
/M5 { %def
% draw marker 5: hourglass
% Stack: - M5 -
    2 2 rlineto
    -4 0 rlineto
    4 -4 rlineto
    -4 0 rlineto
    2 2 rlineto
} bind def
/M6 { %def
% draw marker 6: bowtie
% Stack: - M6 -
    2 2 rlineto
    0 -4 rlineto
    -4 4 rlineto
    0 -4 rlineto
    2 2 rlineto
} bind def
/M7 { %def
% draw marker 7: small plus (goes with char marker)
% Stack: - M7 -
    -1 0 rmoveto
    2 0 rlineto
    -1 1 rmoveto
    0 -2 rlineto
} bind def
/Marker { %def
% Command from driver: draw marker
% STACK: x y Marker -
    MAttr_Size 0 gt
    {
        gsave
        moveto
        MAttr_Size 4 div dup scale
        MAttr_Type load exec
        4 MAttr_Size div dup scale
        MAttr_Width setlinewidth
        stroke
        grestore
    } if
} def
%%EndProcSet: Markers 1.0 0
%%BeginProcSet: Lib 1.0 0
/sg { %def
% Command from driver: set the gray scale 0 - 100
% STACK: greylevel sg
    100 div dup setgray /glev exch def
} bind def
/Circle { %def
% draw a circle
% STACK: x y radius Circle -
    0 360 arc
} bind def
/RndAper { %def
% select a round aperture
% STACK: - RndAper -
    1 setlinejoin
    1 setlinecap
} bind def
/SqrAper { %def
% select a square aperture
% STACK: - SqrAper -
    0 setlinejoin
    2 setlinecap
} bind def
/Line { %def
% draw a set of connected lines
% STACK: x1 y1 [ x2 y2 ... xn yn ] Line -
    3 1 roll
    moveto
    true
    exch
    % This pushes the x then the y then does lineto
    { exch  { false } { lineto true } ifelse } forall
    pop
} bind def
/Clipto { %def
% set clipping rectangle from 0,0 to new values
% STACK: x y Clipto -
    0 0 moveto
    dup 0 exch lineto
    2 copy lineto
    pop
    0 lineto
    closepath
    clip
    newpath
} bind def
/Clip4 { %def
% set clipping rectangle from xmin,ymin to xmax,ymax
% STACK: xmin ymin xmax ymax Clip4 -
    4 copy pop pop moveto
    4 copy pop exch lineto pop
    2 copy lineto
    exch pop exch pop lineto
    closepath
    clip
    newpath
} bind def
%%EndProcSet: Lib 1.0 0
%%BeginProcSet: Lines 1.0 0
% line attributes %
/LAttr_Width 1 def
% line procedures
/PLine { %def
% Cammand from driver: draw a set of connected lines
% STACK: x1 y1 [ x2 y2 ... xn yn ] PLine -
    Line
    LAttr_Width setlinewidth
    stroke
} bind def % PLine
/Char { %def
% Command from driver: draw a character at the current position
% STACK: type x y stroke_array Char -
%    stroke array -- [ stroke1 stroke2 ... stroken ]
%    stroke -- connected staight lines
%    type = 0 if text  1 if marker
    gsave
    4 1 roll
    translate
    0 eq { TAttr_Width } { MAttr_Width } ifelse setlinewidth
    {
        dup length 2 gt
        {
            dup dup 0 get exch 1 get % get starting point
            3 -1 roll                % put x y before array
            dup length 2 sub 2 exch getinterval % delete first items from array
            Line
            stroke
        }
        {
            aload pop currentlinewidth 2 div Circle fill
        } ifelse
    } forall
    grestore
} bind def % Char
/PArc { %def
% Command from driver: draw an arc
% STACK: x y radius startangle deltaangle Arc -
	 10 div exch 10 div exch
    2 copy pop add
    arc
    LAttr_Width setlinewidth
    stroke
} bind def
/PCircle { %def
% Command from driver: draw an circle
% STACK: x y radius PCircle -
    Circle
    LAttr_Width setlinewidth
    stroke
} bind def
%%EndProcSet: Lines 1.0 0
%%BeginProcSet: Polygon 1.0 0
% polygon attributes %
/PAttr_ExtWidth 1 def
/PAttr_IntWidth 1 def
/PAttr_Grid 1 def
% polygon procedures
/LoopSet { %def
% set up for loop condition
% STACK: start end LoopSet low gridwidth high
    2 copy lt { exch } if
    % make grid line up to absolute coordinates
    PAttr_Grid div truncate PAttr_Grid mul exch
    PAttr_Grid exch
} bind def
/Hatch { %def
% draw cross hatch pattern in current path
% STACK: - Hatch -
    pathbbox
    /ury exch def
    /urx exch def
    /lly exch def
    /llx exch def
    clip
    newpath
    llx urx LoopSet
    { % x loop
        dup lly exch ury moveto lineto
    } for
    lly ury LoopSet
    { % y loop
        llx exch dup urx exch moveto lineto
    } for
    PAttr_IntWidth setlinewidth
    stroke
} bind def
/PPoly { %def
% Command from driver: draw a plygon
% STACK: x1 y1 [ x2 y2 ... xn yn ] PLine -
    Line
    closepath
    gsave
    PAttr_IntWidth PAttr_Grid ge {fill} {Hatch} ifelse
    grestore
    PAttr_ExtWidth setlinewidth
    stroke
} bind def
%%EndProcSet: Polygon 1.0 0
%%BeginProcSet: Text 1.0 0
% text attributes %
/TAttr_Mirr 0 def
/TAttr_Orient 0 def
/TAttr_Width 1 def
% text procedures
/Text { %def
% Command from driver: Draw text
% STACK: x y width string Text -
    gsave
    4 2 roll
    translate
    TAttr_Mirr 0 gt
    {
        -1 1 scale
    } if
    TAttr_Orient rotate
    0 0 moveto
    dup length dup 1 gt
    {
        exch dup stringwidth pop
        4 -1 roll
        exch 2 copy
        lt
        {
            div 1 scale show
        }
        {
            sub
            3 -1 roll 1 sub div
            0 3 -1 roll ashow
        }
        ifelse
    }
    {
        pop
        show
    } ifelse
    grestore
} bind def
%%EndProcSet: Text 1.0 0
%%BeginProcSet: FlashSymbols 1.0 0
% flash symbol attributes %
/FAttr_Type /PRndPad def
/FAttr_Width  0 def
/FAttr_Length 1 def
/FAttr_Orient 0 def
% flash symbol procedures
/PRndPad { %def
% Command from driver: draw an circular pad
% STACK: - PCirclePad -
    FAttr_Width dup scale
    0 0 .5 Circle
    fill
} bind def
/PSqrPad { %def
% Draw an Square pad
% STACK: - PRectPad -
    FAttr_Width dup scale
    .5 .5 moveto
    -.5 .5 lineto
    -.5 -.5 lineto
    .5 -.5 lineto
    closepath
    fill
} bind def
/PRectPad { %def
% Draw an rectangular pad
% STACK: - PRectPad -
    FAttr_Length FAttr_Width scale
    .5 .5 moveto
    -.5 .5 lineto
    -.5 -.5 lineto
    .5 -.5 lineto
    closepath
    fill
} bind def
/POvalPad { %def
% Draw an oval pad
% STACK: - POvalPad -
    FAttr_Width setlinewidth
    FAttr_Length FAttr_Width sub 2 div dup
    neg 0 moveto
    0 lineto
    RndAper
    stroke
} bind def
/Anl { %def
    0 0 .5 Circle
    fill
    FAttr_Length FAttr_Width lt
    { % inner circle
        0 0
        FAttr_Length 0 gt { FAttr_Length FAttr_Width div } { .5 } ifelse
        2 div Circle
        1 setgray
        fill
        glev setgray
    } if
} bind def
/PAnlPad { %def
% Draw an annular pad
% STACK: - PAnlPad -
    FAttr_Width dup scale
    Anl
} bind def
/PRelPad { %def
% Draw an thermal relief pad
% STACK: - PRelPad -
    PAnlPad
    1 setgray
    .17 setlinewidth
    0 setlinecap   % the x
    45 rotate
    .5 0 moveto -.5 0 lineto
    0 .5 moveto  0 -.5 lineto
    stroke
    glev setgray
} bind def
/Flash { %def
% Command from driver: Flash a symbol
% STACK: x y Flash -
    FAttr_Width 0 gt
    {
        gsave
        translate
        FAttr_Orient rotate
        FAttr_Type load exec
        grestore
    } if
} def
%%EndProcSet: FlashSymbols 1.0 0
%%BeginProcSet: SetAttr 1.0 0
/SetLine { %def
% Set the width of the lines
% STACK: linewidth SetLine -
    /LAttr_Width exch def
    RndAper
} bind def
/SetPoly { %def
% Set attribute of polygon
% STACK: external_width internal_grid_width grid_spacing SetPoly -
    /PAttr_Grid exch def
    /PAttr_IntWidth exch def
    /PAttr_ExtWidth exch def
    RndAper
} bind def
/SetFlash { %def
% Set Attributed of flash pad
% STACK: orientation_angle length width aperture_type SetFlash -
    /FAttr_Type exch def
    FAttr_Type /PSqrPad eq FAttr_Type /PRectPad eq or
    { SqrAper } { RndAper } ifelse
    /FAttr_Width exch def
    /FAttr_Length exch def
    /FAttr_Orient exch 10 div def
} bind def
/SetMkr { %def
% Set attributes of markers
% STACK: linewidth size type SetMkr -
    /MAttr_Type exch def
    /MAttr_Size exch def
    /MAttr_Width exch def
    RndAper
} bind def
/SetText1 { %def
% Set attributes of text
% STACK: fontname height orient mirror SetMkr -
    /TAttr_Mirr exch def
    /TAttr_Orient exch 10 div def
    exch findfont exch scalefont setfont
    RndAper
} bind def
/SetText2 { %def
% Set attributes of text
% STACK: linewidth height mirror orient SetMkr -
    /TAttr_Width exch def
    RndAper
} bind def
%%EndProcSet: SetAttr 1.0 0
%%BeginProcSet: Initialize 1.0 0
/Init { %def
% Initialize the driver
% STACK: Init -
    72 1000 div dup scale % Scale to 1/1000 inch
    250 250 translate     % make origin 1/4 inch from bottom left
    1.5 setmiterlimit 1 RndAper                     % set line defaults
    0 setgray                                       % set color default
    /glev 0 def
} def
%%EndProcSet: Initialize 1.0 0
%%EndProlog
/Helvetica findfont 12 scalefont setfont
35 760 moveto
(lr.job - Fri Jul 17 02:20:02 1992) show
gsave
Init
8000 10500 Clipto
6057 9252 translate
90 rotate
1 1 div dup scale
75 sg
50 sg
25 sg
0 sg
10 SetLine
-7805 3900 [ -8005 3900 ] PLine
-8005 3900 [ -8005 3700 ] PLine
10 SetLine
-8000 200 [ -8000 0 ] PLine
-8000 0 [ -7800 0 ] PLine
10 SetLine
-200 0 [ 0 0 ] PLine
0 0 [ 0 200 ] PLine
10 SetLine
-200 3892 [ 0 3892 ] PLine
0 3892 [ 0 3692 ] PLine
0 0 70 /PRndPad SetFlash
-7100 3150 Flash
-6800 3150 Flash
-7400 3000 Flash
-7700 3000 Flash
-7400 2850 Flash
-7700 2850 Flash
-7700 2250 Flash
-7400 2250 Flash
-7700 2100 Flash
-7400 2100 Flash
-7100 2250 Flash
-6800 2250 Flash
-7400 1950 Flash
-7700 1950 Flash
-7100 1950 Flash
-6800 1950 Flash
-7450 1100 Flash
-7650 1100 Flash
-7300 1800 Flash
-7300 1500 Flash
-7400 1250 Flash
-7700 1250 Flash
-6500 800 Flash
-6800 800 Flash
-6900 800 Flash
-7200 800 Flash
-6150 1100 Flash
-6150 1400 Flash
-7500 800 Flash
-7700 800 Flash
-7300 350 Flash
-7300 650 Flash
-7400 950 Flash
-7700 950 Flash
-4850 2600 Flash
-4850 2900 Flash
-6000 3050 Flash
-6000 2850 Flash
-6650 400 Flash
-6350 400 Flash
-6350 600 Flash
-6650 600 Flash
-6000 800 Flash
-6200 800 Flash
-5600 450 Flash
-5600 750 Flash
-5925 950 Flash
-6225 950 Flash
-6300 2200 Flash
-6300 2500 Flash
-6450 2200 Flash
-6450 2500 Flash
-5850 2300 Flash
-5850 2500 Flash
-6000 2200 Flash
-6000 2500 Flash
-5700 2450 Flash
-5400 2450 Flash
-4850 2450 Flash
-5150 2450 Flash
-550 700 Flash
-550 500 Flash
-4450 3100 Flash
-4450 3400 Flash
-2250 3700 Flash
-2250 3400 Flash
-1350 3700 Flash
-1350 3400 Flash
-4450 2800 Flash
-4450 2500 Flash
-2950 2800 Flash
-2950 2500 Flash
-4450 2100 Flash
-4450 1800 Flash
-3050 2100 Flash
-3050 1800 Flash
-4450 1400 Flash
-4450 1100 Flash
-3450 1400 Flash
-3450 1100 Flash
-4450 800 Flash
-4450 500 Flash
-2050 800 Flash
-2050 500 Flash
-4750 700 Flash
-4750 500 Flash
-750 700 Flash
-750 500 Flash
-4800 3500 Flash
-4800 3300 Flash
-4750 1300 Flash
-4750 1100 Flash
0 0 70 /PSqrPad SetFlash
-7700 3300 Flash
0 0 70 /PRndPad SetFlash
-7300 3300 Flash
0 0 70 /PSqrPad SetFlash
-7300 3150 Flash
0 0 70 /PRndPad SetFlash
-7700 3150 Flash
0 0 70 /PSqrPad SetFlash
-4750 2150 Flash
0 0 70 /PRndPad SetFlash
-5150 2150 Flash
0 0 70 /PSqrPad SetFlash
-5700 3050 Flash
0 0 70 /PRndPad SetFlash
-5300 3050 Flash
0 0 70 /PSqrPad SetFlash
-6150 2200 Flash
0 0 70 /PRndPad SetFlash
-6150 2600 Flash
0 0 60 /PSqrPad SetFlash
-6877 1721 Flash
0 0 60 /PRndPad SetFlash
-6947 1751 Flash
-7017 1721 Flash
-7047 1651 Flash
-7017 1581 Flash
-6947 1551 Flash
-6877 1581 Flash
-6847 1651 Flash
0 0 70 /PSqrPad SetFlash
-7250 950 Flash
0 0 70 /PRndPad SetFlash
-7150 950 Flash
-7050 950 Flash
-6950 950 Flash
-6850 950 Flash
-6750 950 Flash
-6650 950 Flash
-6550 950 Flash
-6550 1250 Flash
-6650 1250 Flash
-6750 1250 Flash
-6850 1250 Flash
-6950 1250 Flash
-7050 1250 Flash
-7150 1250 Flash
-7250 1250 Flash
0 0 60 /PSqrPad SetFlash
-6880 570 Flash
0 0 60 /PRndPad SetFlash
-6950 600 Flash
-7020 570 Flash
-7050 500 Flash
-7020 430 Flash
-6950 400 Flash
-6880 430 Flash
-6850 500 Flash
0 0 70 /PRndPad SetFlash
-6400 2800 Flash
-6200 2800 Flash
-6300 2800 Flash
0 0 187 /PRndPad SetFlash
-6300 3550 Flash
0 0 60 /PSqrPad SetFlash
-6166 571 Flash
0 0 60 /PRndPad SetFlash
-6196 501 Flash
-6166 431 Flash
-6096 401 Flash
-6026 431 Flash
-5996 501 Flash
-6026 571 Flash
-6096 601 Flash
0 0 70 /PSqrPad SetFlash
-5650 950 Flash
0 0 70 /PRndPad SetFlash
-5550 950 Flash
-5450 950 Flash
-5350 950 Flash
-5250 950 Flash
-5150 950 Flash
-5050 950 Flash
-4950 950 Flash
-4950 1250 Flash
-5050 1250 Flash
-5150 1250 Flash
-5250 1250 Flash
-5350 1250 Flash
-5450 1250 Flash
-5550 1250 Flash
-5650 1250 Flash
0 0 70 /PSqrPad SetFlash
-5650 2600 Flash
0 0 70 /PRndPad SetFlash
-5550 2600 Flash
-5450 2600 Flash
-5350 2600 Flash
-5250 2600 Flash
-5150 2600 Flash
-5050 2600 Flash
-5050 2900 Flash
-5150 2900 Flash
-5250 2900 Flash
-5350 2900 Flash
-5450 2900 Flash
-5550 2900 Flash
-5650 2900 Flash
0 0 70 /PSqrPad SetFlash
-5650 1550 Flash
0 0 70 /PRndPad SetFlash
-5550 1550 Flash
-5450 1550 Flash
-5350 1550 Flash
-5250 1550 Flash
-5150 1550 Flash
-5050 1550 Flash
-4950 1550 Flash
-4950 1850 Flash
-5050 1850 Flash
-5150 1850 Flash
-5250 1850 Flash
-5350 1850 Flash
-5450 1850 Flash
-5550 1850 Flash
-5650 1850 Flash
0 0 70 /PSqrPad SetFlash
-4350 3100 Flash
0 0 70 /PRndPad SetFlash
-4250 3100 Flash
-4150 3100 Flash
-4050 3100 Flash
-3950 3100 Flash
-3850 3100 Flash
-3750 3100 Flash
-3650 3100 Flash
-3550 3100 Flash
-3450 3100 Flash
-3350 3100 Flash
-3250 3100 Flash
-3150 3100 Flash
-3050 3100 Flash
-2950 3100 Flash
-2850 3100 Flash
-2750 3100 Flash
-2650 3100 Flash
-2550 3100 Flash
-2450 3100 Flash
-2450 3700 Flash
-2550 3700 Flash
-2650 3700 Flash
-2750 3700 Flash
-2850 3700 Flash
-2950 3700 Flash
-3050 3700 Flash
-3150 3700 Flash
-3250 3700 Flash
-3350 3700 Flash
-3450 3700 Flash
-3550 3700 Flash
-3650 3700 Flash
-3750 3700 Flash
-3850 3700 Flash
-3950 3700 Flash
-4050 3700 Flash
-4150 3700 Flash
-4250 3700 Flash
-4350 3700 Flash
0 0 70 /PSqrPad SetFlash
-2950 1800 Flash
0 0 70 /PRndPad SetFlash
-2850 1800 Flash
-2750 1800 Flash
-2650 1800 Flash
-2550 1800 Flash
-2450 1800 Flash
-2350 1800 Flash
-2250 1800 Flash
-2250 2100 Flash
-2350 2100 Flash
-2450 2100 Flash
-2550 2100 Flash
-2650 2100 Flash
-2750 2100 Flash
-2850 2100 Flash
-2950 2100 Flash
0 0 70 /PSqrPad SetFlash
-4350 1800 Flash
0 0 70 /PRndPad SetFlash
-4250 1800 Flash
-4150 1800 Flash
-4050 1800 Flash
-3950 1800 Flash
-3850 1800 Flash
-3750 1800 Flash
-3650 1800 Flash
-3550 1800 Flash
-3450 1800 Flash
-3450 2100 Flash
-3550 2100 Flash
-3650 2100 Flash
-3750 2100 Flash
-3850 2100 Flash
-3950 2100 Flash
-4050 2100 Flash
-4150 2100 Flash
-4250 2100 Flash
-4350 2100 Flash
0 0 70 /PSqrPad SetFlash
-4350 2500 Flash
0 0 70 /PRndPad SetFlash
-4250 2500 Flash
-4150 2500 Flash
-4050 2500 Flash
-3950 2500 Flash
-3850 2500 Flash
-3750 2500 Flash
-3650 2500 Flash
-3550 2500 Flash
-3450 2500 Flash
-3350 2500 Flash
-3250 2500 Flash
-3250 2800 Flash
-3350 2800 Flash
-3450 2800 Flash
-3550 2800 Flash
-3650 2800 Flash
-3750 2800 Flash
-3850 2800 Flash
-3950 2800 Flash
-4050 2800 Flash
-4150 2800 Flash
-4250 2800 Flash
-4350 2800 Flash
0 0 70 /PSqrPad SetFlash
-1950 1100 Flash
0 0 70 /PRndPad SetFlash
-1850 1100 Flash
-1750 1100 Flash
-1650 1100 Flash
-1550 1100 Flash
-1450 1100 Flash
-1350 1100 Flash
-1250 1100 Flash
-1150 1100 Flash
-1050 1100 Flash
-950 1100 Flash
-850 1100 Flash
-750 1100 Flash
-650 1100 Flash
-650 1500 Flash
-750 1500 Flash
-850 1500 Flash
-950 1500 Flash
-1050 1500 Flash
-1150 1500 Flash
-1250 1500 Flash
-1350 1500 Flash
-1450 1500 Flash
-1550 1500 Flash
-1650 1500 Flash
-1750 1500 Flash
-1850 1500 Flash
-1950 1500 Flash
0 0 70 /PSqrPad SetFlash
-1950 500 Flash
0 0 70 /PRndPad SetFlash
-1850 500 Flash
-1750 500 Flash
-1650 500 Flash
-1550 500 Flash
-1450 500 Flash
-1350 500 Flash
-1250 500 Flash
-1150 500 Flash
-1050 500 Flash
-1050 800 Flash
-1150 800 Flash
-1250 800 Flash
-1350 800 Flash
-1450 800 Flash
-1550 800 Flash
-1650 800 Flash
-1750 800 Flash
-1850 800 Flash
-1950 800 Flash
0 0 70 /PSqrPad SetFlash
-1950 2500 Flash
0 0 70 /PRndPad SetFlash
-1850 2500 Flash
-1750 2500 Flash
-1650 2500 Flash
-1550 2500 Flash
-1450 2500 Flash
-1350 2500 Flash
-1250 2500 Flash
-1150 2500 Flash
-1050 2500 Flash
-950 2500 Flash
-850 2500 Flash
-750 2500 Flash
-650 2500 Flash
-650 3100 Flash
-750 3100 Flash
-850 3100 Flash
-950 3100 Flash
-1050 3100 Flash
-1150 3100 Flash
-1250 3100 Flash
-1350 3100 Flash
-1450 3100 Flash
-1550 3100 Flash
-1650 3100 Flash
-1750 3100 Flash
-1850 3100 Flash
-1950 3100 Flash
0 0 70 /PSqrPad SetFlash
-1950 1700 Flash
0 0 70 /PRndPad SetFlash
-1850 1700 Flash
-1750 1700 Flash
-1650 1700 Flash
-1550 1700 Flash
-1450 1700 Flash
-1350 1700 Flash
-1250 1700 Flash
-1150 1700 Flash
-1050 1700 Flash
-950 1700 Flash
-850 1700 Flash
-750 1700 Flash
-650 1700 Flash
-650 2300 Flash
-750 2300 Flash
-850 2300 Flash
-950 2300 Flash
-1050 2300 Flash
-1150 2300 Flash
-1250 2300 Flash
-1350 2300 Flash
-1450 2300 Flash
-1550 2300 Flash
-1650 2300 Flash
-1750 2300 Flash
-1850 2300 Flash
-1950 2300 Flash
0 0 70 /PSqrPad SetFlash
-2850 2500 Flash
0 0 70 /PRndPad SetFlash
-2750 2500 Flash
-2650 2500 Flash
-2550 2500 Flash
-2450 2500 Flash
-2350 2500 Flash
-2250 2500 Flash
-2250 2800 Flash
-2350 2800 Flash
-2450 2800 Flash
-2550 2800 Flash
-2650 2800 Flash
-2750 2800 Flash
-2850 2800 Flash
0 0 70 /PSqrPad SetFlash
-4350 500 Flash
0 0 70 /PRndPad SetFlash
-4250 500 Flash
-4150 500 Flash
-4050 500 Flash
-3950 500 Flash
-3850 500 Flash
-3750 500 Flash
-3650 500 Flash
-3550 500 Flash
-3450 500 Flash
-3350 500 Flash
-3250 500 Flash
-3250 800 Flash
-3350 800 Flash
-3450 800 Flash
-3550 800 Flash
-3650 800 Flash
-3750 800 Flash
-3850 800 Flash
-3950 800 Flash
-4050 800 Flash
-4150 800 Flash
-4250 800 Flash
-4350 800 Flash
0 0 70 /PSqrPad SetFlash
-3350 1100 Flash
0 0 70 /PRndPad SetFlash
-3250 1100 Flash
-3150 1100 Flash
-3050 1100 Flash
-2950 1100 Flash
-2850 1100 Flash
-2750 1100 Flash
-2650 1100 Flash
-2550 1100 Flash
-2450 1100 Flash
-2350 1100 Flash
-2250 1100 Flash
-2250 1400 Flash
-2350 1400 Flash
-2450 1400 Flash
-2550 1400 Flash
-2650 1400 Flash
-2750 1400 Flash
-2850 1400 Flash
-2950 1400 Flash
-3050 1400 Flash
-3150 1400 Flash
-3250 1400 Flash
-3350 1400 Flash
0 0 70 /PSqrPad SetFlash
-2150 3400 Flash
0 0 70 /PRndPad SetFlash
-2050 3400 Flash
-1950 3400 Flash
-1850 3400 Flash
-1750 3400 Flash
-1650 3400 Flash
-1550 3400 Flash
-1550 3700 Flash
-1650 3700 Flash
-1750 3700 Flash
-1850 3700 Flash
-1950 3700 Flash
-2050 3700 Flash
-2150 3700 Flash
0 0 70 /PSqrPad SetFlash
-4350 1100 Flash
0 0 70 /PRndPad SetFlash
-4250 1100 Flash
-4150 1100 Flash
-4050 1100 Flash
-3950 1100 Flash
-3850 1100 Flash
-3750 1100 Flash
-3750 1400 Flash
-3850 1400 Flash
-3950 1400 Flash
-4050 1400 Flash
-4150 1400 Flash
-4250 1400 Flash
-4350 1400 Flash
0 0 70 /PSqrPad SetFlash
-1250 3400 Flash
0 0 70 /PRndPad SetFlash
-1150 3400 Flash
-1050 3400 Flash
-950 3400 Flash
-850 3400 Flash
-750 3400 Flash
-650 3400 Flash
-650 3700 Flash
-750 3700 Flash
-850 3700 Flash
-950 3700 Flash
-1050 3700 Flash
-1150 3700 Flash
-1250 3700 Flash
-7250 3600 Flash
-7150 3600 Flash
0 0 80 /PRndPad SetFlash
-271 2698 Flash
-271 2590 Flash
-271 2482 Flash
-271 2374 Flash
-271 2266 Flash
-271 2158 Flash
-271 2050 Flash
-271 1942 Flash
-271 1834 Flash
-271 1726 Flash
-271 1618 Flash
-271 1510 Flash
-271 1402 Flash
-157 2644 Flash
-157 2536 Flash
-157 2428 Flash
-157 2320 Flash
-157 2212 Flash
-157 2104 Flash
-157 1996 Flash
-157 1888 Flash
-157 1780 Flash
-157 1672 Flash
-157 1564 Flash
-157 1456 Flash
0 0 187 /PRndPad SetFlash
-214 1110 Flash
-214 2990 Flash
900 410 80 /POvalPad SetFlash
-900 -100 Flash
-1000 -100 Flash
-1100 -100 Flash
-1200 -100 Flash
-1300 -100 Flash
-1400 -100 Flash
-1500 -100 Flash
-1600 -100 Flash
-1700 -100 Flash
-1800 -100 Flash
-1900 -100 Flash
-2000 -100 Flash
-2100 -100 Flash
-2200 -100 Flash
-2300 -100 Flash
-2400 -100 Flash
-2500 -100 Flash
-2600 -100 Flash
-2700 -100 Flash
-2800 -100 Flash
-2900 -100 Flash
-3000 -100 Flash
-3100 -100 Flash
-3200 -100 Flash
-3300 -100 Flash
-3400 -100 Flash
-3500 -100 Flash
-3600 -100 Flash
-3700 -100 Flash
-3800 -100 Flash
-3900 -100 Flash
0 0 70 /PSqrPad SetFlash
-7000 3625 Flash
0 0 70 /PRndPad SetFlash
-7000 3325 Flash
-7000 3475 Flash
-6700 3625 Flash
-6700 3325 Flash
0 0 100 /PRndPad SetFlash
-6850 3675 Flash
-6850 3275 Flash
0 0 70 /PSqrPad SetFlash
-7100 2400 Flash
0 0 70 /PRndPad SetFlash
-7100 2700 Flash
-7100 2550 Flash
-7400 2400 Flash
-7400 2700 Flash
0 0 100 /PRndPad SetFlash
-7250 2350 Flash
-7250 2750 Flash
0 0 70 /PSqrPad SetFlash
-7525 2400 Flash
0 0 70 /PRndPad SetFlash
-7525 2700 Flash
-7525 2550 Flash
-7825 2400 Flash
-7825 2700 Flash
0 0 100 /PRndPad SetFlash
-7675 2350 Flash
-7675 2750 Flash
0 0 70 /PSqrPad SetFlash
-6975 2700 Flash
0 0 70 /PRndPad SetFlash
-6975 2400 Flash
-6975 2550 Flash
-6675 2700 Flash
-6675 2400 Flash
0 0 100 /PRndPad SetFlash
-6825 2750 Flash
-6825 2350 Flash
0 0 70 /PSqrPad SetFlash
-7450 1500 Flash
0 0 70 /PRndPad SetFlash
-7450 1800 Flash
-7450 1650 Flash
-7750 1500 Flash
-7750 1800 Flash
0 0 100 /PRndPad SetFlash
-7600 1450 Flash
-7600 1850 Flash
0 0 70 /PSqrPad SetFlash
-7450 350 Flash
0 0 70 /PRndPad SetFlash
-7450 650 Flash
-7450 500 Flash
-7750 350 Flash
-7750 650 Flash
0 0 100 /PRndPad SetFlash
-7600 300 Flash
-7600 700 Flash
0 0 70 /PRndPad SetFlash
-7500 3600 Flash
-7600 3500 Flash
-7700 3600 Flash
-7200 3000 Flash
-6800 3000 Flash
-7200 2850 Flash
-6800 2850 Flash
-7200 2100 Flash
-6800 2100 Flash
-6300 1650 Flash
-6300 2050 Flash
-6450 1650 Flash
-6450 2050 Flash
-6000 1100 Flash
-6000 1500 Flash
-6150 1650 Flash
-6150 2050 Flash
-4950 3300 Flash
-4950 3700 Flash
-6300 1500 Flash
-6300 1100 Flash
-4750 2000 Flash
-5150 2000 Flash
-5150 2300 Flash
-4750 2300 Flash
-5850 3050 Flash
-5850 2650 Flash
-5750 350 Flash
-5750 750 Flash
-5450 825 Flash
-5050 825 Flash
-6000 2050 Flash
-6000 1650 Flash
-5850 1650 Flash
-5850 2050 Flash
-5750 1450 Flash
-5350 1450 Flash
-4850 1450 Flash
-5250 1450 Flash
-5850 1100 Flash
-5850 1500 Flash
-5300 2000 Flash
-5700 2000 Flash
-5300 2150 Flash
-5700 2150 Flash
-5300 2300 Flash
-5700 2300 Flash
-4650 3300 Flash
-4650 3700 Flash
-350 900 Flash
-350 500 Flash
-200 500 Flash
-200 900 Flash
-350 3400 Flash
-350 3800 Flash
0 0 70 /PSqrPad SetFlash
-2950 500 Flash
0 0 70 /PRndPad SetFlash
-2850 500 Flash
-2750 500 Flash
-2650 500 Flash
-2550 500 Flash
-2450 500 Flash
-2350 500 Flash
-2250 500 Flash
-2250 800 Flash
-2350 800 Flash
-2450 800 Flash
-2550 800 Flash
-2650 800 Flash
-2750 800 Flash
-2850 800 Flash
-2950 800 Flash
0 0 70 /PSqrPad SetFlash
-5100 350 Flash
0 0 70 /PRndPad SetFlash
-5100 650 Flash
-5100 500 Flash
-5400 350 Flash
-5400 650 Flash
0 0 100 /PRndPad SetFlash
-5250 300 Flash
-5250 700 Flash
0 0 70 /PSqrPad SetFlash
-5800 3300 Flash
0 0 70 /PRndPad SetFlash
-5200 3300 Flash
-5200 3600 Flash
-5800 3600 Flash
-6000 3225 Flash
-6000 3525 Flash
0 0 187 /PRndPad SetFlash
-7875 3700 Flash
-6650 3150 Flash
-6650 1450 Flash
-7875 1450 Flash
10 SetText2
0 -4100 4350 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -4048 4350 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -3992 4350 [ [ 0 65 0 0 27 0 ] ] Char
0 -3945 4350 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -3893 4350 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -3843 4350 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -3739 4350 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -3683 4350 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -3627 4350 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -3575 4350 [ [ 0 65 0 0 ] [ 31 65 0 21 ] [ 11 37 31 0 ] ] Char
0 0 65 /PRndPad SetFlash
-4625 3100 Flash
-4625 2800 Flash
-4625 3500 Flash
-4625 2100 Flash
-4625 1550 Flash
-4450 1550 Flash
-4350 1550 Flash
-4625 800 Flash
-3450 1550 Flash
-3350 1550 Flash
-4625 250 Flash
-4450 250 Flash
-3350 2100 Flash
-3050 2800 Flash
-2850 2925 Flash
-2325 2925 Flash
-450 2590 Flash
-450 900 Flash
-750 900 Flash
-450 300 Flash
-1025 300 Flash
-950 900 Flash
-1950 900 Flash
0 0 65 /PRndPad SetFlash
-1500 200 Flash
-1600 550 Flash
-1000 1250 Flash
0 0 65 /PRndPad SetFlash
-4750 1800 Flash
-5200 1800 Flash
0 0 65 /PRndPad SetFlash
-5150 2675 Flash
0 0 65 /PRndPad SetFlash
-4975 2150 Flash
0 0 65 /PRndPad SetFlash
-5450 3050 Flash
0 0 65 /PRndPad SetFlash
-5700 1050 Flash
0 0 65 /PRndPad SetFlash
-5900 1025 Flash
0 0 65 /PRndPad SetFlash
-4850 1250 Flash
0 0 65 /PRndPad SetFlash
-5400 1600 Flash
0 0 65 /PRndPad SetFlash
-6450 1000 Flash
0 0 65 /PRndPad SetFlash
-6400 1250 Flash
0 0 65 /PRndPad SetFlash
-6500 1100 Flash
-6500 1700 Flash
0 0 65 /PRndPad SetFlash
-4950 2900 Flash
0 0 65 /PRndPad SetFlash
-275 500 Flash
-275 825 Flash
-850 825 Flash
0 0 65 /PRndPad SetFlash
-825 750 Flash
-800 2400 Flash
0 0 65 /PRndPad SetFlash
-1850 3525 Flash
0 0 65 /PRndPad SetFlash
-2075 2825 Flash
0 0 65 /PRndPad SetFlash
-2000 425 Flash
-2000 3350 Flash
0 0 65 /PRndPad SetFlash
-100 3675 Flash
0 0 65 /PRndPad SetFlash
-4900 75 Flash
-4900 3575 Flash
0 0 65 /PRndPad SetFlash
-4700 575 Flash
-4700 3050 Flash
-2300 650 Flash
-3650 3400 Flash
0 0 65 /PRndPad SetFlash
-3050 925 Flash
0 0 65 /PRndPad SetFlash
-2200 225 Flash
-2225 1025 Flash
0 0 65 /PRndPad SetFlash
-1150 2175 Flash
-950 2175 Flash
-950 2425 Flash
0 0 65 /PRndPad SetFlash
-5350 2800 Flash
-1650 2700 Flash
-1550 1600 Flash
-2075 1600 Flash
-2075 2700 Flash
-6075 1775 Flash
-5775 1325 Flash
-750 1600 Flash
-750 1250 Flash
-350 700 Flash
-200 1250 Flash
0 0 65 /PRndPad SetFlash
-1400 750 Flash
0 0 65 /PRndPad SetFlash
-1600 3000 Flash
-3250 3275 Flash
-700 2350 Flash
-700 1650 Flash
-2850 1575 Flash
-2925 1275 Flash
-4100 1275 Flash
0 0 65 /PRndPad SetFlash
-1750 2925 Flash
-950 2900 Flash
-1600 1850 Flash
-1600 1200 Flash
0 0 65 /PRndPad SetFlash
-1850 2975 Flash
-1050 2950 Flash
-1925 1875 Flash
-1000 2100 Flash
-1400 2075 Flash
0 0 65 /PRndPad SetFlash
-1950 3000 Flash
-1950 2800 Flash
-1150 2800 Flash
-2400 2225 Flash
-1800 2250 Flash
-1800 1000 Flash
-1450 1025 Flash
0 0 65 /PRndPad SetFlash
-3000 3150 Flash
-3000 2025 Flash
-1250 2025 Flash
-1000 2025 Flash
-1350 975 Flash
-875 975 Flash
0 0 65 /PRndPad SetFlash
-3400 3200 Flash
-3350 2175 Flash
-1350 2125 Flash
-1100 2125 Flash
0 0 65 /PRndPad SetFlash
-2500 3150 Flash
-2550 1975 Flash
-1500 1450 Flash
0 0 65 /PRndPad SetFlash
-1900 3050 Flash
-2900 3225 Flash
-2750 2200 Flash
-1500 1850 Flash
-1300 1850 Flash
-1300 750 Flash
0 0 65 /PRndPad SetFlash
-4300 2625 Flash
-2300 2450 Flash
0 0 65 /PRndPad SetFlash
-6350 1925 Flash
-6350 1050 Flash
-2650 1925 Flash
-2900 1925 Flash
0 0 65 /PRndPad SetFlash
-2925 2600 Flash
0 0 65 /PRndPad SetFlash
-900 1300 Flash
-2850 1275 Flash
0 0 65 /PRndPad SetFlash
-3550 1050 Flash
0 0 65 /PRndPad SetFlash
-3900 2550 Flash
-3125 2525 Flash
-3100 1350 Flash
-4475 1625 Flash
-4475 2725 Flash
0 0 65 /PRndPad SetFlash
-4100 3300 Flash
-3750 3300 Flash
0 0 65 /PRndPad SetFlash
-3400 1350 Flash
-3450 2250 Flash
-2850 2225 Flash
0 0 65 /PRndPad SetFlash
-1100 2850 Flash
-650 2850 Flash
-625 1375 Flash
-1350 1375 Flash
0 0 65 /PRndPad SetFlash
-5750 2875 Flash
-5750 1550 Flash
0 0 65 /PRndPad SetFlash
-3850 3000 Flash
-5600 3000 Flash
0 0 65 /PRndPad SetFlash
-3500 1300 Flash
0 0 65 /PRndPad SetFlash
-4550 1100 Flash
-4550 500 Flash
-4550 1800 Flash
-4550 950 Flash
-4250 950 Flash
-4550 2500 Flash
-3750 950 Flash
-4550 2900 Flash
-4250 2900 Flash
-4550 3400 Flash
-3450 950 Flash
-3650 950 Flash
-3650 1650 Flash
-3450 1650 Flash
-3350 950 Flash
-3250 1650 Flash
-3350 600 Flash
-3250 600 Flash
-3250 1800 Flash
-3250 2300 Flash
-2950 2300 Flash
-2150 2300 Flash
-2150 2500 Flash
-2150 1800 Flash
-2250 3250 Flash
-2150 3250 Flash
-2150 1100 Flash
-2250 3525 Flash
-2450 3525 Flash
-2050 3525 Flash
-2150 1475 Flash
-2350 1475 Flash
-2150 500 Flash
-2150 600 Flash
-1850 600 Flash
-2150 300 Flash
-1875 300 Flash
-1550 3250 Flash
-1350 3250 Flash
-750 3250 Flash
-525 3250 Flash
-525 2200 Flash
-750 2200 Flash
-525 2698 Flash
-625 500 Flash
0 0 65 /PRndPad SetFlash
-3000 1675 Flash
-4350 1700 Flash
-4400 1175 Flash
0 0 65 /PRndPad SetFlash
-3300 1225 Flash
-3300 2875 Flash
0 0 65 /PRndPad SetFlash
-3800 3475 Flash
0 0 65 /PRndPad SetFlash
-3200 3425 Flash
0 0 65 /PRndPad SetFlash
-2400 1000 Flash
0 0 65 /PRndPad SetFlash
-2075 1125 Flash
0 0 65 /PRndPad SetFlash
-1200 200 Flash
-2950 575 Flash
0 0 65 /PRndPad SetFlash
-2550 2400 Flash
-1800 2775 Flash
0 0 65 /PRndPad SetFlash
-650 2000 Flash
0 0 65 /PRndPad SetFlash
-850 3550 Flash
-575 3550 Flash
-600 1050 Flash
0 0 65 /PRndPad SetFlash
-3700 2850 Flash
-950 3575 Flash
-2800 3575 Flash
0 0 65 /PRndPad SetFlash
-375 3200 Flash
0 0 65 /PRndPad SetFlash
-5500 3150 Flash
-2700 3375 Flash
-2625 2225 Flash
-2225 2200 Flash
-2225 1200 Flash
0 0 65 /PRndPad SetFlash
-2450 2375 Flash
-5600 2225 Flash
0 0 65 /PRndPad SetFlash
-4800 750 Flash
-4900 2225 Flash
-3500 2300 Flash
0 0 65 /PRndPad SetFlash
-4050 1875 Flash
0 0 65 /PRndPad SetFlash
-3650 2175 Flash
-3550 1975 Flash
0 0 65 /PRndPad SetFlash
-3900 1050 Flash
0 0 65 /PRndPad SetFlash
-4050 2950 Flash
-4725 2950 Flash
-4725 1375 Flash
-5200 1350 Flash
-5200 1150 Flash
-7250 1150 Flash
-2350 1700 Flash
-2400 1225 Flash
0 0 65 /PRndPad SetFlash
-4400 2575 Flash
-2850 2425 Flash
0 0 65 /PRndPad SetFlash
-2900 850 Flash
0 0 65 /PRndPad SetFlash
-2600 1450 Flash
0 0 65 /PRndPad SetFlash
-7325 2800 Flash
-7325 2175 Flash
0 0 65 /PRndPad SetFlash
-2700 2850 Flash
-2700 750 Flash
-3100 400 Flash
0 0 65 /PRndPad SetFlash
-950 825 Flash
-2800 850 Flash
0 0 65 /PRndPad SetFlash
-5100 2375 Flash
-1750 1325 Flash
-1700 2200 Flash
0 0 65 /PRndPad SetFlash
-5000 1000 Flash
-1900 1000 Flash
-750 2125 Flash
-750 1900 Flash
-1850 1900 Flash
0 0 65 /PRndPad SetFlash
-4800 2950 Flash
-4850 2300 Flash
-4750 1500 Flash
-1975 1950 Flash
0 0 65 /PRndPad SetFlash
-50 3625 Flash
-125 1375 Flash
0 0 65 /PRndPad SetFlash
-2800 950 Flash
0 0 65 /PRndPad SetFlash
-3600 2950 Flash
0 0 65 /PRndPad SetFlash
-5350 2725 Flash
-6200 1500 Flash
-6050 900 Flash
-6000 1200 Flash
-5400 1200 Flash
0 0 65 /PRndPad SetFlash
-2425 3425 Flash
-2225 2575 Flash
-1200 1850 Flash
0 0 65 /PRndPad SetFlash
-2250 900 Flash
0 0 65 /PRndPad SetFlash
-3150 1475 Flash
-3150 2900 Flash
-2650 600 Flash
0 0 65 /PRndPad SetFlash
-3125 2625 Flash
0 0 65 /PRndPad SetFlash
-1050 400 Flash
-1925 700 Flash
-1200 1350 Flash
-5300 775 Flash
-5300 1725 Flash
-6250 1750 Flash
0 0 65 /PRndPad SetFlash
-125 1275 Flash
-50 1672 Flash
grestore
showpage
