void diftim(buf)
char buf[280];
{
#include <stdio.h>
#include <dos.h>
char c;
int j,yr,mo,day,hr,min,sec,dst;   /* holds parsed NBS time */
int yribm,moibm,dayibm,hribm,minibm,secibm,hunibm; /* holds computer time */
int yrat,moat,dayat,hrat,minat,secat;/* holds CMOS time for AT*/
int iterr = 0;
float diff;
extern int utcdif;           /* local time - utc in hours */
extern int dsflag;           /* daylight saving time? 1=yes, 0=no */
extern int atflag;           /* AT-type machine? 1=yes, 0=no */
int lday[13] = {0,31,28,31,30,31,30,31,31,30,31,30,31}; /*last day of month*/
int tday[13] = {0,0,31,59,90,120,151,181,212,243,273,304,334};
char *ptrslw,*ptrfas;
int unpbcd();
int done = 0;                /* flag to show when comparison is complete */
int dsdone=0;                /* flag to show conversion for daylight sav.*/
	ptrslw="\n Computer clock slow by %.2f %s";
	ptrfas="\n Computer clock fast by %.2f %s";
/*
	this subroutine receives a time string in character
	array buf.  it is parsed and compared with the system
	clock.  the origin of the parser is the - character between
	the year and the month so that leading stuff will simply be
	ignored.

	this subroutine uses global variables dsflag to check for
	daylight savings time and utcdif to convert from UTC to local
	time

	begin by getting computer time now.
*/
	_AH=0x2c;
	geninterrupt(0x21);
	hribm=_CH;
	minibm=_CL;
	secibm=_DH;
	hunibm=_DL;
	_AH=0x2a;
	geninterrupt(0x21);
	yribm=_CX;
	moibm=_DH;
	dayibm=_DL;
	yribm -= 1900;
/*
	if this is an at-type machine, read CMOS clock too
*/
	if(atflag != 0)
	{
	_AH=2;
	geninterrupt(0x1a);
	hrat=_CH;
	minat=_CL;
	secat=_DH;
	_AH=4;
	geninterrupt(0x1a);
	yrat=_CL;
	moat=_DH;
	dayat=_DL;
	}
/*
	now parse line from NBS transmission
*/
	for(j=0; (buf[j] != 0) && (buf[j] != '-') ; j++) ;
	sscanf(&buf[j-2],"%2d-%2d-%2d %2d:%2d:%2d %d",&yr,&mo,&day,
	&hr,&min,&sec,&dst);
/*
	make standard-time portion of dst flag contiguous
*/
	if(dst == 0) dst = 100;
/*
	convert from utc to local time. note that minute and second
	are already correct.
	daylight savings time flag must also be updated
	if conversion to local time changes the day
*/
	if( (yr & 3) == 0 ) lday[2]=29;  /* 29 days for Feb in leap year */
	hr += utcdif;                    /* convert hour to local time */
/*
	also do first part of conversion to daylight savings time
	see parset and arcdif where same problem is dealt with
*/
	if( (dsflag != 0) && (dst <= 50) && (dst > 1) )
	{
	hr++;
	dsdone=1;
	}
	if(hr < 0)
	{
	hr += 24;
	day--;
	dst++;         /* update daylight savings flag for change of day */
	if(day < 1)
	   {
	   mo--;
	   if(mo < 1)
	      {
	      mo=12;
	      yr--;
	      }
	   day=lday[mo];
	   }
	}
	if(hr > 23)
	{
	hr -= 24;
	day++;
	dst--;        /* update daylight saving flag for change of day */
	if(day > lday[mo])
	   {
	   day=1;
	   mo++;
	   if(mo > 12)
	      {
	      mo=1;
	      yr++;
	      }
	   }
	}
/*
	now finish up daylight savings time if enabled
*/
	if( (dsflag != 0) && (dsdone == 0) )
	{
	   if( (dst == 51) && (hr >= 2) ) hr++;
	   if( (dst ==  1) && (hr <  2) ) hr++;
	}
/*
	ready to begin comparing the clocks
	first print out both times
*/
	printf("\n Computer time= %2d-%2.2d-%2.2d %2.2d:%2.2d:%2.2d.%2.2d",
	      yribm,moibm,dayibm,hribm,minibm,secibm,hunibm);
	printf("\n NBS time     = %2d-%2.2d-%2.2d %2.2d:%2.2d:%2.2d.00",
	      yr,mo,day,hr,min,sec);
	diff=365*(yribm - yr) + tday[moibm] - tday[mo] + dayibm - day;
	if( ( (yribm & 3) == 0)  && (moibm > 2) ) diff++;
	if( ( (yr    & 3) == 0)  && (mo    > 2) ) diff--;
	if(diff > 1)
	{
	printf(ptrfas,diff,"days.");
	done=1;
	}
	if(diff < -1)
	{
	printf(ptrslw,-diff,"days.");
	done=1;
	}
	if(done == 0)
	{
	   diff= 24*diff + hribm - hr;
	   if(diff > 2)
	   {
	      printf(ptrfas,diff,"hours.");
	      done=1;
	   }
	   if(diff < -2)
	   {
	      printf(ptrslw,-diff,"hours.");
	      done=1;
	   }
	}
	if(done == 0)
	{
	   diff=60*diff + minibm - min;
	   if(diff > 10)
	   {
	   printf(ptrfas,diff,"minutes.");
	   done=1;
	   }
	   if(diff < -10)
	   {
	   printf(ptrslw,-diff,"minutes.");
	   done=1;
	   }
	}
	if(done == 0)
	{
	   diff=60*diff + secibm - sec +  0.01*(float)hunibm;
	   if(diff > 0)
	      {
	      printf(ptrfas,diff,"seconds.");
	      iterr=18.2*diff;
	      }
	   if(diff < 0)
	      {
	      printf(ptrslw,-diff,"seconds.");
	      iterr=-18.2*diff;
	      }
	   if(iterr == 0)
	      printf("\n Clocks agree to within 1 computer clock tick.");
	   else
	      printf("\n Difference is %d computer clock tick(s).",iterr);
	}
	if(atflag == 0)return;
	printf("\n\nCompare time of CMOS (Battery-run) Clock with NBS.\n");
/*
	begin comparison of CMOS time -- first convert from packed
	BCD to normal binary, then compare as above.
*/
	yrat=unpbcd(yrat);
	moat=unpbcd(moat);
	dayat=unpbcd(dayat);
	hrat=unpbcd(hrat);
	minat=unpbcd(minat);
	secat=unpbcd(secat);
	printf("\nCMOS time= %2.2d-%2.2d-%2.2d %2.2d:%2.2d:%2.2d",
	yrat,moat,dayat,hrat,minat,secat);
	printf("\nNBS  time= %2.2d-%2.2d-%2.2d %2.2d:%2.2d:%2.2d",
	yr,mo,day,hr,min,sec);
	diff=365*(yrat - yr) + tday[moat] - tday[mo] + dayat - day;
	if( ( (yrat & 3) == 0) && (moat > 2) )  diff++;
	if( ( (yr   & 3) == 0) && (mo   > 2) )  diff--;
	done=0;
	if(diff > 1)
	{
	   printf(ptrfas,diff,"days.");
	   done=1;
	}
	if(diff < -1)
	{
	   printf(ptrslw,-diff,"days.");
	   done=1;
	}
	if(done == 0)
	{
	diff=24*diff + hrat - hr;
	if(diff > 2)
	   {
	   printf(ptrfas,diff,"hours.");
	   done=1;
	   }
	if(diff < -2)
	   {
	   printf(ptrslw,-diff,"hours.");
	   done=1;
	   }
	}
	if(done == 0)
	{
	diff=60*diff + minat - min;
	if(diff > 10)
	   {
	   printf(ptrfas,diff,"minutes.");
	   done=1;
	   }
	if(diff < -10)
	   {
	   printf(ptrslw,-diff,"minutes.");
	   done=1;
	   }
	}
	if(done == 0)
	{
	diff=60*diff +secat - sec;
	if(diff > 0)  printf(ptrfas,diff,"seconds.");
	if(diff < 0)  printf(ptrslw,-diff,"seconds.");
	if(diff == 0) printf("\n Time agrees to within 1 second.");
	}
}
	
