/*
File:    rdate.h

   VMS does not keep track of information like the local time zone or
whether Daylight Savings Time is currently in effect.  That information
must be supplied here.  Specify the following defines to match your
locality.

   UCT_OFFSET - the number of hours difference from UTC (Universal
                Coordinated Time) to your local time zone (not
                including Daylight Savings Time).

   Time Zone         Offset
   Atlantic          -4
   Eastern           -5
   Central           -6
   Mountain          -7
   Pacific           -8
   Alaska            -9
   Hawii             -10
*/

#define UTC_OFFSET   -6

/*
   The following defines describe when Daylight Savings Time begins and
when it ends.  No sanity checks are done by the program to determine if
values are reasonable.  So, be careful of the values you use.  There is
also more than one way to express the same DST period.
   Daylight Savings Time for most places in the U.S. begins at 2:00 a.m.
on the first Sunday in April and ends at 2:00 a.m. on the last Sunday in
October (which is also the last Sunday before the first of November). 
If your site follows these rules, then the defines should work for you.
   If you do not observe Daylight Savings Time, be sure to set DOW to
-1 to turn off the check.  The values for the other defines will be
ignored.  Setting DOW to 0 implies CMP is 0 and vice versa.
   This specification is more powerful than needed in the U.S., but it
should be sufficient to express DST for most countries in the world.

   TIM - a four-digit, 24-hour time
   DOW - the day of the week
   CMP - the comparison to perform (on, before, after)
   MON - the month
   DOM - the day of the month

              DOW               CMP                  MON        DOM
   No day     -1
   Any day     0           on    0
   Sunday      1           <     1        January     1        1 - 31
   Monday      2           <=    2        February    2
   Tuesday     3           >     3        March       3
   Wednesday   4           >=    4        April       4
   Thursday    5                          May         5
   Friday      6                          June        6
   Saturday    7                          July        7
                                          August      8
                                          September   9
                                          October     10
                                          November    11
                                          December    12
*/

                              /* Daylight Savings Time begins at */
#define DSTON_TIM    0200     /* 2:00 a.m. */
#define DSTON_DOW    1        /* the Sunday */
#define DSTON_CMP    4        /* after or on */
#define DSTON_MON    4        /* April */
#define DSTON_DOM    1        /* 1 */

                              /* Daylight Savings Time ends at */
#define DSTOFF_TIM   0200     /* 2:00 a.m. */
#define DSTOFF_DOW   1        /* the Sunday */
#define DSTOFF_CMP   1        /* before */
#define DSTOFF_MON   11       /* November */
#define DSTOFF_DOM   1        /* 1 */
