/* 
This software is being provided to you, the LICENSEE, by the
Massachusetts Institute of Technology (M.I.T.) under the following
license.  By obtaining, using and/or copying this software, you agree
that you have read, understood, and will comply with these terms and
conditions:

Permission to use, copy, modify and distribute, including the right to
grant others the right to distribute at any tier, this software and
its documentation for any purpose and without fee or royalty is hereby
granted, provided that you agree to comply with the following
copyright notice and statements, including the disclaimer, and that
the same appear on ALL copies of the software and documentation,
including modifications that you make for internal use or for
distribution:

Copyright 1992,1993,1994 by the Massachusetts Institute of Technology.
                    All rights reserved.

THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

The name of the Massachusetts Institute of Technology or M.I.T. may
NOT be used in advertising or publicity pertaining to distribution of
the software.  Title to copyright in this software and any associated
documentation shall at all times remain with M.I.T., and USER agrees
to preserve same.
*/
/*
 * Gregory D. Troxel
 */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "median.h"

void panic(char *s);

#define MED_INC 128

median_t
*median_init()
{
  median_t *m;

  m = malloc (sizeof(median_t));
  if ( m == NULL )
    panic("median_init: cannot malloc");

  m->n = 0;
  m->lim = 0;
  m->sortedp = 1;
  m->dptr = NULL;

  return m;
}

void
median_free(median_t *m)
{
  if ( m != NULL )
    {
      if ( m->dptr != NULL )
	free(m->dptr);
      free(m);
    }
}

#ifdef __GNUC__
inline
#endif
static void
median_grow(median_t *m, int n)
{
  void *ptr;

  m->lim += MED_INC;
  if ( m->dptr == NULL )
    ptr = malloc(m->lim * sizeof(double));
  else
    ptr = realloc(m->dptr, m->lim * sizeof(double));

  if ( ptr == NULL )
    panic("median_grow: realloc returned NULL ptr");
  m->dptr = (double *) ptr;
}

/* make sure there are n points ready */
#ifdef __GNUC__
inline
#endif
static void
median_need(median_t *m, int n)
{
  if ( m->n + n > m->lim )
    median_grow(m, m->n + n - m->lim);
}

void
median_add(median_t *m, double x)
{
  double *dp;

  median_need(m, 1);
  dp = & m->dptr[m->n];
  *dp = x;
  m->sortedp = 0;
  m->n++;
}

int
median_n(median_t *m)
{
  return m->n;
}

int
dbl_gt(const void *x1, const void *x2)
{
  if (* (double *) x1 > * ( double *) x2) return 1;
  if (* (double *) x1 < * ( double *) x2) return -1;
  return 0;
}

#ifdef __GNUC__
inline
#endif
void
median_sort(median_t *m)
{
  if ( m->sortedp )
    return;

  qsort(m->dptr, m->n, sizeof(double), &dbl_gt);

  m->sortedp = 1;
}

/* return element greater than at least frac of the elements */
double
median_extract(median_t *m, double frac)
{
  int index;

  median_sort(m);

  /* m->n is total count; samples are in 0 to n-1 */
  index = (int) floor(frac * m->n);

  /* index now ranges 0 to n, and is n iff frac = 1 */
  if ( index > m->n - 1)
    index = m->n - 1;

  /* now index ranges from 0 to n-1 */
  return m->dptr[index];
}

