/* 
This software is being provided to you, the LICENSEE, by the
Massachusetts Institute of Technology (M.I.T.) under the following
license.  By obtaining, using and/or copying this software, you agree
that you have read, understood, and will comply with these terms and
conditions:

Permission to use, copy, modify and distribute, including the right to
grant others the right to distribute at any tier, this software and
its documentation for any purpose and without fee or royalty is hereby
granted, provided that you agree to comply with the following
copyright notice and statements, including the disclaimer, and that
the same appear on ALL copies of the software and documentation,
including modifications that you make for internal use or for
distribution:

Copyright 1992,1993,1994 by the Massachusetts Institute of Technology.
                    All rights reserved.

THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

The name of the Massachusetts Institute of Technology or M.I.T. may
NOT be used in advertising or publicity pertaining to distribution of
the software.  Title to copyright in this software and any associated
documentation shall at all times remain with M.I.T., and USER agrees
to preserve same.
*/
/*
 * Gregory D. Troxel
 * global data
 */

#include "pd.h"

char datafilename[1024];
char datafiledir[1024];
char datahostname[1024];

flag_t flags;

globals_t globals;

int run_n = 0;

#ifdef __GNUC__
inline static
#endif
void
free_fitseg_maybe(fitseg_t **fspp)
{
  if ( *fspp )
    {
      fitseg_free(*fspp);
      *fspp = NULL;
    }
}

void
globals_free_fitsegs()
{
  int clock;

  free_fitseg_maybe(&globals.fs_ntp);
  free_fitseg_maybe (&globals.fs_ntpoverall);

  free_fitseg_maybe(&globals.fs_integrated);


  for ( clock = 0; clock <= CLOCK_MAX(); clock++ )
    {
      free_fitseg_maybe(&globals.fs_raw[clock]);
      free_fitseg_maybe(&globals.fs_rawoverall[clock]);
    }
}
