/* 
This software is being provided to you, the LICENSEE, by the
Massachusetts Institute of Technology (M.I.T.) under the following
license.  By obtaining, using and/or copying this software, you agree
that you have read, understood, and will comply with these terms and
conditions:

Permission to use, copy, modify and distribute, including the right to
grant others the right to distribute at any tier, this software and
its documentation for any purpose and without fee or royalty is hereby
granted, provided that you agree to comply with the following
copyright notice and statements, including the disclaimer, and that
the same appear on ALL copies of the software and documentation,
including modifications that you make for internal use or for
distribution:

Copyright 1992,1993,1994 by the Massachusetts Institute of Technology.
                    All rights reserved.

THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

The name of the Massachusetts Institute of Technology or M.I.T. may
NOT be used in advertising or publicity pertaining to distribution of
the software.  Title to copyright in this software and any associated
documentation shall at all times remain with M.I.T., and USER agrees
to preserve same.
*/
/*
 * Gregory D. Troxel
 */

extern char datafilename[1024];
extern char datafiledir[1024];
extern char datahostname[1024];

/* global control paramaters */
typedef struct flag_s
{
  int debug;
  int verbose;
  int nooutput;
  int noaging;
  int simulate;
  int predict;
  int writeparam;
  int intvalid;
} flag_t;
extern flag_t flags;

/* number of "runs", ie, periods under control of one daemon */
#define RUN_MAX() (run_n - 1)	/* highest run seen */
extern int run_n;		/* highest run seen + 1 */

/* global data not associated with any clock */
typedef struct globals_s
{
  ntp_t first_time;		/* ntp time */
  ntp_t ufirst_time;		/* in unix time */
  ntp_t last_adjust;		/* from here, all relative to first_time */
  ntp_t last_time;		/* from here, all relative to first_time */
  ntp_t runbeg[NRUNS];
  ntp_t runend[NRUNS];
  ntp_t start;			/* currently IGNORED */
  ntp_t stop;			/* all points after disregarded, in theory */
  fitseg_t *fs_ntp;
  fitseg_t *fs_raw[NCLOCKS];
  fitseg_t *fs_integrated;
  fitseg_t *fs_ntpoverall;
  fitseg_t *fs_rawoverall[NCLOCKS];
} globals_t;
extern globals_t globals;

void globals_free_fitsegs();
