# NTP_CACHEVERSION(component, version)
# ------------------------------------
# compare this configure script's cache version stamp with the stamp
# saved by the prior run in config.cache.  If they differ, clear all
# cache variables to avoid using results cached with a script that
# is known to differ in a cache-invalidating manner.
#
# Note: use immediately following AC_INIT in configure.ac, as clearing
# all _cv_ variables only makes sense immediately after loading, before
# use or modification.
#
# It is assumed that parent configure.ac files which use
# AC_CONFIG_SUBDIR to invoke child configure.ac files have used 
# NTP_CACHEVERSION if any children do.  The top-level configure script
# will clear a previous cache lacking any saved cache version number,
# while children do not.  The reason is the children can rely on the
# parent having cleared any cache variables predating this mechanism.
# Therefore the child can rely on the config.cache generated by the
# parent on the first run despite not finding its version stamp
# previously saved.

AC_DEFUN_ONCE([NTP_CACHEVERSION], [
    AC_BEFORE([$0], [AM_INIT_AUTOMAKE])dnl
    AC_BEFORE([$0], [AM_CONFIG_HEADER])dnl
    AC_BEFORE([$0], [AC_PROG_CC])dnl

    # Is this the top-level configure, or a child invoked
    # by a parent via AC_CONFIG_SUBDIRS?  There is no 
    # reliable general way to say, so we use a variable 
    # NTP_CONFIGURE_PARENT set to an empty string early
    # in our top-level configure.ac and then set to the
    # simple flag value 'top' before AC_CONFIG_SUBDIRS.
    # Assuming only two levels of configure.ac files,
    # only the parent has to manage AC_CONFIG_PARENT.
    case "${NTP_CONFIGURE_PARENT-varnotset}" in
     '')
	ntp_top_configure=1
	;;
     varnotset)
	# without a clear indication from NTP_CONFIGURE_PARENT
	# heuristically assume we are a child configure if our
	# cache file path begins with ../
	case "$cache_file" in
	 ../*)
	    ntp_top_configure=0
	    AC_MSG_WARN([[ Using heuristic, guessing this configure is ]])
	    AC_MSG_WARN([[ a child of another configure script based ]])
	    AC_MSG_WARN([[ on cache file name starting with ../ ]])
	    ;;
	 *)
	    ntp_top_configure=1
	    AC_MSG_WARN([[ Using heuristic, guessing this configure is ]])
	    AC_MSG_WARN([[ _not_ a child of another configure script ]])
	    AC_MSG_WARN([[ based on cache file name not starting ]])
	    AC_MSG_WARN([[ with ../ ]])
	esac
	;;
     *)
	ntp_top_configure=0;
    esac
    
    ntp_cache_flush=1
    
    case "$ntp_cv_[$1]_cache_version" in
     [$2])
	# same version, good
	ntp_cache_flush=0
	;;
     '')
	# No cache, predates ntp_cv_$1_cache_version, or is empty.
	case "$cache_file" in
	 /dev/null)
	    ntp_cache_flush=0
	    ;;
	 *)
	    case "$ntp_top_configure" in
	     1)
		# Do not clear the cache immediately after it is created
		# empty as it is noisy.  Differentiate a newly-created 
		# config.cache from one predating the cache version 
		# mechanism by looking for the first cached variable set 
		# by Autoconf
		case "$ac_cv_path_install" in
		 '')
		    # empty config.cache file
		    ntp_cache_flush=0
		esac
		;;
	     0)
		# Parent configure just created cache from empty,
		# flushing would be counterproductive.
		ntp_cache_flush=0;
		;;
	     *)
	        AC_MSG_ERROR([[NTP_CACHEVERSION var ntp_top_configure misset]])
	    esac
	esac
	;;
     *)
	# configure cache version mismatches config.cache version
    esac
    case "$ntp_cache_flush" in
     1)
        # Do we flush all variables or exclude others' version stamps?
        
	case "$ntp_top_configure" in
	 1)
	    # Clear all *_cv_* variables including our child subdirs'
	    # ntp_cv_*_cache_version variables.  This prevents subdir
	    # configure scripts from noticing a version mismatch just
	    # after the top configure in the invocation cleared and
	    # recreated the cache.
	
	    c_varname_list=`set |
			    sed -n -e 's/=.*$//' \
				   -e '/_cv_/p'
			   `
	    ;;
	 *)
	    # This is not the top configure this particular invocation.
	    # Clear all *_cv_* variables sparing the version stamps
	    # of other configure scripts, so we don't trigger
	    # useless repeated clearings.

	    c_varname_list=`set |
			    sed -n -e 's/=.*$//' \
				   -e '/ntp_cv_.*_cache_version/d' \
				   -e '/_cv_/p'
			   `
	esac
	for c_varname in $c_varname_list
	do
	    dnl use AS_UNSET([$c_varname]) eventually
	    eval ${c_varname}=;  $as_unset $c_varname
	done
	
	dnl use AS_UNSET([c_varname_list c_varname]) eventually
	c_varname_list=;  $as_unset c_varname_list c_varname
	
	AC_MSG_NOTICE([[$cache_file saved by another version, ignored.]])
	AC_MSG_NOTICE([[configure script cache version: ]][$2])
	c_version="${ntp_cv_[$1]_cache_version:-(no version found)}"
	AC_MSG_NOTICE([[$cache_file version: $c_version]])
	$as_unset c_version
    esac

    # save configure version in config.cache for next time
    ntp_cv_[$1]_cache_version="[$2]"

    $as_unset ntp_cache_flush ntp_top_configure

])dnl
