#if defined(REFCLOCK) && (defined(PARSE) || defined(PARSEPPS))
/*
 * /src/NTP/REPOSITORY/v3/lib/parse_conf.c,v 3.8 1993/09/02 23:20:57 kardel Exp
 *  
 * parse_conf.c,v 3.8 1993/09/02 23:20:57 kardel Exp
 *
 * Parser configuration module for reference clocks
 *
 * STREAM define switches between two personalities of the module
 * if STREAM is defined this module can be used with dcf77sync.c as
 * a STREAMS kernel module. In this case the time stamps will be
 * a struct timeval.
 * when STREAM is not defined NTP time stamps will be used.
 *
 * Copyright (c) 1992,1993
 * Frank Kardel Friedrich-Alexander Universitaet Erlangen-Nuernberg
 *                                    
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * parse_conf.c,v 
 * Revision 3.8  1993/09/02  23:20:57  kardel
 * dragon extinction
 *
 * Revision 3.7  1993/09/01  21:44:52  kardel
 * conditional cleanup
 *
 * Revision 3.6  1993/09/01  11:25:09  kardel
 * patch accident 8-(
 *
 * Revision 3.5  1993/08/31  22:31:14  kardel
 * SINIX-M SysVR4 integration
 *
 * Revision 3.4  1993/08/27  00:29:42  kardel
 * compilation cleanup
 *
 * Revision 3.3  1993/07/14  09:04:45  kardel
 * only when REFCLOCK && PARSE is defined
 *
 * Revision 3.2  1993/07/09  11:37:13  kardel
 * Initial restructured version + GPS support
 *
 * Revision 3.1  1993/07/06  10:00:11  kardel
 * DCF77 driver goes generic...
 *
 *
 */

#include "sys/types.h"
#include "sys/time.h"
#include "sys/errno.h"
#include "ntp_fp.h"
#include "ntp_unixtime.h"
#include "ntp_calendar.h"

#include "parse.h"

#ifdef CLOCK_SCHMID
extern clockformat_t clock_schmid;
#endif

#ifdef CLOCK_DCF7000
extern clockformat_t clock_dcf7000;
#endif

#ifdef CLOCK_MEINBERG
extern clockformat_t clock_meinberg[];
#endif

#ifdef CLOCK_RAWDCF
extern clockformat_t clock_rawdcf;
#endif

/*
 * format definitions
 */
clockformat_t *clockformats[] =
{
#ifdef CLOCK_MEINBERG
  &clock_meinberg[0],
  &clock_meinberg[1],
  &clock_meinberg[2],
#endif
#ifdef CLOCK_DCF7000
  &clock_dcf7000,
#endif
#ifdef CLOCK_SCHMID
  &clock_schmid,
#endif
#ifdef CLOCK_RAWDCF
  &clock_rawdcf,
#endif
0};

int nformats = sizeof(clockformats) / sizeof(clockformats[0]) - 1;
#endif /* REFCLOCK PARSE */

