/*
 *  snmp_rip2.h
 *
 */
#ifndef _MIBGROUP_SNMP_RIP2_H
#define _MIBGROUP_SNMP_RIP2_H

config_require(smux)

extern u_char	*var_rip2();

#define RIP2GLOBALROUTECHANGES  0
#define RIP2GLOBALQUERIES       1
#define RIP2IFSTATADDRESS       2
#define RIP2IFSTATRCVBADPKTS    3
#define RIP2IFSTATRCVBADROUTES  4
#define RIP2IFSTATSENTUPDATES   5
#define RIP2IFSTATSTATUS        6
#define RIP2IFCONFADDRESS       7
#define RIP2IFCONFDOMAIN        8
#define RIP2IFCONFAUTHTYPE      9
#define RIP2IFCONFAUTHKEY       10
#define RIP2IFCONFSEND          11
#define RIP2IFCONFRECEIVE       12
#define RIP2IFCONFDEFAULTMETRIC 13
#define RIP2IFCONFSTATUS        14
#define RIP2IFCONFSRCADDRESS    15
#define RIP2PEERADDRESS         16
#define RIP2PEERDOMAIN          17
#define RIP2PEERLASTUPDATE      18
#define RIP2PEERVERSION         19
#define RIP2PEERRCVBADPKTS      20
#define RIP2PEERRCVBADROUTES    21

#ifdef IN_SNMP_VARS_C

struct variable13 rip2_variables[] = {
	{RIP2GLOBALROUTECHANGES, COUNTER, RONLY, var_rip2, 2, {1, 1}},
	{RIP2GLOBALQUERIES, COUNTER, RONLY, var_rip2, 2, {1, 2}},
	{RIP2IFSTATADDRESS, IPADDRESS, RONLY, var_rip2, 3, {2, 1, 1}},
	{RIP2IFSTATRCVBADPKTS, COUNTER, RONLY, var_rip2, 3, {2, 1, 2}},
	{RIP2IFSTATRCVBADROUTES, COUNTER, RONLY, var_rip2, 3, {2, 1, 3}},
	{RIP2IFSTATSENTUPDATES, COUNTER, RONLY, var_rip2, 3, {2, 1, 4}},
	{RIP2IFSTATSTATUS, INTEGER, RWRITE, var_rip2, 3, {2, 1, 5}},
	{RIP2IFCONFADDRESS, IPADDRESS, RONLY, var_rip2, 3, {3, 1, 1}},
	{RIP2IFCONFDOMAIN, STRING, RWRITE, var_rip2, 3, {3, 1, 2}},
	{RIP2IFCONFAUTHTYPE, INTEGER, RWRITE, var_rip2, 3, {3, 1, 3}},
	{RIP2IFCONFAUTHKEY, STRING, RWRITE, var_rip2, 3, {3, 1, 4}},
	{RIP2IFCONFSEND, INTEGER, RWRITE, var_rip2, 3, {3, 1, 5}},
	{RIP2IFCONFRECEIVE, INTEGER, RWRITE, var_rip2, 3, {3, 1, 6}},
        {RIP2IFCONFDEFAULTMETRIC,INTEGER, RWRITE, var_rip2, 3, {3, 1, 7}},
	{RIP2IFCONFSTATUS, INTEGER, RWRITE, var_rip2, 3, {3, 1, 8}},
	{RIP2IFCONFSRCADDRESS, IPADDRESS, RWRITE, var_rip2, 3, {3, 1, 9}},
	{RIP2PEERADDRESS, IPADDRESS, RONLY, var_rip2, 3, {4, 1, 1}},
	{RIP2PEERDOMAIN, STRING, RONLY, var_rip2, 3, {4, 1, 2}},
	{RIP2PEERLASTUPDATE, TIMETICKS, RONLY, var_rip2, 3, {4, 1, 3}},
	{RIP2PEERVERSION, INTEGER, RONLY, var_rip2, 3, {4, 1, 4}},
	{RIP2PEERRCVBADPKTS, COUNTER, RONLY, var_rip2, 3, {4, 1, 5}},
	{RIP2PEERRCVBADROUTES, COUNTER, RONLY, var_rip2, 3, {4, 1, 6}}
};

config_load_mib( MIB.23, 7, rip2_variables)

#endif
#endif /* _MIBGROUP_SNMP_RIP2_H */
