/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Channel;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

class FconfigureCmd
implements Command {
    private static final String[] validCmds = new String[]{"-blocking", "-buffering", "-buffersize", "-eofchar", "-translation"};

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Channel channel;
        if (tclObjectArray.length < 2 || tclObjectArray.length % 2 == 1 && tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "channelId ?optionName? ?value? ?optionName value?...");
        }
        TclObject tclObject = tclObjectArray[1];
        if (tclObject.stringRep == null) {
            tclObject.stringRep = tclObject.internalRep.toString();
        }
        if ((channel = TclIO.getChannel(interp, tclObject.stringRep)) == null) {
            StringBuffer stringBuffer = new StringBuffer("can not find channel named \"");
            tclObject = tclObjectArray[1];
            if (tclObject.stringRep == null) {
                tclObject.stringRep = tclObject.internalRep.toString();
            }
            throw new TclException(interp, stringBuffer.append(tclObject.stringRep).append("\"").toString());
        }
        if (tclObjectArray.length == 3) {
            int n = TclIndex.get(interp, tclObjectArray[2], validCmds, "option", 0);
            switch (n) {
                default: {
                    throw new TclRuntimeError("Fconfigure.cmdProc() error: incorrect index returned from TclIndex.get()");
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
            }
        }
        int n = 3;
        while (n < tclObjectArray.length) {
            int n2 = TclIndex.get(interp, tclObjectArray[n - 1], validCmds, "option", 0);
            switch (n2) {
                case 1: {
                    Object object = tclObjectArray[n];
                    if (((TclObject)object).stringRep == null) {
                        ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                    }
                    if (((String)(object = ((TclObject)object).stringRep)).equals("full") || ((String)object).equals("line") || ((String)object).equals("none")) break;
                    throw new TclException(interp, "bad value for -buffering: must be one of full, line, or none");
                }
                case 4: {
                    Object object = tclObjectArray[n];
                    if (((TclObject)object).stringRep == null) {
                        ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                    }
                    if (((String)(object = ((TclObject)object).stringRep)).equals("auto") || ((String)object).equals("binary") || ((String)object).equals("cr") || ((String)object).equals("crlf") || ((String)object).equals("lf")) break;
                    throw new TclException(interp, "bad value for -translation: must be one of auto, binary, cr, lf, crlf, or platform");
                }
                default: {
                    throw new TclRuntimeError("Fconfigure.cmdProc() error: incorrect index returned from TclIndex.get()");
                }
                case 0: 
                case 2: 
                case 3: 
            }
            n += 2;
        }
        throw new TclException(interp, "fconfigure command not implemented yet");
    }

    FconfigureCmd() {
    }
}

