/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclVarException;
import tcl.lang.TraceRecord;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.VarTrace;

class CallFrame {
    static final String noSuchVar = "no such variable";
    static final String isArray = "variable is array";
    static final String needArray = "variable isn't array";
    static final String noSuchElement = "no such element in array";
    static final String danglingUpvar = "upvar refers to element in deleted array";
    protected static final int CRT_PART1 = 1;
    protected static final int CRT_PART2 = 2;
    protected Interp interp;
    protected Hashtable varTable;
    TclObject[] m_argv;
    protected CallFrame caller;
    protected CallFrame callerVar;
    protected int m_level;

    CallFrame(Interp i) {
        this.interp = i;
        this.varTable = new Hashtable();
        this.caller = null;
        this.callerVar = null;
        this.m_argv = null;
        this.m_level = 0;
    }

    CallFrame(Interp ainterp, Procedure proc, TclObject[] argv) throws TclException {
        this.interp = ainterp;
        this.varTable = new Hashtable();
        try {
            this.chain(proc, argv);
        }
        catch (TclException e) {
            this.dispose();
            throw e;
        }
    }

    void chain(Procedure proc, TclObject[] argv) throws TclException {
        this.m_argv = argv;
        this.m_level = this.interp.varFrame.m_level + 1;
        this.caller = this.interp.frame;
        this.callerVar = this.interp.varFrame;
        this.interp.frame = this;
        this.interp.varFrame = this;
        int numArgs = proc.argList.length;
        if (!proc.isVarArgs && argv.length - 1 > numArgs) {
            throw new TclException(this.interp, "called \"" + argv[0] + "\" with too many arguments");
        }
        int i = 0;
        int j = 1;
        while (i < numArgs) {
            TclObject varName = proc.argList[i][0];
            TclObject value = null;
            if (i == numArgs - 1 && proc.isVarArgs) {
                value = TclList.newInstance();
                value.preserve();
                int k = j;
                while (k < argv.length) {
                    TclList.append(this.interp, value, argv[k]);
                    ++k;
                }
                this.interp.setVar(varName, value, 0);
                value.release();
            } else {
                if (j < argv.length) {
                    value = argv[j];
                } else if (proc.argList[i][1] != null) {
                    value = proc.argList[i][1];
                } else {
                    throw new TclException(this.interp, "no value given for parameter \"" + varName + "\" to \"" + argv[0] + "\"");
                }
                this.interp.setVar(varName, value, 0);
            }
            ++i;
            ++j;
        }
    }

    Var[] lookupVar(String part1, String part2, int flags, String msg, int create, boolean throwException) throws TclException {
        Var var;
        int i;
        int len = part1.length();
        if (len > 0 && part1.charAt(len - 1) == ')' && (i = part1.indexOf(40)) != -1) {
            if (part2 != null) {
                throw new TclVarException(this.interp, part1, part2, msg, needArray);
            }
            if (i < len - 2) {
                char[] n1 = new char[i];
                char[] n2 = new char[len - 2 - i];
                part1.getChars(0, i, n1, 0);
                part1.getChars(i + 1, len - 1, n2, 0);
                part1 = new String(n1);
                part2 = new String(n2);
            }
        }
        Hashtable table = (flags & 1) != 0 ? this.interp.globalFrame.varTable : this.interp.varFrame.varTable;
        if ((create & 1) != 0) {
            var = (Var)table.get(part1);
            if (var == null) {
                var = new Var();
                var.table = table;
                var.hashKey = part1;
                table.put(part1, var);
            }
        } else {
            var = (Var)table.get(part1);
            if (var == null) {
                if (throwException) {
                    throw new TclVarException(this.interp, part1, part2, msg, noSuchVar);
                }
                return null;
            }
        }
        if ((var.flags & 2) != 0) {
            var = (Var)var.value;
        }
        if (part2 == null) {
            Var[] ret = new Var[]{var, null};
            return ret;
        }
        if ((var.flags & 4) != 0) {
            if ((create & 1) == 0) {
                if (throwException) {
                    throw new TclVarException(this.interp, part1, part2, msg, noSuchVar);
                }
                return null;
            }
            var.flags = 1;
            var.value = new Hashtable();
        } else if ((var.flags & 1) == 0) {
            if (throwException) {
                throw new TclVarException(this.interp, part1, part2, msg, needArray);
            }
            return null;
        }
        Var av = var;
        Hashtable arrayTable = (Hashtable)av.value;
        if ((create & 2) != 0) {
            var = (Var)arrayTable.get(part2);
            if (var == null) {
                var = new Var();
                var.table = arrayTable;
                var.hashKey = part2;
                arrayTable.put(part2, var);
                var.sidVec = null;
            }
        } else {
            var = (Var)arrayTable.get(part2);
            if (var == null) {
                if (throwException) {
                    throw new TclVarException(this.interp, part1, part2, msg, noSuchElement);
                }
                return null;
            }
        }
        Var[] ret = new Var[]{var, av};
        return ret;
    }

    TclObject setVar(TclObject nameObj, TclObject value, int flags) throws TclException {
        return this.setVar(nameObj.toString(), null, value, flags);
    }

    TclObject setVar(String name, TclObject value, int flags) throws TclException {
        return this.setVar(name, null, value, flags);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TclObject setVar(String part1, String part2, TclObject tobj, int flags) throws TclException {
        TclObject tclObject;
        Var[] result = this.lookupVar(part1, part2, flags, "set", 3, true);
        Var var = result[0];
        Var array = result[1];
        if (var.table == null) {
            throw new TclVarException(this.interp, part1, part2, "set", danglingUpvar);
        }
        if ((var.flags & 1) != 0) {
            throw new TclVarException(this.interp, part1, part2, "set", isArray);
        }
        boolean hasTraces = var.traces != null || array != null && array.traces != null;
        try {
            String msg;
            String msg2;
            if ((flags & 4) != 0 && hasTraces && (msg2 = this.callTraces(array, var, part1, part2, flags & 1 | 0x10)) != null) {
                throw new TclVarException(this.interp, part1, part2, "read", msg2);
            }
            TclObject value = (TclObject)var.value;
            if (value == null) {
                if ((flags & 8) == 0) {
                    value = tobj;
                    value.preserve();
                } else {
                    value = TclList.newInstance();
                    value.preserve();
                    TclList.append(this.interp, value, tobj);
                }
            } else if ((flags & 4) == 0) {
                if (value != tobj) {
                    value.release();
                    value = tobj;
                    value.preserve();
                }
            } else if ((flags & 8) == 0) {
                value = value.takeExclusive();
                TclString.append((TclObject)value, (TclObject)tobj);
            } else {
                value = value.takeExclusive();
                TclList.append(this.interp, value, tobj);
            }
            if (array != null && (var.flags & 4) != 0) {
                array.sidVec = null;
            }
            var.value = value;
            var.flags &= 0xFFFFFFFB;
            if (hasTraces && (msg = this.callTraces(array, var, part1, part2, flags & 1 | 0x20)) != null) {
                throw new TclVarException(this.interp, part1, part2, "set", msg);
            }
            if ((var.flags & 7) == 0) {
                TclObject tclObject2 = (TclObject)var.value;
                Object var11_13 = null;
                if ((var.flags & 4) == 0) return tclObject2;
                this.cleanupVar(var, array);
                return tclObject2;
            }
            tclObject = TclString.newInstance((String)"");
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if ((var.flags & 4) == 0) throw throwable;
            this.cleanupVar(var, array);
            throw throwable;
        }
        Object var11_14 = null;
        if ((var.flags & 4) == 0) return tclObject;
        this.cleanupVar(var, array);
        return tclObject;
    }

    TclObject getVar(TclObject nameObj, int flags) throws TclException {
        return this.getVar(nameObj.toString(), null, flags);
    }

    TclObject getVar(String name, int flags) throws TclException {
        return this.getVar(name, null, flags);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TclObject getVar(String part1, String part2, int flags) throws TclException {
        TclObject tclObject;
        Var array;
        Var var;
        block10: {
            TclObject tclObject2;
            block9: {
                boolean throwException = (flags & 0x800) == 0;
                Var[] result = this.lookupVar(part1, part2, flags, "read", 2, throwException);
                if (result == null) {
                    return null;
                }
                var = result[0];
                array = result[1];
                try {
                    String msg;
                    if ((var.traces != null || array != null && array.traces != null) && (msg = this.callTraces(array, var, part1, part2, flags & 1 | 0x10)) != null) {
                        if (throwException) {
                            throw new TclVarException(this.interp, part1, part2, "read", msg);
                        }
                        TclObject tclObject3 = null;
                        Object var10_12 = null;
                        if ((var.flags & 4) == 0) return tclObject3;
                        this.cleanupVar(var, array);
                        return tclObject3;
                    }
                    if ((var.flags & 7) == 0) {
                        tclObject2 = (TclObject)var.value;
                        break block9;
                    }
                    if (throwException) {
                        if ((var.flags & 4) != 0 && array != null && (array.flags & 4) == 0) {
                            msg = noSuchElement;
                            throw new TclVarException(this.interp, part1, part2, "read", msg);
                        }
                        if ((var.flags & 1) != 0) {
                            msg = isArray;
                            throw new TclVarException(this.interp, part1, part2, "read", msg);
                        }
                        msg = noSuchVar;
                        throw new TclVarException(this.interp, part1, part2, "read", msg);
                    }
                    tclObject = null;
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    if ((var.flags & 4) == 0) throw throwable;
                    this.cleanupVar(var, array);
                    throw throwable;
                }
            }
            Object var10_13 = null;
            if ((var.flags & 4) == 0) return tclObject2;
            this.cleanupVar(var, array);
            return tclObject2;
        }
        Object var10_14 = null;
        if ((var.flags & 4) == 0) return tclObject;
        this.cleanupVar(var, array);
        return tclObject;
    }

    void unsetVar(TclObject nameObj, int flags) throws TclException {
        this.unsetVar(nameObj.toString(), null, flags);
    }

    void unsetVar(String name, int flags) throws TclException {
        this.unsetVar(name, null, flags);
    }

    void unsetVar(String part1, String part2, int flags) throws TclException {
        boolean undefined;
        Var[] result = this.lookupVar(part1, part2, flags, "unset", 0, true);
        Var var = result[0];
        Var array = result[1];
        boolean bl = undefined = (var.flags & 4) != 0;
        if (array != null) {
            array.sidVec = null;
        }
        if (var.value != null && var.value instanceof TclObject) {
            ((TclObject)var.value).release();
            var.value = null;
        }
        Var dummyVar = new Var();
        dummyVar.value = var.value;
        dummyVar.traces = var.traces;
        dummyVar.flags = var.flags;
        dummyVar.hashKey = var.hashKey;
        dummyVar.table = var.table;
        dummyVar.refCount = var.refCount;
        var.flags = 4;
        var.traces = null;
        var.value = null;
        var.sidVec = null;
        if (dummyVar.traces != null || array != null && array.traces != null) {
            ++var.refCount;
            dummyVar.flags &= 0xFFFFFFEF;
            this.callTraces(array, dummyVar, part1, part2, flags & 1 | 0x40);
            dummyVar.traces = null;
            --var.refCount;
        }
        if ((dummyVar.flags & 1) != 0) {
            this.deleteArray(part1, dummyVar, flags & 1 | 0x40);
        }
        this.cleanupVar(var, array);
        if (undefined) {
            throw new TclVarException(this.interp, part1, part2, "unset", array == null ? noSuchVar : noSuchElement);
        }
    }

    void traceVar(TclObject nameObj, VarTrace trace, int flags) throws TclException {
        this.traceVar(nameObj.toString(), null, trace, flags);
    }

    void traceVar(String name, VarTrace trace, int flags) throws TclException {
        this.traceVar(name, null, trace, flags);
    }

    void traceVar(String part1, String part2, VarTrace trace, int flags) throws TclException {
        Var[] result = this.lookupVar(part1, part2, flags, "trace", 3, true);
        Var var = result[0];
        Var array = result[1];
        if (var.traces == null) {
            var.traces = new Vector();
        }
        TraceRecord rec = new TraceRecord();
        rec.flags = flags;
        rec.trace = trace;
        var.traces.insertElementAt(rec, 0);
        if (array != null && (var.flags & 4) != 0) {
            array.sidVec = null;
        }
    }

    void untraceVar(TclObject nameObj, VarTrace trace, int flags) {
        this.untraceVar(nameObj.toString(), null, trace, flags);
    }

    void untraceVar(String name, VarTrace trace, int flags) {
        this.untraceVar(name, null, trace, flags);
    }

    void untraceVar(String part1, String part2, VarTrace trace, int flags) {
        Var[] result;
        try {
            result = this.lookupVar(part1, part2, flags, "trace", 3, false);
            if (result == null) {
                return;
            }
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
        Var var = result[0];
        if (var.traces != null) {
            int len = var.traces.size();
            int i = 0;
            while (i < len) {
                TraceRecord rec = (TraceRecord)var.traces.elementAt(i);
                if (rec.trace == trace) {
                    var.traces.removeElementAt(i);
                    break;
                }
                ++i;
            }
        }
    }

    protected Vector getTraces(TclObject nameObj, int flags) throws TclException {
        return this.getTraces(nameObj.toString(), null, flags);
    }

    protected Vector getTraces(String name, int flags) throws TclException {
        return this.getTraces(name, null, flags);
    }

    protected Vector getTraces(String part1, String part2, int flags) throws TclException {
        Var[] result = this.lookupVar(part1, part2, flags &= 1, "lookup", 0, false);
        if (result == null) {
            return null;
        }
        Var var = result[0];
        return var.traces;
    }

    protected void makeUpVar(CallFrame frame, TclObject otherNameObj, String myName, int flags) throws TclException {
        this.makeUpVar(frame, otherNameObj.toString(), null, myName, flags);
    }

    protected void makeUpVar(CallFrame frame, String otherName, String myName, int flags) throws TclException {
        this.makeUpVar(frame, otherName, null, myName, flags);
    }

    protected void makeUpVar(CallFrame frame, String otherP1, String otherP2, String myName, int flags) throws TclException {
        CallFrame savedFrame = this.interp.varFrame;
        this.interp.varFrame = frame;
        Var[] result = this.lookupVar(otherP1, otherP2, flags, "access", 3, true);
        this.interp.varFrame = savedFrame;
        Var other = result[0];
        Hashtable table = (flags & 1) != 0 ? this.interp.globalFrame.varTable : this.interp.varFrame.varTable;
        Var var = (Var)table.get(myName);
        if (var == null) {
            var = new Var();
            var.table = table;
            var.hashKey = myName;
            table.put(myName, var);
        } else {
            if (var == other) {
                throw new TclException(this.interp, "can't upvar from variable to itself");
            }
            if ((var.flags & 2) != 0) {
                Var upvar = (Var)var.value;
                if (upvar == other) {
                    return;
                }
                --upvar.refCount;
                if ((upvar.flags & 4) != 0) {
                    this.cleanupVar(upvar, null);
                }
            } else {
                if ((var.flags & 4) == 0) {
                    throw new TclException(this.interp, "variable \"" + myName + "\" already exists");
                }
                if (var.traces != null) {
                    throw new TclException(this.interp, "variable \"" + myName + "\" has traces: can't use for upvar");
                }
            }
        }
        var.flags = var.flags & 0xFFFFFFFB | 2;
        var.value = other;
        ++other.refCount;
    }

    boolean exists(String name) {
        try {
            Var[] result = this.lookupVar(name, null, 0, "lookup", 0, false);
            if (result == null) {
                return false;
            }
            return (result[0].flags & 4) == 0;
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
    }

    Vector getVarNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration e1 = this.varTable.elements();
        while (e1.hasMoreElements()) {
            Var v = (Var)e1.nextElement();
            if ((v.flags & 4) != 0) continue;
            vector.addElement(v.hashKey);
        }
        return vector;
    }

    Vector getLocalVarNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration e1 = this.varTable.elements();
        while (e1.hasMoreElements()) {
            Var v = (Var)e1.nextElement();
            if ((v.flags & 6) != 0) continue;
            vector.addElement(v.hashKey);
        }
        return vector;
    }

    CallFrame getFrame(String s) throws TclException {
        int j;
        int i = -1;
        if (s.length() > 0 && s.charAt(0) == '#') {
            String sub = s.substring(1, s.length());
            j = Util.getInt(this.interp, sub);
            if (j < 0) {
                throw new TclException(this.interp, "bad level \"" + s + "\"");
            }
            i = this.m_level - j;
        } else {
            try {
                i = Util.getInt(this.interp, s);
            }
            catch (TclException tclException) {
                if (this.interp.varFrame == this.interp.globalFrame) {
                    throw new TclException(this.interp, "bad level \"" + s + "\"");
                }
                return null;
            }
        }
        if (i < 0) {
            throw new TclException(this.interp, "bad level \"" + s + "\"");
        }
        CallFrame frame = this.interp.varFrame;
        j = 0;
        while (j < i) {
            if (frame == this.interp.globalFrame) {
                throw new TclException(this.interp, "bad level \"" + s + "\"");
            }
            frame = frame.callerVar;
            ++j;
        }
        return frame;
    }

    protected String callTraces(Var array, Var var, String part1, String part2, int flags) {
        String string;
        int i;
        int len;
        if ((var.flags & 0x10) != 0) {
            return null;
        }
        var.flags |= 0x10;
        ++var.refCount;
        if (part2 == null && (len = part1.length()) > 0 && part1.charAt(len - 1) == ')') {
            i = 0;
            while (i < len - 1) {
                if (part1.charAt(i) == '(') break;
                ++i;
            }
            if (i < len - 1 && i < len - 2) {
                char[] n1 = new char[i];
                char[] n2 = new char[len - 2 - i];
                part1.getChars(0, i, n1, 0);
                part1.getChars(i + 1, len - 1, n2, 0);
                part1 = new String(n1);
                part2 = new String(n2);
            }
        }
        TclObject oldResult = this.interp.getResult();
        oldResult.preserve();
        this.interp.resetResult();
        try {
            TraceRecord rec;
            if (array != null) {
                ++array.refCount;
            }
            if (array != null && array.traces != null) {
                i = 0;
                while (array.traces != null && i < array.traces.size()) {
                    block21: {
                        rec = (TraceRecord)array.traces.elementAt(i);
                        if ((rec.flags & flags) != 0) {
                            try {
                                rec.trace.traceProc(this.interp, part1, part2, flags);
                            }
                            catch (TclException tclException) {
                                if ((flags & 0x40) != 0) break block21;
                                string = this.interp.getResult().toString();
                                Object var10_13 = null;
                                if (array != null) {
                                    --array.refCount;
                                }
                                var.flags &= 0xFFFFFFEF;
                                --var.refCount;
                                this.interp.setResult(oldResult);
                                oldResult.release();
                                return string;
                            }
                        }
                    }
                    ++i;
                }
            }
            if ((flags & 0x40) != 0) {
                flags |= 0x80;
            }
            i = 0;
            while (var.traces != null && i < var.traces.size()) {
                block22: {
                    rec = (TraceRecord)var.traces.elementAt(i);
                    if ((rec.flags & flags) != 0) {
                        try {
                            rec.trace.traceProc(this.interp, part1, part2, flags);
                        }
                        catch (TclException tclException) {
                            if ((flags & 0x40) != 0) break block22;
                            string = this.interp.getResult().toString();
                            Object var10_14 = null;
                            if (array != null) {
                                --array.refCount;
                            }
                            var.flags &= 0xFFFFFFEF;
                            --var.refCount;
                            this.interp.setResult(oldResult);
                            oldResult.release();
                            return string;
                        }
                    }
                }
                ++i;
            }
            string = null;
            Object var10_15 = null;
            if (array != null) {
                --array.refCount;
            }
            var.flags &= 0xFFFFFFEF;
            --var.refCount;
            this.interp.setResult(oldResult);
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (array != null) {
                --array.refCount;
            }
            var.flags &= 0xFFFFFFEF;
            --var.refCount;
            this.interp.setResult(oldResult);
            oldResult.release();
            throw throwable;
        }
        oldResult.release();
        return string;
    }

    protected void dispose() {
        this.interp.frame = this.caller;
        this.interp.varFrame = this.callerVar;
        this.caller = null;
        this.callerVar = null;
        int flags = 64;
        if (this == this.interp.globalFrame) {
            flags |= 0x101;
        }
        Enumeration e = this.varTable.elements();
        while (e.hasMoreElements()) {
            Var var = (Var)e.nextElement();
            if ((var.flags & 2) != 0) {
                Var upvar = (Var)var.value;
                --upvar.refCount;
                if (upvar.refCount == 0 && (upvar.flags & 4) != 0 && upvar.traces == null && upvar.table != null && upvar.table != this.varTable) {
                    upvar.table.remove(upvar.hashKey);
                    upvar.table = null;
                }
            }
            if (var.traces != null) {
                this.callTraces(null, var, var.hashKey, null, flags);
            }
            if ((var.flags & 1) != 0) {
                this.deleteArray(var.hashKey, var, flags);
            } else if (var.value != null && var.value instanceof TclObject) {
                ((TclObject)var.value).release();
            }
            var.value = null;
            var.traces = null;
            var.flags = 4;
            var.table = null;
            var.hashKey = null;
        }
        this.varTable = null;
    }

    protected void deleteArray(String arrayName, Var var, int flags) {
        var.sidVec = null;
        Hashtable table = (Hashtable)var.value;
        Var dummyVar = null;
        Enumeration e1 = table.elements();
        while (e1.hasMoreElements()) {
            Var el = (Var)e1.nextElement();
            TclObject value = (TclObject)el.value;
            if (value != null) {
                value.release();
            }
            el.table = null;
            if (el.traces != null) {
                if (dummyVar == null) {
                    dummyVar = new Var();
                }
                dummyVar.traces = el.traces;
                dummyVar.flags = el.flags;
                dummyVar.flags &= 0xFFFFFFEF;
                el.traces = null;
                ++el.refCount;
                this.callTraces(null, dummyVar, arrayName, el.hashKey, flags);
                --el.refCount;
            }
            el.flags = 4;
        }
        var.value = null;
    }

    protected void cleanupVar(Var var, Var array) {
        if ((var.flags & 4) != 0 && var.refCount == 0 && var.traces == null && var.table != null) {
            var.table.remove(var.hashKey);
            var.table = null;
        }
        if (array != null && (array.flags & 4) != 0 && array.refCount == 0 && array.traces == null && array.table != null) {
            array.table.remove(array.hashKey);
            array.table = null;
        }
    }
}

