/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

class ExecCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int argLen = argv.length;
        boolean background = false;
        boolean keepNewline = false;
        int firstWord = 1;
        while (firstWord < argLen) {
            String argStr = argv[firstWord].toString();
            if (argStr.length() <= 0 || argStr.charAt(0) != '-') break;
            if (!argStr.equals("-keepnewline")) {
                if (argStr.equals("--")) {
                    ++firstWord;
                    break;
                }
                throw new TclException(interp, "bad switch \"" + argStr + "\": must be -keepnewline or --");
            }
            keepNewline = true;
            ++firstWord;
        }
        if (argLen <= firstWord) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? arg ?arg ...?");
        }
        if (argv[argLen - 1].toString().equals("&")) {
            --argLen;
            background = true;
        }
        try {
            Process p = Util.isUnix() ? this.execUnix(interp, argv, firstWord, argLen) : (Util.isWindows() ? this.execWin(interp, argv, firstWord, argLen) : this.execDefault(interp, argv, firstWord, argLen));
            int exit = p.waitFor();
            StringBuffer sbuf = new StringBuffer();
            ExecCmd.readStreamIntoBuffer(p.getInputStream(), sbuf);
            int errorBytes = ExecCmd.readStreamIntoBuffer(p.getErrorStream(), sbuf);
            if (errorBytes == 0 && exit != 0) {
                sbuf.append("child process exited abnormally");
            }
            int length = sbuf.length();
            if (!keepNewline && length > 0 && sbuf.charAt(length - 1) == '\n') {
                sbuf.setLength(length - 1);
            }
            if (exit != 0 || errorBytes != 0) {
                throw new TclException(interp, sbuf.toString());
            }
            interp.setResult(sbuf.toString());
        }
        catch (IOException e) {
            throw new TclException(interp, "couldn't execute \"" + argv[firstWord].toString() + "\": no such file or directory");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    static int readStreamIntoBuffer(InputStream in, StringBuffer sbuf) {
        void var2_2;
        block9: {
            int numRead = 0;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = br.readLine();
            while (line != null) {
                sbuf.append(line);
                numRead += line.length();
                sbuf.append('\n');
                ++numRead;
                line = br.readLine();
            }
            Object var5_8 = null;
            try {
                br.close();
            }
            catch (IOException iOException) {}
            break block9;
            {
                catch (IOException iOException) {
                    Object var5_9 = null;
                    try {
                        br.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return (int)var2_2;
    }

    static String escapeWinString(String str) {
        if (str.indexOf(37) == -1) {
            return str;
        }
        char[] arr = str.toCharArray();
        StringBuffer sb = new StringBuffer(50);
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == '%') {
                sb.append('%');
            }
            sb.append(arr[i]);
            ++i;
        }
        return sb.toString();
    }

    private Process execUnix(Interp interp, TclObject[] argv, int first, int last) throws IOException, InterruptedException {
        String[] argStrs = new String[3];
        argStrs[0] = "sh";
        argStrs[1] = "-c";
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("cd '");
        sbuf.append(interp.getWorkingDir().toString());
        sbuf.append("'; ");
        int i = first;
        while (i < last) {
            sbuf.append('\'');
            sbuf.append(argv[i].toString());
            sbuf.append('\'');
            sbuf.append(' ');
            ++i;
        }
        sbuf.setLength(sbuf.length() - 1);
        argStrs[2] = sbuf.toString();
        return Runtime.getRuntime().exec(argStrs);
    }

    private Process execWin(Interp interp, TclObject[] argv, int first, int last) throws IOException, InterruptedException {
        File out_file;
        File tmp = new File("C:\\TEMP");
        if (!tmp.exists() && !tmp.mkdirs()) {
            throw new IOException("could not create C:\\TEMP");
        }
        String jacl1 = "C:\\TEMP\\jacl1.bat";
        String jacl2 = "C:\\TEMP\\jacl2.bat";
        boolean isNT = System.getProperty("os.name").toLowerCase().equals("windows nt");
        File jacl1_file = new File(jacl1);
        File jacl2_file = new File(jacl2);
        if (isNT) {
            if (jacl1_file.exists()) {
                jacl1_file.delete();
            }
            PrintWriter jacl_out = new PrintWriter(new BufferedWriter(new FileWriter(jacl1_file)));
            jacl_out.println("@echo off");
            jacl_out.println("cmd.exe /C " + jacl2);
            jacl_out.close();
            out_file = jacl2_file;
        } else {
            out_file = jacl1_file;
        }
        if (out_file.exists()) {
            out_file.delete();
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(out_file)));
        out.println("@echo off");
        String path = interp.getWorkingDir().toString();
        out.println(path.substring(0, 2));
        out.println("cd " + ExecCmd.escapeWinString(path.substring(2)));
        out.print(ExecCmd.escapeWinString(argv[first].toString()));
        out.print(' ');
        int i = first + 1;
        while (i < last) {
            out.print('\"');
            out.print(ExecCmd.escapeWinString(argv[i].toString()));
            out.print('\"');
            out.print(' ');
            ++i;
        }
        out.println();
        out.close();
        String[] argStrs = new String[]{"command.com", "/C", jacl1};
        return Runtime.getRuntime().exec(argStrs);
    }

    private Process execDefault(Interp interp, TclObject[] argv, int first, int last) throws IOException, InterruptedException {
        String[] strv = new String[last - first];
        int i = first;
        int j = 0;
        while (i < last) {
            strv[j] = argv[i].toString();
            ++j;
            ++i;
        }
        return Runtime.getRuntime().exec(strv);
    }

    ExecCmd() {
    }
}

