/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Vector;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Procedure;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

class InfoCmd
implements Command {
    private static final String[] validCmds = new String[]{"args", "body", "cmdcount", "commands", "complete", "default", "exists", "globals", "hostname", "level", "library", "loaded", "locals", "nameofexecutable", "patchlevel", "procs", "script", "sharedlibextension", "tclversion", "vars"};
    static final int OPT_ARGS = 0;
    static final int OPT_BODY = 1;
    static final int OPT_CMDCOUNT = 2;
    static final int OPT_COMMANDS = 3;
    static final int OPT_COMPLETE = 4;
    static final int OPT_DEFAULT = 5;
    static final int OPT_EXISTS = 6;
    static final int OPT_GLOBALS = 7;
    static final int OPT_HOSTNAME = 8;
    static final int OPT_LEVEL = 9;
    static final int OPT_LIBRARY = 10;
    static final int OPT_LOADED = 11;
    static final int OPT_LOCALS = 12;
    static final int OPT_NAMEOFEXECUTABLE = 13;
    static final int OPT_PATCHLEVEL = 14;
    static final int OPT_PROCS = 15;
    static final int OPT_SCRIPT = 16;
    static final int OPT_SHAREDLIBEXTENSION = 17;
    static final int OPT_TCLVERSION = 18;
    static final int OPT_VARS = 19;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int index = TclIndex.get((Interp)interp, (TclObject)argv[1], (String[])validCmds, (String)"option", (int)0);
        switch (index) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "procname");
                }
                Command cmd = (Command)interp.cmdTable.get(argv[2].toString());
                if (cmd == null || !(cmd instanceof Procedure)) {
                    throw new TclException(interp, "\"" + argv[2] + "\" isn't a procedure");
                }
                Procedure proc = (Procedure)cmd;
                TclObject list = TclList.newInstance();
                int i = 0;
                while (i < proc.argList.length) {
                    TclObject s = TclString.newInstance((Object)proc.argList[i][0]);
                    TclList.append(interp, list, s);
                    ++i;
                }
                interp.setResult(list);
                return;
            }
            case 1: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "procname");
                }
                Command cmd = (Command)interp.cmdTable.get(argv[2].toString());
                if (cmd == null || !(cmd instanceof Procedure)) {
                    throw new TclException(interp, "\"" + argv[2] + "\" isn't a procedure");
                }
                Procedure proc = (Procedure)cmd;
                TclObject s = TclString.newInstance((Object)proc.body);
                interp.setResult(s);
                return;
            }
            case 2: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 2, argv, null);
                }
                interp.setResult(interp.cmdCount);
                return;
            }
            case 3: {
                if (argv.length != 2 && argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?pattern?");
                }
                if (argv.length == 2) {
                    this.matchAndAppend(interp, interp.cmdTable.keys(), null);
                } else {
                    this.matchAndAppend(interp, interp.cmdTable.keys(), argv[2].toString());
                }
                return;
            }
            case 4: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "command");
                }
                interp.setResult(TclBoolean.newInstance((boolean)Interp.commandComplete(argv[2].toString())));
                return;
            }
            case 5: {
                if (argv.length != 5) {
                    throw new TclNumArgsException(interp, 2, argv, "procname arg varname");
                }
                String procName = argv[2].toString();
                String argName = argv[3].toString();
                Command cmd = (Command)interp.cmdTable.get(argv[2].toString());
                if (cmd == null || !(cmd instanceof Procedure)) {
                    throw new TclException(interp, "\"" + argv[2] + "\" isn't a procedure");
                }
                Procedure proc = (Procedure)cmd;
                int i = 0;
                while (i < proc.argList.length) {
                    if (argName.equals(proc.argList[i][0].toString())) {
                        String varName = argv[4].toString();
                        try {
                            if (proc.argList[i][1] != null) {
                                interp.setVar(varName, proc.argList[i][1], 0);
                                interp.setResult(1);
                            } else {
                                TclObject s = TclString.newInstance((String)"");
                                interp.setVar(varName, s, 0);
                                interp.setResult(0);
                            }
                        }
                        catch (TclException tclException) {
                            throw new TclException(interp, "couldn't store default value in variable \"" + varName + "\"");
                        }
                        return;
                    }
                    ++i;
                }
                throw new TclException(interp, "procedure \"" + procName + "\" doesn't have an argument \"" + argName + "\"");
            }
            case 6: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "varName");
                }
                boolean exists = interp.varFrame.exists(argv[2].toString());
                interp.setResult(TclBoolean.newInstance((boolean)exists));
                return;
            }
            case 7: {
                if (argv.length != 2 && argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?pattern?");
                }
                if (argv.length == 2) {
                    this.matchAndAppend(interp, interp.globalFrame.getVarNames(), null);
                } else {
                    this.matchAndAppend(interp, interp.globalFrame.getVarNames(), argv[2].toString());
                }
                return;
            }
            case 8: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 2, argv, null);
                }
                interp.setResult("no host info");
                return;
            }
            case 9: {
                if (argv.length != 2 && argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?number?");
                }
                if (argv.length == 2) {
                    if (interp.varFrame == null) {
                        interp.setResult(0);
                    } else {
                        interp.setResult(interp.varFrame.m_level);
                    }
                    return;
                }
                int level = TclInteger.get((Interp)interp, (TclObject)argv[2]);
                if (level > 0) {
                    if (interp.varFrame == null) {
                        throw new TclException(interp, "bad level \"" + level + "\"");
                    }
                    level -= interp.varFrame.m_level;
                }
                CallFrame currentFrame = interp.varFrame;
                int counter = level;
                while (counter != 0) {
                    if (currentFrame == null) break;
                    currentFrame = currentFrame.callerVar;
                    ++counter;
                }
                if (currentFrame == null || currentFrame.m_argv == null) {
                    throw new TclException(interp, "bad level \"" + level + "\"");
                }
                TclObject list = TclList.newInstance();
                int i = 0;
                while (i < currentFrame.m_argv.length) {
                    TclObject s = TclString.newInstance((Object)currentFrame.m_argv[i]);
                    TclList.append(interp, list, s);
                    ++i;
                }
                interp.setResult(list);
                return;
            }
            case 10: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 2, argv, null);
                }
                TclObject obj = interp.getVar("tcl_library", 2049);
                if (obj == null) {
                    throw new TclException(interp, "no library has been specified for Tcl");
                }
                interp.setResult(obj);
                return;
            }
            case 11: {
                if (argv.length != 2 && argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?interp?");
                }
                throw new TclException(interp, "info loaded not implemented");
            }
            case 12: {
                if (argv.length != 2 && argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?pattern?");
                }
                if (interp.varFrame == interp.globalFrame) {
                    return;
                }
                if (argv.length == 2) {
                    this.matchAndAppend(interp, interp.varFrame.getLocalVarNames(), null);
                } else {
                    this.matchAndAppend(interp, interp.varFrame.getLocalVarNames(), argv[2].toString());
                }
                return;
            }
            case 13: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 2, argv, null);
                }
                interp.setResult(TclString.newInstance((String)""));
                return;
            }
            case 14: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 2, argv, null);
                }
                interp.setResult(interp.getVar("tcl_patchLevel", 1));
                return;
            }
            case 15: {
                String pattern = null;
                if (argv.length != 2 && argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?pattern?");
                }
                if (argv.length == 3) {
                    pattern = argv[2].toString();
                }
                StringBuffer sbuf = new StringBuffer();
                Enumeration e = interp.cmdTable.keys();
                while (e.hasMoreElements()) {
                    Command cmd;
                    String key = (String)e.nextElement();
                    if (pattern != null && !Util.stringMatch(key, pattern) || !((cmd = (Command)interp.cmdTable.get(key)) instanceof Procedure)) continue;
                    Util.appendElement(interp, sbuf, key);
                }
                interp.setResult(TclString.newInstance((StringBuffer)sbuf));
                return;
            }
            case 16: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 2, argv, null);
                }
                interp.setResult(TclString.newInstance((String)interp.scriptFile));
                return;
            }
            case 17: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 2, argv, null);
                }
                interp.setResult(".class");
                return;
            }
            case 18: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 2, argv, null);
                }
                interp.setResult(interp.getVar("tcl_version", 1));
                return;
            }
            case 19: {
                if (argv.length != 2 && argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?pattern?");
                }
                if (argv.length == 2) {
                    this.matchAndAppend(interp, interp.varFrame.getVarNames(), null);
                } else {
                    this.matchAndAppend(interp, interp.varFrame.getVarNames(), argv[2].toString());
                }
                return;
            }
        }
        throw new TclException(interp, String.valueOf(argv[0]) + " " + argv[1] + " function not yet implemented");
    }

    private void matchAndAppend(Interp interp, Enumeration e, String pattern) {
        StringBuffer sbuf = new StringBuffer();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (pattern != null && !Util.stringMatch(key, pattern)) continue;
            try {
                Util.appendElement(interp, sbuf, key);
            }
            catch (TclException excp) {
                throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)excp));
            }
        }
        interp.setResult(TclString.newInstance((StringBuffer)sbuf));
    }

    private void matchAndAppend(Interp interp, Vector v, String pattern) {
        StringBuffer sbuf = new StringBuffer();
        int length = v.size();
        int i = 0;
        while (i < length) {
            String key = (String)v.elementAt(i);
            if (pattern == null || Util.stringMatch(key, pattern)) {
                try {
                    Util.appendElement(interp, sbuf, key);
                }
                catch (TclException excp) {
                    throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)excp));
                }
            }
            ++i;
        }
        interp.setResult(TclString.newInstance((StringBuffer)sbuf));
    }

    InfoCmd() {
    }
}

