# cmdcategory.tcl --
#
#       This script contains category information about the Tix
#       commands.
#
#       This script is source'd by man2html-pdffix.tcl and other
#       scripts that produce documentation for Tix.
#
# Copyright (c) 2000-2001 Tix Project Group.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# $Id: cmdcategory.tcl,v 1.1 2001/02/27 05:42:15 ioilam Exp $

namespace eval ::cmdcategory {
    set categories {
        intro
        standard_widget
        mega_widget
        display_item
        image_type
        other_cmd
        executable
    }

    set title(intro) {
        Introduction to the Tix Library
    }
    set cmds(intro) {
        TixIntro
    }

    set title(standard_widget) {
        Standard Widgets
    }
    set cmds(standard_widget) {
        tixGrid
        tixHList
        tixInputOnly
        tixNBFrame
        tixTList
    }

    set title(mega_widget) {
        Mega Widgets
    }
    set cmds(mega_widget) {
        tixBalloon
        tixButtonBox
        tixCheckList
        tixComboBox
        tixControl
        tixDirList
        tixDirSelectDialog
        tixDirTree
        tixExFileSelectBox
        tixExFileSelectDialog
        tixFileEntry
        tixFileSelectBox
        tixFileSelectDialog
        tixLabelEntry
        tixLabelFrame
        tixListNoteBook
        tixMeter
        tixNoteBook
        tixOptionMenu
        tixPanedWindow
        tixPopupMenu
        tixScrolledHList
        tixScrolledListBox
        tixScrolledText
        tixScrolledWindow
        tixSelect
        tixStdButtonBox
        tixTree
    }

    set title(display_item) {
        Display Items
    }
    set cmds(display_item) {
        tixDisplayStyle
    }

    set title(image_type) {
        Image Types
    }
    set cmds(image_type) {
        compound
        pixmap
    }
     
    set title(other_cmd) {
        Other Commands
    }
    set cmds(other_cmd) {
        tixDestroy
        tixForm
        tixMwm
        tix
        tixGetBoolean
        tixGetInt
        tixUtils
    }

    set title(executable) {
        Executable Programs
    }
    set cmds(executable) {
        tixwish
    }
}

