/* ANREP defined constants that one might want to modify
   It is advisable not to change the entries with a !.   */

#define	VERSION	 "ANREP Version 1.3 (8/7/92)\n"	  /* Version header! */

#define SIGMA    128	/* ASCII alphabet size!  */

#define PCHAR    ';'	/* Statement termination char! */
#define ICHAR    '+'	/* Insertion symbol! */
#define DCHAR    '-'	/* Deletion symbol! */
#define SCHAR    '^'	/* All other characters symbol! */
#define ECHAR    '$'	/* Epsilon / gap symbol! */

#define INIT_MATRIX  "Unitary"	/* Name of default scoring scheme */

#define HPRIME   2099		/* Id hash table size (pick a prime please) */
#define MAXID    1024		/* Maximum number of identifiers */
#define MAXSTR   (16*MAXID)	/* Maximum chars in all identifiers */

#define BUFMAX   80		/* Specification input line size */

#define PARMAX   50		/* Maximum number of parameter allowed */

#define NONE     (-1E10)	/* Largest negative value (== not allowed */

#define HEADER_MAX   1000	/* Maximum search file header size */

#define MAXMATCH    10000	/* Maximum span of matched substring */

#define OVERLAP  0.9		/* Maximum overlap % between reported matches */
