#include <stdio.h>
#include <string.h>
#include "anrep.h"

#define PLAIN 0			/* supported formats */
#define FASTA 1

static int type, first;		/* current format type, first record? */

static FILE *unit;		/* current file */

/* Given "format" string from search command and opened "file" for i/o.
   Record file globally in "unit" so other routines know what file to
   do i/o on.  Also convert format to an integer case code and store
   globally in "type".  Finally set global "first" to true so other
   routines can know whether its the first time they've been called.
*/

int Start_scan(format,file) char *format; FILE *file;
{ unit = file;
  first = 1;
  if (*format == '\0' || strcmp(format,"PLAIN") == 0)
    type = PLAIN;
  else if (strcmp(format,"FASTA") == 0)
    type = FASTA;
  else
    return (1);
  return (0);
}

static char hbuf[HEADER_MAX+2];	   /* buffering globals for FASTA format */

static int eof, newline, sym1;

/* Next_header is to return a char pointer to the header string
   for the next entry.  If there is no next entry it should return
   0 (null pointer) to indicate this.  The string pointed to must
   stay extent til the next call to the routine.  It is the string
   printed with a match if one is found in the next entry.
*/

char *Next_header()
{ switch (type)

  { case PLAIN:
      if (first)
        { first = 0;
          return ("NO HEADER\n");
        }
      return (0);

    case FASTA:
      { register int hlen, len;
        static char sbuf[HEADER_MAX+1];

        if (first)
          { first = 0;
            if (fgets(hbuf,HEADER_MAX+1,unit) == NULL) return (0);
            eof = 0;
          }
        if (eof) return (0);
        hlen = strlen(hbuf);
        newline = (hbuf[hlen-1] == '\n');
        eof = ((sym1 = fgetc(unit)) == EOF);
        while (!eof && (!newline || sym1 == '>'))
          { if (hlen < HEADER_MAX) hbuf[hlen++] = sym1;
            if (sym1 != '\n')
              { fgets(sbuf,HEADER_MAX+1,unit);
                len = strlen(sbuf);
                newline = (sbuf[len-1] == '\n');
                if (len > HEADER_MAX-hlen) len = HEADER_MAX-hlen;
                if (len > 0) strncpy(hbuf+hlen,sbuf,len);
                hlen += len;
              }
            else
              newline = 1;
            eof = ((sym1 = fgetc(unit)) == EOF);
          }
        if (hbuf[hlen-1] != '\n')
          hbuf[hlen++] = '\n';
        hbuf[hlen] = '\0';
        return (hbuf);
      }
  }
}

/* Get_sequence is to read the next "amnt" characters of a sequence
   entry and place them at location "where".  It should null-terminate
   the string it reads into "where".  If there are less than "amnt"
   characters left in the current entry, then it should read the
   remainder.
*/

void Get_sequence(where,amnt) char *where; int amnt;
{ switch (type)

  { case PLAIN:
      { register int len;

        len = fread(where,sizeof(char),amnt,unit);
        where[len] = '\0';
        return;
      }

    case FASTA:
      { register int len;

        if (eof)
          { where[0] = '\0';
            return;
          }
        if (sym1 != '\0')
          { *where++ = sym1;
            amnt -= 1;
            newline = (sym1 == '\n');
            sym1 = '\0';
          }
        while (amnt > 0)
          { eof = (fgets(where,amnt+1,unit) == NULL);
            len = strlen(where);
            if (eof || *where == '>' && newline)
              { if (!eof)
                  { if (len > HEADER_MAX) len = HEADER_MAX;
                    strncpy(hbuf,where,len);
                    hbuf[len] = '\0';
                  }
                break;
              }
            if (newline = (where[len-1] == '\n'))
              len = len-1;
            where += len;
            amnt  -= len;
          }
        *where = '\0';
        return;
      }
  }
}
