/* Scoring scheme datatype */

#include <stdio.h>
#include "anrep.h"

typedef struct metric { int    alpha;
                        int    map[SIGMA];
                        float *weight;
                      };

int    _alpha;
int   *_map;
float *_weight;

set_met(m) struct metric *m;
{ _alpha  = m->alpha;
  _map    = m->map;
  _weight = m->weight;
}

struct metric *alloc_met(a) int a;
{ register struct metric *m;
  register int i;
  if ((m = (struct metric *) malloc((unsigned) sizeof(struct metric))) == 0)
    fatal("out of memory");
  m->alpha = a++;
  for (i = 0; i < SIGMA; i++)
    m->map[i] = 0;
  if ((m->weight = (float *) malloc((unsigned) (sizeof(float)*a*a))) == 0)
    fatal("out of memory");
  set_met(m);
  return (m);
}

struct metric *init_met ()
{ register int i, j;
  register struct metric *m;
  m = alloc_met(SIGMA);
  for (i = 0; i < SIGMA; i++)
    m->map[i] = i + 1;
  for (i = 0; i <= m->alpha; i++)
    for (j = 0; j <= m->alpha; j++)
      m->weight[i*(m->alpha+1)+j] = 0.0;
  for (i = 1; i <= m->alpha; i++)
    { m->weight[i] = m->weight[i*(m->alpha+1)] = NONE;
      m->weight[i*(m->alpha+1)+i] = 1.0;
    }
  return (m);
}

free_met(m) struct metric *m;
{ free((char *) (m->weight));
  free((char *) m);
}
