/*

Obtained from Stephen Altschul at the NCBI on August 7, '92 and
modified by E. Myers on the same date to produce ANREP output and
to accept the i flag option.

This is a simple PAM matrix program.  You call it in the following manner:
  pam -n250 -s4.343 -iPAM250
The n flag is the PAM distance you want.  The s flag is a scale for the
matrix.  The default is half bits (2/ln 2), but Dayhoff used 1/10 Hartleys
(10/ln 10).  The i flag is the name given to the ANREP scoring scheme
output by the program on the standard output.
*/

#include <stdio.h>
#include <math.h>

char aa[21] = "ARNDCQEGHILKMFPSTWYV";

/*	Dayhoff amino acid background frequencies	*/

double fq[20] = {
8.713, 4.090, 4.043, 4.687, 3.347, 3.826, 4.953, 8.861, 3.362, 3.689,
8.536, 8.048, 1.475, 3.977, 5.068, 6.958, 5.854, 1.049, 2.992, 6.472};

/*	Dayhoff mutability data		*/

double mutab[20] = {
100.0,  65.0, 134.0, 106.0,  20.0,  93.0, 102.0,  49.0,  66.0,  96.0,
 40.0,  56.0,  94.0,  41.0,  56.0, 120.0,  97.0,  18.0,  41.0,  74.0};

/*	Dayhoff mutation data		*/

int mut[190] = {
 30,
109, 17,
154,  0,532,
 33, 10,  0,  0,
 93,120, 50, 76,  0,
266,  0, 94,831,  0,422,
579, 10,156,162, 10, 30,112,
 21,103,226, 43, 10,243, 23, 10,
 66, 30, 36, 13, 17,  8, 35,  0,  3,
 95, 17, 37,  0,  0, 75, 15, 17, 40,253,
 57,477,322, 85,  0,147,104, 60, 23, 43, 39,
 29, 17,  0,  0,  0, 20,  7,  7,  0, 57,207, 90,
 20,  7,  7,  0,  0,  0,  0, 17, 20, 90,167,  0, 17,
345, 67, 27, 10, 10, 93, 40, 49, 50,  7, 43, 43,  4,  7,
772,137,432, 98,117, 47, 86,450, 26, 20, 32,168, 20, 40,269,
590, 20,169, 57, 10, 37, 31, 50, 14,129, 52,200, 28, 10, 73,696,
  0, 27,  3,  0,  0,  0,  0,  0,  3,  0, 13,  0,  0, 10,  0, 17, 0,
 20,  3, 36,  0, 30,  0, 10,  0, 40, 13, 23, 10,  0,260,  0, 22, 23,  6,
365, 20, 13, 17, 33, 27, 37, 97, 30,661,303, 17, 77, 10, 50, 43, 186, 0, 17};

double M[8][20][20];
double pam[2][20][20];

main(argc,argv)
        int argc;
        char *argv[];
{
	int i,j,k,l,n,index,q,qq,first;
	double t,sc,log(),atof();
        char *name;

	n=120;
	sc=2/log(2.0);
	name="Dayhoff";
        for (i=1;i<argc;++i) if (argv[i][0]=='-') switch (argv[i][1]) {
                case 'n' :
			n=atoi(argv[i]+2);
                        break;
                case 's' :
			sc=atof(argv[i]+2);
                        break;
		case 'i' :
			name=argv[i]+2;
			break;
                default  :
                        break;
        }

	/* Normalize background frequencies */

	for (t=i=0;i<20;++i) t+=fq[i];
	for (i=0;i<20;++i) fq[i]/=t;

	/* Calculate transition matrix for 1 PAM */

	for (k=0,i=1;i<20;++i) for (j=0;j<i;++j)
		M[0][j][i] = M[0][i][j] = mut[k++];
	for (t=i=0;i<20;++i) t+=mutab[i]*fq[i];
	t*=100.0;
	for (i=0;i<20;++i) M[0][i][i]=1.0-(mutab[i]/=t);
	for (i=0;i<20;++i) {
		for (t=j=0;j<20;++j) if (j!=i) t+=M[0][i][j];
		for (j=0;j<20;++j) if (j!=i) M[0][i][j]*=mutab[i]/t;
	}

	for (i=qq=first=index=1;(index*=2)<=n;++i)
		for (j=0;j<20;++j)
			for (k=0;k<20;++k)
				for (M[i][j][k]=l=0;l<20;++l)
					M[i][j][k]+=M[i-1][j][l]*M[i-1][l][k];

	for (;n;n-=index) {
		for (;index>n;index/=2) --i;
		if (first) for (j=first=q=0;j<20;++j) for (k=0;k<20;++k)
			pam[0][j][k]=M[i][j][k];
		else for (j=0;j<20;++j) for (k=0;k<20;++k)
			for (pam[q][j][k]=l=0;l<20;++l)
				pam[q][j][k]+=pam[qq][j][l]*M[i][l][k];
		q=1-q;
		qq=1-qq;
	}

	printf("score %s = [",name);
        for (j=0;j<20;j++) printf("%c",aa[j]);
        printf("] {\n");
	for (k=0;k<20;++k) {
		for (j=0;j<=k;++j) {
			t=log(pam[qq][j][k]/fq[k]);
			printf("\t<%c.%c> # %4.0f;\n",aa[k],aa[j],t*sc);
		}
	}
	printf("};\n");

  exit (0);
}
