/* Parse tree datatype */

#include <stdio.h>
#include <string.h>
#include "anrep.h"
#include "metric.h"
#include "partree.h"

static struct node *freelist = 0;

struct node *newref(p) struct node *p;
{ if (p != 0)
    p->rcnt += 1;
  return (p);
}

struct node *binary(la,lp,rp) int la; struct node *lp, *rp;
{ register struct node *p;
  if ((p = (struct node *) malloc(sizeof(struct node))) == 0)
    fatal("out of memory");
  p->label = la;
  p->lft   = newref(lp);
  p->rgt   = newref(rp);
  p->rcnt  = 0;
  p->lnk   = freelist;
  freelist = p;
  return (p);
}

struct node *ileaf(la,iv) int la, iv;
{ register struct icons *p;
  if ((p = (struct icons *) malloc(sizeof(struct node))) == 0)
    fatal("out of memory");
  p->label = la;
  p->ival  = iv;
  p->rcnt  = 0;
  p->lnk   = freelist;
  freelist = p->lnk;
  return ((struct node *) p);
}

struct node *fleaf(la,fv) int la; float fv;
{ register struct fcons *p;
  if ((p = (struct fcons *) malloc(sizeof(struct node))) == 0)
    fatal("out of memory");
  p->label = la;
  p->fval  = fv;
  p->rcnt  = 0;
  p->lnk   = freelist;
  freelist = p->lnk;
  return ((struct node *) p);
}

struct node *mleaf(la,mv) int la; metric mv;
{ register struct mcons *p;
  if ((p = (struct mcons *) malloc(sizeof(struct node))) == 0)
    fatal("out of memory");
  p->label = la;
  p->mval  = mv;
  p->rcnt  = 0;
  p->lnk   = freelist;
  freelist = p->lnk;
  return ((struct node *) p);
}

struct node *sleaf(la,mv,iv,sv) int la; metric mv; float *iv, *sv;
{ register struct scons *p;
  if ((p = (struct scons *) malloc(sizeof(struct node))) == 0)
    fatal("out of memory");
  p->label = la;
  p->mval  = mv;
  p->ins   = iv;
  p->sub   = sv;
  p->rcnt  = 0;
  p->lnk   = 0;
  return ((struct node *) p);
}

keeptree()
{ register struct node *p;
  while (freelist != 0)
    { p = freelist;
      freelist = p->lnk;
      p->lnk = 0;
    }
}

freetree()
{ register struct node *p;
  for (p = freelist; p != 0; p = p->lnk)
    if (p->label < Lint)
      { if (p->lft != 0) p->lft->rcnt -= 1;
        if (p->rgt != 0) p->rgt->rcnt -= 1;
      }
  while (freelist != 0)
    { p = freelist;
      freelist = p->lnk;
      if (p->label == Lmet)
        free_met(((struct mcons *) p)->mval);
      free((char *) p);
    }
}

decref(p) struct node *p;
{ p->rcnt -= 1;
  if (p->rcnt > 0) return;
  if (p->label < Lint)
    { if (p->lft != 0) decref(p->lft);
      if (p->rgt != 0) decref(p->rgt);
    }
  if (p->label == Lmet)
    free_met(((struct mcons *) p)->mval);
  free((char *) p);
  if (p == freelist)
    freelist = 0;
}

static char graph[80], *tbase = 0;

static char *sym[] =
{   "Tnil", "Tmet", "Tint", "Tflp", "Talp", "Tmot", "Tnet",
    "Nor", "Ncon", "Nopt", "Nmot", "Nspacer", "Nref", 
    "Mor", "Mmet", "Mwgt", "Mcon", "Mopt", "Mref",
    "Lwgt", "Lcon", "Lmax", "Lavg", "Lmin", "Ldef",
    "Acon",
    "Lint", "Lsymb", "Lins", "Lsub", "Ldel", "Ldot", "Lfp", "Lflp", "Lmet"
};

static display(ind,sec,p) int ind, sec; struct node *p;
{ printf("%s_%s",graph,sym[p->label]);
  printf("[%d,%d]",p->rcnt,(((char *) p) - tbase) - 99000);
  if (sec) graph[ind] = ' ';
  strcat(graph," |");
  if (p->label < Lint)
    { printf("\n");
      if (p->rgt != 0)
        display(ind+2,0,p->rgt);
      if (p->lft != 0)
        display(ind+2,1,p->lft);
    }
  else if (p->label < Lflp)
    printf(" == %d\n",((struct icons *) p)->ival);
  else if (p->label < Lmet)
    printf(" == %f\n",((struct fcons *) p)->fval);
  else
    printf(" == Met\n");
  graph[ind+1] = '\0';
}

showtree(p) struct node *p;
{ strcpy(graph,"|");
  printf("\n\n");
  display(0,1,p);
}
