/* Parse tree datatype */

#define Nor      7
#define Ncon     8
#define Nopt     9
#define Nmot    10
#define Nspacer 11
#define Nref    12

#define Mor     13
#define Mmet    14
#define Mwgt    15
#define Mcon    16
#define Mopt    17
#define Mref    18

#define Lwgt    19
#define Lcon    20
#define Lmax    21
#define Lavg    22
#define Lmin    23
#define Ldef    24

#define Acon    25

#define Lint    26
#define Lsymb   27
#define Lins    28
#define Lsub    29
#define Ldel    30
#define Ldot    31
#define Lfp     32
#define Lflp    33
#define Lmet    34
#define Lvec    35

typedef struct node { struct node *lnk;
                      int          rcnt, label;
                      struct node *lft, *rgt;
                    } node;

#define IVAL(p) (((struct icons *) (p))->ival)
#define FVAL(p) (((struct fcons *) (p))->fval)
#define MVAL(p) (((struct mcons *) (p))->mval)
#define VINS(p) (((struct scons *) (p))->ins )
#define VSUB(p) (((struct scons *) (p))->sub )

typedef struct icons { struct node *lnk;
                       int          rcnt, label;
                       int          ival;
                     } icons;

typedef struct fcons { struct node *lnk;
                       int          rcnt, label;
                       float        fval;
                     } fcons;

typedef struct mcons { struct node *lnk;
                       int          rcnt, label;
                       metric       mval;
                     } mcons;

typedef struct scons { struct node *lnk;
                       int         rcnt, label;
                       metric      mval;
                       float       *ins, *sub;
                     } scons;

extern struct node *binary(), *ileaf(), *fleaf(), *mleaf(), *sleaf(), *newref();

extern keeptree(), freetree(), decref(), showtree();
