/* Metric constructor module */

#include <stdio.h>
#include <ctype.h>
#include "anrep.h"
#include "metric.h"
#include "partree.h"

static FILE *mfile;
static char *mname = "..m";
static char *cname = "..c";
static char *ename = "..e";
static int a;
static metric met;
static node *alphabet;

INIT_MET(p) register node *p;
{ register int i, j;

  a = 0;
  met = NULL;
  alphabet = p;
  for (i = 0; p != 0; p = p->lft, i++);
  met = alloc_met(i);
  for (p = alphabet; p != 0; p = p->lft)
    MAP(IVAL(p->rgt)) = 1;
  for (i = j = 0; i < SIGMA; i++)
    if (MAP(i) != 0)
      MAP(i) = ++j;
  mfile = fopen(cname,"w");
  if (mfile == NULL)
    fatal("can't open .c file",0);
  fprintf(mfile,"#include <stdio.h>\n");
  fprintf(mfile,"int m[%d];\n",SIGMA);
  fprintf(mfile,"main(){\n");
  fprintf(mfile,"register int X,x,Y,y,i,j,a[%d];\n",ALPHA+1);
  fprintf(mfile,"float w[%d];\n",(ALPHA+1)*(ALPHA+1));
  fprintf(mfile,"FILE *f;\n");
  fprintf(mfile,"for(i=0;i<%d;w[i++]=(%g));\n",(ALPHA+1)*(ALPHA+1),NONE);
}

INIT_DECL(p,o,q) register node *p, *q; char o;
{ register node *r;
  register int x, y;
  static char *emsg = "the symbol '%' is not in the alphabet";

  if (p == NULL)
    { if (!a)
        { for (a = 0; a < SIGMA; a++)
            if (MAP(a) != 0)
              fprintf(mfile,"m[%d]=%d;\n",a,MAP(a));
	  fprintf(mfile,"a[0]=0;\n");
	  for (a = 1, p = alphabet; p != 0; p = p->lft, a++)
	    fprintf(mfile,"a[%d]=%d;\n",a,IVAL(p->rgt));
	}
      fprintf(mfile,"for(X=x=a[i=0];i<%d;X=x=a[++i])\n",ALPHA+1);
      fprintf(mfile,"for(Y=y=a[j=0];j<%d;Y=y=a[++j])\n",ALPHA+1);
      fprintf(mfile,"if(");
    }
  else
    { if (q == NULL)
        q = alphabet;
      for (r = q; p != NULL; p = p->lft)
        { if (p->rgt->label == Ldel)
	    x = 0;
          else if (p->rgt->label == Lsymb  &&  MAP(IVAL(p->rgt)) > 0)
	    x = MAP(IVAL(p->rgt));
	  else
	    { emsg[12] = IVAL(p->rgt);
	      error(emsg,0);
	    }
          for (q = r; q != NULL; q = q->lft)
	    { if (q->rgt->label == Ldel)
	        y = 0;
              else if (q->rgt->label == Lsymb  &&  MAP(IVAL(q->rgt)) > 0)
	        y = MAP(IVAL(q->rgt));
	      else
	        { emsg[12] = IVAL(q->rgt);
	          error(emsg,0);
	        }
	      fprintf(mfile,"w[%d]=",x*(ALPHA+1)+y);
	      if (o == '.'  &&  x != y)
	        fprintf(mfile,"w[%d]=",y*(ALPHA+1)+x);
	    }
        }
      fprintf(mfile,"(");
    }
}

DEPOSIT(c) char c; { fputc(c,mfile); }

GLUE_DECL() { fprintf(mfile,")w[m[x]*%d+m[y]]=(",ALPHA+1); }

FINI_DECL(p) register node *p;
{ if (p != NULL)
    if (p->label == Lint)
      fprintf(mfile,"%d",IVAL(p));
    else
      fprintf(mfile,"%g",FVAL(p));
  fprintf(mfile,");\n");
}

metric FINI_MET()
{ char cmd[64];

  fprintf(mfile,"if(!(f=fopen(\"%s\",\"w\")))exit(1);\n",mname);
  fprintf(mfile,"if(fwrite(w,sizeof(*w),%d,f)!=%d)exit(1);\n",
                (ALPHA+1)*(ALPHA+1),(ALPHA+1)*(ALPHA+1));
  fprintf(mfile,"if(fclose(f)==EOF)exit(1);\n");
  fprintf(mfile,"exit(0);\n");
  fprintf(mfile,"}\n");
  fclose(mfile);
  mfile = NULL;
  sprintf(cmd,"cc -o %s %s",ename,cname);
  if (system(cmd) != 0)
    error("invalid C expression in metric definition",0);
  sprintf(cmd,"%s",ename);
  if (system(cmd) != 0)
    { CLEAN_MET(1);
      fatal("can't open/write/close .m file",0);
    }
  mfile = fopen(mname,"r");
  if (mfile == NULL)
    { CLEAN_MET(1);
      fatal("can't open .m file",0);
    }
  if (fread((char *)_weight,sizeof(_weight),(ALPHA+1)*(ALPHA+1),mfile)
       != (ALPHA+1)*(ALPHA+1))
    { CLEAN_MET(1);
      fatal("error in reading .m file",0);
    }
  fclose(mfile);
  mfile = NULL;
  CLEAN_MET(0);

#ifdef DEBUG
  { register int i, j;
    for (i = 0; i <= ALPHA; i++)
      { for (j = 0; j <= ALPHA; j++)
          printf("%f   ",WEIGHT(i,j));
        printf("\n");
      }
  }
#endif

  return(met);
}

CLEAN_MET(f) int f;
{ if (mfile != NULL)
    { fclose(mfile);
      mfile = NULL;
    }
  unlink(mname);
#ifndef DEBUG
  unlink(cname);
#endif
  unlink(ename);
  if (met != NULL  &&  f)
    free_met(met);
}
