/* Symbol table datatype */

#include <stdio.h>
#include <string.h>
#include "anrep.h"
#include "metric.h"
#include "partree.h"
#include "symbol.h"

char *index(s,c) register char *s, c;
{ while (*s != '\0'  &&  *s != c)
    s++;
  return(*s == c ? s : NULL);
}

static struct entry **htab;

static struct entry *object, *folist;

static char *lits, *litop, *litend;

static unsigned char test[4] = {0x00, 0x01, 0x02, 0x03};

static int MTYPE;

inithash()
{ register int i;
  register struct entry *e;

  MTYPE = (*(unsigned long *)test == 0x00010203);

  if ((htab   = (struct entry **) malloc((unsigned) sizeof(struct entry *)*HPRIME)) == 0)
  	fatal("out of memory");
  for (i = 0; i < HPRIME; i++)
    htab[i] = NULL;
  if ((object = (struct entry  *) malloc((unsigned) sizeof(struct entry  )* MAXID)) == 0)
  	fatal("out of memory");
  if ((lits   = (char *) malloc((unsigned) sizeof(char)*MAXSTR)) == 0)
  	fatal("out of memory");
  litop  = lits;
  litend = lits + MAXSTR;
  folist = object + (MAXID-1);
  for (e = folist; e > object; e--)
    e->chain = e-1;
  e->chain = 0;
}

struct entry *add(loc,len) char *loc; int len;
{ int hval;
  register int i;
  register char *p, *q;
  register struct entry *e, *f, *g;

  hval = hash(loc,len);
  for (e = htab[hval]; e != 0; e = e->chain)
    if (strncmp(e->name,loc,len) == 0 && e->name[len] == '\0')
      return (e);
  if (folist == 0 || litop+len >= litend)
    { for (i = 0; i < HPRIME; i++)
        { e = htab[i];
          f = 0;
          while (e != 0)
            if (e->type == Tnil && ! e->param)
              { *(e->name) = '\0';
                if (f == 0)
                  htab[i] = e->chain;
                else
                  f->chain = e->chain;
                g = e->chain;
                e->chain = folist;
                folist = e;
                e = g;
              }
            else
              { f = e;
                e = e->chain;
              }
        }
      q = p = lits;
      while (p < litop)
        if (*p == '\0')
          p = index(p+1,'\0') + 1;
        else
          { strcpy(q,p);
            i = strlen(q);
            e = htab[hash(q,i++)];
            while (e->name != p)
              e = e->chain;
            e->name = q;
            p += i;
            q += i;
          }
      litop = q;
    }
  if (folist == 0 || litop+len >= litend)
    fatal("symbol table full");
  e = folist;
  folist   = folist->chain;
  e->type  = Tnil;
  e->param = 0;
  e->name  = litop;
  e->chain = htab[hval];
  htab[hval] = e;
  strncpy(litop,loc,len);
  litop[len++] = '\0';
  litop += len;
  return(e);
}

static int hash(loc,len) char *loc; int len;
{ register unsigned long *lbeg, *lend, hvalue;
  static unsigned long mask[2][4] = {
    {0x00000000, 0x000000FF, 0x0000FFFF, 0x00FFFFFF},
    {0x00000000, 0xFF000000, 0xFFFF0000, 0xFFFFFF00}
  };

  lbeg = (unsigned long *) loc;
  lend = lbeg + (unsigned long) (len/4);
  hvalue = *lend & mask[MTYPE][len%4];
  while (lbeg < lend)
    hvalue ^= *lbeg++;
  return ((int)(hvalue%(unsigned long)HPRIME));
}

struct entry *get (p) register struct node *p;
{ register char *s;
  register struct entry *e;

  for (s = lits; s != litop; s += strlen(s)+1)
    { e = add(s,strlen(s));
      if (p == e->tree)
        return(e);
    }
  return(NULL);
}

static char tnames[] = { '?', 'S', 'I', 'F', 'A', 'M', 'N' };

int showvar(e) struct entry *e;
{ register int i;
  fprintf(stdout,"\n  %s :: %c",e->name,tnames[e->type]);
  if (e->nform > 0)
    { fprintf(stdout,"(%c",tnames[e->tform[0]]);
      for (i = 1; i < e->nform; i++)
        fprintf(stdout,",%c",tnames[e->tform[i]]);
      fprintf(stdout,")");
    }
  if (Tmet <= e->type && e->type <= Tnet)
    showtree(e->tree);
  fprintf(stdout,"\n\n");
}
