#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#ifdef __MSDOS__
#include<stdlib.h>
#endif
/*
   chkfont
   By Glenn Chappell (ggc@uiuc.edu)
   November 4, 1993

   This program checks Figlet 2.0 font files for formatting errors.

   Usage: chkfont fontfile ...

   Note: this is very much a spare-time project. It's probably full o'
   bugs ....
*/

#define FONTFILESUFFIX ".flf"
#define FONTFILEMAGICNUMBER "flf2"

char *myname,*fontfilename;
FILE *fontfile;
char hardblank;
int charheight,upheight,charwidthlimit=0,defaultmode;
char *inputline;
int maxlinelength=0,currline;
int ec,wc;

int incon_endchar,endchar_count;
int gone;

/* Function prototypes to stop Borland C++ from barfing */
#ifdef __MSDOS__
void weregone(int really);
void checkit(void);
void readchar(void);
void usageerr(void);
char *my_alloc(int size);
#endif

#ifdef __MSDOS__
void weregone(int really)
#else
weregone(really)
int really;
#endif
{
if (!really && ec<=20) {
  return;
  }
if (ec+wc>0) printf("*******************************************************************************\n");
if (!really && (ec+wc>20)) {
  printf("%s: Too many errors.\n",fontfilename);
  }
printf("%s: Errors: %d, Warnings: %d\n",fontfilename,ec,wc);
if (currline>1) {
  printf("%s: charwidthlimit: %d, actual max line length: %d\n",
    fontfilename,charwidthlimit,maxlinelength);
  }
printf("-------------------------------------------------------------------------------\n");
gone=1;
}

#ifdef __MSDOS__
char *my_alloc(int size)
#else
char *my_alloc(size)
int size;
#endif
{
char *ptr;

ptr=malloc(size);
if (ptr==NULL) {
  fprintf(stderr,"%s: Out of memory\n",myname);
  exit(1);
  }
  return(ptr);
}


#ifdef __MSDOS__
void usageerr(void)
#else
usageerr()
#endif
{
#ifdef __MSDOS__
   char *ptr;
   ptr = strrchr(myname,'\\');
   if (ptr) myname = ptr+1;     /* cut out path */
   ptr = strrchr(myname,'.');
   if (ptr) *ptr='\0';          /* cut out .exe extension */
#endif
fprintf(stderr,"chkfont by Glenn Chappell (ggc@uiuc.edu), ");
fprintf(stderr,"November 4, 1993.\n");
fprintf(stderr,"Checks Figlet 2.0 font files for format errors.\n");
fprintf(stderr,"Usage: %s fontfile ...\n",myname);
exit(1);
}


#ifdef __MSDOS__
void readchar(void)
#else
readchar()
#endif
{
int i,expected_width,k,len,diff;
char endchar,expected_endchar;

for (i=0;i<charheight;i++) {
  fgets(inputline,charwidthlimit+1000,fontfile);
  if (feof(fontfile)) {
    printf("%s: ERROR (fatal)- Unexpected end of file after line %d.\n",
      fontfilename,currline);
    ec++;
    weregone(1); if (gone) return;
    }
  currline++;
  len=strlen(inputline)-1;
  if (len>maxlinelength) {
    maxlinelength=len;
    }
  if (len>charwidthlimit) {
    printf("%s: ERROR- Line length > charwidthlimit in line %d.\n",
      fontfilename,currline);
    ec++;
    weregone(0); if (gone) return;
    }
  k=len;
  endchar=k<0?'\0':(k==0||inputline[k]!='\n')?inputline[k]:inputline[k-1];
  for(;k>=0?(inputline[k]=='\n' || inputline[k]==endchar):0;k--) {
    inputline[k]='\0';
    }
  if (i==0) {
    expected_endchar=endchar;
    expected_width=strlen(inputline);
    if (endchar==' ') {
      printf("%s: Warning- Blank endchar in line %d.\n",
        fontfilename,currline);
      wc++;
      weregone(0); if (gone) return;
      }
    }
  else {
    if (endchar!=expected_endchar && !incon_endchar) {
      printf("%s: Warning- Inconsistent endchar in line %d.\n",
        fontfilename,currline);
      printf("%s:          (Above warning will only be printed once.)\n"
        ,fontfilename);
      incon_endchar = 1;
      wc++;
      weregone(0); if (gone) return;
      }
    if (strlen(inputline)!=expected_width) {
      printf("%s: ERROR- Inconsistent character width in line %d.\n",
        fontfilename,currline);
      ec++;
      weregone(0); if (gone) return;
      }
    }
  diff=len-strlen(inputline);
  if (diff<1||diff>2|| (charheight>1 &&
                        ((i<charheight-1&&diff!=1)||(i==charheight-1&&diff!=2))
                       )
     ) {
    if (!endchar_count) {
      printf("%s: Warning- Endchar count convention violated in line %d.\n",
        fontfilename,currline);
      printf("%s:          (Above warning will only be printed once.)\n"
        ,fontfilename);
      endchar_count = 1;
      wc++;
      weregone(0); if (gone) return;
      }
    }
  }
}


#ifdef __MSDOS__
void checkit(void)
#else
checkit()
#endif
{
int i,k,cmtcount;
char magicnum[5],cha;

ec=0;wc=0;
incon_endchar=0; endchar_count=0;
gone=0;
fontfile=fopen(fontfilename,"r");
if (fontfile == NULL) {
  fprintf(stderr,"%s: Could not open file '%s'\n",myname,fontfilename);
  exit(1);
  }

if (strlen(fontfilename)<strlen(FONTFILESUFFIX)?1
  :strcmp(fontfilename+strlen(fontfilename)-4,FONTFILESUFFIX)) {
  printf("%s: ERROR- Filename does not end with '%s'.\n",
    fontfilename,FONTFILESUFFIX);
  ec++;
  weregone(0); if (gone) return;
  }
fscanf(fontfile,"%4s",magicnum);
if (strcmp(magicnum,FONTFILEMAGICNUMBER)) {
  printf("%s: ERROR- Incorrect magic number.\n",fontfilename);
  ec++;
  weregone(0); if (gone) return;
  }
cha=getc(fontfile);
if (cha!='a') {
  printf("%s: Warning- Sub-version character is not 'a'.\n",fontfilename);
  wc++;
  weregone(0); if (gone) return;
  }
if (6!=fscanf(fontfile,"%c %d %d %d %d %d"
  ,&hardblank,&charheight,&upheight,&charwidthlimit,&defaultmode,&cmtcount)) {
  printf("%s: ERROR (fatal)- First line improperly formatted.\n",fontfilename);
  ec++;
  weregone(1); if (gone) return;
  }
if (hardblank!='$' && hardblank!=0x7f) {
  printf("%s: Warning- Unusual hardblank.\n",fontfilename);
  wc++;
  weregone(0); if (gone) return;
  }
if (charheight<1) {
  printf("%s: ERROR (fatal)- charheight not positive.\n",fontfilename);
  ec++;
  weregone(1); if (gone) return;
  }
if (upheight>charheight || upheight<1) {
  printf("%s: ERROR- up_height out of bounds.\n",fontfilename);
  ec++;
  weregone(0); if (gone) return;
  }
if (charwidthlimit<1) {
  printf("%s: ERROR (fatal)- charwidthlimit not positive.\n",fontfilename);
  ec++;
  weregone(1); if (gone) return;
  }
if (defaultmode<-1) {
  printf("%s: ERROR- defaultmode < -1.\n",fontfilename);
  ec++;
  weregone(0); if (gone) return;
  }
if (defaultmode>63) {
  printf("%s: Warning- defaultmode > 63.\n",fontfilename);
  wc++;
  weregone(0); if (gone) return;
  }
if (cmtcount<0) {
  printf("%s: ERROR- cmt_count not positive.\n",fontfilename);
  ec++;
  weregone(0); if (gone) return;
  }

for (i=0;i<=cmtcount;i++) {
  while(k=getc(fontfile),k!='\n'&&k!=EOF) ; /* Advance to end of line */
  }

maxlinelength = 0;
currline=cmtcount+1;
inputline=(char*)my_alloc(sizeof(char)*(charwidthlimit+1001));
for (i=0;i<102;i++) {
  readchar();
  if (gone) return;
  }
getc(fontfile);
currline++;
if (!feof(fontfile)) {
  printf("%s: Warning- Extra chars after font in line %d.\n",
    fontfilename,currline);
  wc++;
  weregone(0); if (gone) return;
  }
fclose(fontfile);

weregone(1); if (gone) return;
}


#ifdef __MSDOS__
void main(int argc,char **argv)
#else
main(argc,argv)
int argc;
char *argv[];
#endif
{
int arg;

if ((myname=strrchr(argv[0],'/'))!=NULL) {
  myname++;
  }
else {
  myname = argv[0];
  }
if (argc<2) {
  usageerr();
  }
for (arg=1;arg<argc;arg++) {
  fontfilename=argv[arg];
  checkit();
  }
}
