/*
 *  Ball And Paddle
 *
 *  Copyright (C) 2007 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#ifndef __BALL_H__
#define __BALL_H__

#include <cmath>
#include <iostream>
using namespace std;

#include "SDL.h"
#include "SDL_image.h"

#include "globals.h"
#include "block.h"
#include "paddle.h"
#include "powerup.h"
#include "gamestatemanager.h"

class Ball
{
  SDL_Surface *imgBall;
  double x;
  double y;
  int width;
  int height;
  double speed;
  double direction;
  bool attached;
  Paddle *attacher;
  double attachXOff;
  double attachYOff;
  void mirrorXDir ();
  void mirrorYDir ();
  void normalizeDirection ();
  void bounceTR ();
  void bounceTL ();
  void bounceBR ();
  void bounceBL ();
public:
    Ball (int x, int y, double direction, SDL_Surface * imgBall);
   ~Ball ();
  void draw (SDL_Surface * dest, bool powerBalls);
  void update (int time, vector < vector < Block * > >blocks, Paddle * paddle,
	       vector < PowerUp * >&powerUps, bool powerBalls, int &score,
	       GameStateManager * gameStateManager);
  void setAttached (Paddle * paddle);
  void setSpeed (double speed);
  Block *block_at (vector < vector < Block * > >blocks, int x, int y);
  Block *strong_block_at (vector < vector < Block * > >blocks, int x, int y);
  double getX ()
  {
    return x;
  }
  double getY ()
  {
    return y;
  }
  double getDirection ()
  {
    return direction;
  }
  double getSpeed ()
  {
    return speed;
  }
  void release ();
  bool isAttached ()
  {
    return attached;
  }
};

#endif
