// Copyright (C) 2000-2002 Open Source Telecom Corporation.
// 
// Author: Jeremy J. McNamara 
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <ivrconfig.h>
#include <server.h>
#include <cc++/audio.h>


#define	P_PLATFORM_HAS_THREADS
#define	P_PTHREADS
#define	P_HAS_SEMAPHORES
#define	NDEBUG

#ifdef	__linux__
#define	P_LINUX
#endif

#ifdef	__FreeBSD__
#define	P_FREEBSD
#endif

#include <ptlib.h>
typedef	WORD	PUInt16b;
typedef	DWORD	PUInt32b;
#include <h323.h>

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

class OH323Trunk;

typedef	bool (OH323Trunk::*trunkhandler_t)(TrunkEvent *event);


class OH323EndPoint : public H323EndPoint
{
  PCLASSINFO(OH323EndPoint, H323EndPoint);

  public:
    OH323EndPoint();
    ~OH323EndPoint();

    // overrides from H323EndPoint
	virtual BOOL OnIncomingCall(H323Connection &, const H323SignalPDU &, H323SignalPDU &);
//    virtual H323Connection * CreateConnection(unsigned callReference);
//    virtual H323Connection::AnswerCallResponse OnAnswerCall(H323Connection &, const PString &, const H323SignalPDU &, H323SignalPDU &);
//    virtual void OnConnectionEstablished(H323Connection & connection, const PString & token);
//    virtual void OnConnectionCleared(H323Connection & connection, const PString & clearedCallToken);
    
    BOOL Initialise();

};

class OH323Trunk : private Trunk, private TimerPort
{
private:
	friend class OH323Driver;
	static char status[250];

	trunkhandler_t handler;
	time_t lastring;
	int ts;

	void initSyms(void);
	bool postEvent(TrunkEvent *evt);
	void putEvent(TrunkEvent *evt);
	void timerTick(void);
	void exit(void);
	void getName(char *buffer);
	unsigned long getIdleTime(void);

	void rrunkStep(trunkstep_t step)
		{return;};

	OH323Trunk(tpport_t port, int ts);
	~OH323Trunk();
};

class OH323Config : public Keydata
{
public:
	OH323Config();

	tpport_t getFirstPort(void)
		{return atoi(getLast("first"));};

	unsigned getRTPCount(void)
		{return atoi(getLast("count"));};

	unsigned getRTPInc(void)
		{return atoi(getLast("inc"));};

	InetAddress getBindAddress(void);
};

class OH323Driver : public Driver, public OH323Config
{

	//PWLib entry point
	class PWLibProcess : public PProcess
	{
		PCLASSINFO(PWLibProcess, PProcess)

		public:
			void Main() { }
	
	} pwlibProcess;

protected:
   OH323EndPoint * endpoint;

private:
	OH323Trunk **ports;
	int port_count;

public:
	OH323Driver();
	~OH323Driver();

	int start(void);
	void stop(void);

	int getTrunkCount(void)
		{return port_count;};

	Trunk *getTrunkPort(int id);
	aaScript *getScript(void);
};

extern OH323Driver oh323ivr;

#ifdef	CCXX_NAMESPACES
};
#endif
