/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright (C) 2012-2019 Free Software Foundation, Inc.
   Contributed by ARM Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-dis.h"

/* Called by aarch64_opcode_lookup.  */

static int
aarch64_opcode_lookup_1 (uint32_t word)
{
  if (((word >> 26) & 0x1) == 0)
    {
      if (((word >> 25) & 0x1) == 0)
        {
          if (((word >> 27) & 0x1) == 0)
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 31) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         0xxx0000xxxxxxxxxxxxxxxxxxxxxxxx
                         adr.  */
                      return 1184;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         1xxx0000xxxxxxxxxxxxxxxxxxxxxxxx
                         adrp.  */
                      return 1185;
                    }
                }
              else
                {
                  if (((word >> 29) & 0x1) == 0)
                    {
                      if (((word >> 30) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             x00x0001xxxxxxxxxxxxxxxxxxxxxxxx
                             add.  */
                          return 12;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             x10x0001xxxxxxxxxxxxxxxxxxxxxxxx
                             sub.  */
                          return 16;
                        }
                    }
                  else
                    {
                      if (((word >> 30) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             x01x0001xxxxxxxxxxxxxxxxxxxxxxxx
                             adds.  */
                          return 14;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             x11x0001xxxxxxxxxxxxxxxxxxxxxxxx
                             subs.  */
                          return 17;
                        }
                    }
                }
            }
          else
            {
              if (((word >> 28) & 0x1) == 0)
                {
                  if (((word >> 22) & 0x1) == 0)
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x000xxxxx0xxxxxxxxxxxxxxx
                                                 stxrb.  */
                                              return 936;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x000xxxxx0xxxxxxxxxxxxxxx
                                                 stxrh.  */
                                              return 942;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x000xxxxx0xxxxxxxxxxxxxxx
                                             stxr.  */
                                          return 948;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0x00100x001xxxxx0xxxxxxxxxxxxxxx
                                             casp.  */
                                          return 1019;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x001xxxxx0xxxxxxxxxxxxxxx
                                             stxp.  */
                                          return 950;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x000xxxxx1xxxxxxxxxxxxxxx
                                                 stlxrb.  */
                                              return 937;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x000xxxxx1xxxxxxxxxxxxxxx
                                                 stlxrh.  */
                                              return 943;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x000xxxxx1xxxxxxxxxxxxxxx
                                             stlxr.  */
                                          return 949;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0x00100x001xxxxx1xxxxxxxxxxxxxxx
                                             caspl.  */
                                          return 1021;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x001xxxxx1xxxxxxxxxxxxxxx
                                             stlxp.  */
                                          return 951;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x010100x00xxxxxxxxxxxxxxxxxxxxxx
                                     stnp.  */
                                  return 968;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x110100x00xxxxxxxxxxxxxxxxxxxxxx
                                     stgp.  */
                                  return 977;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0x00100x100xxxxx0xxxxxxxxxxxxxxx
                                             stllrb.  */
                                          return 966;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x100xxxxx0xxxxxxxxxxxxxxx
                                             stllr.  */
                                          return 965;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x101xxxxx0xxxxxxxxxxxxxxx
                                                 casb.  */
                                              return 1007;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x101xxxxx0xxxxxxxxxxxxxxx
                                                 cash.  */
                                              return 1008;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x101xxxxx0xxxxxxxxxxxxxxx
                                             cas.  */
                                          return 1009;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x100xxxxx1xxxxxxxxxxxxxxx
                                                 stlrb.  */
                                              return 940;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x100xxxxx1xxxxxxxxxxxxxxx
                                                 stlrh.  */
                                              return 946;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x100xxxxx1xxxxxxxxxxxxxxx
                                             stlr.  */
                                          return 956;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x101xxxxx1xxxxxxxxxxxxxxx
                                                 caslb.  */
                                              return 1011;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x101xxxxx1xxxxxxxxxxxxxxx
                                                 caslh.  */
                                              return 1014;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x101xxxxx1xxxxxxxxxxxxxxx
                                             casl.  */
                                          return 1017;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x010100x10xxxxxxxxxxxxxxxxxxxxxx
                                     stp.  */
                                  return 978;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x110100x10xxxxxxxxxxxxxxxxxxxxxx
                                     stgp.  */
                                  return 983;
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x010xxxxx0xxxxxxxxxxxxxxx
                                                 ldxrb.  */
                                              return 938;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x010xxxxx0xxxxxxxxxxxxxxx
                                                 ldxrh.  */
                                              return 944;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x010xxxxx0xxxxxxxxxxxxxxx
                                             ldxr.  */
                                          return 952;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0x00100x011xxxxx0xxxxxxxxxxxxxxx
                                             caspa.  */
                                          return 1020;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x011xxxxx0xxxxxxxxxxxxxxx
                                             ldxp.  */
                                          return 954;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x010xxxxx1xxxxxxxxxxxxxxx
                                                 ldaxrb.  */
                                              return 939;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x010xxxxx1xxxxxxxxxxxxxxx
                                                 ldaxrh.  */
                                              return 945;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x010xxxxx1xxxxxxxxxxxxxxx
                                             ldaxr.  */
                                          return 953;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0x00100x011xxxxx1xxxxxxxxxxxxxxx
                                             caspal.  */
                                          return 1022;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x011xxxxx1xxxxxxxxxxxxxxx
                                             ldaxp.  */
                                          return 955;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x010100x01xxxxxxxxxxxxxxxxxxxxxx
                                     ldnp.  */
                                  return 969;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x110100x01xxxxxxxxxxxxxxxxxxxxxx
                                     ldpsw.  */
                                  return 976;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x110xxxxx0xxxxxxxxxxxxxxx
                                                 ldlarb.  */
                                              return 963;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x110xxxxx0xxxxxxxxxxxxxxx
                                                 ldlarh.  */
                                              return 964;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x110xxxxx0xxxxxxxxxxxxxxx
                                             ldlar.  */
                                          return 962;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x111xxxxx0xxxxxxxxxxxxxxx
                                                 casab.  */
                                              return 1010;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x111xxxxx0xxxxxxxxxxxxxxx
                                                 casah.  */
                                              return 1013;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x111xxxxx0xxxxxxxxxxxxxxx
                                             casa.  */
                                          return 1016;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x110xxxxx1xxxxxxxxxxxxxxx
                                                 ldarb.  */
                                              return 941;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x110xxxxx1xxxxxxxxxxxxxxx
                                                 ldarh.  */
                                              return 947;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x110xxxxx1xxxxxxxxxxxxxxx
                                             ldar.  */
                                          return 957;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x111xxxxx1xxxxxxxxxxxxxxx
                                                 casalb.  */
                                              return 1012;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x111xxxxx1xxxxxxxxxxxxxxx
                                                 casalh.  */
                                              return 1015;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x111xxxxx1xxxxxxxxxxxxxxx
                                             casal.  */
                                          return 1018;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x010100x11xxxxxxxxxxxxxxxxxxxxxx
                                     ldp.  */
                                  return 979;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x110100x11xxxxxxxxxxxxxxxxxxxxxx
                                     ldpsw.  */
                                  return 982;
                                }
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 31) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 0x011000xxxxxxxxxxxxxxxxxxxxxxxx
                                 ldr.  */
                              return 984;
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     10011000xxxxxxxxxxxxxxxxxxxxxxxx
                                     ldrsw.  */
                                  return 986;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     11011000xxxxxxxxxxxxxxxxxxxxxxxx
                                     prfm.  */
                                  return 987;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00111000000xxxxxxxxx00xxxxxxxxxx
                                                         sturb.  */
                                                      return 921;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01111000000xxxxxxxxx00xxxxxxxxxx
                                                         sturh.  */
                                                      return 926;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x111000000xxxxxxxxx00xxxxxxxxxx
                                                     stur.  */
                                                  return 929;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00111000010xxxxxxxxx00xxxxxxxxxx
                                                         ldurb.  */
                                                      return 922;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01111000010xxxxxxxxx00xxxxxxxxxx
                                                         ldurh.  */
                                                      return 927;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x111000010xxxxxxxxx00xxxxxxxxxx
                                                     ldur.  */
                                                  return 930;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001110001x0xxxxxxxxx00xxxxxxxxxx
                                                     ldursb.  */
                                                  return 923;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101110001x0xxxxxxxxx00xxxxxxxxxx
                                                     ldursw.  */
                                                  return 931;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011110001x0xxxxxxxxx00xxxxxxxxxx
                                                     ldursh.  */
                                                  return 928;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111110001x0xxxxxxxxx00xxxxxxxxxx
                                                     prfum.  */
                                                  return 932;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000001xxxxx000000xxxxxxxxxx
                                                                         ldaddb.  */
                                                                      return 1035;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000001xxxxx000000xxxxxxxxxx
                                                                         ldaddh.  */
                                                                      return 1036;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000001xxxxx000000xxxxxxxxxx
                                                                     ldadd.  */
                                                                  return 1037;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000101xxxxx000000xxxxxxxxxx
                                                                         ldaddab.  */
                                                                      return 1038;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000101xxxxx000000xxxxxxxxxx
                                                                         ldaddah.  */
                                                                      return 1041;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000101xxxxx000000xxxxxxxxxx
                                                                     ldadda.  */
                                                                  return 1044;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000011xxxxx000000xxxxxxxxxx
                                                                         ldaddlb.  */
                                                                      return 1039;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000011xxxxx000000xxxxxxxxxx
                                                                         ldaddlh.  */
                                                                      return 1042;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000011xxxxx000000xxxxxxxxxx
                                                                     ldaddl.  */
                                                                  return 1045;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000111xxxxx000000xxxxxxxxxx
                                                                         ldaddalb.  */
                                                                      return 1040;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000111xxxxx000000xxxxxxxxxx
                                                                         ldaddalh.  */
                                                                      return 1043;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000111xxxxx000000xxxxxxxxxx
                                                                     ldaddal.  */
                                                                  return 1046;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000001xxxxx100000xxxxxxxxxx
                                                                         swpb.  */
                                                                      return 1023;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000001xxxxx100000xxxxxxxxxx
                                                                         swph.  */
                                                                      return 1024;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000001xxxxx100000xxxxxxxxxx
                                                                     swp.  */
                                                                  return 1025;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000101xxxxx100000xxxxxxxxxx
                                                                         swpab.  */
                                                                      return 1026;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000101xxxxx100000xxxxxxxxxx
                                                                         swpah.  */
                                                                      return 1029;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000101xxxxx100000xxxxxxxxxx
                                                                     swpa.  */
                                                                  return 1032;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000011xxxxx100000xxxxxxxxxx
                                                                         swplb.  */
                                                                      return 1027;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000011xxxxx100000xxxxxxxxxx
                                                                         swplh.  */
                                                                      return 1030;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000011xxxxx100000xxxxxxxxxx
                                                                     swpl.  */
                                                                  return 1033;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000111xxxxx100000xxxxxxxxxx
                                                                         swpalb.  */
                                                                      return 1028;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000111xxxxx100000xxxxxxxxxx
                                                                         swpalh.  */
                                                                      return 1031;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000111xxxxx100000xxxxxxxxxx
                                                                     swpal.  */
                                                                  return 1034;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000001xxxxx010000xxxxxxxxxx
                                                                         ldsmaxb.  */
                                                                      return 1083;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000001xxxxx010000xxxxxxxxxx
                                                                         ldsmaxh.  */
                                                                      return 1084;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000001xxxxx010000xxxxxxxxxx
                                                                     ldsmax.  */
                                                                  return 1085;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000101xxxxx010000xxxxxxxxxx
                                                                         ldsmaxab.  */
                                                                      return 1086;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000101xxxxx010000xxxxxxxxxx
                                                                         ldsmaxah.  */
                                                                      return 1089;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000101xxxxx010000xxxxxxxxxx
                                                                     ldsmaxa.  */
                                                                  return 1092;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000011xxxxx010000xxxxxxxxxx
                                                                         ldsmaxlb.  */
                                                                      return 1087;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000011xxxxx010000xxxxxxxxxx
                                                                         ldsmaxlh.  */
                                                                      return 1090;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000011xxxxx010000xxxxxxxxxx
                                                                     ldsmaxl.  */
                                                                  return 1093;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000111xxxxx010000xxxxxxxxxx
                                                                         ldsmaxalb.  */
                                                                      return 1088;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000111xxxxx010000xxxxxxxxxx
                                                                         ldsmaxalh.  */
                                                                      return 1091;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000111xxxxx010000xxxxxxxxxx
                                                                     ldsmaxal.  */
                                                                  return 1094;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 31) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 00111000xx1xxxxx110000xxxxxxxxxx
                                                                 ldaprb.  */
                                                              return 958;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 01111000xx1xxxxx110000xxxxxxxxxx
                                                                 ldaprh.  */
                                                              return 959;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             1x111000xx1xxxxx110000xxxxxxxxxx
                                                             ldapr.  */
                                                          return 960;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000001xxxxxx01000xxxxxxxxxx
                                                                     ldeorb.  */
                                                                  return 1059;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000001xxxxxx01000xxxxxxxxxx
                                                                     ldeorh.  */
                                                                  return 1060;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000001xxxxxx01000xxxxxxxxxx
                                                                 ldeor.  */
                                                              return 1061;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000101xxxxxx01000xxxxxxxxxx
                                                                     ldeorab.  */
                                                                  return 1062;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000101xxxxxx01000xxxxxxxxxx
                                                                     ldeorah.  */
                                                                  return 1065;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000101xxxxxx01000xxxxxxxxxx
                                                                 ldeora.  */
                                                              return 1068;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000011xxxxxx01000xxxxxxxxxx
                                                                     ldeorlb.  */
                                                                  return 1063;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000011xxxxxx01000xxxxxxxxxx
                                                                     ldeorlh.  */
                                                                  return 1066;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000011xxxxxx01000xxxxxxxxxx
                                                                 ldeorl.  */
                                                              return 1069;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000111xxxxxx01000xxxxxxxxxx
                                                                     ldeoralb.  */
                                                                  return 1064;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000111xxxxxx01000xxxxxxxxxx
                                                                     ldeoralh.  */
                                                                  return 1067;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000111xxxxxx01000xxxxxxxxxx
                                                                 ldeoral.  */
                                                              return 1070;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000001xxxxxx11000xxxxxxxxxx
                                                                     ldumaxb.  */
                                                                  return 1107;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000001xxxxxx11000xxxxxxxxxx
                                                                     ldumaxh.  */
                                                                  return 1108;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000001xxxxxx11000xxxxxxxxxx
                                                                 ldumax.  */
                                                              return 1109;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000101xxxxxx11000xxxxxxxxxx
                                                                     ldumaxab.  */
                                                                  return 1110;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000101xxxxxx11000xxxxxxxxxx
                                                                     ldumaxah.  */
                                                                  return 1113;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000101xxxxxx11000xxxxxxxxxx
                                                                 ldumaxa.  */
                                                              return 1116;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000011xxxxxx11000xxxxxxxxxx
                                                                     ldumaxlb.  */
                                                                  return 1111;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000011xxxxxx11000xxxxxxxxxx
                                                                     ldumaxlh.  */
                                                                  return 1114;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000011xxxxxx11000xxxxxxxxxx
                                                                 ldumaxl.  */
                                                              return 1117;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000111xxxxxx11000xxxxxxxxxx
                                                                     ldumaxalb.  */
                                                                  return 1112;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000111xxxxxx11000xxxxxxxxxx
                                                                     ldumaxalh.  */
                                                                  return 1115;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000111xxxxxx11000xxxxxxxxxx
                                                                 ldumaxal.  */
                                                              return 1118;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000001xxxxxx00100xxxxxxxxxx
                                                                     ldclrb.  */
                                                                  return 1047;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000001xxxxxx00100xxxxxxxxxx
                                                                     ldclrh.  */
                                                                  return 1048;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000001xxxxxx00100xxxxxxxxxx
                                                                 ldclr.  */
                                                              return 1049;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000101xxxxxx00100xxxxxxxxxx
                                                                     ldclrab.  */
                                                                  return 1050;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000101xxxxxx00100xxxxxxxxxx
                                                                     ldclrah.  */
                                                                  return 1053;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000101xxxxxx00100xxxxxxxxxx
                                                                 ldclra.  */
                                                              return 1056;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000011xxxxxx00100xxxxxxxxxx
                                                                     ldclrlb.  */
                                                                  return 1051;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000011xxxxxx00100xxxxxxxxxx
                                                                     ldclrlh.  */
                                                                  return 1054;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000011xxxxxx00100xxxxxxxxxx
                                                                 ldclrl.  */
                                                              return 1057;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000111xxxxxx00100xxxxxxxxxx
                                                                     ldclralb.  */
                                                                  return 1052;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000111xxxxxx00100xxxxxxxxxx
                                                                     ldclralh.  */
                                                                  return 1055;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000111xxxxxx00100xxxxxxxxxx
                                                                 ldclral.  */
                                                              return 1058;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000001xxxxxx10100xxxxxxxxxx
                                                                     ldsminb.  */
                                                                  return 1095;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000001xxxxxx10100xxxxxxxxxx
                                                                     ldsminh.  */
                                                                  return 1096;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000001xxxxxx10100xxxxxxxxxx
                                                                 ldsmin.  */
                                                              return 1097;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000101xxxxxx10100xxxxxxxxxx
                                                                     ldsminab.  */
                                                                  return 1098;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000101xxxxxx10100xxxxxxxxxx
                                                                     ldsminah.  */
                                                                  return 1101;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000101xxxxxx10100xxxxxxxxxx
                                                                 ldsmina.  */
                                                              return 1104;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000011xxxxxx10100xxxxxxxxxx
                                                                     ldsminlb.  */
                                                                  return 1099;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000011xxxxxx10100xxxxxxxxxx
                                                                     ldsminlh.  */
                                                                  return 1102;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000011xxxxxx10100xxxxxxxxxx
                                                                 ldsminl.  */
                                                              return 1105;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000111xxxxxx10100xxxxxxxxxx
                                                                     ldsminalb.  */
                                                                  return 1100;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000111xxxxxx10100xxxxxxxxxx
                                                                     ldsminalh.  */
                                                                  return 1103;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000111xxxxxx10100xxxxxxxxxx
                                                                 ldsminal.  */
                                                              return 1106;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000001xxxxxx01100xxxxxxxxxx
                                                                     ldsetb.  */
                                                                  return 1071;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000001xxxxxx01100xxxxxxxxxx
                                                                     ldseth.  */
                                                                  return 1072;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000001xxxxxx01100xxxxxxxxxx
                                                                 ldset.  */
                                                              return 1073;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000101xxxxxx01100xxxxxxxxxx
                                                                     ldsetab.  */
                                                                  return 1074;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000101xxxxxx01100xxxxxxxxxx
                                                                     ldsetah.  */
                                                                  return 1077;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000101xxxxxx01100xxxxxxxxxx
                                                                 ldseta.  */
                                                              return 1080;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000011xxxxxx01100xxxxxxxxxx
                                                                     ldsetlb.  */
                                                                  return 1075;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000011xxxxxx01100xxxxxxxxxx
                                                                     ldsetlh.  */
                                                                  return 1078;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000011xxxxxx01100xxxxxxxxxx
                                                                 ldsetl.  */
                                                              return 1081;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000111xxxxxx01100xxxxxxxxxx
                                                                     ldsetalb.  */
                                                                  return 1076;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000111xxxxxx01100xxxxxxxxxx
                                                                     ldsetalh.  */
                                                                  return 1079;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000111xxxxxx01100xxxxxxxxxx
                                                                 ldsetal.  */
                                                              return 1082;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000001xxxxxx11100xxxxxxxxxx
                                                                     lduminb.  */
                                                                  return 1119;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000001xxxxxx11100xxxxxxxxxx
                                                                     lduminh.  */
                                                                  return 1120;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000001xxxxxx11100xxxxxxxxxx
                                                                 ldumin.  */
                                                              return 1121;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000101xxxxxx11100xxxxxxxxxx
                                                                     lduminab.  */
                                                                  return 1122;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000101xxxxxx11100xxxxxxxxxx
                                                                     lduminah.  */
                                                                  return 1125;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000101xxxxxx11100xxxxxxxxxx
                                                                 ldumina.  */
                                                              return 1128;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000011xxxxxx11100xxxxxxxxxx
                                                                     lduminlb.  */
                                                                  return 1123;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000011xxxxxx11100xxxxxxxxxx
                                                                     lduminlh.  */
                                                                  return 1126;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000011xxxxxx11100xxxxxxxxxx
                                                                 lduminl.  */
                                                              return 1129;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000111xxxxxx11100xxxxxxxxxx
                                                                     lduminalb.  */
                                                                  return 1124;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000111xxxxxx11100xxxxxxxxxx
                                                                     lduminalh.  */
                                                                  return 1127;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000111xxxxxx11100xxxxxxxxxx
                                                                 lduminal.  */
                                                              return 1130;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00111000000xxxxxxxxx10xxxxxxxxxx
                                                         sttrb.  */
                                                      return 912;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01111000000xxxxxxxxx10xxxxxxxxxx
                                                         sttrh.  */
                                                      return 915;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x111000000xxxxxxxxx10xxxxxxxxxx
                                                     sttr.  */
                                                  return 918;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00111000010xxxxxxxxx10xxxxxxxxxx
                                                         ldtrb.  */
                                                      return 913;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01111000010xxxxxxxxx10xxxxxxxxxx
                                                         ldtrh.  */
                                                      return 916;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x111000010xxxxxxxxx10xxxxxxxxxx
                                                     ldtr.  */
                                                  return 919;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001110001x0xxxxxxxxx10xxxxxxxxxx
                                                     ldtrsb.  */
                                                  return 914;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101110001x0xxxxxxxxx10xxxxxxxxxx
                                                     ldtrsw.  */
                                                  return 920;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x11110001x0xxxxxxxxx10xxxxxxxxxx
                                                 ldtrsh.  */
                                              return 917;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00111000001xxxxxxxxx10xxxxxxxxxx
                                                         strb.  */
                                                      return 900;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01111000001xxxxxxxxx10xxxxxxxxxx
                                                         strh.  */
                                                      return 905;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x111000001xxxxxxxxx10xxxxxxxxxx
                                                     str.  */
                                                  return 908;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00111000011xxxxxxxxx10xxxxxxxxxx
                                                         ldrb.  */
                                                      return 901;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01111000011xxxxxxxxx10xxxxxxxxxx
                                                         ldrh.  */
                                                      return 906;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x111000011xxxxxxxxx10xxxxxxxxxx
                                                     ldr.  */
                                                  return 909;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001110001x1xxxxxxxxx10xxxxxxxxxx
                                                     ldrsb.  */
                                                  return 902;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101110001x1xxxxxxxxx10xxxxxxxxxx
                                                     ldrsw.  */
                                                  return 910;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011110001x1xxxxxxxxx10xxxxxxxxxx
                                                     ldrsh.  */
                                                  return 907;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111110001x1xxxxxxxxx10xxxxxxxxxx
                                                     prfm.  */
                                                  return 911;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     00111000000xxxxxxxxxx1xxxxxxxxxx
                                                     strb.  */
                                                  return 869;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     01111000000xxxxxxxxxx1xxxxxxxxxx
                                                     strh.  */
                                                  return 874;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 1x111000000xxxxxxxxxx1xxxxxxxxxx
                                                 str.  */
                                              return 877;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     00111000010xxxxxxxxxx1xxxxxxxxxx
                                                     ldrb.  */
                                                  return 870;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     01111000010xxxxxxxxxx1xxxxxxxxxx
                                                     ldrh.  */
                                                  return 875;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 1x111000010xxxxxxxxxx1xxxxxxxxxx
                                                 ldr.  */
                                              return 878;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 001110001x0xxxxxxxxxx1xxxxxxxxxx
                                                 ldrsb.  */
                                              return 871;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 101110001x0xxxxxxxxxx1xxxxxxxxxx
                                                 ldrsw.  */
                                              return 879;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x11110001x0xxxxxxxxxx1xxxxxxxxxx
                                             ldrsh.  */
                                          return 876;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx1110000x1xxxxxxxxxx1xxxxxxxxxx
                                         ldraa.  */
                                      return 934;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx1110001x1xxxxxxxxxx1xxxxxxxxxx
                                         ldrab.  */
                                      return 935;
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 22) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00011001000xxxxxxxxx00xxxxxxxxxx
                                                         stlurb.  */
                                                      return 2080;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         10011001000xxxxxxxxx00xxxxxxxxxx
                                                         stlur.  */
                                                      return 2088;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01011001000xxxxxxxxx00xxxxxxxxxx
                                                         stlurh.  */
                                                      return 2084;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         11011001000xxxxxxxxx00xxxxxxxxxx
                                                         stlur.  */
                                                      return 2091;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xx011001001xxxxxxxxx00xxxxxxxxxx
                                                 stzgm.  */
                                              return 961;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx01100100xxxxxxxxxx10xxxxxxxxxx
                                             stg.  */
                                          return 880;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx01100100xxxxxxxxxxx1xxxxxxxxxx
                                         stg.  */
                                      return 884;
                                    }
                                }
                              else
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0011100100xxxxxxxxxxxxxxxxxxxxxx
                                             strb.  */
                                          return 888;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0111100100xxxxxxxxxxxxxxxxxxxxxx
                                             strh.  */
                                          return 893;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         1x11100100xxxxxxxxxxxxxxxxxxxxxx
                                         str.  */
                                      return 896;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00011001010xxxxxxxxx00xxxxxxxxxx
                                                         ldapurb.  */
                                                      return 2081;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         10011001010xxxxxxxxx00xxxxxxxxxx
                                                         ldapur.  */
                                                      return 2089;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01011001010xxxxxxxxx00xxxxxxxxxx
                                                         ldapurh.  */
                                                      return 2085;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         11011001010xxxxxxxxx00xxxxxxxxxx
                                                         ldapur.  */
                                                      return 2092;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xx011001011xxxxxxxxx00xxxxxxxxxx
                                                 ldg.  */
                                              return 933;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx01100101xxxxxxxxxx10xxxxxxxxxx
                                             stzg.  */
                                          return 881;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx01100101xxxxxxxxxxx1xxxxxxxxxx
                                         stzg.  */
                                      return 885;
                                    }
                                }
                              else
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0011100101xxxxxxxxxxxxxxxxxxxxxx
                                             ldrb.  */
                                          return 889;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0111100101xxxxxxxxxxxxxxxxxxxxxx
                                             ldrh.  */
                                          return 894;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         1x11100101xxxxxxxxxxxxxxxxxxxxxx
                                         ldr.  */
                                      return 897;
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 10) & 0x1) == 0)
                                {
                                  if (((word >> 11) & 0x1) == 0)
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     0001100110xxxxxxxxxx00xxxxxxxxxx
                                                     ldapursb.  */
                                                  return 2083;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1001100110xxxxxxxxxx00xxxxxxxxxx
                                                     ldapursw.  */
                                                  return 2090;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x101100110xxxxxxxxxx00xxxxxxxxxx
                                                 ldapursh.  */
                                              return 2087;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x001100111xxxxxxxxxx00xxxxxxxxxx
                                                 ldapursb.  */
                                              return 2082;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x101100111xxxxxxxxxx00xxxxxxxxxx
                                                 ldapursh.  */
                                              return 2086;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx01100110xxxxxxxxxx10xxxxxxxxxx
                                             st2g.  */
                                          return 882;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx01100111xxxxxxxxxx10xxxxxxxxxx
                                             stz2g.  */
                                          return 883;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx01100110xxxxxxxxxxx1xxxxxxxxxx
                                         st2g.  */
                                      return 886;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx01100111xxxxxxxxxxx1xxxxxxxxxx
                                         stz2g.  */
                                      return 887;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         001110011xxxxxxxxxxxxxxxxxxxxxxx
                                         ldrsb.  */
                                      return 890;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         101110011xxxxxxxxxxxxxxxxxxxxxxx
                                         ldrsw.  */
                                      return 898;
                                    }
                                }
                              else
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         011110011xxxxxxxxxxxxxxxxxxxxxxx
                                         ldrsh.  */
                                      return 895;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         111110011xxxxxxxxxxxxxxxxxxxxxxx
                                         prfm.  */
                                      return 899;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
      else
        {
          if (((word >> 24) & 0x1) == 0)
            {
              if (((word >> 27) & 0x1) == 0)
                {
                  if (((word >> 23) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x00x00100xxxxxxxxxxxxxxxxxxxxxxx
                                 and.  */
                              return 988;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x10x00100xxxxxxxxxxxxxxxxxxxxxxx
                                 eor.  */
                              return 992;
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x01x00100xxxxxxxxxxxxxxxxxxxxxxx
                                 orr.  */
                              return 990;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x11x00100xxxxxxxxxxxxxxxxxxxxxxx
                                 ands.  */
                              return 993;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x00x00101xxxxxxxxxxxxxxxxxxxxxxx
                                 movn.  */
                              return 1179;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x10x00101xxxxxxxxxxxxxxxxxxxxxxx
                                 movz.  */
                              return 1181;
                            }
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xx1x00101xxxxxxxxxxxxxxxxxxxxxxx
                             movk.  */
                          return 1183;
                        }
                    }
                }
              else
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x0001010xx0xxxxxxxxxxxxxxxxxxxxx
                                     and.  */
                                  return 995;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x1001010xx0xxxxxxxxxxxxxxxxxxxxx
                                     eor.  */
                                  return 1002;
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x0101010xx0xxxxxxxxxxxxxxxxxxxxx
                                     orr.  */
                                  return 997;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x1101010xx0xxxxxxxxxxxxxxxxxxxxx
                                     ands.  */
                                  return 1004;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x0011010000xxxxxxxxx00xxxxxxxxxx
                                                     adc.  */
                                                  return 0;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1011010000xxxxxxxxx00xxxxxxxxxx
                                                     sbc.  */
                                                  return 2;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x0111010000xxxxxxxxx00xxxxxxxxxx
                                                     adcs.  */
                                                  return 1;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1111010000xxxxxxxxx00xxxxxxxxxx
                                                     sbcs.  */
                                                  return 4;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x0x11010100xxxxxxxxx00xxxxxxxxxx
                                                 csel.  */
                                              return 662;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1x11010100xxxxxxxxx00xxxxxxxxxx
                                                 csinv.  */
                                              return 666;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x0x11010010xxxxxxxxx00xxxxxxxxxx
                                                 ccmn.  */
                                              return 660;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1x11010010xxxxxxxxx00xxxxxxxxxx
                                                 ccmp.  */
                                              return 661;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x0011010110xxxxxx00000xxxxxxxxxx
                                                                 subp.  */
                                                              return 721;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 16) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     x1011010110xxxx0x00000xxxxxxxxxx
                                                                     rbit.  */
                                                                  return 685;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     x1011010110xxxx1x00000xxxxxxxxxx
                                                                     pacia.  */
                                                                  return 693;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx111010110xxxxxx00000xxxxxxxxxx
                                                             subps.  */
                                                          return 722;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0x11010110xxxxxx10000xxxxxxxxxx
                                                             crc32b.  */
                                                          return 727;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1x11010110xxxxxx10000xxxxxxxxxx
                                                             xpaci.  */
                                                          return 709;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x0x11010110xxxxxxx1000xxxxxxxxxx
                                                         lslv.  */
                                                      return 713;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x11010110xxxxxxx1000xxxxxxxxxx
                                                         paciza.  */
                                                      return 701;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0x11010110xxxxxx00100xxxxxxxxxx
                                                             irg.  */
                                                          return 724;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x1x11010110xxxx0x00100xxxxxxxxxx
                                                                 clz.  */
                                                              return 690;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x1x11010110xxxx1x00100xxxxxxxxxx
                                                                 autia.  */
                                                              return 697;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxx11010110xxxxxx10100xxxxxxxxxx
                                                         crc32cb.  */
                                                      return 731;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x0x11010110xxxxxxx1100xxxxxxxxxx
                                                         pacga.  */
                                                      return 726;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x11010110xxxxxxx1100xxxxxxxxxx
                                                         autiza.  */
                                                      return 705;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxx11010x00xxxxxx0xx10xxxxxxxxxx
                                             setf8.  */
                                          return 2078;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxx11010x00xxxxxx1xx10xxxxxxxxxx
                                             setf16.  */
                                          return 2079;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x0x11010010xxxxxxxxx10xxxxxxxxxx
                                                 ccmn.  */
                                              return 658;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1x11010010xxxxxxxxx10xxxxxxxxxx
                                                 ccmp.  */
                                              return 659;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0x11010110xxxxxx00010xxxxxxxxxx
                                                             udiv.  */
                                                          return 711;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01x11010110xxxx0x00010xxxxxxxxxx
                                                                     rev.  */
                                                                  return 687;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     11x11010110xxxx0x00010xxxxxxxxxx
                                                                     rev32.  */
                                                                  return 692;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x1x11010110xxxx1x00010xxxxxxxxxx
                                                                 pacda.  */
                                                              return 695;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxx11010110xxxxxx10010xxxxxxxxxx
                                                         crc32w.  */
                                                      return 729;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x0x11010110xxxxxxx1010xxxxxxxxxx
                                                         asrv.  */
                                                      return 717;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x11010110xxxxxxx1010xxxxxxxxxx
                                                         pacdza.  */
                                                      return 703;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxx11010110xxxxxx00110xxxxxxxxxx
                                                         autda.  */
                                                      return 699;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxx11010110xxxxxx10110xxxxxxxxxx
                                                         crc32cw.  */
                                                      return 733;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxx11010110xxxxxxx1110xxxxxxxxxx
                                                     autdza.  */
                                                  return 707;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxx11010000xxxxxxxxx01xxxxxxxxxx
                                             rmif.  */
                                          return 2077;
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x0x11010100xxxxxxxxx01xxxxxxxxxx
                                                 csinc.  */
                                              return 663;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1x11010100xxxxxxxxx01xxxxxxxxxx
                                                 csneg.  */
                                              return 669;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxx11010x10xxxx0x00001xxxxxxxxxx
                                                         rev16.  */
                                                      return 686;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxx11010x10xxxx1x00001xxxxxxxxxx
                                                         pacib.  */
                                                      return 694;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x0x11010x10xxxxxx10001xxxxxxxxxx
                                                         crc32h.  */
                                                      return 728;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x11010x10xxxxxx10001xxxxxxxxxx
                                                         xpacd.  */
                                                      return 710;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x0x11010x10xxxxxxx1001xxxxxxxxxx
                                                     lsrv.  */
                                                  return 715;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1x11010x10xxxxxxx1001xxxxxxxxxx
                                                     pacizb.  */
                                                  return 702;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x0x11010x10xxxxxx00101xxxxxxxxxx
                                                         gmi.  */
                                                      return 725;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1x11010x10xxxx0x00101xxxxxxxxxx
                                                             cls.  */
                                                          return 691;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1x11010x10xxxx1x00101xxxxxxxxxx
                                                             autib.  */
                                                          return 698;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxx11010x10xxxxxx10101xxxxxxxxxx
                                                     crc32ch.  */
                                                  return 732;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxx11010x10xxxxxxx1101xxxxxxxxxx
                                                 autizb.  */
                                              return 706;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x0x11010xx0xxxxxx00011xxxxxxxxxx
                                                     sdiv.  */
                                                  return 712;
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x11010xx0xxxx0x00011xxxxxxxxxx
                                                         rev.  */
                                                      return 688;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x11010xx0xxxx1x00011xxxxxxxxxx
                                                         pacdb.  */
                                                      return 696;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxx11010xx0xxxxxx10011xxxxxxxxxx
                                                 crc32x.  */
                                              return 730;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x0x11010xx0xxxxxxx1011xxxxxxxxxx
                                                 rorv.  */
                                              return 719;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1x11010xx0xxxxxxx1011xxxxxxxxxx
                                                 pacdzb.  */
                                              return 704;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxx11010xx0xxxxxx00111xxxxxxxxxx
                                                 autdb.  */
                                              return 700;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxx11010xx0xxxxxx10111xxxxxxxxxx
                                                 crc32cx.  */
                                              return 734;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxx11010xx0xxxxxxx1111xxxxxxxxxx
                                             autdzb.  */
                                          return 708;
                                        }
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x00x1010xx1xxxxxxxxxxxxxxxxxxxxx
                                 bic.  */
                              return 996;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x10x1010xx1xxxxxxxxxxxxxxxxxxxxx
                                 eon.  */
                              return 1003;
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x01x1010xx1xxxxxxxxxxxxxxxxxxxxx
                                 orn.  */
                              return 1000;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x11x1010xx1xxxxxxxxxxxxxxxxxxxxx
                                 bics.  */
                              return 1006;
                            }
                        }
                    }
                }
            }
          else
            {
              if (((word >> 27) & 0x1) == 0)
                {
                  if (((word >> 23) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x00x00110xxxxxxxxxxxxxxxxxxxxxxx
                                 sbfm.  */
                              return 618;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x10x00110xxxxxxxxxxxxxxxxxxxxxxx
                                 ubfm.  */
                              return 629;
                            }
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xx1x00110xxxxxxxxxxxxxxxxxxxxxxx
                             bfm.  */
                          return 625;
                        }
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxx00111xxxxxxxxxxxxxxxxxxxxxxx
                         extr.  */
                      return 757;
                    }
                }
              else
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x0001011xx0xxxxxxxxxxxxxxxxxxxxx
                                     add.  */
                                  return 21;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x1001011xx0xxxxxxxxxxxxxxxxxxxxx
                                     sub.  */
                                  return 24;
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x0101011xx0xxxxxxxxxxxxxxxxxxxxx
                                     adds.  */
                                  return 22;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x1101011xx0xxxxxxxxxxxxxxxxxxxxx
                                     subs.  */
                                  return 26;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              if (((word >> 22) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxx11011x00xxxxx0xxxxxxxxxxxxxxx
                                     madd.  */
                                  return 735;
                                }
                              else
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxx11011010xxxxx0xxxxxxxxxxxxxxx
                                         smulh.  */
                                      return 743;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxx11011110xxxxx0xxxxxxxxxxxxxxx
                                         umulh.  */
                                      return 748;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxx11011xx0xxxxx1xxxxxxxxxxxxxxx
                                 msub.  */
                              return 737;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 28) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x00010110x1xxxxxxxxxxxxxxxxxxxxx
                                         add.  */
                                      return 6;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x10010110x1xxxxxxxxxxxxxxxxxxxxx
                                         sub.  */
                                      return 9;
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x01010110x1xxxxxxxxxxxxxxxxxxxxx
                                         adds.  */
                                      return 7;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x11010110x1xxxxxxxxxxxxxxxxxxxxx
                                         subs.  */
                                      return 10;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxx110110x1xxxxx0xxxxxxxxxxxxxxx
                                     smaddl.  */
                                  return 739;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxx110110x1xxxxx1xxxxxxxxxxxxxxx
                                     smsubl.  */
                                  return 741;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxx10111x1xxxxx0xxxxxxxxxxxxxxx
                                 umaddl.  */
                              return 744;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxx10111x1xxxxx1xxxxxxxxxxxxxxx
                                 umsubl.  */
                              return 746;
                            }
                        }
                    }
                }
            }
        }
    }
  else
    {
      if (((word >> 27) & 0x1) == 0)
        {
          if (((word >> 28) & 0x1) == 0)
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 29) & 0x1) == 0)
                    {
                      if (((word >> 13) & 0x1) == 0)
                        {
                          if (((word >> 14) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx000000000xxxxxxxxxxxxx
                                                                     add.  */
                                                                  return 1269;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx010000000xxxxxxxxxxxxx
                                                                     mul.  */
                                                                  return 1738;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx001000000xxxxxxxxxxxxx
                                                                     smax.  */
                                                                  return 1817;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx011000000xxxxxxxxxxxxx
                                                                     orr.  */
                                                                  return 1749;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0100000xxxxxxxxxxxxx
                                                                 sdiv.  */
                                                              return 1808;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1100000xxxxxxxxxxxxx
                                                                 sabd.  */
                                                              return 1799;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0010000xxxxxxxxxxxxx
                                                                 smulh.  */
                                                              return 1822;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx001010000xxxxxxxxxxxxx
                                                                     smin.  */
                                                                  return 1820;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx011010000xxxxxxxxxxxxx
                                                                     and.  */
                                                                  return 1277;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx0xx110000xxxxxxxxxxxxx
                                                             sdivr.  */
                                                          return 1809;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0001000xxxxxxxxxxxxx
                                                                 sub.  */
                                                              return 1938;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx001001000xxxxxxxxxxxxx
                                                                     umax.  */
                                                                  return 1966;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx011001000xxxxxxxxxxxxx
                                                                     eor.  */
                                                                  return 1364;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0101000xxxxxxxxxxxxx
                                                                 udiv.  */
                                                              return 1960;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1101000xxxxxxxxxxxxx
                                                                 uabd.  */
                                                              return 1951;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx000011000xxxxxxxxxxxxx
                                                                     subr.  */
                                                                  return 1940;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx010011000xxxxxxxxxxxxx
                                                                     umulh.  */
                                                                  return 1971;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx001011000xxxxxxxxxxxxx
                                                                     umin.  */
                                                                  return 1969;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx011011000xxxxxxxxxxxxx
                                                                     bic.  */
                                                                  return 1289;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx0xx111000xxxxxxxxxxxxx
                                                             udivr.  */
                                                          return 1961;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x0xxxxx000xxxxxxxxxxxxx
                                                     ld1sb.  */
                                                  return 1551;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x0xxxxx000xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1562;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x0xxxxx000xxxxxxxxxxxxx
                                                 ld1sb.  */
                                              return 1555;
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x01x0xxxxx000xx0xxxxxxxxxx
                                                         sdot.  */
                                                      return 1810;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x01x0xxxxx000xx1xxxxxxxxxx
                                                         udot.  */
                                                      return 1962;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x01x0xxxxx000xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1566;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx000000xxxxxxxxxx
                                                             add.  */
                                                          return 1267;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx000100xxxxxxxxxx
                                                             sqadd.  */
                                                          return 1824;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx000x10xxxxxxxxxx
                                                         sqsub.  */
                                                      return 1854;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx000001xxxxxxxxxx
                                                             sub.  */
                                                          return 1936;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx000101xxxxxxxxxx
                                                             uqadd.  */
                                                          return 1972;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx000x11xxxxxxxxxx
                                                         uqsub.  */
                                                      return 2002;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x1xxxxx000xxxxxxxxxxxxx
                                                     prfb.  */
                                                  return 1757;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x1xxxxx000xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1563;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x1xxxxx000xxxxxxxxxxxxx
                                                 prfb.  */
                                              return 1758;
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0101xxxxx000xx0xxxxxxxxxx
                                                             sdot.  */
                                                          return 1811;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0111xxxxx000xx0xxxxxxxxxx
                                                             sdot.  */
                                                          return 1812;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0101xxxxx000xx1xxxxxxxxxx
                                                             udot.  */
                                                          return 1963;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0111xxxxx000xx1xxxxxxxxxx
                                                             udot.  */
                                                          return 1964;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x01x1xxxxx000xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1567;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0000x0100xxxxxxxxxxxxx
                                                                 asr.  */
                                                              return 1285;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0100x0100xxxxxxxxxxxxx
                                                                 asr.  */
                                                              return 1283;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx0x10x0100xxxxxxxxxxxxx
                                                             asr.  */
                                                          return 1284;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx00x1x0100xxxxxxxxxxxxx
                                                             asrd.  */
                                                          return 1286;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx01x1x0100xxxxxxxxxxxxx
                                                             asrr.  */
                                                          return 1287;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx000001100xxxxxxxxxxxxx
                                                                     lsr.  */
                                                                  return 1729;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx010001100xxxxxxxxxxxxx
                                                                     lsr.  */
                                                                  return 1727;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1001100xxxxxxxxxxxxx
                                                                 lsr.  */
                                                              return 1728;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx0xx101100xxxxxxxxxxxxx
                                                             lsrr.  */
                                                          return 1730;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx000011100xxxxxxxxxxxxx
                                                                     lsl.  */
                                                                  return 1723;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx010011100xxxxxxxxxxxxx
                                                                     lsl.  */
                                                                  return 1721;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1011100xxxxxxxxxxxxx
                                                                 lsl.  */
                                                              return 1722;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx0xx111100xxxxxxxxxxxxx
                                                             lslr.  */
                                                          return 1724;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx1000x0xxxxxxxxxx
                                                         asr.  */
                                                      return 1281;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx1001x0xxxxxxxxxx
                                                         asr.  */
                                                      return 1282;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx100001xxxxxxxxxx
                                                             lsr.  */
                                                          return 1725;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx100101xxxxxxxxxx
                                                             lsr.  */
                                                          return 1726;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx100011xxxxxxxxxx
                                                             lsl.  */
                                                          return 1719;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx100111xxxxxxxxxx
                                                             lsl.  */
                                                          return 1720;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x000xxxxxx100xxxxxxxxxxxxx
                                                     ld1sb.  */
                                                  return 1557;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x010xxxxxx100xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1570;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x001xxxxxx100xxxxxxxxxxxxx
                                                     ld1rb.  */
                                                  return 1527;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x011xxxxxx100xxxxxxxxxxxxx
                                                     ld1rsw.  */
                                                  return 1548;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x0xxxxx100xxxxxxxxxxxxx
                                                 ld1sb.  */
                                              return 1556;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x01x0xxxxx100xxxxxxxxxxxxx
                                                 ld1sh.  */
                                              return 1568;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0001xxxxx100xxxxxxxxxxxxx
                                                     ld1sb.  */
                                                  return 1561;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0101xxxxx100xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1573;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0011xxxxx100xxxxxxxxxxxxx
                                                     prfb.  */
                                                  return 1759;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0111xxxxx100xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1569;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x0xx0xxxxx010xxxxxxxxxxxxx
                                                 mla.  */
                                              return 1732;
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x0xxxxx010xxxxxxxxxxxxx
                                                     ld1b.  */
                                                  return 1493;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x0xxxxx010xxxxxxxxxxxxx
                                                     ld1h.  */
                                                  return 1513;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x0xxxxx010xxxxxxxxxxxxx
                                                 ld1b.  */
                                              return 1498;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x01x0xxxxx010xxxxxxxxxxxxx
                                                 ld1h.  */
                                              return 1518;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx010000xxxxxxxxxx
                                                             index.  */
                                                          return 1484;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx010001xxxxxxxxxx
                                                             index.  */
                                                          return 1485;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0001xxxxx01010xxxxxxxxxxx
                                                                 addvl.  */
                                                              return 1271;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0101xxxxx01010xxxxxxxxxxx
                                                                 rdvl.  */
                                                              return 1793;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0x11xxxxx01010xxxxxxxxxxx
                                                             addpl.  */
                                                          return 1270;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx010x10xxxxxxxxxx
                                                         index.  */
                                                      return 1486;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx010x11xxxxxxxxxx
                                                         index.  */
                                                      return 1483;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x1xxxxx010xxxxxxxxxxxxx
                                                     prfw.  */
                                                  return 1777;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x1xxxxx010xxxxxxxxxxxxx
                                                     ld1h.  */
                                                  return 1514;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x1xxxxx010xxxxxxxxxxxxx
                                                 prfw.  */
                                              return 1779;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x01x1xxxxx010xxxxxxxxxxxxx
                                                 ld1h.  */
                                              return 1519;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x0xx0xxxxx110xxxxxxxxxxxxx
                                                 mad.  */
                                              return 1731;
                                            }
                                          else
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0x010xxxx110x00xxxxxxxxxx
                                                                 sqincw.  */
                                                              return 1851;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00110xxxx110x00xxxxxxxxxx
                                                                     sqinch.  */
                                                                  return 1845;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01110xxxx110x00xxxxxxxxxx
                                                                     sqincd.  */
                                                                  return 1842;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0x011xxxx110x00xxxxxxxxxx
                                                                 incw.  */
                                                              return 1481;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00111xxxx110x00xxxxxxxxxx
                                                                     inch.  */
                                                                  return 1477;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01111xxxx110x00xxxxxxxxxx
                                                                     incd.  */
                                                                  return 1475;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0x01xxxxx110x10xxxxxxxxxx
                                                             sqdecw.  */
                                                          return 1837;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0011xxxxx110x10xxxxxxxxxx
                                                                 sqdech.  */
                                                              return 1831;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0111xxxxx110x10xxxxxxxxxx
                                                                 sqdecd.  */
                                                              return 1828;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0x010xxxx110x01xxxxxxxxxx
                                                                 uqincw.  */
                                                              return 1999;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00110xxxx110x01xxxxxxxxxx
                                                                     uqinch.  */
                                                                  return 1993;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01110xxxx110x01xxxxxxxxxx
                                                                     uqincd.  */
                                                                  return 1990;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0x011xxxx110x01xxxxxxxxxx
                                                                 decw.  */
                                                              return 1356;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00111xxxx110x01xxxxxxxxxx
                                                                     dech.  */
                                                                  return 1352;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01111xxxx110x01xxxxxxxxxx
                                                                     decd.  */
                                                                  return 1350;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0x01xxxxx110x11xxxxxxxxxx
                                                             uqdecw.  */
                                                          return 1985;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0011xxxxx110x11xxxxxxxxxx
                                                                 uqdech.  */
                                                              return 1979;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0111xxxxx110x11xxxxxxxxxx
                                                                 uqdecd.  */
                                                              return 1976;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0000xxxxx110xxxxxxxxxxxxx
                                                         prfb.  */
                                                      return 1756;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0100xxxxx110xxxxxxxxxxxxx
                                                         prfh.  */
                                                      return 1771;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0001xxxxx110xxxxxxxxxxxxx
                                                         ld1b.  */
                                                      return 1500;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0101xxxxx110xxxxxxxxxxxxx
                                                         ld1h.  */
                                                      return 1522;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x001xxxxxx110xxxxxxxxxxxxx
                                                     ld1rb.  */
                                                  return 1529;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x011xxxxxx110xxxxxxxxxxxxx
                                                     ld1rh.  */
                                                  return 1533;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x0xxxxx110xxxxxxxxxxxxx
                                                 ld1b.  */
                                              return 1499;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x01x0xxxxx110xxxxxxxxxxxxx
                                                 ld1h.  */
                                              return 1520;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0001xxxxx110xxxxxxxxxxxxx
                                                     ld1b.  */
                                                  return 1505;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0101xxxxx110xxxxxxxxxxxxx
                                                     ld1h.  */
                                                  return 1526;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0011xxxxx110xxxxxxxxxxxxx
                                                     prfw.  */
                                                  return 1780;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0111xxxxx110xxxxxxxxxxxxx
                                                     ld1h.  */
                                                  return 1521;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 14) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 17) & 0x1) == 0)
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx000x00001xxxxxxxxxxxxx
                                                                 saddv.  */
                                                              return 1800;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx000x01001xxxxxxxxxxxxx
                                                                 uaddv.  */
                                                              return 1952;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx010x0x001xxxxxxxxxxxxx
                                                             movprfx.  */
                                                          return 1735;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx001x00001xxxxxxxxxxxxx
                                                                 smaxv.  */
                                                              return 1818;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx011x00001xxxxxxxxxxxxx
                                                                 orv.  */
                                                              return 1752;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx001x01001xxxxxxxxxxxxx
                                                                 umaxv.  */
                                                              return 1967;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx011x01001xxxxxxxxxxxxx
                                                                 eorv.  */
                                                              return 1367;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx00xx10001xxxxxxxxxxxxx
                                                             sminv.  */
                                                          return 1821;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx01xx10001xxxxxxxxxxxxx
                                                             andv.  */
                                                          return 1280;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx0xxx11001xxxxxxxxxxxxx
                                                         uminv.  */
                                                      return 1970;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x0xxxxx001xxxxxxxxxxxxx
                                                     ldff1sb.  */
                                                  return 1651;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x0xxxxx001xxxxxxxxxxxxx
                                                     ldff1sh.  */
                                                  return 1662;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x0xxxxx001xxxxxxxxxxxxx
                                                 ldff1sb.  */
                                              return 1658;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x01x0xxxxx001xxxxxxxxxxxxx
                                                 ldff1sh.  */
                                              return 1668;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0001xxxxx001xxxxxxxxxxxxx
                                                         and.  */
                                                      return 1275;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0011xxxxx001xxxxxxxxxxxxx
                                                         orr.  */
                                                      return 1747;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x1xxxxx001xxxxxxxxxxxxx
                                                     prfh.  */
                                                  return 1770;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x1xxxxx001xxxxxxxxxxxxx
                                                 prfh.  */
                                              return 1772;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0101xxxxx001xxxxxxxxxxxxx
                                                         eor.  */
                                                      return 1362;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0111xxxxx001xxxxxxxxxxxxx
                                                         bic.  */
                                                      return 1288;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x1xxxxx001xxxxxxxxxxxxx
                                                     ldff1sh.  */
                                                  return 1663;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x01x1xxxxx001xxxxxxxxxxxxx
                                                 ldff1sh.  */
                                              return 1669;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0000101xxxxxxxxxxxxx
                                                                 sxtb.  */
                                                              return 1943;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1000101xxxxxxxxxxxxx
                                                                 cls.  */
                                                              return 1308;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0100101xxxxxxxxxxxxx
                                                                 sxtw.  */
                                                              return 1945;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1100101xxxxxxxxxxxxx
                                                                 fabs.  */
                                                              return 1370;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0010101xxxxxxxxxxxxx
                                                                 sxth.  */
                                                              return 1944;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1010101xxxxxxxxxxxxx
                                                                 cnt.  */
                                                              return 1337;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0110101xxxxxxxxxxxxx
                                                                 abs.  */
                                                              return 1266;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1110101xxxxxxxxxxxxx
                                                                 not.  */
                                                              return 1744;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0001101xxxxxxxxxxxxx
                                                                 uxtb.  */
                                                              return 2006;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1001101xxxxxxxxxxxxx
                                                                 clz.  */
                                                              return 1309;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0101101xxxxxxxxxxxxx
                                                                 uxtw.  */
                                                              return 2008;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1101101xxxxxxxxxxxxx
                                                                 fneg.  */
                                                              return 1447;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0011101xxxxxxxxxxxxx
                                                                 uxth.  */
                                                              return 2007;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1011101xxxxxxxxxxxxx
                                                                 cnot.  */
                                                              return 1336;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx0xx111101xxxxxxxxxxxxx
                                                             neg.  */
                                                          return 1741;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0001xxxxx1010xxxxxxxxxxxx
                                                             adr.  */
                                                          return 1272;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0011xxxxx1010xxxxxxxxxxxx
                                                             adr.  */
                                                          return 1273;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x01x1xxxxx1010xxxxxxxxxxxx
                                                         adr.  */
                                                      return 1274;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx101100xxxxxxxxxx
                                                             ftssel.  */
                                                          return 1473;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx101110xxxxxxxxxx
                                                             fexpa.  */
                                                          return 1417;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx1011x1xxxxxxxxxx
                                                         movprfx.  */
                                                      return 1734;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x000xxxxxx101xxxxxxxxxxxxx
                                                     ldff1sb.  */
                                                  return 1660;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x010xxxxxx101xxxxxxxxxxxxx
                                                     ldff1sh.  */
                                                  return 1672;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x001xxxxxx101xxxxxxxxxxxxx
                                                     ld1rb.  */
                                                  return 1528;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x011xxxxxx101xxxxxxxxxxxxx
                                                     ld1rh.  */
                                                  return 1532;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x0xxxxx101xxxxxxxxxxxxx
                                                 ldff1sb.  */
                                              return 1659;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x01x0xxxxx101xxxxxxxxxxxxx
                                                 ldff1sh.  */
                                              return 1670;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0001xxxxx101xxxxxxxxxxxxx
                                                     ldff1sb.  */
                                                  return 1661;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0101xxxxx101xxxxxxxxxxxxx
                                                     ldff1sh.  */
                                                  return 1673;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0011xxxxx101xxxxxxxxxxxxx
                                                     prfh.  */
                                                  return 1773;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0111xxxxx101xxxxxxxxxxxxx
                                                     ldff1sh.  */
                                                  return 1671;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x0xx0xxxxx011xxxxxxxxxxxxx
                                                 mls.  */
                                              return 1733;
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x0xxxxx011xxxxxxxxxxxxx
                                                     ldff1b.  */
                                                  return 1617;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x0xxxxx011xxxxxxxxxxxxx
                                                     ldff1h.  */
                                                  return 1637;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x0xxxxx011xxxxxxxxxxxxx
                                                 ldff1b.  */
                                              return 1626;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x01x0xxxxx011xxxxxxxxxxxxx
                                                 ldff1h.  */
                                              return 1645;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x00001x00x1xxxxx011xxxxxxxxxxxxx
                                                 prfd.  */
                                              return 1763;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x1xxxxx011xxxxxxxxxxxxx
                                                 prfd.  */
                                              return 1765;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x00001x01x1xxxxx011xxxxxxxxxxxxx
                                                 ldff1h.  */
                                              return 1638;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x01x1xxxxx011xxxxxxxxxxxxx
                                                 ldff1h.  */
                                              return 1646;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x0xx0xxxxx111xxxxxxxxxxxxx
                                                 msb.  */
                                              return 1736;
                                            }
                                          else
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00010xxxx111000xxxxxxxxxx
                                                                         cntb.  */
                                                                      return 1338;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01010xxxx111000xxxxxxxxxx
                                                                         cntw.  */
                                                                      return 1342;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00110xxxx111000xxxxxxxxxx
                                                                         cnth.  */
                                                                      return 1340;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01110xxxx111000xxxxxxxxxx
                                                                         cntd.  */
                                                                      return 1339;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00011xxxx111000xxxxxxxxxx
                                                                         incb.  */
                                                                      return 1474;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01011xxxx111000xxxxxxxxxx
                                                                         incw.  */
                                                                      return 1482;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00111xxxx111000xxxxxxxxxx
                                                                         inch.  */
                                                                      return 1478;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01111xxxx111000xxxxxxxxxx
                                                                         incd.  */
                                                                      return 1476;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00010xxxx111100xxxxxxxxxx
                                                                         sqincb.  */
                                                                      return 1841;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01010xxxx111100xxxxxxxxxx
                                                                         sqincw.  */
                                                                      return 1853;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00110xxxx111100xxxxxxxxxx
                                                                         sqinch.  */
                                                                      return 1847;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01110xxxx111100xxxxxxxxxx
                                                                         sqincd.  */
                                                                      return 1844;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00011xxxx111100xxxxxxxxxx
                                                                         sqincb.  */
                                                                      return 1840;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01011xxxx111100xxxxxxxxxx
                                                                         sqincw.  */
                                                                      return 1852;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00111xxxx111100xxxxxxxxxx
                                                                         sqinch.  */
                                                                      return 1846;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01111xxxx111100xxxxxxxxxx
                                                                         sqincd.  */
                                                                      return 1843;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00010xxxx111x10xxxxxxxxxx
                                                                     sqdecb.  */
                                                                  return 1827;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01010xxxx111x10xxxxxxxxxx
                                                                     sqdecw.  */
                                                                  return 1839;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00110xxxx111x10xxxxxxxxxx
                                                                     sqdech.  */
                                                                  return 1833;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01110xxxx111x10xxxxxxxxxx
                                                                     sqdecd.  */
                                                                  return 1830;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00011xxxx111x10xxxxxxxxxx
                                                                     sqdecb.  */
                                                                  return 1826;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01011xxxx111x10xxxxxxxxxx
                                                                     sqdecw.  */
                                                                  return 1838;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00111xxxx111x10xxxxxxxxxx
                                                                     sqdech.  */
                                                                  return 1832;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01111xxxx111x10xxxxxxxxxx
                                                                     sqdecd.  */
                                                                  return 1829;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0001xxxxx111001xxxxxxxxxx
                                                                     decb.  */
                                                                  return 1349;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0101xxxxx111001xxxxxxxxxx
                                                                     decw.  */
                                                                  return 1357;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0011xxxxx111001xxxxxxxxxx
                                                                     dech.  */
                                                                  return 1353;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0111xxxxx111001xxxxxxxxxx
                                                                     decd.  */
                                                                  return 1351;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00010xxxx111101xxxxxxxxxx
                                                                         uqincb.  */
                                                                      return 1988;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01010xxxx111101xxxxxxxxxx
                                                                         uqincw.  */
                                                                      return 2000;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00110xxxx111101xxxxxxxxxx
                                                                         uqinch.  */
                                                                      return 1994;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01110xxxx111101xxxxxxxxxx
                                                                         uqincd.  */
                                                                      return 1991;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00011xxxx111101xxxxxxxxxx
                                                                         uqincb.  */
                                                                      return 1989;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01011xxxx111101xxxxxxxxxx
                                                                         uqincw.  */
                                                                      return 2001;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00111xxxx111101xxxxxxxxxx
                                                                         uqinch.  */
                                                                      return 1995;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01111xxxx111101xxxxxxxxxx
                                                                         uqincd.  */
                                                                      return 1992;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00010xxxx111x11xxxxxxxxxx
                                                                     uqdecb.  */
                                                                  return 1974;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01010xxxx111x11xxxxxxxxxx
                                                                     uqdecw.  */
                                                                  return 1986;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00110xxxx111x11xxxxxxxxxx
                                                                     uqdech.  */
                                                                  return 1980;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01110xxxx111x11xxxxxxxxxx
                                                                     uqdecd.  */
                                                                  return 1977;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00011xxxx111x11xxxxxxxxxx
                                                                     uqdecb.  */
                                                                  return 1975;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01011xxxx111x11xxxxxxxxxx
                                                                     uqdecw.  */
                                                                  return 1987;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00111xxxx111x11xxxxxxxxxx
                                                                     uqdech.  */
                                                                  return 1981;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01111xxxx111x11xxxxxxxxxx
                                                                     uqdecd.  */
                                                                  return 1978;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0000xxxxx111xxxxxxxxxxxxx
                                                         prfb.  */
                                                      return 1760;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0100xxxxx111xxxxxxxxxxxxx
                                                         prfh.  */
                                                      return 1774;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0001xxxxx111xxxxxxxxxxxxx
                                                         ldff1b.  */
                                                      return 1628;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0101xxxxx111xxxxxxxxxxxxx
                                                         ldff1h.  */
                                                      return 1649;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x001xxxxxx111xxxxxxxxxxxxx
                                                     ld1rb.  */
                                                  return 1530;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x011xxxxxx111xxxxxxxxxxxxx
                                                     ld1rh.  */
                                                  return 1534;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0000xxxxx111xxxxxxxxxxxxx
                                                     prfb.  */
                                                  return 1762;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0100xxxxx111xxxxxxxxxxxxx
                                                     prfh.  */
                                                  return 1776;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0010xxxxx111xxxxxxxxxxxxx
                                                     ldff1b.  */
                                                  return 1627;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0110xxxxx111xxxxxxxxxxxxx
                                                     ldff1h.  */
                                                  return 1647;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0001xxxxx111xxxxxxxxxxxxx
                                                     ldff1b.  */
                                                  return 1629;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0101xxxxx111xxxxxxxxxxxxx
                                                     ldff1h.  */
                                                  return 1650;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0011xxxxx111xxxxxxxxxxxxx
                                                     prfd.  */
                                                  return 1766;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0111xxxxx111xxxxxxxxxxxxx
                                                     ldff1h.  */
                                                  return 1648;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 21) & 0x1) == 0)
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx000xxxxxxxx0xxxx
                                                     cmphs.  */
                                                  return 1322;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx000xxxxxxxx1xxxx
                                                     cmphi.  */
                                                  return 1319;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x00x0xxxxx000xxxxxxxxxxxxx
                                                     ld1rqb.  */
                                                  return 1536;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x01x0xxxxx000xxxxxxxxxxxxx
                                                     ld1rqh.  */
                                                  return 1540;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx010xxxxxxxx0xxxx
                                                     cmpge.  */
                                                  return 1313;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx010xxxxxxxx1xxxx
                                                     cmpgt.  */
                                                  return 1316;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0000xxxxx010xxxxxxxxxxxxx
                                                         ld1b.  */
                                                      return 1494;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0100xxxxx010xxxxxxxxxxxxx
                                                         ld1sw.  */
                                                      return 1574;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0010xxxxx010xxxxxxxxxxxxx
                                                         ld1b.  */
                                                      return 1496;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0110xxxxx010xxxxxxxxxxxxx
                                                         ld1h.  */
                                                      return 1516;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx001xxxxxxxx0xxxx
                                                     cmpeq.  */
                                                  return 1310;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx001xxxxxxxx1xxxx
                                                     cmpne.  */
                                                  return 1333;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x00x0xxxxx001xxxxxxxxxxxxx
                                                     ld1rqb.  */
                                                  return 1535;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x01x0xxxxx001xxxxxxxxxxxxx
                                                     ld1rqh.  */
                                                  return 1539;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx011xxxxxxxx0xxxx
                                                     cmplt.  */
                                                  return 1331;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx011xxxxxxxx1xxxx
                                                     cmple.  */
                                                  return 1325;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0000xxxxx011xxxxxxxxxxxxx
                                                         ldff1b.  */
                                                      return 1618;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0100xxxxx011xxxxxxxxxxxxx
                                                         ldff1sw.  */
                                                      return 1674;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0010xxxxx011xxxxxxxxxxxxx
                                                         ldff1b.  */
                                                      return 1622;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0110xxxxx011xxxxxxxxxxxxx
                                                         ldff1h.  */
                                                      return 1641;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         011001x0xx0xxxxx0xxxxxxxxxxxxxxx
                                         fcmla.  */
                                      return 1379;
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 111001x0x00xxxxx0x0xxxxxxxxxxxxx
                                                 st1b.  */
                                              return 1856;
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0010xxxxx0x0xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1860;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0110xxxxx0x0xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1881;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0000xxxxx0x1xxxxxxxxxxxxx
                                                     stnt1b.  */
                                                  return 1926;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0100xxxxx0x1xxxxxxxxxxxxx
                                                     stnt1h.  */
                                                  return 1930;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0010xxxxx0x1xxxxxxxxxxxxx
                                                     st3b.  */
                                                  return 1910;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0110xxxxx0x1xxxxxxxxxxxxx
                                                     st3h.  */
                                                  return 1914;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 13) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 4) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x01001x0xx0xxxxx100xxxxxxxx0xxxx
                                                 cmpge.  */
                                              return 1314;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x01001x0xx0xxxxx100xxxxxxxx1xxxx
                                                 cmpgt.  */
                                              return 1317;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx110xxxxxxxx0xxxx
                                                     cmphs.  */
                                                  return 1323;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx110xxxxxxxx1xxxx
                                                     cmphi.  */
                                                  return 1320;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0000xxxxx110xxxxxxxxxxxxx
                                                         ldnt1b.  */
                                                      return 1709;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0100xxxxx110xxxxxxxxxxxxx
                                                         ldnt1h.  */
                                                      return 1713;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0010xxxxx110xxxxxxxxxxxxx
                                                         ld3b.  */
                                                      return 1601;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0110xxxxx110xxxxxxxxxxxxx
                                                         ld3h.  */
                                                      return 1605;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             011001x0xx0xxxxx1x0xxxxxxxxxxxxx
                                             fcadd.  */
                                          return 1378;
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0000xxxxx1x0xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1857;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0100xxxxx1x0xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1876;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0010xxxxx1x0xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1861;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0110xxxxx1x0xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1882;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx101xxxxxxxx0xxxx
                                                     cmpeq.  */
                                                  return 1311;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx101xxxxxxxx1xxxx
                                                     cmpne.  */
                                                  return 1334;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 20) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x00000xxxx101xxxxxxxxxxxxx
                                                             ld1b.  */
                                                          return 1501;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x01000xxxx101xxxxxxxxxxxxx
                                                             ld1sw.  */
                                                          return 1579;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x00100xxxx101xxxxxxxxxxxxx
                                                             ld1b.  */
                                                          return 1503;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x01100xxxx101xxxxxxxxxxxxx
                                                             ld1h.  */
                                                          return 1524;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x00001xxxx101xxxxxxxxxxxxx
                                                             ldnf1b.  */
                                                          return 1693;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x01001xxxx101xxxxxxxxxxxxx
                                                             ldnf1sw.  */
                                                          return 1706;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x00101xxxx101xxxxxxxxxxxxx
                                                             ldnf1b.  */
                                                          return 1695;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x01101xxxx101xxxxxxxxxxxxx
                                                             ldnf1h.  */
                                                          return 1699;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0000xxxxx101xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1858;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0100xxxxx101xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1877;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0010xxxxx101xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1865;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0110xxxxx101xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1886;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx111xxxxxxxx0xxxx
                                                     cmplo.  */
                                                  return 1327;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx111xxxxxxxx1xxxx
                                                     cmpls.  */
                                                  return 1329;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0000xxxxx111xxxxxxxxxxxxx
                                                         ldnt1b.  */
                                                      return 1710;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0100xxxxx111xxxxxxxxxxxxx
                                                         ldnt1h.  */
                                                      return 1714;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0010xxxxx111xxxxxxxxxxxxx
                                                         ld3b.  */
                                                      return 1602;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0110xxxxx111xxxxxxxxxxxxx
                                                         ld3h.  */
                                                      return 1606;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 20) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0x000xxxx111xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1863;
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00100xxxx111xxxxxxxxxxxxx
                                                         st1b.  */
                                                      return 1866;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x01100xxxx111xxxxxxxxxxxxx
                                                         st1h.  */
                                                      return 1887;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00001xxxx111xxxxxxxxxxxxx
                                                         stnt1b.  */
                                                      return 1927;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x01001xxxx111xxxxxxxxxxxxx
                                                         stnt1h.  */
                                                      return 1931;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00101xxxx111xxxxxxxxxxxxx
                                                         st3b.  */
                                                      return 1911;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x01101xxxx111xxxxxxxxxxxxx
                                                         st3h.  */
                                                      return 1915;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 13) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      if (((word >> 4) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             001001x0xx1xxxxxxx0xxxxxxxx0xxxx
                                             cmphs.  */
                                          return 1324;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             001001x0xx1xxxxxxx0xxxxxxxx1xxxx
                                             cmphi.  */
                                          return 1321;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x0001xxxxx0x0xxxxxxxxxxxxx
                                                     ld1b.  */
                                                  return 1495;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x0101xxxxx0x0xxxxxxxxxxxxx
                                                     ld1h.  */
                                                  return 1515;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x0011xxxxx0x0xxxxxxxxxxxxx
                                                     ld1b.  */
                                                  return 1497;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x0111xxxxx0x0xxxxxxxxxxxxx
                                                     ld1h.  */
                                                  return 1517;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x0001xxxxx1x0xxxxxxxxxxxxx
                                                     ld2b.  */
                                                  return 1593;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x0101xxxxx1x0xxxxxxxxxxxxx
                                                     ld2h.  */
                                                  return 1597;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x0011xxxxx1x0xxxxxxxxxxxxx
                                                     ld4b.  */
                                                  return 1609;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x0111xxxxx1x0xxxxxxxxxxxxx
                                                     ld4h.  */
                                                  return 1613;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 15) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00x1xxxxx0000x0xxxxxxxxxx
                                                         fmla.  */
                                                      return 1432;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x0101xxxxx0000x0xxxxxxxxxx
                                                             fmla.  */
                                                          return 1433;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x0111xxxxx0000x0xxxxxxxxxx
                                                             fmla.  */
                                                          return 1434;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00x1xxxxx0000x1xxxxxxxxxx
                                                         fmls.  */
                                                      return 1436;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x0101xxxxx0000x1xxxxxxxxxx
                                                             fmls.  */
                                                          return 1437;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x0111xxxxx0000x1xxxxxxxxxx
                                                             fmls.  */
                                                          return 1438;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0x01xxxxx0001xxxxxxxxxxxx
                                                     fcmla.  */
                                                  return 1380;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0x11xxxxx0001xxxxxxxxxxxx
                                                     fcmla.  */
                                                  return 1381;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0001xxxxx010xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1859;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0101xxxxx010xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1878;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0011xxxxx010xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1862;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0111xxxxx010xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1883;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x11001x0x01xxxxx1x0xxxxxxxxxxxxx
                                             st1h.  */
                                          return 1879;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x11001x0x11xxxxx1x0xxxxxxxxxxxxx
                                             st1h.  */
                                          return 1884;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      if (((word >> 4) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             001001x0xx1xxxxxxx1xxxxxxxx0xxxx
                                             cmplo.  */
                                          return 1328;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             001001x0xx1xxxxxxx1xxxxxxxx1xxxx
                                             cmpls.  */
                                          return 1330;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 20) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x00010xxxxx01xxxxxxxxxxxxx
                                                         ld1b.  */
                                                      return 1502;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x01010xxxxx01xxxxxxxxxxxxx
                                                         ld1h.  */
                                                      return 1523;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x00110xxxxx01xxxxxxxxxxxxx
                                                         ld1b.  */
                                                      return 1504;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x01110xxxxx01xxxxxxxxxxxxx
                                                         ld1h.  */
                                                      return 1525;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x00011xxxxx01xxxxxxxxxxxxx
                                                         ldnf1b.  */
                                                      return 1694;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x01011xxxxx01xxxxxxxxxxxxx
                                                         ldnf1h.  */
                                                      return 1698;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x00111xxxxx01xxxxxxxxxxxxx
                                                         ldnf1b.  */
                                                      return 1696;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x01111xxxxx01xxxxxxxxxxxxx
                                                         ldnf1h.  */
                                                      return 1700;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0001xxxxx011xxxxxxxxxxxxx
                                                         ldff1b.  */
                                                      return 1620;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0101xxxxx011xxxxxxxxxxxxx
                                                         ldff1h.  */
                                                      return 1639;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0011xxxxx011xxxxxxxxxxxxx
                                                         ldff1b.  */
                                                      return 1624;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0111xxxxx011xxxxxxxxxxxxx
                                                         ldff1h.  */
                                                      return 1643;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0001xxxxx111xxxxxxxxxxxxx
                                                         ld2b.  */
                                                      return 1594;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0101xxxxx111xxxxxxxxxxxxx
                                                         ld2h.  */
                                                      return 1598;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0011xxxxx111xxxxxxxxxxxxx
                                                         ld4b.  */
                                                      return 1610;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0111xxxxx111xxxxxxxxxxxxx
                                                         ld4h.  */
                                                      return 1614;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x11001x00x1xxxxx001xxxxxxxxxxxxx
                                                 fmul.  */
                                              return 1443;
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0101xxxxx001xxxxxxxxxxxxx
                                                     fmul.  */
                                                  return 1444;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0111xxxxx001xxxxxxxxxxxxx
                                                     fmul.  */
                                                  return 1445;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x11001x0x01xxxxx101xxxxxxxxxxxxx
                                                 st1h.  */
                                              return 1880;
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0011xxxxx101xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1867;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0111xxxxx101xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1888;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0001xxxxx011xxxxxxxxxxxxx
                                                     st2b.  */
                                                  return 1902;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0101xxxxx011xxxxxxxxxxxxx
                                                     st2h.  */
                                                  return 1906;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0011xxxxx011xxxxxxxxxxxxx
                                                     st4b.  */
                                                  return 1918;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0111xxxxx011xxxxxxxxxxxxx
                                                     st4h.  */
                                                  return 1922;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 20) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00010xxxx111xxxxxxxxxxxxx
                                                         st1b.  */
                                                      return 1864;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x01010xxxx111xxxxxxxxxxxxx
                                                         st1h.  */
                                                      return 1885;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00110xxxx111xxxxxxxxxxxxx
                                                         st1b.  */
                                                      return 1868;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x01110xxxx111xxxxxxxxxxxxx
                                                         st1h.  */
                                                      return 1889;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00011xxxx111xxxxxxxxxxxxx
                                                         st2b.  */
                                                      return 1903;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x01011xxxx111xxxxxxxxxxxxx
                                                         st2h.  */
                                                      return 1907;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00111xxxx111xxxxxxxxxxxxx
                                                         st4b.  */
                                                      return 1919;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x01111xxxx111xxxxxxxxxxxxx
                                                         st4h.  */
                                                      return 1923;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 29) & 0x1) == 0)
                    {
                      if (((word >> 30) & 0x1) == 0)
                        {
                          if (((word >> 31) & 0x1) == 0)
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  if (((word >> 20) & 0x1) == 0)
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x10000xxxxxxxxxxxxxxxxxxxx
                                                 orr.  */
                                              return 1748;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x11000xxxxxxxxxxxxxxxxxxxx
                                                 and.  */
                                              return 1276;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x10100xxxxxxxxxxxxxxxxxxxx
                                                 eor.  */
                                              return 1363;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x11100xxxxxxxxxxxxxxxxxxxx
                                                 dupm.  */
                                              return 1361;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             000001x1xx01xxxx0xxxxxxxxxxxxxxx
                                             cpy.  */
                                          return 1346;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             000001x1xx01xxxx1xxxxxxxxxxxxxxx
                                             fcpy.  */
                                          return 1393;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x1xx1xxxxx000xxxxxxxxxxxxx
                                                 ext.  */
                                              return 1368;
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x0000100xxxxxxxxxxxxx
                                                                 cpy.  */
                                                              return 1344;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x1000100xxxxxxxxxxxxx
                                                                 clasta.  */
                                                              return 1302;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x0100100xxxxxxxxxxxxx
                                                                 revb.  */
                                                              return 1796;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x1100100xxxxxxxxxxxxx
                                                                 splice.  */
                                                              return 1823;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x0010100xxxxxxxxxxxxx
                                                                 lasta.  */
                                                              return 1490;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x1010100xxxxxxxxxxxxx
                                                                 clasta.  */
                                                              return 1303;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xx110100xxxxxxxxxxxxx
                                                             revw.  */
                                                          return 1798;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x0001100xxxxxxxxxxxxx
                                                                 compact.  */
                                                              return 1343;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x1001100xxxxxxxxxxxxx
                                                                 clastb.  */
                                                              return 1305;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xx101100xxxxxxxxxxxxx
                                                             revh.  */
                                                          return 1797;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x0011100xxxxxxxxxxxxx
                                                                 lastb.  */
                                                              return 1492;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x1011100xxxxxxxxxxxxx
                                                                 clastb.  */
                                                              return 1306;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xx111100xxxxxxxxxxxxx
                                                             rbit.  */
                                                          return 1789;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx1xxxxx00100xxxxxxxxxxx
                                                         dup.  */
                                                      return 1359;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx1xxxxx00110xxxxxxxxxxx
                                                         tbl.  */
                                                      return 1946;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x1xx100000001x1xxxxxxxxxxx
                                                                         dup.  */
                                                                      return 1358;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x1xx110000001x1xxxxxxxxxxx
                                                                         sunpklo.  */
                                                                      return 1942;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x1xx1x1000001x1xxxxxxxxxxx
                                                                     rev.  */
                                                                  return 1795;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x1xx10x100001x1xxxxxxxxxxx
                                                                     insr.  */
                                                                  return 1487;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x1xx11x100001x1xxxxxxxxxxx
                                                                     insr.  */
                                                                  return 1488;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxx10001x1xxxxxxxxxxx
                                                             uunpklo.  */
                                                          return 2005;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxx01001x1xxxxxxxxxxx
                                                             sunpkhi.  */
                                                          return 1941;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxx11001x1xxxxxxxxxxx
                                                             uunpkhi.  */
                                                          return 2004;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx100xx0101xxxxxxxxxxxxx
                                                             lasta.  */
                                                          return 1489;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx110xx0101xxxxxxxxxxxxx
                                                             clasta.  */
                                                          return 1304;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx1x1xx0101xxxxxxxxxxxxx
                                                         cpy.  */
                                                      return 1345;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx10xxx1101xxxxxxxxxxxxx
                                                         lastb.  */
                                                      return 1491;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx11xxx1101xxxxxxxxxxxxx
                                                         clastb.  */
                                                      return 1307;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 10) & 0x1) == 0)
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      if (((word >> 13) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx10xxxx010000xxxxxxxxxx
                                                                 zip1.  */
                                                              return 2022;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 16) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 18) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x1xx11x0x0010000xxxxxxxxxx
                                                                         punpklo.  */
                                                                      return 1788;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x1xx11x1x0010000xxxxxxxxxx
                                                                         rev.  */
                                                                      return 1794;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x1xx11xxx1010000xxxxxxxxxx
                                                                     punpkhi.  */
                                                                  return 1787;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx011000xxxxxxxxxx
                                                             zip1.  */
                                                          return 2023;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 13) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx010100xxxxxxxxxx
                                                             trn1.  */
                                                          return 1947;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx011100xxxxxxxxxx
                                                             trn1.  */
                                                          return 1948;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx1xxxxx010x10xxxxxxxxxx
                                                         uzp1.  */
                                                      return 2009;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx1xxxxx011x10xxxxxxxxxx
                                                         uzp1.  */
                                                      return 2010;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      if (((word >> 13) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx010001xxxxxxxxxx
                                                             zip2.  */
                                                          return 2024;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx011001xxxxxxxxxx
                                                             zip2.  */
                                                          return 2025;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 13) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx010101xxxxxxxxxx
                                                             trn2.  */
                                                          return 1949;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx011101xxxxxxxxxx
                                                             trn2.  */
                                                          return 1950;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx1xxxxx010x11xxxxxxxxxx
                                                         uzp2.  */
                                                      return 2011;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx1xxxxx011x11xxxxxxxxxx
                                                         uzp2.  */
                                                      return 2012;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             000001x1xx1xxxxx11xxxxxxxxxxxxxx
                                             sel.  */
                                          return 1813;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 13) & 0x1) == 0)
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x1x0xxxxxx000xxxxxxxxxxxxx
                                                 ldr.  */
                                              return 1717;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x1x1xxxxxx000xxxxxxxxxxxxx
                                                 prfb.  */
                                              return 1761;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x10xxxxxxx100xxxxxxxxxxxxx
                                                 ld1rsh.  */
                                              return 1546;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x11xxxxxxx100xxxxxxxxxxxxx
                                                 ld1rsb.  */
                                              return 1543;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x10x0xxxxx010xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1581;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x10x1xxxxx010xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1582;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x110xxxxxx010xxxxxxxxxxxxx
                                                     ldr.  */
                                                  return 1718;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x111xxxxxx010xxxxxxxxxxxxx
                                                     prfw.  */
                                                  return 1782;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x1000xxxxx110xxxxxxxxxxxxx
                                                         prfw.  */
                                                      return 1778;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x1100xxxxx110xxxxxxxxxxxxx
                                                         prfd.  */
                                                      return 1764;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x1x01xxxxx110xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1589;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x101xxxxxx110xxxxxxxxxxxxx
                                                     ld1rw.  */
                                                  return 1549;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x111xxxxxx110xxxxxxxxxxxxx
                                                     ld1rsb.  */
                                                  return 1545;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             100001x1xxxxxxxx001xxxxxxxxxxxxx
                                             prfh.  */
                                          return 1775;
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x10xxxxxxx101xxxxxxxxxxxxx
                                                 ld1rsh.  */
                                              return 1547;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x11xxxxxxx101xxxxxxxxxxxxx
                                                 ld1rsb.  */
                                              return 1544;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x10x0xxxxx011xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1681;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x10x1xxxxx011xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1682;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x11xxxxxxx011xxxxxxxxxxxxx
                                                 prfd.  */
                                              return 1768;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x1000xxxxx111xxxxxxxxxxxxx
                                                         prfw.  */
                                                      return 1781;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x1100xxxxx111xxxxxxxxxxxxx
                                                         prfd.  */
                                                      return 1767;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x1x01xxxxx111xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1691;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x101xxxxxx111xxxxxxxxxxxxx
                                                     ld1rw.  */
                                                  return 1550;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x111xxxxxx111xxxxxxxxxxxxx
                                                     ld1rd.  */
                                                  return 1531;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 13) & 0x1) == 0)
                            {
                              if (((word >> 14) & 0x1) == 0)
                                {
                                  if (((word >> 15) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x10001x1xx0xxxxx000xxxxxxxxxxxxx
                                             ld1sw.  */
                                          return 1575;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x10001x1xx1xxxxx000xxxxxxxxxxxxx
                                             ld1sw.  */
                                          return 1576;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x10001x1xx0xxxxx100xxxxxxxxxxxxx
                                             ld1sw.  */
                                          return 1577;
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x1x01xxxxx100xxxxxxxxxxxxx
                                                 ld1sw.  */
                                              return 1580;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x1x11xxxxx100xxxxxxxxxxxxx
                                                 ld1sw.  */
                                              return 1578;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 15) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x10x0xxxxx010xxxxxxxxxxxxx
                                                 ld1w.  */
                                              return 1585;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x11x0xxxxx010xxxxxxxxxxxxx
                                                 ld1d.  */
                                              return 1507;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x10x1xxxxx010xxxxxxxxxxxxx
                                                 ld1w.  */
                                              return 1586;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x11x1xxxxx010xxxxxxxxxxxxx
                                                 ld1d.  */
                                              return 1508;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x10x0xxxxx110xxxxxxxxxxxxx
                                                 ld1w.  */
                                              return 1587;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x11x0xxxxx110xxxxxxxxxxxxx
                                                 ld1d.  */
                                              return 1509;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1001xxxxx110xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1592;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1101xxxxx110xxxxxxxxxxxxx
                                                     ld1d.  */
                                                  return 1512;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1011xxxxx110xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1588;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1111xxxxx110xxxxxxxxxxxxx
                                                     ld1d.  */
                                                  return 1510;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 14) & 0x1) == 0)
                                {
                                  if (((word >> 15) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x10001x1xx0xxxxx001xxxxxxxxxxxxx
                                             ldff1sw.  */
                                          return 1676;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x10001x1xx1xxxxx001xxxxxxxxxxxxx
                                             ldff1sw.  */
                                          return 1677;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x10001x1xx0xxxxx101xxxxxxxxxxxxx
                                             ldff1sw.  */
                                          return 1678;
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x1x01xxxxx101xxxxxxxxxxxxx
                                                 ldff1sw.  */
                                              return 1680;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x1x11xxxxx101xxxxxxxxxxxxx
                                                 ldff1sw.  */
                                              return 1679;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 15) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x10x0xxxxx011xxxxxxxxxxxxx
                                                 ldff1w.  */
                                              return 1687;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x11x0xxxxx011xxxxxxxxxxxxx
                                                 ldff1d.  */
                                              return 1632;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x10x1xxxxx011xxxxxxxxxxxxx
                                                 ldff1w.  */
                                              return 1688;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x11x1xxxxx011xxxxxxxxxxxxx
                                                 ldff1d.  */
                                              return 1633;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1000xxxxx111xxxxxxxxxxxxx
                                                     prfw.  */
                                                  return 1783;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1100xxxxx111xxxxxxxxxxxxx
                                                     prfd.  */
                                                  return 1769;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1010xxxxx111xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1689;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1110xxxxx111xxxxxxxxxxxxx
                                                     ldff1d.  */
                                                  return 1634;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1001xxxxx111xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1692;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1101xxxxx111xxxxxxxxxxxxx
                                                     ldff1d.  */
                                                  return 1636;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1011xxxxx111xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1690;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1111xxxxx111xxxxxxxxxxxxx
                                                     ldff1d.  */
                                                  return 1635;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 15) & 0x1) == 0)
                        {
                          if (((word >> 14) & 0x1) == 0)
                            {
                              if (((word >> 13) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x1xx0xxxxx000xxxxxxxx0xxxx
                                                     cmpge.  */
                                                  return 1315;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x1xx0xxxxx000xxxxxxxx1xxxx
                                                     cmpgt.  */
                                                  return 1318;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x10x0xxxxx000xxxxxxxxxxxxx
                                                     ld1rqw.  */
                                                  return 1542;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x11x0xxxxx000xxxxxxxxxxxxx
                                                     ld1rqd.  */
                                                  return 1538;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 4) & 0x1) == 0)
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x1xx1xxxxx00000xxxxxx0xxxx
                                                         whilelt.  */
                                                      return 2019;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x1xx1xxxxx00010xxxxxx0xxxx
                                                         whilelt.  */
                                                      return 2020;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x1xx1xxxxx00001xxxxxx0xxxx
                                                         whilelo.  */
                                                      return 2015;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x1xx1xxxxx00011xxxxxx0xxxx
                                                         whilelo.  */
                                                      return 2016;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x1xx1xxxxx00000xxxxxx1xxxx
                                                         whilele.  */
                                                      return 2013;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x1xx1xxxxx00010xxxxxx1xxxx
                                                         whilele.  */
                                                      return 2014;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x1xx1xxxxx00001xxxxxx1xxxx
                                                         whilels.  */
                                                      return 2017;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x1xx1xxxxx00011xxxxxx1xxxx
                                                         whilels.  */
                                                      return 2018;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x1xx0xxxxx000x00xxxxxxxxxx
                                                         fadd.  */
                                                      return 1373;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x1xx0xxxxx000010xxxxxxxxxx
                                                             fmul.  */
                                                          return 1440;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x1xx0xxxxx000110xxxxxxxxxx
                                                             frecps.  */
                                                          return 1453;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x1xx0xxxxx000x01xxxxxxxxxx
                                                         fsub.  */
                                                      return 1466;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x1xx0xxxxx000011xxxxxxxxxx
                                                             ftsmul.  */
                                                          return 1472;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x1xx0xxxxx000111xxxxxxxxxx
                                                             frsqrts.  */
                                                          return 1463;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 011001x1xx1xxxxx000xxxxxxxxxxxxx
                                                 fmla.  */
                                              return 1431;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             111001x1xxxxxxxx000xxxxxxxxxxxxx
                                             str.  */
                                          return 1934;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x1xx0xxxxx001xxxxxxxx0xxxx
                                                     cmplt.  */
                                                  return 1332;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x1xx0xxxxx001xxxxxxxx1xxxx
                                                     cmple.  */
                                                  return 1326;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x10x0xxxxx001xxxxxxxxxxxxx
                                                     ld1rqw.  */
                                                  return 1541;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x11x0xxxxx001xxxxxxxxxxxxx
                                                     ld1rqd.  */
                                                  return 1537;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 16) & 0x1) == 0)
                                            {
                                              if (((word >> 17) & 0x1) == 0)
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x11001x1xx000000001xxxxxxxxxxxxx
                                                                 faddv.  */
                                                              return 1377;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 4) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     x11001x1xx010000001xxxxxxxx0xxxx
                                                                     fcmge.  */
                                                                  return 1384;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     x11001x1xx010000001xxxxxxxx1xxxx
                                                                     fcmgt.  */
                                                                  return 1386;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x1xx0x1000001xxxxxxxxxxxxx
                                                             fadda.  */
                                                          return 1376;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x1xx0xx100001xxxxxxxxxxxxx
                                                         fmaxnmv.  */
                                                      return 1423;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x1xx0xx010001xxxxxxxxxxxxx
                                                         fcmeq.  */
                                                      return 1382;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x1xx0x0110001xxxxxxxxxxxxx
                                                             fmaxv.  */
                                                          return 1424;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x1xx0x1110001xxxxxxxxxxxxx
                                                             frecpe.  */
                                                          return 1452;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 17) & 0x1) == 0)
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      if (((word >> 4) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x1xx0xx001001xxxxxxxx0xxxx
                                                             fcmlt.  */
                                                          return 1389;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x1xx0xx001001xxxxxxxx1xxxx
                                                             fcmle.  */
                                                          return 1388;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x1xx0xx101001xxxxxxxxxxxxx
                                                         fminnmv.  */
                                                      return 1429;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x1xx0xx011001xxxxxxxxxxxxx
                                                         fcmne.  */
                                                      return 1390;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x1xx0x0111001xxxxxxxxxxxxx
                                                             fminv.  */
                                                          return 1430;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x1xx0x1111001xxxxxxxxxxxxx
                                                             frsqrte.  */
                                                          return 1462;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 4) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x01001x1xx1xxxxx001xxxxxxxx0xxxx
                                                 ctermeq.  */
                                              return 1347;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x01001x1xx1xxxxx001xxxxxxxx1xxxx
                                                 ctermne.  */
                                              return 1348;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x11001x1xx1xxxxx001xxxxxxxxxxxxx
                                             fmls.  */
                                          return 1435;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 9) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 4) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x10000xxxx01xxxx0xxxx0xxxx
                                                                 and.  */
                                                              return 1278;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x10000xxxx01xxxx0xxxx1xxxx
                                                                 bic.  */
                                                              return 1290;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x100010xxx01xxxx0xxxxxxxxx
                                                                 brka.  */
                                                              return 1292;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x100011xxx01xxxx0xxxxxxxxx
                                                                 brkn.  */
                                                              return 1296;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 4) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1000xxxxx01xxxx1xxxx0xxxx
                                                             eor.  */
                                                          return 1365;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1000xxxxx01xxxx1xxxx1xxxx
                                                             sel.  */
                                                          return 1814;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1000xxxxx010xxxxxxxxxxxxx
                                                         ld1sh.  */
                                                      return 1564;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1000xxxxx011xxxxxxxxxxxxx
                                                         ldff1sh.  */
                                                      return 1664;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 9) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 4) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x11000xxxx01xxxx0xxxx0xxxx
                                                                 orr.  */
                                                              return 1750;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x11000xxxx01xxxx0xxxx1xxxx
                                                                 orn.  */
                                                              return 1745;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x11001xxxx01xxxx0xxxxxxxxx
                                                             brkb.  */
                                                          return 1294;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 4) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1100xxxxx01xxxx1xxxx0xxxx
                                                             nor.  */
                                                          return 1742;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1100xxxxx01xxxx1xxxx1xxxx
                                                             nand.  */
                                                          return 1739;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1100xxxxx010xxxxxxxxxxxxx
                                                         ld1sb.  */
                                                      return 1552;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1100xxxxx011xxxxxxxxxxxxx
                                                         ldff1sb.  */
                                                      return 1652;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 4) & 0x1) == 0)
                                                    {
                                                      if (((word >> 9) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x10100xxxx01xxxx0xxxx0xxxx
                                                                 ands.  */
                                                              return 1279;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     001001x101010xxx01xxxx0xxxx0xxxx
                                                                     brkas.  */
                                                                  return 1293;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     001001x101011xxx01xxxx0xxxx0xxxx
                                                                     brkns.  */
                                                                  return 1297;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1010xxxxx01xxxx1xxxx0xxxx
                                                             eors.  */
                                                          return 1366;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1010xxxxx01xxxxxxxxx1xxxx
                                                         bics.  */
                                                      return 1291;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1010xxxxx010xxxxxxxxxxxxx
                                                         ld1w.  */
                                                      return 1583;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1010xxxxx011xxxxxxxxxxxxx
                                                         ldff1w.  */
                                                      return 1683;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 4) & 0x1) == 0)
                                                    {
                                                      if (((word >> 9) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x11100xxxx01xxxx0xxxx0xxxx
                                                                 orrs.  */
                                                              return 1751;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x11101xxxx01xxxx0xxxx0xxxx
                                                                 brkbs.  */
                                                              return 1295;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1110xxxxx01xxxx1xxxx0xxxx
                                                             nors.  */
                                                          return 1743;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 9) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1110xxxxx01xxxx0xxxx1xxxx
                                                             orns.  */
                                                          return 1746;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1110xxxxx01xxxx1xxxx1xxxx
                                                             nands.  */
                                                          return 1740;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1110xxxxx010xxxxxxxxxxxxx
                                                         ld1sb.  */
                                                      return 1554;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1110xxxxx011xxxxxxxxxxxxx
                                                         ldff1sb.  */
                                                      return 1656;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1001xxxxx010xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1565;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1101xxxxx010xxxxxxxxxxxxx
                                                     ld1sb.  */
                                                  return 1553;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1011xxxxx010xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1584;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1111xxxxx010xxxxxxxxxxxxx
                                                     ld1d.  */
                                                  return 1506;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1001xxxxx011xxxxxxxxxxxxx
                                                     ldff1sh.  */
                                                  return 1666;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1101xxxxx011xxxxxxxxxxxxx
                                                     ldff1sb.  */
                                                  return 1654;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1011xxxxx011xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1685;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1111xxxxx011xxxxxxxxxxxxx
                                                     ldff1d.  */
                                                  return 1630;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x1xx0xxxxx010xxxxxxxx0xxxx
                                                     fcmge.  */
                                                  return 1385;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x1xx0xxxxx010xxxxxxxx1xxxx
                                                     fcmgt.  */
                                                  return 1387;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 011001x1xx1xxxxx010xxxxxxxxxxxxx
                                                 fnmla.  */
                                              return 1449;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 111001x1x0xxxxxx010xxxxxxxxxxxxx
                                                 str.  */
                                              return 1935;
                                            }
                                          else
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x1x10xxxxx010xxxxxxxxxxxxx
                                                     st1w.  */
                                                  return 1894;
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1011xxxxx010xxxxxxxxxxxxx
                                                         st1w.  */
                                                      return 1896;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1111xxxxx010xxxxxxxxxxxxx
                                                         st1d.  */
                                                      return 1873;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x1xx0xxxxx011xxxxxxxx0xxxx
                                                     fcmeq.  */
                                                  return 1383;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x1xx0xxxxx011xxxxxxxx1xxxx
                                                     fcmne.  */
                                                  return 1391;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1000xxxxx011xxxxxxxxxxxxx
                                                         stnt1w.  */
                                                      return 1932;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1100xxxxx011xxxxxxxxxxxxx
                                                         stnt1d.  */
                                                      return 1928;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1010xxxxx011xxxxxxxxxxxxx
                                                         st3w.  */
                                                      return 1916;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1110xxxxx011xxxxxxxxxxxxx
                                                         st3d.  */
                                                      return 1912;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 011001x1xx1xxxxx011xxxxxxxxxxxxx
                                                 fnmls.  */
                                              return 1450;
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1001xxxxx011xxxxxxxxxxxxx
                                                         st2w.  */
                                                      return 1908;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1101xxxxx011xxxxxxxxxxxxx
                                                         st2d.  */
                                                      return 1904;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1011xxxxx011xxxxxxxxxxxxx
                                                         st4w.  */
                                                      return 1924;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1111xxxxx011xxxxxxxxxxxxx
                                                         st4d.  */
                                                      return 1920;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 21) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 4) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x01001x1xx0xxxxx100xxxxxxxx0xxxx
                                                 cmpeq.  */
                                              return 1312;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x01001x1xx0xxxxx100xxxxxxxx1xxxx
                                                 cmpne.  */
                                              return 1335;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 20) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x10000xxxx101xxxxxxxxxxxxx
                                                         ld1sh.  */
                                                      return 1571;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x11000xxxx101xxxxxxxxxxxxx
                                                         ld1sb.  */
                                                      return 1558;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x10100xxxx101xxxxxxxxxxxxx
                                                         ld1w.  */
                                                      return 1590;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x11100xxxx101xxxxxxxxxxxxx
                                                         ld1sb.  */
                                                      return 1560;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x10001xxxx101xxxxxxxxxxxxx
                                                         ldnf1sh.  */
                                                      return 1704;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x11001xxxx101xxxxxxxxxxxxx
                                                         ldnf1sb.  */
                                                      return 1701;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x10101xxxx101xxxxxxxxxxxxx
                                                         ldnf1w.  */
                                                      return 1707;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x11101xxxx101xxxxxxxxxxxxx
                                                         ldnf1sb.  */
                                                      return 1703;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 4) & 0x1) == 0)
                                            {
                                              if (((word >> 20) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1x000xxxx11xxxxxxxxx0xxxx
                                                         brkpa.  */
                                                      return 1298;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1x100xxxx11xxxxxxxxx0xxxx
                                                         brkpas.  */
                                                      return 1299;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1xx010xx011xxxxxxxxx0xxxx
                                                             ptest.  */
                                                          return 1784;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 10) & 0x1) == 0)
                                                            {
                                                              if (((word >> 12) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 13) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         001001x1xx011xx01100x0xxxxx0xxxx
                                                                         pfirst.  */
                                                                      return 1754;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         001001x1xx011xx01110x0xxxxx0xxxx
                                                                         ptrue.  */
                                                                      return 1785;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 22) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         001001x1x0011xx011x1x0xxxxx0xxxx
                                                                         rdffr.  */
                                                                      return 1791;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         001001x1x1011xx011x1x0xxxxx0xxxx
                                                                         rdffrs.  */
                                                                      return 1792;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx011xx011xxx1xxxxx0xxxx
                                                                 pfalse.  */
                                                              return 1753;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx01xxx111x0x0xxxxx0xxxx
                                                                 ptrues.  */
                                                              return 1786;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx01xxx111x1x0xxxxx0xxxx
                                                                 rdffr.  */
                                                              return 1790;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1xx01xxx111xxx1xxxxx0xxxx
                                                             pnext.  */
                                                          return 1755;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x1x00xxxxx11xxxxxxxxx1xxxx
                                                     brkpb.  */
                                                  return 1300;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x1x10xxxxx11xxxxxxxxx1xxxx
                                                     brkpbs.  */
                                                  return 1301;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1000xxxxx110xxxxxxxxxxxxx
                                                         ldnt1w.  */
                                                      return 1715;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1100xxxxx110xxxxxxxxxxxxx
                                                         ldnt1d.  */
                                                      return 1711;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1010xxxxx110xxxxxxxxxxxxx
                                                         ld3w.  */
                                                      return 1607;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1110xxxxx110xxxxxxxxxxxxx
                                                         ld3d.  */
                                                      return 1603;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1000xxxxx111xxxxxxxxxxxxx
                                                         ldnt1w.  */
                                                      return 1716;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1100xxxxx111xxxxxxxxxxxxx
                                                         ldnt1d.  */
                                                      return 1712;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1010xxxxx111xxxxxxxxxxxxx
                                                         ld3w.  */
                                                      return 1608;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1110xxxxx111xxxxxxxxxxxxx
                                                         ld3d.  */
                                                      return 1604;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 19) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          if (((word >> 17) & 0x1) == 0)
                                                            {
                                                              if (((word >> 18) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000000100xxxxxxxxxxxxx
                                                                     fadd.  */
                                                                  return 1374;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000100100xxxxxxxxxxxxx
                                                                     fmaxnm.  */
                                                                  return 1421;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 18) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000010100xxxxxxxxxxxxx
                                                                     fmul.  */
                                                                  return 1441;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000110100xxxxxxxxxxxxx
                                                                     fmax.  */
                                                                  return 1419;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 17) & 0x1) == 0)
                                                            {
                                                              if (((word >> 18) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000001100xxxxxxxxxxxxx
                                                                     fsub.  */
                                                                  return 1467;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000101100xxxxxxxxxxxxx
                                                                     fminnm.  */
                                                                  return 1427;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 18) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000011100xxxxxxxxxxxxx
                                                                     fsubr.  */
                                                                  return 1469;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000111100xxxxxxxxxxxxx
                                                                     fmin.  */
                                                                  return 1425;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x1xx010xxx100xxxxxxxxxxxxx
                                                         ftmad.  */
                                                      return 1471;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001000100xxxxxxxxxxxxx
                                                                     fabd.  */
                                                                  return 1369;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011000100xxxxxxxxxxxxx
                                                                     fadd.  */
                                                                  return 1375;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001100100xxxxxxxxxxxxx
                                                                     fdivr.  */
                                                                  return 1415;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011100100xxxxxxxxxxxxx
                                                                     fmaxnm.  */
                                                                  return 1422;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001010100xxxxxxxxxxxxx
                                                                     fmulx.  */
                                                                  return 1446;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011010100xxxxxxxxxxxxx
                                                                     fmul.  */
                                                                  return 1442;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0x1110100xxxxxxxxxxxxx
                                                                 fmax.  */
                                                              return 1420;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001001100xxxxxxxxxxxxx
                                                                     fscale.  */
                                                                  return 1464;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011001100xxxxxxxxxxxxx
                                                                     fsub.  */
                                                                  return 1468;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001101100xxxxxxxxxxxxx
                                                                     fdiv.  */
                                                                  return 1414;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011101100xxxxxxxxxxxxx
                                                                     fminnm.  */
                                                                  return 1428;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0x1011100xxxxxxxxxxxxx
                                                                 fsubr.  */
                                                              return 1470;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0x1111100xxxxxxxxxxxxx
                                                                 fmin.  */
                                                              return 1426;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x1xx0xxxxx110xxxxxxxx0xxxx
                                                     fcmuo.  */
                                                  return 1392;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x1xx0xxxxx110xxxxxxxx1xxxx
                                                     facge.  */
                                                  return 1371;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x1000xxxxx1x0xxxxxxxxxxxxx
                                                     st1w.  */
                                                  return 1890;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x1100xxxxx1x0xxxxxxxxxxxxx
                                                     st1d.  */
                                                  return 1869;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 111001x1x10xxxxx1x0xxxxxxxxxxxxx
                                                 st1w.  */
                                              return 1895;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000000101xxxxxxxxxxxxx
                                                                     frintn.  */
                                                                  return 1458;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx010000101xxxxxxxxxxxxx
                                                                     scvtf.  */
                                                                  return 1804;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 22) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x0001000101xxxxxxxxxxxxx
                                                                         fcvt.  */
                                                                      return 1394;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x1001000101xxxxxxxxxxxxx
                                                                         fcvt.  */
                                                                      return 1396;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011000101xxxxxxxxxxxxx
                                                                     fcvtzs.  */
                                                                  return 1404;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000100101xxxxxxxxxxxxx
                                                                     frinta.  */
                                                                  return 1455;
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 22) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x0010100101xxxxxxxxxxxxx
                                                                         scvtf.  */
                                                                      return 1803;
                                                                    }
                                                                  else
                                                                    {
                                                                      if (((word >> 23) & 0x1) == 0)
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             011001x101010100101xxxxxxxxxxxxx
                                                                             scvtf.  */
                                                                          return 1802;
                                                                        }
                                                                      else
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             011001x111010100101xxxxxxxxxxxxx
                                                                             scvtf.  */
                                                                          return 1806;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001100101xxxxxxxxxxxxx
                                                                     frecpx.  */
                                                                  return 1454;
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 22) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x0011100101xxxxxxxxxxxxx
                                                                         fcvtzs.  */
                                                                      return 1403;
                                                                    }
                                                                  else
                                                                    {
                                                                      if (((word >> 23) & 0x1) == 0)
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             011001x101011100101xxxxxxxxxxxxx
                                                                             fcvtzs.  */
                                                                          return 1401;
                                                                        }
                                                                      else
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             011001x111011100101xxxxxxxxxxxxx
                                                                             fcvtzs.  */
                                                                          return 1405;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000010101xxxxxxxxxxxxx
                                                                     frintm.  */
                                                                  return 1457;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx010010101xxxxxxxxxxxxx
                                                                     scvtf.  */
                                                                  return 1801;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001010101xxxxxxxxxxxxx
                                                                     fcvt.  */
                                                                  return 1398;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011010101xxxxxxxxxxxxx
                                                                     fcvtzs.  */
                                                                  return 1400;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000110101xxxxxxxxxxxxx
                                                                     frintx.  */
                                                                  return 1460;
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x10x010110101xxxxxxxxxxxxx
                                                                         scvtf.  */
                                                                      return 1805;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x11x010110101xxxxxxxxxxxxx
                                                                         scvtf.  */
                                                                      return 1807;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x10x0x1110101xxxxxxxxxxxxx
                                                                     fcvtzs.  */
                                                                  return 1402;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x11x0x1110101xxxxxxxxxxxxx
                                                                     fcvtzs.  */
                                                                  return 1406;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000001101xxxxxxxxxxxxx
                                                                     frintp.  */
                                                                  return 1459;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx010001101xxxxxxxxxxxxx
                                                                     ucvtf.  */
                                                                  return 1956;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 22) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x0001001101xxxxxxxxxxxxx
                                                                         fcvt.  */
                                                                      return 1395;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x1001001101xxxxxxxxxxxxx
                                                                         fcvt.  */
                                                                      return 1397;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011001101xxxxxxxxxxxxx
                                                                     fcvtzu.  */
                                                                  return 1411;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1x00x0101101xxxxxxxxxxxxx
                                                                     ucvtf.  */
                                                                  return 1955;
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1010x0101101xxxxxxxxxxxxx
                                                                         ucvtf.  */
                                                                      return 1954;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1110x0101101xxxxxxxxxxxxx
                                                                         ucvtf.  */
                                                                      return 1958;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001101101xxxxxxxxxxxxx
                                                                     fsqrt.  */
                                                                  return 1465;
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 22) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x0011101101xxxxxxxxxxxxx
                                                                         fcvtzu.  */
                                                                      return 1410;
                                                                    }
                                                                  else
                                                                    {
                                                                      if (((word >> 23) & 0x1) == 0)
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             011001x101011101101xxxxxxxxxxxxx
                                                                             fcvtzu.  */
                                                                          return 1408;
                                                                        }
                                                                      else
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             011001x111011101101xxxxxxxxxxxxx
                                                                             fcvtzu.  */
                                                                          return 1412;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000011101xxxxxxxxxxxxx
                                                                     frintz.  */
                                                                  return 1461;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx010011101xxxxxxxxxxxxx
                                                                     ucvtf.  */
                                                                  return 1953;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001011101xxxxxxxxxxxxx
                                                                     fcvt.  */
                                                                  return 1399;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011011101xxxxxxxxxxxxx
                                                                     fcvtzu.  */
                                                                  return 1407;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000111101xxxxxxxxxxxxx
                                                                     frinti.  */
                                                                  return 1456;
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x10x010111101xxxxxxxxxxxxx
                                                                         ucvtf.  */
                                                                      return 1957;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x11x010111101xxxxxxxxxxxxx
                                                                         ucvtf.  */
                                                                      return 1959;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x10x0x1111101xxxxxxxxxxxxx
                                                                     fcvtzu.  */
                                                                  return 1409;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x11x0x1111101xxxxxxxxxxxxx
                                                                     fcvtzu.  */
                                                                  return 1413;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1000xxxxx101xxxxxxxxxxxxx
                                                         st1w.  */
                                                      return 1891;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1100xxxxx101xxxxxxxxxxxxx
                                                         st1d.  */
                                                      return 1870;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1010xxxxx101xxxxxxxxxxxxx
                                                         st1w.  */
                                                      return 1898;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1110xxxxx101xxxxxxxxxxxxx
                                                         st1d.  */
                                                      return 1874;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 011001x1xx0xxxxx111xxxxxxxxxxxxx
                                                 facgt.  */
                                              return 1372;
                                            }
                                          else
                                            {
                                              if (((word >> 20) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x1xx00xxxx111xxxxxxxxxxxxx
                                                     st1w.  */
                                                  return 1899;
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x10001xxxx111xxxxxxxxxxxxx
                                                             stnt1w.  */
                                                          return 1933;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x11001xxxx111xxxxxxxxxxxxx
                                                             stnt1d.  */
                                                          return 1929;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x10101xxxx111xxxxxxxxxxxxx
                                                             st3w.  */
                                                          return 1917;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x11101xxxx111xxxxxxxxxxxxx
                                                             st3d.  */
                                                          return 1913;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 20) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx10000010xxxxxxxxxxxxxx
                                                                 cntp.  */
                                                              return 1341;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 10) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 11) & 0x1) == 0)
                                                                    {
                                                                      if (((word >> 12) & 0x1) == 0)
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             001001x1xx10100010x000xxxxxxxxxx
                                                                             sqincp.  */
                                                                          return 1848;
                                                                        }
                                                                      else
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             001001x1xx10100010x100xxxxxxxxxx
                                                                             wrffr.  */
                                                                          return 2021;
                                                                        }
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         001001x1xx10100010xx10xxxxxxxxxx
                                                                         sqincp.  */
                                                                      return 1850;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     001001x1xx10100010xxx1xxxxxxxxxx
                                                                     sqincp.  */
                                                                  return 1849;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 11) & 0x1) == 0)
                                                            {
                                                              if (((word >> 12) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     001001x1xx10x10010x00xxxxxxxxxxx
                                                                     incp.  */
                                                                  return 1479;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     001001x1xx10x10010x10xxxxxxxxxxx
                                                                     setffr.  */
                                                                  return 1815;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx10x10010xx1xxxxxxxxxxx
                                                                 incp.  */
                                                              return 1480;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          if (((word >> 11) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx10xx1010xx00xxxxxxxxxx
                                                                 sqdecp.  */
                                                              return 1834;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx10xx1010xx10xxxxxxxxxx
                                                                 sqdecp.  */
                                                              return 1836;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1xx10xx1010xxx1xxxxxxxxxx
                                                             sqdecp.  */
                                                          return 1835;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          if (((word >> 17) & 0x1) == 0)
                                                            {
                                                              if (((word >> 18) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     001001x1xx10x00110xx00xxxxxxxxxx
                                                                     uqincp.  */
                                                                  return 1996;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     001001x1xx10x10110xx00xxxxxxxxxx
                                                                     decp.  */
                                                                  return 1354;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx10xx1110xx00xxxxxxxxxx
                                                                 uqdecp.  */
                                                              return 1982;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 17) & 0x1) == 0)
                                                            {
                                                              if (((word >> 18) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     001001x1xx10x00110xx10xxxxxxxxxx
                                                                     uqincp.  */
                                                                  return 1997;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     001001x1xx10x10110xx10xxxxxxxxxx
                                                                     decp.  */
                                                                  return 1355;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx10xx1110xx10xxxxxxxxxx
                                                                 uqdecp.  */
                                                              return 1983;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1xx10xx0110xxx1xxxxxxxxxx
                                                             uqincp.  */
                                                          return 1998;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1xx10xx1110xxx1xxxxxxxxxx
                                                             uqdecp.  */
                                                          return 1984;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x10010xxxx10xxxxxxxxxxxxxx
                                                         ld1sh.  */
                                                      return 1572;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x11010xxxx10xxxxxxxxxxxxxx
                                                         ld1sb.  */
                                                      return 1559;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x10110xxxx10xxxxxxxxxxxxxx
                                                         ld1w.  */
                                                      return 1591;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x11110xxxx10xxxxxxxxxxxxxx
                                                         ld1d.  */
                                                      return 1511;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x10011xxxx10xxxxxxxxxxxxxx
                                                     ldnf1sh.  */
                                                  return 1705;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x11011xxxx10xxxxxxxxxxxxxx
                                                     ldnf1sb.  */
                                                  return 1702;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x10111xxxx10xxxxxxxxxxxxxx
                                                     ldnf1w.  */
                                                  return 1708;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x11111xxxx10xxxxxxxxxxxxxx
                                                     ldnf1d.  */
                                                  return 1697;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 16) & 0x1) == 0)
                                            {
                                              if (((word >> 17) & 0x1) == 0)
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx10000011xxxxxxxxxxxxxx
                                                                 add.  */
                                                              return 1268;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx11000011xxxxxxxxxxxxxx
                                                                 mul.  */
                                                              return 1737;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx10100011xxxxxxxxxxxxxx
                                                                 smax.  */
                                                              return 1816;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx11100011xxxxxxxxxxxxxx
                                                                 dup.  */
                                                              return 1360;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1xx1xx10011xxxxxxxxxxxxxx
                                                         sqadd.  */
                                                      return 1825;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1xx1xx01011xxxxxxxxxxxxxx
                                                         smin.  */
                                                      return 1819;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1xx1xx11011xxxxxxxxxxxxxx
                                                         sqsub.  */
                                                      return 1855;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 17) & 0x1) == 0)
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1xx1x000111xxxxxxxxxxxxxx
                                                             sub.  */
                                                          return 1937;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx10100111xxxxxxxxxxxxxx
                                                                 umax.  */
                                                              return 1965;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx11100111xxxxxxxxxxxxxx
                                                                 fdup.  */
                                                              return 1416;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1xx1xx10111xxxxxxxxxxxxxx
                                                         uqadd.  */
                                                      return 1973;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1xx1x001111xxxxxxxxxxxxxx
                                                             subr.  */
                                                          return 1939;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1xx1x101111xxxxxxxxxxxxxx
                                                             umin.  */
                                                          return 1968;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1xx1xx11111xxxxxxxxxxxxxx
                                                         uqsub.  */
                                                      return 2003;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1001xxxxx110xxxxxxxxxxxxx
                                                         ld2w.  */
                                                      return 1599;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1101xxxxx110xxxxxxxxxxxxx
                                                         ld2d.  */
                                                      return 1595;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1011xxxxx110xxxxxxxxxxxxx
                                                         ld4w.  */
                                                      return 1615;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1111xxxxx110xxxxxxxxxxxxx
                                                         ld4d.  */
                                                      return 1611;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1001xxxxx111xxxxxxxxxxxxx
                                                         ld2w.  */
                                                      return 1600;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1101xxxxx111xxxxxxxxxxxxx
                                                         ld2d.  */
                                                      return 1596;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1011xxxxx111xxxxxxxxxxxxx
                                                         ld4w.  */
                                                      return 1616;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1111xxxxx111xxxxxxxxxxxxx
                                                         ld4d.  */
                                                      return 1612;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 011001x1xx1xxxxx100xxxxxxxxxxxxx
                                                 fmad.  */
                                              return 1418;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 011001x1xx1xxxxx110xxxxxxxxxxxxx
                                                 fnmad.  */
                                              return 1448;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x1001xxxxx1x0xxxxxxxxxxxxx
                                                     st1w.  */
                                                  return 1892;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x1101xxxxx1x0xxxxxxxxxxxxx
                                                     st1d.  */
                                                  return 1871;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 111001x1x11xxxxx1x0xxxxxxxxxxxxx
                                                 st1w.  */
                                              return 1897;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 011001x1xx1xxxxx101xxxxxxxxxxxxx
                                                 fmsb.  */
                                              return 1439;
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1001xxxxx101xxxxxxxxxxxxx
                                                         st1w.  */
                                                      return 1893;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1101xxxxx101xxxxxxxxxxxxx
                                                         st1d.  */
                                                      return 1872;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x1x11xxxxx101xxxxxxxxxxxxx
                                                     st1w.  */
                                                  return 1900;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 011001x1xx1xxxxx111xxxxxxxxxxxxx
                                                 fnmsb.  */
                                              return 1451;
                                            }
                                          else
                                            {
                                              if (((word >> 20) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x10x10xxxx111xxxxxxxxxxxxx
                                                         st1w.  */
                                                      return 1901;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x11x10xxxx111xxxxxxxxxxxxx
                                                         st1d.  */
                                                      return 1875;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x10011xxxx111xxxxxxxxxxxxx
                                                             st2w.  */
                                                          return 1909;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x11011xxxx111xxxxxxxxxxxxx
                                                             st2d.  */
                                                          return 1905;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x10111xxxx111xxxxxxxxxxxxx
                                                             st4w.  */
                                                          return 1925;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x11111xxxx111xxxxxxxxxxxxx
                                                             st4d.  */
                                                          return 1921;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
          else
            {
              if (((word >> 29) & 0x1) == 0)
                {
                  if (((word >> 30) & 0x1) == 0)
                    {
                      if (((word >> 31) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             000101xxxxxxxxxxxxxxxxxxxxxxxxxx
                             b.  */
                          return 636;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             100101xxxxxxxxxxxxxxxxxxxxxxxxxx
                             bl.  */
                          return 637;
                        }
                    }
                  else
                    {
                      if (((word >> 24) & 0x1) == 0)
                        {
                          if (((word >> 4) & 0x1) == 0)
                            {
                              if (((word >> 25) & 0x1) == 0)
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         01010100xxxxxxxxxxxxxxxxxxx0xxxx
                                         b.c.  */
                                      return 657;
                                    }
                                  else
                                    {
                                      if (((word >> 0) & 0x1) == 0)
                                        {
                                          if (((word >> 1) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     11010100xx0xxxxxxxxxxxxxxxx0xx00
                                                     hlt.  */
                                                  return 753;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     11010100xx1xxxxxxxxxxxxxxxx0xx00
                                                     brk.  */
                                                  return 752;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     11010100xx0xxxxxxxxxxxxxxxx0xx10
                                                     hvc.  */
                                                  return 750;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     11010100xx1xxxxxxxxxxxxxxxx0xx10
                                                     dcps2.  */
                                                  return 755;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 1) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     11010100xx0xxxxxxxxxxxxxxxx0xx01
                                                     svc.  */
                                                  return 749;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     11010100xx1xxxxxxxxxxxxxxxx0xx01
                                                     dcps1.  */
                                                  return 754;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     11010100xx0xxxxxxxxxxxxxxxx0xx11
                                                     smc.  */
                                                  return 751;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     11010100xx1xxxxxxxxxxxxxxxx0xx11
                                                     dcps3.  */
                                                  return 756;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1010110000xxxxxxxxxxxxxxxx0xxxx
                                                 br.  */
                                              return 638;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1010110100xxxxxxxxxxxxxxxx0xxxx
                                                 eret.  */
                                              return 641;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x1010110x10xxxxxxxxxxxxxxxx0xxxx
                                             ret.  */
                                          return 640;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x10101100x1xxxxxxxxxxxxxxxx0xxxx
                                             blr.  */
                                          return 639;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x10101101x1xxxxxxxxxxxxxxxx0xxxx
                                             drps.  */
                                          return 642;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 10) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10101x0000xxxxxxxxxx0xxxxx1xxxx
                                                 braaz.  */
                                              return 647;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10101x0100xxxxxxxxxx0xxxxx1xxxx
                                                 eretaa.  */
                                              return 653;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x10101x0x10xxxxxxxxxx0xxxxx1xxxx
                                             retaa.  */
                                          return 651;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x10101x0xx1xxxxxxxxxx0xxxxx1xxxx
                                         blraaz.  */
                                      return 649;
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10101x0000xxxxxxxxxx1xxxxx1xxxx
                                                 brabz.  */
                                              return 648;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10101x0100xxxxxxxxxx1xxxxx1xxxx
                                                 eretab.  */
                                              return 654;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x10101x0x10xxxxxxxxxx1xxxxx1xxxx
                                             retab.  */
                                          return 652;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x10101x0xx1xxxxxxxxxx1xxxxx1xxxx
                                         blrabz.  */
                                      return 650;
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 21) & 0x1) == 0)
                            {
                              if (((word >> 25) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x1010101xx0xxxxxxxxxxxxxxxxxxxxx
                                     xaflag.  */
                                  return 810;
                                }
                              else
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x1010111xx0xxxxxxxxxx0xxxxxxxxxx
                                         braa.  */
                                      return 643;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x1010111xx0xxxxxxxxxx1xxxxxxxxxx
                                         brab.  */
                                      return 644;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 25) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x1010101xx1xxxxxxxxxxxxxxxxxxxxx
                                     sysl.  */
                                  return 1219;
                                }
                              else
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x1010111xx1xxxxxxxxxx0xxxxxxxxxx
                                         blraa.  */
                                      return 645;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x1010111xx1xxxxxxxxxx1xxxxxxxxxx
                                         blrab.  */
                                      return 646;
                                    }
                                }
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 25) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xx110100xxxxxxxxxxxxxxxxxxxxxxxx
                             cbz.  */
                          return 655;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xx110110xxxxxxxxxxxxxxxxxxxxxxxx
                             tbz.  */
                          return 1229;
                        }
                    }
                  else
                    {
                      if (((word >> 25) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xx110101xxxxxxxxxxxxxxxxxxxxxxxx
                             cbnz.  */
                          return 656;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xx110111xxxxxxxxxxxxxxxxxxxxxxxx
                             tbnz.  */
                          return 1230;
                        }
                    }
                }
            }
        }
      else
        {
          if (((word >> 25) & 0x1) == 0)
            {
              if (((word >> 28) & 0x1) == 0)
                {
                  if (((word >> 22) & 0x1) == 0)
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 24) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xx00110000xxxxxxxxxxxxxxxxxxxxxx
                                     st4.  */
                                  return 440;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xx10110000xxxxxxxxxxxxxxxxxxxxxx
                                     stnp.  */
                                  return 970;
                                }
                            }
                          else
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx001101000xxxxxxx0xxxxxxxxxxxxx
                                             st1.  */
                                          return 456;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx001101001xxxxxxx0xxxxxxxxxxxxx
                                             st2.  */
                                          return 458;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx001101000xxxxxxx1xxxxxxxxxxxxx
                                             st3.  */
                                          return 457;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx001101001xxxxxxx1xxxxxxxxxxxxx
                                             st4.  */
                                          return 459;
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xx10110100xxxxxxxxxxxxxxxxxxxxxx
                                     stp.  */
                                  return 974;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  if (((word >> 24) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx001100100xxxxxxxxxxxxxxxxxxxxx
                                         st4.  */
                                      return 448;
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx001101100xxxxxxx0xxxxxxxxxxxxx
                                             st1.  */
                                          return 468;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx001101100xxxxxxx1xxxxxxxxxxxxx
                                             st3.  */
                                          return 469;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx00110x101xxxxxxx0xxxxxxxxxxxxx
                                         st2.  */
                                      return 470;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx00110x101xxxxxxx1xxxxxxxxxxxxx
                                         st4.  */
                                      return 471;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xx10110x10xxxxxxxxxxxxxxxxxxxxxx
                                 stp.  */
                              return 980;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 24) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xx00110001xxxxxxxxxxxxxxxxxxxxxx
                                     ld4.  */
                                  return 444;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xx10110001xxxxxxxxxxxxxxxxxxxxxx
                                     ldnp.  */
                                  return 971;
                                }
                            }
                          else
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx001101010xxxxxxx0xxxxxxxxxxxxx
                                             ld1.  */
                                          return 460;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx001101011xxxxxxx0xxxxxxxxxxxxx
                                             ld2.  */
                                          return 464;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx001101010xxxxxxx1xxxxxxxxxxxxx
                                             ld3.  */
                                          return 461;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx001101011xxxxxxx1xxxxxxxxxxxxx
                                             ld4.  */
                                          return 465;
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xx10110101xxxxxxxxxxxxxxxxxxxxxx
                                     ldp.  */
                                  return 975;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  if (((word >> 24) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx001100110xxxxxxxxxxxxxxxxxxxxx
                                         ld4.  */
                                      return 452;
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx001101110xxxxxxx0xxxxxxxxxxxxx
                                             ld1.  */
                                          return 472;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx001101110xxxxxxx1xxxxxxxxxxxxx
                                             ld3.  */
                                          return 473;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx00110x111xxxxxxx0xxxxxxxxxxxxx
                                         ld2.  */
                                      return 476;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx00110x111xxxxxxx1xxxxxxxxxxxxx
                                         ld4.  */
                                      return 477;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xx10110x11xxxxxxxxxxxxxxxxxxxxxx
                                 ldp.  */
                              return 981;
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xx011100xxxxxxxxxxxxxxxxxxxxxxxx
                             ldr.  */
                          return 985;
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx111100x0xxxxxxxxxx00xxxxxxxxxx
                                         stur.  */
                                      return 924;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx111100x1xxxxxxxxxx00xxxxxxxxxx
                                         ldur.  */
                                      return 925;
                                    }
                                }
                              else
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx111100x0xxxxxxxxxx10xxxxxxxxxx
                                         str.  */
                                      return 903;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx111100x1xxxxxxxxxx10xxxxxxxxxx
                                         ldr.  */
                                      return 904;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 22) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xx111100x0xxxxxxxxxxx1xxxxxxxxxx
                                     str.  */
                                  return 872;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xx111100x1xxxxxxxxxxx1xxxxxxxxxx
                                     ldr.  */
                                  return 873;
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 22) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxx11101x0xxxxxxxxxxxxxxxxxxxxxx
                             str.  */
                          return 891;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxx11101x1xxxxxxxxxxxxxxxxxxxxxx
                             ldr.  */
                          return 892;
                        }
                    }
                }
            }
          else
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0x001110xx0xxxxxxxx000xxxxxxxxxx
                                                 tbl.  */
                                              return 420;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0x001110xx0xxxxxxxx100xxxxxxxxxx
                                                 tbx.  */
                                              return 421;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     0x001110xx0xxxxxx0x010xxxxxxxxxx
                                                     trn1.  */
                                                  return 263;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     0x001110xx0xxxxxx1x010xxxxxxxxxx
                                                     trn2.  */
                                                  return 266;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         0x001110xx0xxxxxx00110xxxxxxxxxx
                                                         uzp1.  */
                                                      return 262;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         0x001110xx0xxxxxx10110xxxxxxxxxx
                                                         uzp2.  */
                                                      return 265;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         0x001110xx0xxxxxx01110xxxxxxxxxx
                                                         zip1.  */
                                                      return 264;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         0x001110xx0xxxxxx11110xxxxxxxxxx
                                                         zip2.  */
                                                      return 267;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         0x001110x00xxxxxxx0001xxxxxxxxxx
                                                         dup.  */
                                                      return 149;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110010xxxxxxx0001xxxxxxxxxx
                                                             fmaxnm.  */
                                                          return 292;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110110xxxxxxx0001xxxxxxxxxx
                                                             fminnm.  */
                                                          return 308;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     0x001110xx0xxxxxxx1001xxxxxxxxxx
                                                     fcmeq.  */
                                                  return 300;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x0011100x0xxxxx0x0101xxxxxxxxxx
                                                             fadd.  */
                                                          return 296;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x0011101x0xxxxx0x0101xxxxxxxxxx
                                                             fsub.  */
                                                          return 312;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         0x001110xx0xxxxx1x0101xxxxxxxxxx
                                                         sdot.  */
                                                      return 2040;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         0x0011100x0xxxxxxx1101xxxxxxxxxx
                                                         fmax.  */
                                                      return 302;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         0x0011101x0xxxxxxx1101xxxxxxxxxx
                                                         fmin.  */
                                                      return 314;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         0x001110x00xxxxxxx0011xxxxxxxxxx
                                                         dup.  */
                                                      return 150;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110010xxxxxxx0011xxxxxxxxxx
                                                             fmla.  */
                                                          return 294;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110110xxxxxxx0011xxxxxxxxxx
                                                             fmls.  */
                                                          return 310;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     0x001110xx0xxxxxxx1011xxxxxxxxxx
                                                     smov.  */
                                                  return 151;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         0x001110x00xxxxxxx0111xxxxxxxxxx
                                                         ins.  */
                                                      return 154;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         0x001110x10xxxxxxx0111xxxxxxxxxx
                                                         fmulx.  */
                                                      return 298;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         0x001110x00xxxxxxx1111xxxxxxxxxx
                                                         umov.  */
                                                      return 152;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110010xxxxxxx1111xxxxxxxxxx
                                                             frecps.  */
                                                          return 304;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110110xxxxxxx1111xxxxxxxxxx
                                                             frsqrts.  */
                                                          return 316;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x001110000xxxxxxxxxxxxxxxxxxxxx
                                             eor3.  */
                                          return 2047;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x001110100xxxxxxxxxxxxxxxxxxxxx
                                             xar.  */
                                          return 2049;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x001110x10xxxxx0xxxxxxxxxxxxxxx
                                             sm3ss1.  */
                                          return 2051;
                                        }
                                      else
                                        {
                                          if (((word >> 10) & 0x1) == 0)
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         1x001110010xxxxx1xxx00xxxxxxxxxx
                                                         sm3tt1a.  */
                                                      return 2052;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         1x001110110xxxxx1xxx00xxxxxxxxxx
                                                         sha512su0.  */
                                                      return 2045;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x001110x10xxxxx1xxx10xxxxxxxxxx
                                                     sm3tt2a.  */
                                                  return 2054;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         1x001110010xxxxx1xxx01xxxxxxxxxx
                                                         sm3tt1b.  */
                                                      return 2053;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         1x001110110xxxxx1xxx01xxxxxxxxxx
                                                         sm4e.  */
                                                      return 2058;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x001110x10xxxxx1xxx11xxxxxxxxxx
                                                     sm3tt2b.  */
                                                  return 2055;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 10) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xx101110xx0xxxxxxxxxx0xxxxxxxxxx
                                     ext.  */
                                  return 132;
                                }
                              else
                                {
                                  if (((word >> 15) & 0x1) == 0)
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx101110x00xxxxx0xxxx1xxxxxxxxxx
                                             ins.  */
                                          return 156;
                                        }
                                      else
                                        {
                                          if (((word >> 11) & 0x1) == 0)
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx101110010xxxxx0x0001xxxxxxxxxx
                                                             fmaxnmp.  */
                                                          return 343;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx101110110xxxxx0x0001xxxxxxxxxx
                                                             fminnmp.  */
                                                          return 359;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx101110010xxxxx0x1001xxxxxxxxxx
                                                             fcmge.  */
                                                          return 349;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx101110110xxxxx0x1001xxxxxxxxxx
                                                             fcmgt.  */
                                                          return 363;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx101110010xxxxx0x0101xxxxxxxxxx
                                                             faddp.  */
                                                          return 345;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx101110110xxxxx0x0101xxxxxxxxxx
                                                             fabd.  */
                                                          return 361;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx101110010xxxxx0x1101xxxxxxxxxx
                                                             fmaxp.  */
                                                          return 353;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx101110110xxxxx0x1101xxxxxxxxxx
                                                             fminp.  */
                                                          return 367;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110010xxxxx0xx011xxxxxxxxxx
                                                         facge.  */
                                                      return 351;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110110xxxxx0xx011xxxxxxxxxx
                                                         facgt.  */
                                                      return 365;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110x10xxxxx0x0111xxxxxxxxxx
                                                         fmul.  */
                                                      return 347;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110x10xxxxx0x1111xxxxxxxxxx
                                                         fdiv.  */
                                                      return 355;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx0xxxxx100001xxxxxxxxxx
                                                         sqrdmlah.  */
                                                      return 370;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx0xxxxx100101xxxxxxxxxx
                                                         udot.  */
                                                      return 2039;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xx101110xx0xxxxx100x11xxxxxxxxxx
                                                     sqrdmlsh.  */
                                                  return 371;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xx101110xx0xxxxx110xx1xxxxxxxxxx
                                                 fcmla.  */
                                              return 372;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx101110xx0xxxxx1x1xx1xxxxxxxxxx
                                             fcadd.  */
                                          return 373;
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 16) & 0x1) == 0)
                                    {
                                      if (((word >> 17) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x0011110xx0xxx00xxxxxxxxxxxxxxxx
                                             fcvtzs.  */
                                          return 763;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x0011110xx0xxx10xxxxxxxxxxxxxxxx
                                             scvtf.  */
                                          return 759;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 17) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x0011110xx0xxx01xxxxxxxxxxxxxxxx
                                             fcvtzu.  */
                                          return 765;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x0011110xx0xxx11xxxxxxxxxxxxxxxx
                                             ucvtf.  */
                                          return 761;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1011110xx0xxxxxx000x0xxxxxxxxxx
                                                     sha1c.  */
                                                  return 678;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1011110xx0xxxxxx100x0xxxxxxxxxx
                                                     sha256h.  */
                                                  return 682;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1011110xx0xxxxxx010x0xxxxxxxxxx
                                                     sha1m.  */
                                                  return 680;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1011110xx0xxxxxx110x0xxxxxxxxxx
                                                     sha256su1.  */
                                                  return 684;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1011110xx0xxxxxx001x0xxxxxxxxxx
                                                     sha1p.  */
                                                  return 679;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1011110xx0xxxxxx101x0xxxxxxxxxx
                                                     sha256h2.  */
                                                  return 683;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1011110xx0xxxxxxx11x0xxxxxxxxxx
                                                 sha1su0.  */
                                              return 681;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1011110xx0xxxxxxx0x01xxxxxxxxxx
                                                 dup.  */
                                              return 535;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1011110xx0xxxxxxx1x01xxxxxxxxxx
                                                 fcmeq.  */
                                              return 556;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1011110xx0xxxxxxx0x11xxxxxxxxxx
                                                 fmulx.  */
                                              return 554;
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10111100x0xxxxxxx1x11xxxxxxxxxx
                                                     frecps.  */
                                                  return 558;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10111101x0xxxxxxx1x11xxxxxxxxxx
                                                     frsqrts.  */
                                                  return 560;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx111110xx0xxxxxxx000xxxxxxxxxxx
                                             sqrdmlah.  */
                                          return 588;
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xx1111100x0xxxxxxx100xxxxxxxxxxx
                                                 fcmge.  */
                                              return 573;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xx1111101x0xxxxxxx100xxxxxxxxxxx
                                                 fcmgt.  */
                                              return 579;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx111110xx0xxxxxxxx10xxxxxxxxxxx
                                         fabd.  */
                                      return 577;
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx111110xx0xxxxxxx0x1xxxxxxxxxxx
                                         sqrdmlsh.  */
                                      return 589;
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx1111100x0xxxxxxx1x1xxxxxxxxxxx
                                             facge.  */
                                          return 575;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx1111101x0xxxxxxx1x1xxxxxxxxxxx
                                             facgt.  */
                                          return 581;
                                        }
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      if (((word >> 10) & 0x1) == 0)
                                        {
                                          if (((word >> 11) & 0x1) == 0)
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 00001110xx1xxxxx000000xxxxxxxxxx
                                                                 saddl.  */
                                                              return 44;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 01001110xx1xxxxx000000xxxxxxxxxx
                                                                 saddl2.  */
                                                              return 45;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 00001110xx1xxxxx010000xxxxxxxxxx
                                                                 addhn.  */
                                                              return 52;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 01001110xx1xxxxx010000xxxxxxxxxx
                                                                 addhn2.  */
                                                              return 53;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 00001110xx1xxxxx001000xxxxxxxxxx
                                                                 ssubl.  */
                                                              return 48;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 01001110xx1xxxxx001000xxxxxxxxxx
                                                                 ssubl2.  */
                                                              return 49;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 00001110xx1xxxxx011000xxxxxxxxxx
                                                                 subhn.  */
                                                              return 56;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 01001110xx1xxxxx011000xxxxxxxxxx
                                                                 subhn2.  */
                                                              return 57;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 00001110xx1xxxxx000100xxxxxxxxxx
                                                                 saddw.  */
                                                              return 46;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 01001110xx1xxxxx000100xxxxxxxxxx
                                                                 saddw2.  */
                                                              return 47;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 00001110xx1xxxxx010100xxxxxxxxxx
                                                                 sabal.  */
                                                              return 54;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 01001110xx1xxxxx010100xxxxxxxxxx
                                                                 sabal2.  */
                                                              return 55;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 00001110xx1xxxxx001100xxxxxxxxxx
                                                                 ssubw.  */
                                                              return 50;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 01001110xx1xxxxx001100xxxxxxxxxx
                                                                 ssubw2.  */
                                                              return 51;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 00001110xx1xxxxx011100xxxxxxxxxx
                                                                 sabdl.  */
                                                              return 58;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 01001110xx1xxxxx011100xxxxxxxxxx
                                                                 sabdl2.  */
                                                              return 59;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx000010xxxxxxxxxx
                                                             rev64.  */
                                                          return 162;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     0x001110xx1x0xx0010010xxxxxxxxxx
                                                                     cls.  */
                                                                  return 166;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     0x001110xx1x1xx0010010xxxxxxxxxx
                                                                     aese.  */
                                                                  return 671;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00001110xx1xxxx1010010xxxxxxxxxx
                                                                     sqxtn.  */
                                                                  return 176;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01001110xx1xxxx1010010xxxxxxxxxx
                                                                     sqxtn2.  */
                                                                  return 177;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x001110xx1xxxx0001010xxxxxxxxxx
                                                                 saddlp.  */
                                                              return 164;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00001110xx1xxxx1001010xxxxxxxxxx
                                                                     xtn.  */
                                                                  return 174;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01001110xx1xxxx1001010xxxxxxxxxx
                                                                     xtn2.  */
                                                                  return 175;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     0x001110xx1x0xx0011010xxxxxxxxxx
                                                                     sadalp.  */
                                                                  return 168;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     0x001110xx1x1xx0011010xxxxxxxxxx
                                                                     aesmc.  */
                                                                  return 673;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00001110xx1xxxx1011010xxxxxxxxxx
                                                                     fcvtn.  */
                                                                  return 178;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01001110xx1xxxx1011010xxxxxxxxxx
                                                                     fcvtn2.  */
                                                                  return 179;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx000110xxxxxxxxxx
                                                             rev16.  */
                                                          return 163;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x001110xx1x0xxx010110xxxxxxxxxx
                                                                 cnt.  */
                                                              return 167;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x001110xx1x1xxx010110xxxxxxxxxx
                                                                 aesd.  */
                                                              return 672;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x001110xx10xxxx001110xxxxxxxxxx
                                                                 suqadd.  */
                                                              return 165;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x001110xx11xxxx001110xxxxxxxxxx
                                                                 saddlv.  */
                                                              return 29;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     0x001110xx1x0xx0011110xxxxxxxxxx
                                                                     sqabs.  */
                                                                  return 169;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     0x001110xx1x1xx0011110xxxxxxxxxx
                                                                     aesimc.  */
                                                                  return 674;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00001110xx1xxxx1011110xxxxxxxxxx
                                                                     fcvtl.  */
                                                                  return 180;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01001110xx1xxxx1011110xxxxxxxxxx
                                                                     fcvtl2.  */
                                                                  return 181;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 11) & 0x1) == 0)
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx000001xxxxxxxxxx
                                                             shadd.  */
                                                          return 268;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx010001xxxxxxxxxx
                                                             sshl.  */
                                                          return 275;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx001001xxxxxxxxxx
                                                             shsub.  */
                                                          return 271;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx011001xxxxxxxxxx
                                                             smax.  */
                                                          return 279;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx000101xxxxxxxxxx
                                                             srhadd.  */
                                                          return 270;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx010101xxxxxxxxxx
                                                             srshl.  */
                                                          return 277;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx001101xxxxxxxxxx
                                                             cmgt.  */
                                                          return 273;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx011101xxxxxxxxxx
                                                             sabd.  */
                                                          return 281;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx000011xxxxxxxxxx
                                                             sqadd.  */
                                                          return 269;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx010011xxxxxxxxxx
                                                             sqshl.  */
                                                          return 276;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx001011xxxxxxxxxx
                                                             sqsub.  */
                                                          return 272;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx011011xxxxxxxxxx
                                                             smin.  */
                                                          return 280;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     0x001110001xxxxx000111xxxxxxxxxx
                                                                     and.  */
                                                                  return 305;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     0x001110101xxxxx000111xxxxxxxxxx
                                                                     orr.  */
                                                                  return 317;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     0x001110011xxxxx000111xxxxxxxxxx
                                                                     bic.  */
                                                                  return 306;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     0x001110111xxxxx000111xxxxxxxxxx
                                                                     orn.  */
                                                                  return 319;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx010111xxxxxxxxxx
                                                             sqrshl.  */
                                                          return 278;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 14) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx001111xxxxxxxxxx
                                                             cmge.  */
                                                          return 274;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             0x001110xx1xxxxx011111xxxxxxxxxx
                                                             saba.  */
                                                          return 282;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         1x001110xx1xxxxx0xxxxxxxxxxxxxxx
                                         bcax.  */
                                      return 2050;
                                    }
                                }
                              else
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0101110xx1xxxxx000000xxxxxxxxxx
                                                             uaddl.  */
                                                          return 76;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1101110xx1xxxxx000000xxxxxxxxxx
                                                             uaddl2.  */
                                                          return 77;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0101110xx1xxxxx010000xxxxxxxxxx
                                                             raddhn.  */
                                                          return 84;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1101110xx1xxxxx010000xxxxxxxxxx
                                                             raddhn2.  */
                                                          return 85;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0101110xx1xxxxx001000xxxxxxxxxx
                                                             usubl.  */
                                                          return 80;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1101110xx1xxxxx001000xxxxxxxxxx
                                                             usubl2.  */
                                                          return 81;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0101110xx1xxxxx011000xxxxxxxxxx
                                                             rsubhn.  */
                                                          return 88;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1101110xx1xxxxx011000xxxxxxxxxx
                                                             rsubhn2.  */
                                                          return 89;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0101110xx1xxxxx000100xxxxxxxxxx
                                                             uaddw.  */
                                                          return 78;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1101110xx1xxxxx000100xxxxxxxxxx
                                                             uaddw2.  */
                                                          return 79;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0101110xx1xxxxx010100xxxxxxxxxx
                                                             uabal.  */
                                                          return 86;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1101110xx1xxxxx010100xxxxxxxxxx
                                                             uabal2.  */
                                                          return 87;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0101110xx1xxxxx001100xxxxxxxxxx
                                                             usubw.  */
                                                          return 82;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1101110xx1xxxxx001100xxxxxxxxxx
                                                             usubw2.  */
                                                          return 83;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0101110xx1xxxxx011100xxxxxxxxxx
                                                             uabdl.  */
                                                          return 90;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1101110xx1xxxxx011100xxxxxxxxxx
                                                             uabdl2.  */
                                                          return 91;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx000010xxxxxxxxxx
                                                         rev32.  */
                                                      return 213;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx101110xx1xxxx0010010xxxxxxxxxx
                                                             clz.  */
                                                          return 216;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x0101110xx1xxxx1010010xxxxxxxxxx
                                                                 uqxtn.  */
                                                              return 226;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x1101110xx1xxxx1010010xxxxxxxxxx
                                                                 uqxtn2.  */
                                                              return 227;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx101110xx1xxxx0001010xxxxxxxxxx
                                                             uaddlp.  */
                                                          return 214;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x0101110xx1xxxx1001010xxxxxxxxxx
                                                                 sqxtun.  */
                                                              return 222;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x1101110xx1xxxx1001010xxxxxxxxxx
                                                                 sqxtun2.  */
                                                              return 223;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx101110xx1xxxx0011010xxxxxxxxxx
                                                             uadalp.  */
                                                          return 217;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x0101110xx1xxxx1011010xxxxxxxxxx
                                                                 fcvtxn.  */
                                                              return 228;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x1101110xx1xxxx1011010xxxxxxxxxx
                                                                 fcvtxn2.  */
                                                              return 229;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110x01xxxxx0x0110xxxxxxxxxx
                                                         not.  */
                                                      return 242;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110x11xxxxx0x0110xxxxxxxxxx
                                                         rbit.  */
                                                      return 244;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xx101110xx10xxx0001110xxxxxxxxxx
                                                                 usqadd.  */
                                                              return 215;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xx101110xx11xxx0001110xxxxxxxxxx
                                                                 uaddlv.  */
                                                              return 33;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x0101110xx1xxxx1001110xxxxxxxxxx
                                                                 shll.  */
                                                              return 224;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x1101110xx1xxxx1001110xxxxxxxxxx
                                                                 shll2.  */
                                                              return 225;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx011110xxxxxxxxxx
                                                         sqneg.  */
                                                      return 218;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx000001xxxxxxxxxx
                                                         uhadd.  */
                                                      return 320;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx010001xxxxxxxxxx
                                                         ushl.  */
                                                      return 327;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx001001xxxxxxxxxx
                                                         uhsub.  */
                                                      return 323;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx011001xxxxxxxxxx
                                                         umax.  */
                                                      return 331;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx000101xxxxxxxxxx
                                                         urhadd.  */
                                                      return 322;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx010101xxxxxxxxxx
                                                         urshl.  */
                                                      return 329;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx001101xxxxxxxxxx
                                                         cmhi.  */
                                                      return 325;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx011101xxxxxxxxxx
                                                         uabd.  */
                                                      return 333;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx000011xxxxxxxxxx
                                                         uqadd.  */
                                                      return 321;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx010011xxxxxxxxxx
                                                         uqshl.  */
                                                      return 328;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx001011xxxxxxxxxx
                                                         uqsub.  */
                                                      return 324;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx011011xxxxxxxxxx
                                                         umin.  */
                                                      return 332;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xx101110001xxxxx000111xxxxxxxxxx
                                                                 eor.  */
                                                              return 356;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xx101110101xxxxx000111xxxxxxxxxx
                                                                 bit.  */
                                                              return 368;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xx101110011xxxxx000111xxxxxxxxxx
                                                                 bsl.  */
                                                              return 357;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xx101110111xxxxx000111xxxxxxxxxx
                                                                 bif.  */
                                                              return 369;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx010111xxxxxxxxxx
                                                         uqrshl.  */
                                                      return 330;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx001111xxxxxxxxxx
                                                         cmhs.  */
                                                      return 326;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xx101110xx1xxxxx011111xxxxxxxxxx
                                                         uaba.  */
                                                      return 334;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 10) & 0x1) == 0)
                                {
                                  if (((word >> 11) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0001110xx1xxxxx100000xxxxxxxxxx
                                                             smlal.  */
                                                          return 60;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 01001110xx1xxxxx100000xxxxxxxxxx
                                                                 smlal2.  */
                                                              return 61;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 11001110xx1xxxxx100000xxxxxxxxxx
                                                                 sha512h.  */
                                                              return 2043;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0101110xx1xxxxx100000xxxxxxxxxx
                                                             umlal.  */
                                                          return 92;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1101110xx1xxxxx100000xxxxxxxxxx
                                                             umlal2.  */
                                                          return 93;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0001110xx1xxxxx110000xxxxxxxxxx
                                                             smull.  */
                                                          return 68;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 01001110xx1xxxxx110000xxxxxxxxxx
                                                                 smull2.  */
                                                              return 69;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 11001110xx1xxxxx110000xxxxxxxxxx
                                                                 sm3partw1.  */
                                                              return 2056;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0101110xx1xxxxx110000xxxxxxxxxx
                                                             umull.  */
                                                          return 96;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1101110xx1xxxxx110000xxxxxxxxxx
                                                             umull2.  */
                                                          return 97;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0001110xx1xxxxx101000xxxxxxxxxx
                                                             smlsl.  */
                                                          return 64;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1001110xx1xxxxx101000xxxxxxxxxx
                                                             smlsl2.  */
                                                          return 65;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0101110xx1xxxxx101000xxxxxxxxxx
                                                             umlsl.  */
                                                          return 94;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1101110xx1xxxxx101000xxxxxxxxxx
                                                             umlsl2.  */
                                                          return 95;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0x01110x01xxxxx111000xxxxxxxxxx
                                                             pmull.  */
                                                          return 72;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1x01110x01xxxxx111000xxxxxxxxxx
                                                             pmull2.  */
                                                          return 74;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0x01110x11xxxxx111000xxxxxxxxxx
                                                             pmull.  */
                                                          return 73;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1x01110x11xxxxx111000xxxxxxxxxx
                                                             pmull2.  */
                                                          return 75;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x0x01110xx1xxxxx100100xxxxxxxxxx
                                                         sqdmlal.  */
                                                      return 62;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x01110xx1xxxxx100100xxxxxxxxxx
                                                         sqdmlal2.  */
                                                      return 63;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x0x01110xx1xxxxx110100xxxxxxxxxx
                                                         sqdmull.  */
                                                      return 70;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x01110xx1xxxxx110100xxxxxxxxxx
                                                         sqdmull2.  */
                                                      return 71;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x0x01110xx1xxxxx1x1100xxxxxxxxxx
                                                     sqdmlsl.  */
                                                  return 66;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
      