dnl Copyright (C) 1993-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels.

AC_PREREQ(2.13)

AC_DEFUN([CL_FIND_X],
[AC_CHECKING(for X11)
X_INCLUDES=''
X_LIBS=''
dnl First check for xmkmf.
AC_CHECK_PROG(HAVE_XMKMF, xmkmf, yes)dnl
if test "$HAVE_XMKMF" = yes; then
  have_x11=1
  AC_DEFINE(HAVE_X11)
  X_LIBS='-lX11'
  AC_PATH_X()dnl
  if test -n "$x_includes" -a "$x_includes" != NONE; then
    # Adding -I/usr/include may override gcc's private include hierarchy.
    if test "$x_includes" != "/usr/include"; then
      X_INCLUDES="-I$x_includes"
    fi
  fi
  if test -n "$x_libraries" -a "$x_libraries" != NONE; then
    X_LIBS="-L$x_libraries "$X_LIBS
  fi
else
  dnl From John Ousterhout <ouster@allspice.berkeley.edu>
  dnl There are some X11 installations around that don't have xmkmf.
  AC_MSG_CHECKING(for X11 header files)
  AC_TRY_CPP([#include <X11/Intrinsic.h>], have_x_includes=1)
  if test -z "$have_x_includes"; then
    for dir in /usr/X11/include /usr/openwin/include /usr/include/X11R5 /usr/X11R5/include /usr/include/X11R4 /usr/X386/include /usr/x386/include /usr/local/include /usr/unsupported/include; do
      if test -z "$have_x_includes"; then
        if test -r $dir/X11/Intrinsic.h; then
          x_includes="$dir"
          have_x_includes=1
        fi
      fi
    done
  fi
  if test -n "$x_includes" -a "$x_includes" != NONE; then
    X_INCLUDES="-I$x_includes"
  fi
  AC_MSG_RESULT($X_INCLUDES)
  AC_MSG_CHECKING(for X11 library)
  CL_SILENT([
  AC_CHECK_LIB(X11,main, have_x_libraries=1)dnl
  if test -z "$have_x_libraries"; then
    for dir in /usr/X11/lib /usr/openwin/lib /usr/lib/X11R5 /usr/X11R5/lib /usr/lib/X11R4 /usr/X386/lib /usr/x386/lib /usr/local/lib /usr/unsupported/lib; do
      if test -z "$have_x_libraries"; then
        if test -r $dir/libX11.a; then
          x_libraries="$dir"
          have_x_libraries=1
        fi
      fi
    done
  fi
  if test -n "$have_x_libraries"; then
    X_LIBS='-lX11'
    if test -n "$x_libraries" -a "$x_libraries" != NONE; then
      X_LIBS="-L$x_libraries "$X_LIBS
    fi
  else
    AC_CHECK_LIB(Xwindow,main, X_LIBS='-lXwindow' have_x_libraries=1)dnl
  fi
  ])
  AC_MSG_RESULT($X_LIBS)
  dnl Don't use X if either the header files or the libraries were not found.
  if test -n "$have_x_includes" -a -n "$have_x_libraries"; then
    have_x11=1
    AC_DEFINE(HAVE_X11)
  else
    X_INCLUDES=''
    X_LIBS=''
  fi
fi
AC_SUBST(X_INCLUDES)dnl
AC_SUBST(X_LIBS)dnl
])
