/* { dg-options "-O2 -floop-block -fdump-tree-graphite-all" } */

typedef unsigned char   UChar;
typedef int             Int32;
typedef unsigned int    UInt32;

void fallbackSort ( UInt32* fmap, 
                    UInt32* eclass, 
                    Int32   nblock,
                    Int32   verb )
{
   Int32 ftab[257];
   Int32 ftabCopy[256];
   Int32 H, i, j, k, l, r, cc, cc1;
   Int32 nNotDone;
   Int32 nBhtab;
   UChar* eclass8 = (UChar*)eclass;

   if (verb >= 4)
      VPrintf0 ( "        bucket sorting ...\n" );
   for (i = 0; i < 257;    i++) ftab[i] = 0;
   for (i = 0; i < nblock; i++) ftab[eclass8[i]]++;
   for (i = 0; i < 256;    i++) ftabCopy[i] = ftab[i];
   for (i = 1; i < 257;    i++) ftab[i] += ftab[i-1];

   for (i = 0; i < nblock; i++) {
      j = eclass8[i] + ftab [i];
   }
   AssertH ( j < 256, 1005 );
}
/* { dg-final { scan-tree-dump-times "Loop blocked" 1 "graphite" { xfail *-*-* }} } */
/* { dg-final { cleanup-tree-dump "graphite" } } */
