/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.mode;

import gnu.crypto.Registry;
import gnu.crypto.cipher.CipherFactory;
import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.mode.CBC;
import gnu.crypto.mode.CFB;
import gnu.crypto.mode.CTR;
import gnu.crypto.mode.EAX;
import gnu.crypto.mode.ECB;
import gnu.crypto.mode.ICM;
import gnu.crypto.mode.IMode;
import gnu.crypto.mode.OFB;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModeFactory
implements Registry {
    private static Set names;
    static /* synthetic */ Class class$gnu$crypto$mode$ModeFactory;

    public static IMode getInstance(String mode, String cipher, int cipherBlockSize) {
        if (mode == null || cipher == null) {
            return null;
        }
        mode = mode.trim();
        IBlockCipher cipherImpl = CipherFactory.getInstance(cipher = cipher.trim());
        if (cipherImpl == null) {
            return null;
        }
        return ModeFactory.getInstance(mode, cipherImpl, cipherBlockSize);
    }

    public static IMode getInstance(String mode, IBlockCipher cipher, int cipherBlockSize) {
        boolean ok = false;
        Iterator it = cipher.blockSizes();
        while (it.hasNext()) {
            boolean bl = false;
            if (cipherBlockSize == (Integer)it.next()) {
                bl = true;
            }
            if (ok = bl) break;
        }
        if (!ok) {
            throw new IllegalArgumentException("cipherBlockSize");
        }
        IMode result = null;
        if (mode.equalsIgnoreCase("ecb")) {
            result = new ECB(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("ctr")) {
            result = new CTR(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("icm")) {
            result = new ICM(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("ofb")) {
            result = new OFB(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("cbc")) {
            result = new CBC(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("cfb")) {
            result = new CFB(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("eax")) {
            result = new EAX(cipher, cipherBlockSize);
        }
        if (result != null && !result.selfTest()) {
            throw new InternalError(result.name());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Set getNames() {
        Class clazz = class$gnu$crypto$mode$ModeFactory;
        if (clazz == null) {
            clazz = class$gnu$crypto$mode$ModeFactory = ModeFactory.class("[Lgnu.crypto.mode.ModeFactory;", false);
        }
        Class clazz2 = clazz;
        synchronized (clazz) {
            if (names == null) {
                HashSet<String> hs = new HashSet<String>();
                hs.add("ecb");
                hs.add("ctr");
                hs.add("icm");
                hs.add("ofb");
                hs.add("cbc");
                hs.add("cfb");
                hs.add("eax");
                names = Collections.unmodifiableSet(hs);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return names;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private ModeFactory() {
    }
}

