/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * Silicon Labs Si2168 DVB-T/T2/C demodulator driver
 *
 * Copyright (C) 2014 Antti Palosaari <crope@iki.fi>
 */

#ifndef SI2168_PRIV_H
#define SI2168_PRIV_H

#include "si2168.h"
#include <media/dvb_frontend.h>
#include <linux/firmware.h>
#include <linux/i2c-mux.h>
#include <linux/kernel.h>

#define SI2168_A20_FIRMWARE "/*(DEBLOBBED)*/"
#define SI2168_A30_FIRMWARE "/*(DEBLOBBED)*/"
#define SI2168_B40_FIRMWARE "/*(DEBLOBBED)*/"
#define SI2168_D60_FIRMWARE "/*(DEBLOBBED)*/"
#define SI2168_B40_FIRMWARE_FALLBACK "/*(DEBLOBBED)*/"

/* state struct */
struct si2168_dev {
	struct mutex i2c_mutex;
	struct i2c_mux_core *muxc;
	struct dvb_frontend fe;
	enum fe_delivery_system delivery_system;
	enum fe_status fe_status;
	#define SI2168_CHIP_ID_A20 ('A' << 24 | 68 << 16 | '2' << 8 | '0' << 0)
	#define SI2168_CHIP_ID_A30 ('A' << 24 | 68 << 16 | '3' << 8 | '0' << 0)
	#define SI2168_CHIP_ID_B40 ('B' << 24 | 68 << 16 | '4' << 8 | '0' << 0)
	#define SI2168_CHIP_ID_D60 ('D' << 24 | 68 << 16 | '6' << 8 | '0' << 0)
	unsigned int chip_id;
	unsigned int version;
	const char *firmware_name;
	u8 ts_mode;
	unsigned int active:1;
	unsigned int warm:1;
	unsigned int ts_clock_inv:1;
	unsigned int ts_clock_gapped:1;
	unsigned int spectral_inversion:1;
};

/* firmware command struct */
#define SI2168_ARGLEN      30
struct si2168_cmd {
	u8 args[SI2168_ARGLEN];
	unsigned wlen;
	unsigned rlen;
};

#endif
