/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * connect o'scope to audio card.
 */

#include <VrAudioSource.h>
#include <GrSimpleScopeSink.h>
#include <GrFFTSink.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include "VrGUI.h" 

#define SAMPLING_FREQUENCY      16000
#define	AMPLITUDE		 4000

int main(int argc, char **argv) {
  VrGUI *guimain = new VrGUI(argc, argv);
  VrGUILayout *horiz = guimain->top->horizontal();
  VrGUILayout *vert = horiz->vertical();

  VrSource<short> *source = new VrAudioSource<short>(SAMPLING_FREQUENCY);
  VrSink<short> *scope_sink = new GrSimpleScopeSink<short>(vert, -AMPLITUDE, AMPLITUDE, 500);
  VrSink<short> *fft_sink = new GrFFTSink<short>(vert, 20, 100, 1024);

  NWO_CONNECT (source, scope_sink);
  NWO_CONNECT (source, fft_sink);

  VrMultiTask *m = new VrMultiTask ();
  m->add (scope_sink);
  m->add (fft_sink);
  m->start();

  guimain->start();

  while (1) {
    guimain->processEvents(10 /*ms*/);
    m->process();
  }
}
